/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.51.0(67d664a32968e19e2eb08b696a92463804182ae4)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/css/cssWorker", ["require"],(require)=>{
"use strict";
var moduleExports = (() => {
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __export = (target, all) => {
    for (var name in all)
      __defProp(target, name, { get: all[name], enumerable: true });
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

  // src/language/css/cssWorker.ts
  var cssWorker_exports = {};
  __export(cssWorker_exports, {
    CSSWorker: () => CSSWorker,
    create: () => create
  });

  // node_modules/vscode-css-languageservice/lib/esm/parser/cssScanner.js
  var TokenType;
  (function(TokenType2) {
    TokenType2[TokenType2["Ident"] = 0] = "Ident";
    TokenType2[TokenType2["AtKeyword"] = 1] = "AtKeyword";
    TokenType2[TokenType2["String"] = 2] = "String";
    TokenType2[TokenType2["BadString"] = 3] = "BadString";
    TokenType2[TokenType2["UnquotedString"] = 4] = "UnquotedString";
    TokenType2[TokenType2["Hash"] = 5] = "Hash";
    TokenType2[TokenType2["Num"] = 6] = "Num";
    TokenType2[TokenType2["Percentage"] = 7] = "Percentage";
    TokenType2[TokenType2["Dimension"] = 8] = "Dimension";
    TokenType2[TokenType2["UnicodeRange"] = 9] = "UnicodeRange";
    TokenType2[TokenType2["CDO"] = 10] = "CDO";
    TokenType2[TokenType2["CDC"] = 11] = "CDC";
    TokenType2[TokenType2["Colon"] = 12] = "Colon";
    TokenType2[TokenType2["SemiColon"] = 13] = "SemiColon";
    TokenType2[TokenType2["CurlyL"] = 14] = "CurlyL";
    TokenType2[TokenType2["CurlyR"] = 15] = "CurlyR";
    TokenType2[TokenType2["ParenthesisL"] = 16] = "ParenthesisL";
    TokenType2[TokenType2["ParenthesisR"] = 17] = "ParenthesisR";
    TokenType2[TokenType2["BracketL"] = 18] = "BracketL";
    TokenType2[TokenType2["BracketR"] = 19] = "BracketR";
    TokenType2[TokenType2["Whitespace"] = 20] = "Whitespace";
    TokenType2[TokenType2["Includes"] = 21] = "Includes";
    TokenType2[TokenType2["Dashmatch"] = 22] = "Dashmatch";
    TokenType2[TokenType2["SubstringOperator"] = 23] = "SubstringOperator";
    TokenType2[TokenType2["PrefixOperator"] = 24] = "PrefixOperator";
    TokenType2[TokenType2["SuffixOperator"] = 25] = "SuffixOperator";
    TokenType2[TokenType2["Delim"] = 26] = "Delim";
    TokenType2[TokenType2["EMS"] = 27] = "EMS";
    TokenType2[TokenType2["EXS"] = 28] = "EXS";
    TokenType2[TokenType2["Length"] = 29] = "Length";
    TokenType2[TokenType2["Angle"] = 30] = "Angle";
    TokenType2[TokenType2["Time"] = 31] = "Time";
    TokenType2[TokenType2["Freq"] = 32] = "Freq";
    TokenType2[TokenType2["Exclamation"] = 33] = "Exclamation";
    TokenType2[TokenType2["Resolution"] = 34] = "Resolution";
    TokenType2[TokenType2["Comma"] = 35] = "Comma";
    TokenType2[TokenType2["Charset"] = 36] = "Charset";
    TokenType2[TokenType2["EscapedJavaScript"] = 37] = "EscapedJavaScript";
    TokenType2[TokenType2["BadEscapedJavaScript"] = 38] = "BadEscapedJavaScript";
    TokenType2[TokenType2["Comment"] = 39] = "Comment";
    TokenType2[TokenType2["SingleLineComment"] = 40] = "SingleLineComment";
    TokenType2[TokenType2["EOF"] = 41] = "EOF";
    TokenType2[TokenType2["ContainerQueryLength"] = 42] = "ContainerQueryLength";
    TokenType2[TokenType2["CustomToken"] = 43] = "CustomToken";
  })(TokenType || (TokenType = {}));
  var MultiLineStream = class {
    constructor(source) {
      this.source = source;
      this.len = source.length;
      this.position = 0;
    }
    substring(from, to = this.position) {
      return this.source.substring(from, to);
    }
    eos() {
      return this.len <= this.position;
    }
    pos() {
      return this.position;
    }
    goBackTo(pos) {
      this.position = pos;
    }
    goBack(n) {
      this.position -= n;
    }
    advance(n) {
      this.position += n;
    }
    nextChar() {
      return this.source.charCodeAt(this.position++) || 0;
    }
    peekChar(n = 0) {
      return this.source.charCodeAt(this.position + n) || 0;
    }
    lookbackChar(n = 0) {
      return this.source.charCodeAt(this.position - n) || 0;
    }
    advanceIfChar(ch) {
      if (ch === this.source.charCodeAt(this.position)) {
        this.position++;
        return true;
      }
      return false;
    }
    advanceIfChars(ch) {
      if (this.position + ch.length > this.source.length) {
        return false;
      }
      let i = 0;
      for (; i < ch.length; i++) {
        if (this.source.charCodeAt(this.position + i) !== ch[i]) {
          return false;
        }
      }
      this.advance(i);
      return true;
    }
    advanceWhileChar(condition) {
      const posNow = this.position;
      while (this.position < this.len && condition(this.source.charCodeAt(this.position))) {
        this.position++;
      }
      return this.position - posNow;
    }
  };
  var _a = "a".charCodeAt(0);
  var _f = "f".charCodeAt(0);
  var _z = "z".charCodeAt(0);
  var _u = "u".charCodeAt(0);
  var _A = "A".charCodeAt(0);
  var _F = "F".charCodeAt(0);
  var _Z = "Z".charCodeAt(0);
  var _0 = "0".charCodeAt(0);
  var _9 = "9".charCodeAt(0);
  var _TLD = "~".charCodeAt(0);
  var _HAT = "^".charCodeAt(0);
  var _EQS = "=".charCodeAt(0);
  var _PIP = "|".charCodeAt(0);
  var _MIN = "-".charCodeAt(0);
  var _USC = "_".charCodeAt(0);
  var _PRC = "%".charCodeAt(0);
  var _MUL = "*".charCodeAt(0);
  var _LPA = "(".charCodeAt(0);
  var _RPA = ")".charCodeAt(0);
  var _LAN = "<".charCodeAt(0);
  var _RAN = ">".charCodeAt(0);
  var _ATS = "@".charCodeAt(0);
  var _HSH = "#".charCodeAt(0);
  var _DLR = "$".charCodeAt(0);
  var _BSL = "\\".charCodeAt(0);
  var _FSL = "/".charCodeAt(0);
  var _NWL = "\n".charCodeAt(0);
  var _CAR = "\r".charCodeAt(0);
  var _LFD = "\f".charCodeAt(0);
  var _DQO = '"'.charCodeAt(0);
  var _SQO = "'".charCodeAt(0);
  var _WSP = " ".charCodeAt(0);
  var _TAB = "	".charCodeAt(0);
  var _SEM = ";".charCodeAt(0);
  var _COL = ":".charCodeAt(0);
  var _CUL = "{".charCodeAt(0);
  var _CUR = "}".charCodeAt(0);
  var _BRL = "[".charCodeAt(0);
  var _BRR = "]".charCodeAt(0);
  var _CMA = ",".charCodeAt(0);
  var _DOT = ".".charCodeAt(0);
  var _BNG = "!".charCodeAt(0);
  var _QSM = "?".charCodeAt(0);
  var _PLS = "+".charCodeAt(0);
  var staticTokenTable = {};
  staticTokenTable[_SEM] = TokenType.SemiColon;
  staticTokenTable[_COL] = TokenType.Colon;
  staticTokenTable[_CUL] = TokenType.CurlyL;
  staticTokenTable[_CUR] = TokenType.CurlyR;
  staticTokenTable[_BRR] = TokenType.BracketR;
  staticTokenTable[_BRL] = TokenType.BracketL;
  staticTokenTable[_LPA] = TokenType.ParenthesisL;
  staticTokenTable[_RPA] = TokenType.ParenthesisR;
  staticTokenTable[_CMA] = TokenType.Comma;
  var staticUnitTable = {};
  staticUnitTable["em"] = TokenType.EMS;
  staticUnitTable["ex"] = TokenType.EXS;
  staticUnitTable["px"] = TokenType.Length;
  staticUnitTable["cm"] = TokenType.Length;
  staticUnitTable["mm"] = TokenType.Length;
  staticUnitTable["in"] = TokenType.Length;
  staticUnitTable["pt"] = TokenType.Length;
  staticUnitTable["pc"] = TokenType.Length;
  staticUnitTable["deg"] = TokenType.Angle;
  staticUnitTable["rad"] = TokenType.Angle;
  staticUnitTable["grad"] = TokenType.Angle;
  staticUnitTable["ms"] = TokenType.Time;
  staticUnitTable["s"] = TokenType.Time;
  staticUnitTable["hz"] = TokenType.Freq;
  staticUnitTable["khz"] = TokenType.Freq;
  staticUnitTable["%"] = TokenType.Percentage;
  staticUnitTable["fr"] = TokenType.Percentage;
  staticUnitTable["dpi"] = TokenType.Resolution;
  staticUnitTable["dpcm"] = TokenType.Resolution;
  staticUnitTable["cqw"] = TokenType.ContainerQueryLength;
  staticUnitTable["cqh"] = TokenType.ContainerQueryLength;
  staticUnitTable["cqi"] = TokenType.ContainerQueryLength;
  staticUnitTable["cqb"] = TokenType.ContainerQueryLength;
  staticUnitTable["cqmin"] = TokenType.ContainerQueryLength;
  staticUnitTable["cqmax"] = TokenType.ContainerQueryLength;
  var Scanner = class {
    constructor() {
      this.stream = new MultiLineStream("");
      this.ignoreComment = true;
      this.ignoreWhitespace = true;
      this.inURL = false;
    }
    setSource(input) {
      this.stream = new MultiLineStream(input);
    }
    finishToken(offset, type, text) {
      return {
        offset,
        len: this.stream.pos() - offset,
        type,
        text: text || this.stream.substring(offset)
      };
    }
    substring(offset, len) {
      return this.stream.substring(offset, offset + len);
    }
    pos() {
      return this.stream.pos();
    }
    goBackTo(pos) {
      this.stream.goBackTo(pos);
    }
    scanUnquotedString() {
      const offset = this.stream.pos();
      const content = [];
      if (this._unquotedString(content)) {
        return this.finishToken(offset, TokenType.UnquotedString, content.join(""));
      }
      return null;
    }
    scan() {
      const triviaToken = this.trivia();
      if (triviaToken !== null) {
        return triviaToken;
      }
      const offset = this.stream.pos();
      if (this.stream.eos()) {
        return this.finishToken(offset, TokenType.EOF);
      }
      return this.scanNext(offset);
    }
    /**
     * Read the range as described in https://www.w3.org/TR/CSS21/syndata.html#tokenization
     * Assume the `u` has aleady been consumed
     * @returns if reading the unicode was successful
     */
    tryScanUnicode() {
      const offset = this.stream.pos();
      if (!this.stream.eos() && this._unicodeRange()) {
        return this.finishToken(offset, TokenType.UnicodeRange);
      }
      this.stream.goBackTo(offset);
      return void 0;
    }
    scanNext(offset) {
      if (this.stream.advanceIfChars([_LAN, _BNG, _MIN, _MIN])) {
        return this.finishToken(offset, TokenType.CDO);
      }
      if (this.stream.advanceIfChars([_MIN, _MIN, _RAN])) {
        return this.finishToken(offset, TokenType.CDC);
      }
      let content = [];
      if (this.ident(content)) {
        return this.finishToken(offset, TokenType.Ident, content.join(""));
      }
      if (this.stream.advanceIfChar(_ATS)) {
        content = ["@"];
        if (this._name(content)) {
          const keywordText = content.join("");
          if (keywordText === "@charset") {
            return this.finishToken(offset, TokenType.Charset, keywordText);
          }
          return this.finishToken(offset, TokenType.AtKeyword, keywordText);
        } else {
          return this.finishToken(offset, TokenType.Delim);
        }
      }
      if (this.stream.advanceIfChar(_HSH)) {
        content = ["#"];
        if (this._name(content)) {
          return this.finishToken(offset, TokenType.Hash, content.join(""));
        } else {
          return this.finishToken(offset, TokenType.Delim);
        }
      }
      if (this.stream.advanceIfChar(_BNG)) {
        return this.finishToken(offset, TokenType.Exclamation);
      }
      if (this._number()) {
        const pos = this.stream.pos();
        content = [this.stream.substring(offset, pos)];
        if (this.stream.advanceIfChar(_PRC)) {
          return this.finishToken(offset, TokenType.Percentage);
        } else if (this.ident(content)) {
          const dim = this.stream.substring(pos).toLowerCase();
          const tokenType2 = staticUnitTable[dim];
          if (typeof tokenType2 !== "undefined") {
            return this.finishToken(offset, tokenType2, content.join(""));
          } else {
            return this.finishToken(offset, TokenType.Dimension, content.join(""));
          }
        }
        return this.finishToken(offset, TokenType.Num);
      }
      content = [];
      let tokenType = this._string(content);
      if (tokenType !== null) {
        return this.finishToken(offset, tokenType, content.join(""));
      }
      tokenType = staticTokenTable[this.stream.peekChar()];
      if (typeof tokenType !== "undefined") {
        this.stream.advance(1);
        return this.finishToken(offset, tokenType);
      }
      if (this.stream.peekChar(0) === _TLD && this.stream.peekChar(1) === _EQS) {
        this.stream.advance(2);
        return this.finishToken(offset, TokenType.Includes);
      }
      if (this.stream.peekChar(0) === _PIP && this.stream.peekChar(1) === _EQS) {
        this.stream.advance(2);
        return this.finishToken(offset, TokenType.Dashmatch);
      }
      if (this.stream.peekChar(0) === _MUL && this.stream.peekChar(1) === _EQS) {
        this.stream.advance(2);
        return this.finishToken(offset, TokenType.SubstringOperator);
      }
      if (this.stream.peekChar(0) === _HAT && this.stream.peekChar(1) === _EQS) {
        this.stream.advance(2);
        return this.finishToken(offset, TokenType.PrefixOperator);
      }
      if (this.stream.peekChar(0) === _DLR && this.stream.peekChar(1) === _EQS) {
        this.stream.advance(2);
        return this.finishToken(offset, TokenType.SuffixOperator);
      }
      this.stream.nextChar();
      return this.finishToken(offset, TokenType.Delim);
    }
    trivia() {
      while (true) {
        const offset = this.stream.pos();
        if (this._whitespace()) {
          if (!this.ignoreWhitespace) {
            return this.finishToken(offset, TokenType.Whitespace);
          }
        } else if (this.comment()) {
          if (!this.ignoreComment) {
            return this.finishToken(offset, TokenType.Comment);
          }
        } else {
          return null;
        }
      }
    }
    comment() {
      if (this.stream.advanceIfChars([_FSL, _MUL])) {
        let success = false, hot = false;
        this.stream.advanceWhileChar((ch) => {
          if (hot && ch === _FSL) {
            success = true;
            return false;
          }
          hot = ch === _MUL;
          return true;
        });
        if (success) {
          this.stream.advance(1);
        }
        return true;
      }
      return false;
    }
    _number() {
      let npeek = 0, ch;
      if (this.stream.peekChar() === _DOT) {
        npeek = 1;
      }
      ch = this.stream.peekChar(npeek);
      if (ch >= _0 && ch <= _9) {
        this.stream.advance(npeek + 1);
        this.stream.advanceWhileChar((ch2) => {
          return ch2 >= _0 && ch2 <= _9 || npeek === 0 && ch2 === _DOT;
        });
        return true;
      }
      return false;
    }
    _newline(result) {
      const ch = this.stream.peekChar();
      switch (ch) {
        case _CAR:
        case _LFD:
        case _NWL:
          this.stream.advance(1);
          result.push(String.fromCharCode(ch));
          if (ch === _CAR && this.stream.advanceIfChar(_NWL)) {
            result.push("\n");
          }
          return true;
      }
      return false;
    }
    _escape(result, includeNewLines) {
      let ch = this.stream.peekChar();
      if (ch === _BSL) {
        this.stream.advance(1);
        ch = this.stream.peekChar();
        let hexNumCount = 0;
        while (hexNumCount < 6 && (ch >= _0 && ch <= _9 || ch >= _a && ch <= _f || ch >= _A && ch <= _F)) {
          this.stream.advance(1);
          ch = this.stream.peekChar();
          hexNumCount++;
        }
        if (hexNumCount > 0) {
          try {
            const hexVal = parseInt(this.stream.substring(this.stream.pos() - hexNumCount), 16);
            if (hexVal) {
              result.push(String.fromCharCode(hexVal));
            }
          } catch (e) {
          }
          if (ch === _WSP || ch === _TAB) {
            this.stream.advance(1);
          } else {
            this._newline([]);
          }
          return true;
        }
        if (ch !== _CAR && ch !== _LFD && ch !== _NWL) {
          this.stream.advance(1);
          result.push(String.fromCharCode(ch));
          return true;
        } else if (includeNewLines) {
          return this._newline(result);
        }
      }
      return false;
    }
    _stringChar(closeQuote, result) {
      const ch = this.stream.peekChar();
      if (ch !== 0 && ch !== closeQuote && ch !== _BSL && ch !== _CAR && ch !== _LFD && ch !== _NWL) {
        this.stream.advance(1);
        result.push(String.fromCharCode(ch));
        return true;
      }
      return false;
    }
    _string(result) {
      if (this.stream.peekChar() === _SQO || this.stream.peekChar() === _DQO) {
        const closeQuote = this.stream.nextChar();
        result.push(String.fromCharCode(closeQuote));
        while (this._stringChar(closeQuote, result) || this._escape(result, true)) {
        }
        if (this.stream.peekChar() === closeQuote) {
          this.stream.nextChar();
          result.push(String.fromCharCode(closeQuote));
          return TokenType.String;
        } else {
          return TokenType.BadString;
        }
      }
      return null;
    }
    _unquotedChar(result) {
      const ch = this.stream.peekChar();
      if (ch !== 0 && ch !== _BSL && ch !== _SQO && ch !== _DQO && ch !== _LPA && ch !== _RPA && ch !== _WSP && ch !== _TAB && ch !== _NWL && ch !== _LFD && ch !== _CAR) {
        this.stream.advance(1);
        result.push(String.fromCharCode(ch));
        return true;
      }
      return false;
    }
    _unquotedString(result) {
      let hasContent = false;
      while (this._unquotedChar(result) || this._escape(result)) {
        hasContent = true;
      }
      return hasContent;
    }
    _whitespace() {
      const n = this.stream.advanceWhileChar((ch) => {
        return ch === _WSP || ch === _TAB || ch === _NWL || ch === _LFD || ch === _CAR;
      });
      return n > 0;
    }
    _name(result) {
      let matched = false;
      while (this._identChar(result) || this._escape(result)) {
        matched = true;
      }
      return matched;
    }
    ident(result) {
      const pos = this.stream.pos();
      const hasMinus = this._minus(result);
      if (hasMinus) {
        if (this._minus(result) || this._identFirstChar(result) || this._escape(result)) {
          while (this._identChar(result) || this._escape(result)) {
          }
          return true;
        }
      } else if (this._identFirstChar(result) || this._escape(result)) {
        while (this._identChar(result) || this._escape(result)) {
        }
        return true;
      }
      this.stream.goBackTo(pos);
      return false;
    }
    _identFirstChar(result) {
      const ch = this.stream.peekChar();
      if (ch === _USC || // _
      ch >= _a && ch <= _z || // a-z
      ch >= _A && ch <= _Z || // A-Z
      ch >= 128 && ch <= 65535) {
        this.stream.advance(1);
        result.push(String.fromCharCode(ch));
        return true;
      }
      return false;
    }
    _minus(result) {
      const ch = this.stream.peekChar();
      if (ch === _MIN) {
        this.stream.advance(1);
        result.push(String.fromCharCode(ch));
        return true;
      }
      return false;
    }
    _identChar(result) {
      const ch = this.stream.peekChar();
      if (ch === _USC || // _
      ch === _MIN || // -
      ch >= _a && ch <= _z || // a-z
      ch >= _A && ch <= _Z || // A-Z
      ch >= _0 && ch <= _9 || // 0/9
      ch >= 128 && ch <= 65535) {
        this.stream.advance(1);
        result.push(String.fromCharCode(ch));
        return true;
      }
      return false;
    }
    _unicodeRange() {
      if (this.stream.advanceIfChar(_PLS)) {
        const isHexDigit = (ch) => ch >= _0 && ch <= _9 || ch >= _a && ch <= _f || ch >= _A && ch <= _F;
        const codePoints = this.stream.advanceWhileChar(isHexDigit) + this.stream.advanceWhileChar((ch) => ch === _QSM);
        if (codePoints >= 1 && codePoints <= 6) {
          if (this.stream.advanceIfChar(_MIN)) {
            const digits = this.stream.advanceWhileChar(isHexDigit);
            if (digits >= 1 && digits <= 6) {
              return true;
            }
          } else {
            return true;
          }
        }
      }
      return false;
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/utils/strings.js
  function startsWith(haystack, needle) {
    if (haystack.length < needle.length) {
      return false;
    }
    for (let i = 0; i < needle.length; i++) {
      if (haystack[i] !== needle[i]) {
        return false;
      }
    }
    return true;
  }
  function endsWith(haystack, needle) {
    let diff = haystack.length - needle.length;
    if (diff > 0) {
      return haystack.lastIndexOf(needle) === diff;
    } else if (diff === 0) {
      return haystack === needle;
    } else {
      return false;
    }
  }
  function difference(first, second, maxLenDelta = 4) {
    let lengthDifference = Math.abs(first.length - second.length);
    if (lengthDifference > maxLenDelta) {
      return 0;
    }
    let LCS = [];
    let zeroArray = [];
    let i, j;
    for (i = 0; i < second.length + 1; ++i) {
      zeroArray.push(0);
    }
    for (i = 0; i < first.length + 1; ++i) {
      LCS.push(zeroArray);
    }
    for (i = 1; i < first.length + 1; ++i) {
      for (j = 1; j < second.length + 1; ++j) {
        if (first[i - 1] === second[j - 1]) {
          LCS[i][j] = LCS[i - 1][j - 1] + 1;
        } else {
          LCS[i][j] = Math.max(LCS[i - 1][j], LCS[i][j - 1]);
        }
      }
    }
    return LCS[first.length][second.length] - Math.sqrt(lengthDifference);
  }
  function getLimitedString(str, ellipsis = true) {
    if (!str) {
      return "";
    }
    if (str.length < 140) {
      return str;
    }
    return str.slice(0, 140) + (ellipsis ? "\u2026" : "");
  }
  function trim(str, regexp) {
    const m = regexp.exec(str);
    if (m && m[0].length) {
      return str.substr(0, str.length - m[0].length);
    }
    return str;
  }
  function repeat(value, count) {
    let s = "";
    while (count > 0) {
      if ((count & 1) === 1) {
        s += value;
      }
      value += value;
      count = count >>> 1;
    }
    return s;
  }

  // node_modules/vscode-css-languageservice/lib/esm/parser/cssNodes.js
  var NodeType;
  (function(NodeType2) {
    NodeType2[NodeType2["Undefined"] = 0] = "Undefined";
    NodeType2[NodeType2["Identifier"] = 1] = "Identifier";
    NodeType2[NodeType2["Stylesheet"] = 2] = "Stylesheet";
    NodeType2[NodeType2["Ruleset"] = 3] = "Ruleset";
    NodeType2[NodeType2["Selector"] = 4] = "Selector";
    NodeType2[NodeType2["SimpleSelector"] = 5] = "SimpleSelector";
    NodeType2[NodeType2["SelectorInterpolation"] = 6] = "SelectorInterpolation";
    NodeType2[NodeType2["SelectorCombinator"] = 7] = "SelectorCombinator";
    NodeType2[NodeType2["SelectorCombinatorParent"] = 8] = "SelectorCombinatorParent";
    NodeType2[NodeType2["SelectorCombinatorSibling"] = 9] = "SelectorCombinatorSibling";
    NodeType2[NodeType2["SelectorCombinatorAllSiblings"] = 10] = "SelectorCombinatorAllSiblings";
    NodeType2[NodeType2["SelectorCombinatorShadowPiercingDescendant"] = 11] = "SelectorCombinatorShadowPiercingDescendant";
    NodeType2[NodeType2["Page"] = 12] = "Page";
    NodeType2[NodeType2["PageBoxMarginBox"] = 13] = "PageBoxMarginBox";
    NodeType2[NodeType2["ClassSelector"] = 14] = "ClassSelector";
    NodeType2[NodeType2["IdentifierSelector"] = 15] = "IdentifierSelector";
    NodeType2[NodeType2["ElementNameSelector"] = 16] = "ElementNameSelector";
    NodeType2[NodeType2["PseudoSelector"] = 17] = "PseudoSelector";
    NodeType2[NodeType2["AttributeSelector"] = 18] = "AttributeSelector";
    NodeType2[NodeType2["Declaration"] = 19] = "Declaration";
    NodeType2[NodeType2["Declarations"] = 20] = "Declarations";
    NodeType2[NodeType2["Property"] = 21] = "Property";
    NodeType2[NodeType2["Expression"] = 22] = "Expression";
    NodeType2[NodeType2["BinaryExpression"] = 23] = "BinaryExpression";
    NodeType2[NodeType2["Term"] = 24] = "Term";
    NodeType2[NodeType2["Operator"] = 25] = "Operator";
    NodeType2[NodeType2["Value"] = 26] = "Value";
    NodeType2[NodeType2["StringLiteral"] = 27] = "StringLiteral";
    NodeType2[NodeType2["URILiteral"] = 28] = "URILiteral";
    NodeType2[NodeType2["EscapedValue"] = 29] = "EscapedValue";
    NodeType2[NodeType2["Function"] = 30] = "Function";
    NodeType2[NodeType2["NumericValue"] = 31] = "NumericValue";
    NodeType2[NodeType2["HexColorValue"] = 32] = "HexColorValue";
    NodeType2[NodeType2["RatioValue"] = 33] = "RatioValue";
    NodeType2[NodeType2["MixinDeclaration"] = 34] = "MixinDeclaration";
    NodeType2[NodeType2["MixinReference"] = 35] = "MixinReference";
    NodeType2[NodeType2["VariableName"] = 36] = "VariableName";
    NodeType2[NodeType2["VariableDeclaration"] = 37] = "VariableDeclaration";
    NodeType2[NodeType2["Prio"] = 38] = "Prio";
    NodeType2[NodeType2["Interpolation"] = 39] = "Interpolation";
    NodeType2[NodeType2["NestedProperties"] = 40] = "NestedProperties";
    NodeType2[NodeType2["ExtendsReference"] = 41] = "ExtendsReference";
    NodeType2[NodeType2["SelectorPlaceholder"] = 42] = "SelectorPlaceholder";
    NodeType2[NodeType2["Debug"] = 43] = "Debug";
    NodeType2[NodeType2["If"] = 44] = "If";
    NodeType2[NodeType2["Else"] = 45] = "Else";
    NodeType2[NodeType2["For"] = 46] = "For";
    NodeType2[NodeType2["Each"] = 47] = "Each";
    NodeType2[NodeType2["While"] = 48] = "While";
    NodeType2[NodeType2["MixinContentReference"] = 49] = "MixinContentReference";
    NodeType2[NodeType2["MixinContentDeclaration"] = 50] = "MixinContentDeclaration";
    NodeType2[NodeType2["Media"] = 51] = "Media";
    NodeType2[NodeType2["Keyframe"] = 52] = "Keyframe";
    NodeType2[NodeType2["FontFace"] = 53] = "FontFace";
    NodeType2[NodeType2["Import"] = 54] = "Import";
    NodeType2[NodeType2["Namespace"] = 55] = "Namespace";
    NodeType2[NodeType2["Invocation"] = 56] = "Invocation";
    NodeType2[NodeType2["FunctionDeclaration"] = 57] = "FunctionDeclaration";
    NodeType2[NodeType2["ReturnStatement"] = 58] = "ReturnStatement";
    NodeType2[NodeType2["MediaQuery"] = 59] = "MediaQuery";
    NodeType2[NodeType2["MediaCondition"] = 60] = "MediaCondition";
    NodeType2[NodeType2["MediaFeature"] = 61] = "MediaFeature";
    NodeType2[NodeType2["FunctionParameter"] = 62] = "FunctionParameter";
    NodeType2[NodeType2["FunctionArgument"] = 63] = "FunctionArgument";
    NodeType2[NodeType2["KeyframeSelector"] = 64] = "KeyframeSelector";
    NodeType2[NodeType2["ViewPort"] = 65] = "ViewPort";
    NodeType2[NodeType2["Document"] = 66] = "Document";
    NodeType2[NodeType2["AtApplyRule"] = 67] = "AtApplyRule";
    NodeType2[NodeType2["CustomPropertyDeclaration"] = 68] = "CustomPropertyDeclaration";
    NodeType2[NodeType2["CustomPropertySet"] = 69] = "CustomPropertySet";
    NodeType2[NodeType2["ListEntry"] = 70] = "ListEntry";
    NodeType2[NodeType2["Supports"] = 71] = "Supports";
    NodeType2[NodeType2["SupportsCondition"] = 72] = "SupportsCondition";
    NodeType2[NodeType2["NamespacePrefix"] = 73] = "NamespacePrefix";
    NodeType2[NodeType2["GridLine"] = 74] = "GridLine";
    NodeType2[NodeType2["Plugin"] = 75] = "Plugin";
    NodeType2[NodeType2["UnknownAtRule"] = 76] = "UnknownAtRule";
    NodeType2[NodeType2["Use"] = 77] = "Use";
    NodeType2[NodeType2["ModuleConfiguration"] = 78] = "ModuleConfiguration";
    NodeType2[NodeType2["Forward"] = 79] = "Forward";
    NodeType2[NodeType2["ForwardVisibility"] = 80] = "ForwardVisibility";
    NodeType2[NodeType2["Module"] = 81] = "Module";
    NodeType2[NodeType2["UnicodeRange"] = 82] = "UnicodeRange";
    NodeType2[NodeType2["Layer"] = 83] = "Layer";
    NodeType2[NodeType2["LayerNameList"] = 84] = "LayerNameList";
    NodeType2[NodeType2["LayerName"] = 85] = "LayerName";
    NodeType2[NodeType2["PropertyAtRule"] = 86] = "PropertyAtRule";
    NodeType2[NodeType2["Container"] = 87] = "Container";
  })(NodeType || (NodeType = {}));
  var ReferenceType;
  (function(ReferenceType2) {
    ReferenceType2[ReferenceType2["Mixin"] = 0] = "Mixin";
    ReferenceType2[ReferenceType2["Rule"] = 1] = "Rule";
    ReferenceType2[ReferenceType2["Variable"] = 2] = "Variable";
    ReferenceType2[ReferenceType2["Function"] = 3] = "Function";
    ReferenceType2[ReferenceType2["Keyframe"] = 4] = "Keyframe";
    ReferenceType2[ReferenceType2["Unknown"] = 5] = "Unknown";
    ReferenceType2[ReferenceType2["Module"] = 6] = "Module";
    ReferenceType2[ReferenceType2["Forward"] = 7] = "Forward";
    ReferenceType2[ReferenceType2["ForwardVisibility"] = 8] = "ForwardVisibility";
    ReferenceType2[ReferenceType2["Property"] = 9] = "Property";
  })(ReferenceType || (ReferenceType = {}));
  function getNodeAtOffset(node, offset) {
    let candidate = null;
    if (!node || offset < node.offset || offset > node.end) {
      return null;
    }
    node.accept((node2) => {
      if (node2.offset === -1 && node2.length === -1) {
        return true;
      }
      if (node2.offset <= offset && node2.end >= offset) {
        if (!candidate) {
          candidate = node2;
        } else if (node2.length <= candidate.length) {
          candidate = node2;
        }
        return true;
      }
      return false;
    });
    return candidate;
  }
  function getNodePath(node, offset) {
    let candidate = getNodeAtOffset(node, offset);
    const path = [];
    while (candidate) {
      path.unshift(candidate);
      candidate = candidate.parent;
    }
    return path;
  }
  function getParentDeclaration(node) {
    const decl = node.findParent(NodeType.Declaration);
    const value = decl && decl.getValue();
    if (value && value.encloses(node)) {
      return decl;
    }
    return null;
  }
  var Node = class {
    get end() {
      return this.offset + this.length;
    }
    constructor(offset = -1, len = -1, nodeType) {
      this.parent = null;
      this.offset = offset;
      this.length = len;
      if (nodeType) {
        this.nodeType = nodeType;
      }
    }
    set type(type) {
      this.nodeType = type;
    }
    get type() {
      return this.nodeType || NodeType.Undefined;
    }
    getTextProvider() {
      let node = this;
      while (node && !node.textProvider) {
        node = node.parent;
      }
      if (node) {
        return node.textProvider;
      }
      return () => {
        return "unknown";
      };
    }
    getText() {
      return this.getTextProvider()(this.offset, this.length);
    }
    matches(str) {
      return this.length === str.length && this.getTextProvider()(this.offset, this.length) === str;
    }
    startsWith(str) {
      return this.length >= str.length && this.getTextProvider()(this.offset, str.length) === str;
    }
    endsWith(str) {
      return this.length >= str.length && this.getTextProvider()(this.end - str.length, str.length) === str;
    }
    accept(visitor) {
      if (visitor(this) && this.children) {
        for (const child of this.children) {
          child.accept(visitor);
        }
      }
    }
    acceptVisitor(visitor) {
      this.accept(visitor.visitNode.bind(visitor));
    }
    adoptChild(node, index = -1) {
      if (node.parent && node.parent.children) {
        const idx = node.parent.children.indexOf(node);
        if (idx >= 0) {
          node.parent.children.splice(idx, 1);
        }
      }
      node.parent = this;
      let children = this.children;
      if (!children) {
        children = this.children = [];
      }
      if (index !== -1) {
        children.splice(index, 0, node);
      } else {
        children.push(node);
      }
      return node;
    }
    attachTo(parent, index = -1) {
      if (parent) {
        parent.adoptChild(this, index);
      }
      return this;
    }
    collectIssues(results) {
      if (this.issues) {
        results.push.apply(results, this.issues);
      }
    }
    addIssue(issue) {
      if (!this.issues) {
        this.issues = [];
      }
      this.issues.push(issue);
    }
    hasIssue(rule) {
      return Array.isArray(this.issues) && this.issues.some((i) => i.getRule() === rule);
    }
    isErroneous(recursive = false) {
      if (this.issues && this.issues.length > 0) {
        return true;
      }
      return recursive && Array.isArray(this.children) && this.children.some((c) => c.isErroneous(true));
    }
    setNode(field, node, index = -1) {
      if (node) {
        node.attachTo(this, index);
        this[field] = node;
        return true;
      }
      return false;
    }
    addChild(node) {
      if (node) {
        if (!this.children) {
          this.children = [];
        }
        node.attachTo(this);
        this.updateOffsetAndLength(node);
        return true;
      }
      return false;
    }
    updateOffsetAndLength(node) {
      if (node.offset < this.offset || this.offset === -1) {
        this.offset = node.offset;
      }
      const nodeEnd = node.end;
      if (nodeEnd > this.end || this.length === -1) {
        this.length = nodeEnd - this.offset;
      }
    }
    hasChildren() {
      return !!this.children && this.children.length > 0;
    }
    getChildren() {
      return this.children ? this.children.slice(0) : [];
    }
    getChild(index) {
      if (this.children && index < this.children.length) {
        return this.children[index];
      }
      return null;
    }
    addChildren(nodes) {
      for (const node of nodes) {
        this.addChild(node);
      }
    }
    findFirstChildBeforeOffset(offset) {
      if (this.children) {
        let current = null;
        for (let i = this.children.length - 1; i >= 0; i--) {
          current = this.children[i];
          if (current.offset <= offset) {
            return current;
          }
        }
      }
      return null;
    }
    findChildAtOffset(offset, goDeep) {
      const current = this.findFirstChildBeforeOffset(offset);
      if (current && current.end >= offset) {
        if (goDeep) {
          return current.findChildAtOffset(offset, true) || current;
        }
        return current;
      }
      return null;
    }
    encloses(candidate) {
      return this.offset <= candidate.offset && this.offset + this.length >= candidate.offset + candidate.length;
    }
    getParent() {
      let result = this.parent;
      while (result instanceof Nodelist) {
        result = result.parent;
      }
      return result;
    }
    findParent(type) {
      let result = this;
      while (result && result.type !== type) {
        result = result.parent;
      }
      return result;
    }
    findAParent(...types) {
      let result = this;
      while (result && !types.some((t2) => result.type === t2)) {
        result = result.parent;
      }
      return result;
    }
    setData(key, value) {
      if (!this.options) {
        this.options = {};
      }
      this.options[key] = value;
    }
    getData(key) {
      if (!this.options || !this.options.hasOwnProperty(key)) {
        return null;
      }
      return this.options[key];
    }
  };
  var Nodelist = class extends Node {
    constructor(parent, index = -1) {
      super(-1, -1);
      this.attachTo(parent, index);
      this.offset = -1;
      this.length = -1;
    }
  };
  var UnicodeRange = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.UnicodeRange;
    }
    setRangeStart(rangeStart) {
      return this.setNode("rangeStart", rangeStart);
    }
    getRangeStart() {
      return this.rangeStart;
    }
    setRangeEnd(rangeEnd) {
      return this.setNode("rangeEnd", rangeEnd);
    }
    getRangeEnd() {
      return this.rangeEnd;
    }
  };
  var Identifier = class extends Node {
    constructor(offset, length) {
      super(offset, length);
      this.isCustomProperty = false;
    }
    get type() {
      return NodeType.Identifier;
    }
    containsInterpolation() {
      return this.hasChildren();
    }
  };
  var Stylesheet = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Stylesheet;
    }
  };
  var Declarations = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Declarations;
    }
  };
  var BodyDeclaration = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    getDeclarations() {
      return this.declarations;
    }
    setDeclarations(decls) {
      return this.setNode("declarations", decls);
    }
  };
  var RuleSet = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Ruleset;
    }
    getSelectors() {
      if (!this.selectors) {
        this.selectors = new Nodelist(this);
      }
      return this.selectors;
    }
    isNested() {
      return !!this.parent && this.parent.findParent(NodeType.Declarations) !== null;
    }
  };
  var Selector = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Selector;
    }
  };
  var SimpleSelector = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.SimpleSelector;
    }
  };
  var AbstractDeclaration = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
  };
  var CustomPropertySet = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.CustomPropertySet;
    }
  };
  var Declaration = class _Declaration extends AbstractDeclaration {
    constructor(offset, length) {
      super(offset, length);
      this.property = null;
    }
    get type() {
      return NodeType.Declaration;
    }
    setProperty(node) {
      return this.setNode("property", node);
    }
    getProperty() {
      return this.property;
    }
    getFullPropertyName() {
      const propertyName = this.property ? this.property.getName() : "unknown";
      if (this.parent instanceof Declarations && this.parent.getParent() instanceof NestedProperties) {
        const parentDecl = this.parent.getParent().getParent();
        if (parentDecl instanceof _Declaration) {
          return parentDecl.getFullPropertyName() + propertyName;
        }
      }
      return propertyName;
    }
    getNonPrefixedPropertyName() {
      const propertyName = this.getFullPropertyName();
      if (propertyName && propertyName.charAt(0) === "-") {
        const vendorPrefixEnd = propertyName.indexOf("-", 1);
        if (vendorPrefixEnd !== -1) {
          return propertyName.substring(vendorPrefixEnd + 1);
        }
      }
      return propertyName;
    }
    setValue(value) {
      return this.setNode("value", value);
    }
    getValue() {
      return this.value;
    }
    setNestedProperties(value) {
      return this.setNode("nestedProperties", value);
    }
    getNestedProperties() {
      return this.nestedProperties;
    }
  };
  var CustomPropertyDeclaration = class extends Declaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.CustomPropertyDeclaration;
    }
    setPropertySet(value) {
      return this.setNode("propertySet", value);
    }
    getPropertySet() {
      return this.propertySet;
    }
  };
  var Property = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Property;
    }
    setIdentifier(value) {
      return this.setNode("identifier", value);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return trim(this.getText(), /[_\+]+$/);
    }
    isCustomProperty() {
      return !!this.identifier && this.identifier.isCustomProperty;
    }
  };
  var Invocation = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Invocation;
    }
    getArguments() {
      if (!this.arguments) {
        this.arguments = new Nodelist(this);
      }
      return this.arguments;
    }
  };
  var Function = class extends Invocation {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Function;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
  };
  var FunctionParameter = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.FunctionParameter;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
    setDefaultValue(node) {
      return this.setNode("defaultValue", node, 0);
    }
    getDefaultValue() {
      return this.defaultValue;
    }
  };
  var FunctionArgument = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.FunctionArgument;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
    setValue(node) {
      return this.setNode("value", node, 0);
    }
    getValue() {
      return this.value;
    }
  };
  var IfStatement = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.If;
    }
    setExpression(node) {
      return this.setNode("expression", node, 0);
    }
    setElseClause(elseClause) {
      return this.setNode("elseClause", elseClause);
    }
  };
  var ForStatement = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.For;
    }
    setVariable(node) {
      return this.setNode("variable", node, 0);
    }
  };
  var EachStatement = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Each;
    }
    getVariables() {
      if (!this.variables) {
        this.variables = new Nodelist(this);
      }
      return this.variables;
    }
  };
  var WhileStatement = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.While;
    }
  };
  var ElseStatement = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Else;
    }
  };
  var FunctionDeclaration = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.FunctionDeclaration;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
    getParameters() {
      if (!this.parameters) {
        this.parameters = new Nodelist(this);
      }
      return this.parameters;
    }
  };
  var ViewPort = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.ViewPort;
    }
  };
  var FontFace = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.FontFace;
    }
  };
  var NestedProperties = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.NestedProperties;
    }
  };
  var Keyframe = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Keyframe;
    }
    setKeyword(keyword) {
      return this.setNode("keyword", keyword, 0);
    }
    getKeyword() {
      return this.keyword;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
  };
  var KeyframeSelector = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.KeyframeSelector;
    }
  };
  var Import = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Import;
    }
    setMedialist(node) {
      if (node) {
        node.attachTo(this);
        return true;
      }
      return false;
    }
  };
  var Use = class extends Node {
    get type() {
      return NodeType.Use;
    }
    getParameters() {
      if (!this.parameters) {
        this.parameters = new Nodelist(this);
      }
      return this.parameters;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
  };
  var ModuleConfiguration = class extends Node {
    get type() {
      return NodeType.ModuleConfiguration;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
    setValue(node) {
      return this.setNode("value", node, 0);
    }
    getValue() {
      return this.value;
    }
  };
  var Forward = class extends Node {
    get type() {
      return NodeType.Forward;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getMembers() {
      if (!this.members) {
        this.members = new Nodelist(this);
      }
      return this.members;
    }
    getParameters() {
      if (!this.parameters) {
        this.parameters = new Nodelist(this);
      }
      return this.parameters;
    }
  };
  var ForwardVisibility = class extends Node {
    get type() {
      return NodeType.ForwardVisibility;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
  };
  var Namespace = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Namespace;
    }
  };
  var Media = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Media;
    }
  };
  var Supports = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Supports;
    }
  };
  var Layer = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Layer;
    }
    setNames(names) {
      return this.setNode("names", names);
    }
    getNames() {
      return this.names;
    }
  };
  var PropertyAtRule = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.PropertyAtRule;
    }
    setName(node) {
      if (node) {
        node.attachTo(this);
        this.name = node;
        return true;
      }
      return false;
    }
    getName() {
      return this.name;
    }
  };
  var Document = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Document;
    }
  };
  var Container = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Container;
    }
  };
  var Medialist = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
  };
  var MediaQuery = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MediaQuery;
    }
  };
  var MediaCondition = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MediaCondition;
    }
  };
  var MediaFeature = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MediaFeature;
    }
  };
  var SupportsCondition = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.SupportsCondition;
    }
  };
  var Page = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Page;
    }
  };
  var PageBoxMarginBox = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.PageBoxMarginBox;
    }
  };
  var Expression = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Expression;
    }
  };
  var BinaryExpression = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.BinaryExpression;
    }
    setLeft(left) {
      return this.setNode("left", left);
    }
    getLeft() {
      return this.left;
    }
    setRight(right) {
      return this.setNode("right", right);
    }
    getRight() {
      return this.right;
    }
    setOperator(value) {
      return this.setNode("operator", value);
    }
    getOperator() {
      return this.operator;
    }
  };
  var Term = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Term;
    }
    setOperator(value) {
      return this.setNode("operator", value);
    }
    getOperator() {
      return this.operator;
    }
    setExpression(value) {
      return this.setNode("expression", value);
    }
    getExpression() {
      return this.expression;
    }
  };
  var AttributeSelector = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.AttributeSelector;
    }
    setNamespacePrefix(value) {
      return this.setNode("namespacePrefix", value);
    }
    getNamespacePrefix() {
      return this.namespacePrefix;
    }
    setIdentifier(value) {
      return this.setNode("identifier", value);
    }
    getIdentifier() {
      return this.identifier;
    }
    setOperator(operator) {
      return this.setNode("operator", operator);
    }
    getOperator() {
      return this.operator;
    }
    setValue(value) {
      return this.setNode("value", value);
    }
    getValue() {
      return this.value;
    }
  };
  var HexColorValue = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.HexColorValue;
    }
  };
  var RatioValue = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.RatioValue;
    }
  };
  var _dot = ".".charCodeAt(0);
  var _02 = "0".charCodeAt(0);
  var _92 = "9".charCodeAt(0);
  var NumericValue = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.NumericValue;
    }
    getValue() {
      const raw = this.getText();
      let unitIdx = 0;
      let code;
      for (let i = 0, len = raw.length; i < len; i++) {
        code = raw.charCodeAt(i);
        if (!(_02 <= code && code <= _92 || code === _dot)) {
          break;
        }
        unitIdx += 1;
      }
      return {
        value: raw.substring(0, unitIdx),
        unit: unitIdx < raw.length ? raw.substring(unitIdx) : void 0
      };
    }
  };
  var VariableDeclaration = class extends AbstractDeclaration {
    constructor(offset, length) {
      super(offset, length);
      this.needsSemicolon = true;
    }
    get type() {
      return NodeType.VariableDeclaration;
    }
    setVariable(node) {
      if (node) {
        node.attachTo(this);
        this.variable = node;
        return true;
      }
      return false;
    }
    getVariable() {
      return this.variable;
    }
    getName() {
      return this.variable ? this.variable.getName() : "";
    }
    setValue(node) {
      if (node) {
        node.attachTo(this);
        this.value = node;
        return true;
      }
      return false;
    }
    getValue() {
      return this.value;
    }
  };
  var Interpolation = class extends Node {
    // private _interpolations: void; // workaround for https://github.com/Microsoft/TypeScript/issues/18276
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.Interpolation;
    }
  };
  var Variable = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.VariableName;
    }
    getName() {
      return this.getText();
    }
  };
  var ExtendsReference = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.ExtendsReference;
    }
    getSelectors() {
      if (!this.selectors) {
        this.selectors = new Nodelist(this);
      }
      return this.selectors;
    }
  };
  var MixinContentReference = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MixinContentReference;
    }
    getArguments() {
      if (!this.arguments) {
        this.arguments = new Nodelist(this);
      }
      return this.arguments;
    }
  };
  var MixinContentDeclaration = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MixinContentDeclaration;
    }
    getParameters() {
      if (!this.parameters) {
        this.parameters = new Nodelist(this);
      }
      return this.parameters;
    }
  };
  var MixinReference = class extends Node {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MixinReference;
    }
    getNamespaces() {
      if (!this.namespaces) {
        this.namespaces = new Nodelist(this);
      }
      return this.namespaces;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
    getArguments() {
      if (!this.arguments) {
        this.arguments = new Nodelist(this);
      }
      return this.arguments;
    }
    setContent(node) {
      return this.setNode("content", node);
    }
    getContent() {
      return this.content;
    }
  };
  var MixinDeclaration = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.MixinDeclaration;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
    getName() {
      return this.identifier ? this.identifier.getText() : "";
    }
    getParameters() {
      if (!this.parameters) {
        this.parameters = new Nodelist(this);
      }
      return this.parameters;
    }
    setGuard(node) {
      if (node) {
        node.attachTo(this);
        this.guard = node;
      }
      return false;
    }
  };
  var UnknownAtRule = class extends BodyDeclaration {
    constructor(offset, length) {
      super(offset, length);
    }
    get type() {
      return NodeType.UnknownAtRule;
    }
    setAtRuleName(atRuleName) {
      this.atRuleName = atRuleName;
    }
    getAtRuleName() {
      return this.atRuleName;
    }
  };
  var ListEntry = class extends Node {
    get type() {
      return NodeType.ListEntry;
    }
    setKey(node) {
      return this.setNode("key", node, 0);
    }
    setValue(node) {
      return this.setNode("value", node, 1);
    }
  };
  var LessGuard = class extends Node {
    getConditions() {
      if (!this.conditions) {
        this.conditions = new Nodelist(this);
      }
      return this.conditions;
    }
  };
  var GuardCondition = class extends Node {
    setVariable(node) {
      return this.setNode("variable", node);
    }
  };
  var Module = class extends Node {
    get type() {
      return NodeType.Module;
    }
    setIdentifier(node) {
      return this.setNode("identifier", node, 0);
    }
    getIdentifier() {
      return this.identifier;
    }
  };
  var Level;
  (function(Level2) {
    Level2[Level2["Ignore"] = 1] = "Ignore";
    Level2[Level2["Warning"] = 2] = "Warning";
    Level2[Level2["Error"] = 4] = "Error";
  })(Level || (Level = {}));
  var Marker = class {
    constructor(node, rule, level, message, offset = node.offset, length = node.length) {
      this.node = node;
      this.rule = rule;
      this.level = level;
      this.message = message || rule.message;
      this.offset = offset;
      this.length = length;
    }
    getRule() {
      return this.rule;
    }
    getLevel() {
      return this.level;
    }
    getOffset() {
      return this.offset;
    }
    getLength() {
      return this.length;
    }
    getNode() {
      return this.node;
    }
    getMessage() {
      return this.message;
    }
  };
  var ParseErrorCollector = class _ParseErrorCollector {
    static entries(node) {
      const visitor = new _ParseErrorCollector();
      node.acceptVisitor(visitor);
      return visitor.entries;
    }
    constructor() {
      this.entries = [];
    }
    visitNode(node) {
      if (node.isErroneous()) {
        node.collectIssues(this.entries);
      }
      return true;
    }
  };

  // node_modules/@vscode/l10n/dist/browser.js
  var bundle;
  function t(...args) {
    const firstArg = args[0];
    let key;
    let message;
    let formatArgs;
    if (typeof firstArg === "string") {
      key = firstArg;
      message = firstArg;
      args.splice(0, 1);
      formatArgs = !args || typeof args[0] !== "object" ? args : args[0];
    } else if (firstArg instanceof Array) {
      const replacements = args.slice(1);
      if (firstArg.length !== replacements.length + 1) {
        throw new Error("expected a string as the first argument to l10n.t");
      }
      let str = firstArg[0];
      for (let i = 1; i < firstArg.length; i++) {
        str += `{${i - 1}}` + firstArg[i];
      }
      return t(str, ...replacements);
    } else {
      message = firstArg.message;
      key = message;
      if (firstArg.comment && firstArg.comment.length > 0) {
        key += `/${Array.isArray(firstArg.comment) ? firstArg.comment.join("") : firstArg.comment}`;
      }
      formatArgs = firstArg.args ?? {};
    }
    const messageFromBundle = bundle?.[key];
    if (!messageFromBundle) {
      return format(message, formatArgs);
    }
    if (typeof messageFromBundle === "string") {
      return format(messageFromBundle, formatArgs);
    }
    if (messageFromBundle.comment) {
      return format(messageFromBundle.message, formatArgs);
    }
    return format(message, formatArgs);
  }
  var _format2Regexp = /{([^}]+)}/g;
  function format(template, values2) {
    if (Object.keys(values2).length === 0) {
      return template;
    }
    return template.replace(_format2Regexp, (match, group) => values2[group] ?? match);
  }

  // node_modules/vscode-css-languageservice/lib/esm/parser/cssErrors.js
  var CSSIssueType = class {
    constructor(id, message) {
      this.id = id;
      this.message = message;
    }
  };
  var ParseError = {
    NumberExpected: new CSSIssueType("css-numberexpected", t("number expected")),
    ConditionExpected: new CSSIssueType("css-conditionexpected", t("condition expected")),
    RuleOrSelectorExpected: new CSSIssueType("css-ruleorselectorexpected", t("at-rule or selector expected")),
    DotExpected: new CSSIssueType("css-dotexpected", t("dot expected")),
    ColonExpected: new CSSIssueType("css-colonexpected", t("colon expected")),
    SemiColonExpected: new CSSIssueType("css-semicolonexpected", t("semi-colon expected")),
    TermExpected: new CSSIssueType("css-termexpected", t("term expected")),
    ExpressionExpected: new CSSIssueType("css-expressionexpected", t("expression expected")),
    OperatorExpected: new CSSIssueType("css-operatorexpected", t("operator expected")),
    IdentifierExpected: new CSSIssueType("css-identifierexpected", t("identifier expected")),
    PercentageExpected: new CSSIssueType("css-percentageexpected", t("percentage expected")),
    URIOrStringExpected: new CSSIssueType("css-uriorstringexpected", t("uri or string expected")),
    URIExpected: new CSSIssueType("css-uriexpected", t("URI expected")),
    VariableNameExpected: new CSSIssueType("css-varnameexpected", t("variable name expected")),
    VariableValueExpected: new CSSIssueType("css-varvalueexpected", t("variable value expected")),
    PropertyValueExpected: new CSSIssueType("css-propertyvalueexpected", t("property value expected")),
    LeftCurlyExpected: new CSSIssueType("css-lcurlyexpected", t("{ expected")),
    RightCurlyExpected: new CSSIssueType("css-rcurlyexpected", t("} expected")),
    LeftSquareBracketExpected: new CSSIssueType("css-rbracketexpected", t("[ expected")),
    RightSquareBracketExpected: new CSSIssueType("css-lbracketexpected", t("] expected")),
    LeftParenthesisExpected: new CSSIssueType("css-lparentexpected", t("( expected")),
    RightParenthesisExpected: new CSSIssueType("css-rparentexpected", t(") expected")),
    CommaExpected: new CSSIssueType("css-commaexpected", t("comma expected")),
    PageDirectiveOrDeclarationExpected: new CSSIssueType("css-pagedirordeclexpected", t("page directive or declaraton expected")),
    UnknownAtRule: new CSSIssueType("css-unknownatrule", t("at-rule unknown")),
    UnknownKeyword: new CSSIssueType("css-unknownkeyword", t("unknown keyword")),
    SelectorExpected: new CSSIssueType("css-selectorexpected", t("selector expected")),
    StringLiteralExpected: new CSSIssueType("css-stringliteralexpected", t("string literal expected")),
    WhitespaceExpected: new CSSIssueType("css-whitespaceexpected", t("whitespace expected")),
    MediaQueryExpected: new CSSIssueType("css-mediaqueryexpected", t("media query expected")),
    IdentifierOrWildcardExpected: new CSSIssueType("css-idorwildcardexpected", t("identifier or wildcard expected")),
    WildcardExpected: new CSSIssueType("css-wildcardexpected", t("wildcard expected")),
    IdentifierOrVariableExpected: new CSSIssueType("css-idorvarexpected", t("identifier or variable expected"))
  };

  // node_modules/vscode-languageserver-types/lib/esm/main.js
  var DocumentUri;
  (function(DocumentUri2) {
    function is(value) {
      return typeof value === "string";
    }
    DocumentUri2.is = is;
  })(DocumentUri || (DocumentUri = {}));
  var URI;
  (function(URI3) {
    function is(value) {
      return typeof value === "string";
    }
    URI3.is = is;
  })(URI || (URI = {}));
  var integer;
  (function(integer2) {
    integer2.MIN_VALUE = -2147483648;
    integer2.MAX_VALUE = 2147483647;
    function is(value) {
      return typeof value === "number" && integer2.MIN_VALUE <= value && value <= integer2.MAX_VALUE;
    }
    integer2.is = is;
  })(integer || (integer = {}));
  var uinteger;
  (function(uinteger2) {
    uinteger2.MIN_VALUE = 0;
    uinteger2.MAX_VALUE = 2147483647;
    function is(value) {
      return typeof value === "number" && uinteger2.MIN_VALUE <= value && value <= uinteger2.MAX_VALUE;
    }
    uinteger2.is = is;
  })(uinteger || (uinteger = {}));
  var Position;
  (function(Position2) {
    function create2(line, character) {
      if (line === Number.MAX_VALUE) {
        line = uinteger.MAX_VALUE;
      }
      if (character === Number.MAX_VALUE) {
        character = uinteger.MAX_VALUE;
      }
      return { line, character };
    }
    Position2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Is.uinteger(candidate.line) && Is.uinteger(candidate.character);
    }
    Position2.is = is;
  })(Position || (Position = {}));
  var Range;
  (function(Range2) {
    function create2(one, two, three, four) {
      if (Is.uinteger(one) && Is.uinteger(two) && Is.uinteger(three) && Is.uinteger(four)) {
        return { start: Position.create(one, two), end: Position.create(three, four) };
      } else if (Position.is(one) && Position.is(two)) {
        return { start: one, end: two };
      } else {
        throw new Error(`Range#create called with invalid arguments[${one}, ${two}, ${three}, ${four}]`);
      }
    }
    Range2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
    }
    Range2.is = is;
  })(Range || (Range = {}));
  var Location;
  (function(Location2) {
    function create2(uri, range) {
      return { uri, range };
    }
    Location2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
    }
    Location2.is = is;
  })(Location || (Location = {}));
  var LocationLink;
  (function(LocationLink2) {
    function create2(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
      return { targetUri, targetRange, targetSelectionRange, originSelectionRange };
    }
    LocationLink2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri) && Range.is(candidate.targetSelectionRange) && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
    }
    LocationLink2.is = is;
  })(LocationLink || (LocationLink = {}));
  var Color;
  (function(Color2) {
    function create2(red, green, blue, alpha) {
      return {
        red,
        green,
        blue,
        alpha
      };
    }
    Color2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.numberRange(candidate.red, 0, 1) && Is.numberRange(candidate.green, 0, 1) && Is.numberRange(candidate.blue, 0, 1) && Is.numberRange(candidate.alpha, 0, 1);
    }
    Color2.is = is;
  })(Color || (Color = {}));
  var ColorInformation;
  (function(ColorInformation2) {
    function create2(range, color) {
      return {
        range,
        color
      };
    }
    ColorInformation2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.range) && Color.is(candidate.color);
    }
    ColorInformation2.is = is;
  })(ColorInformation || (ColorInformation = {}));
  var ColorPresentation;
  (function(ColorPresentation2) {
    function create2(label, textEdit, additionalTextEdits) {
      return {
        label,
        textEdit,
        additionalTextEdits
      };
    }
    ColorPresentation2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate)) && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
    }
    ColorPresentation2.is = is;
  })(ColorPresentation || (ColorPresentation = {}));
  var FoldingRangeKind;
  (function(FoldingRangeKind2) {
    FoldingRangeKind2.Comment = "comment";
    FoldingRangeKind2.Imports = "imports";
    FoldingRangeKind2.Region = "region";
  })(FoldingRangeKind || (FoldingRangeKind = {}));
  var FoldingRange;
  (function(FoldingRange2) {
    function create2(startLine, endLine, startCharacter, endCharacter, kind, collapsedText) {
      const result = {
        startLine,
        endLine
      };
      if (Is.defined(startCharacter)) {
        result.startCharacter = startCharacter;
      }
      if (Is.defined(endCharacter)) {
        result.endCharacter = endCharacter;
      }
      if (Is.defined(kind)) {
        result.kind = kind;
      }
      if (Is.defined(collapsedText)) {
        result.collapsedText = collapsedText;
      }
      return result;
    }
    FoldingRange2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.uinteger(candidate.startLine) && Is.uinteger(candidate.startLine) && (Is.undefined(candidate.startCharacter) || Is.uinteger(candidate.startCharacter)) && (Is.undefined(candidate.endCharacter) || Is.uinteger(candidate.endCharacter)) && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
    }
    FoldingRange2.is = is;
  })(FoldingRange || (FoldingRange = {}));
  var DiagnosticRelatedInformation;
  (function(DiagnosticRelatedInformation2) {
    function create2(location, message) {
      return {
        location,
        message
      };
    }
    DiagnosticRelatedInformation2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
    }
    DiagnosticRelatedInformation2.is = is;
  })(DiagnosticRelatedInformation || (DiagnosticRelatedInformation = {}));
  var DiagnosticSeverity;
  (function(DiagnosticSeverity2) {
    DiagnosticSeverity2.Error = 1;
    DiagnosticSeverity2.Warning = 2;
    DiagnosticSeverity2.Information = 3;
    DiagnosticSeverity2.Hint = 4;
  })(DiagnosticSeverity || (DiagnosticSeverity = {}));
  var DiagnosticTag;
  (function(DiagnosticTag2) {
    DiagnosticTag2.Unnecessary = 1;
    DiagnosticTag2.Deprecated = 2;
  })(DiagnosticTag || (DiagnosticTag = {}));
  var CodeDescription;
  (function(CodeDescription2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.href);
    }
    CodeDescription2.is = is;
  })(CodeDescription || (CodeDescription = {}));
  var Diagnostic;
  (function(Diagnostic2) {
    function create2(range, message, severity, code, source, relatedInformation) {
      let result = { range, message };
      if (Is.defined(severity)) {
        result.severity = severity;
      }
      if (Is.defined(code)) {
        result.code = code;
      }
      if (Is.defined(source)) {
        result.source = source;
      }
      if (Is.defined(relatedInformation)) {
        result.relatedInformation = relatedInformation;
      }
      return result;
    }
    Diagnostic2.create = create2;
    function is(value) {
      var _a2;
      let candidate = value;
      return Is.defined(candidate) && Range.is(candidate.range) && Is.string(candidate.message) && (Is.number(candidate.severity) || Is.undefined(candidate.severity)) && (Is.integer(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code)) && (Is.undefined(candidate.codeDescription) || Is.string((_a2 = candidate.codeDescription) === null || _a2 === void 0 ? void 0 : _a2.href)) && (Is.string(candidate.source) || Is.undefined(candidate.source)) && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
    }
    Diagnostic2.is = is;
  })(Diagnostic || (Diagnostic = {}));
  var Command;
  (function(Command2) {
    function create2(title, command, ...args) {
      let result = { title, command };
      if (Is.defined(args) && args.length > 0) {
        result.arguments = args;
      }
      return result;
    }
    Command2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
    }
    Command2.is = is;
  })(Command || (Command = {}));
  var TextEdit;
  (function(TextEdit2) {
    function replace(range, newText) {
      return { range, newText };
    }
    TextEdit2.replace = replace;
    function insert(position, newText) {
      return { range: { start: position, end: position }, newText };
    }
    TextEdit2.insert = insert;
    function del(range) {
      return { range, newText: "" };
    }
    TextEdit2.del = del;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.newText) && Range.is(candidate.range);
    }
    TextEdit2.is = is;
  })(TextEdit || (TextEdit = {}));
  var ChangeAnnotation;
  (function(ChangeAnnotation2) {
    function create2(label, needsConfirmation, description) {
      const result = { label };
      if (needsConfirmation !== void 0) {
        result.needsConfirmation = needsConfirmation;
      }
      if (description !== void 0) {
        result.description = description;
      }
      return result;
    }
    ChangeAnnotation2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Is.string(candidate.label) && (Is.boolean(candidate.needsConfirmation) || candidate.needsConfirmation === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
    }
    ChangeAnnotation2.is = is;
  })(ChangeAnnotation || (ChangeAnnotation = {}));
  var ChangeAnnotationIdentifier;
  (function(ChangeAnnotationIdentifier2) {
    function is(value) {
      const candidate = value;
      return Is.string(candidate);
    }
    ChangeAnnotationIdentifier2.is = is;
  })(ChangeAnnotationIdentifier || (ChangeAnnotationIdentifier = {}));
  var AnnotatedTextEdit;
  (function(AnnotatedTextEdit2) {
    function replace(range, newText, annotation) {
      return { range, newText, annotationId: annotation };
    }
    AnnotatedTextEdit2.replace = replace;
    function insert(position, newText, annotation) {
      return { range: { start: position, end: position }, newText, annotationId: annotation };
    }
    AnnotatedTextEdit2.insert = insert;
    function del(range, annotation) {
      return { range, newText: "", annotationId: annotation };
    }
    AnnotatedTextEdit2.del = del;
    function is(value) {
      const candidate = value;
      return TextEdit.is(candidate) && (ChangeAnnotation.is(candidate.annotationId) || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    AnnotatedTextEdit2.is = is;
  })(AnnotatedTextEdit || (AnnotatedTextEdit = {}));
  var TextDocumentEdit;
  (function(TextDocumentEdit2) {
    function create2(textDocument, edits) {
      return { textDocument, edits };
    }
    TextDocumentEdit2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && OptionalVersionedTextDocumentIdentifier.is(candidate.textDocument) && Array.isArray(candidate.edits);
    }
    TextDocumentEdit2.is = is;
  })(TextDocumentEdit || (TextDocumentEdit = {}));
  var CreateFile;
  (function(CreateFile2) {
    function create2(uri, options, annotation) {
      let result = {
        kind: "create",
        uri
      };
      if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
        result.options = options;
      }
      if (annotation !== void 0) {
        result.annotationId = annotation;
      }
      return result;
    }
    CreateFile2.create = create2;
    function is(value) {
      let candidate = value;
      return candidate && candidate.kind === "create" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    CreateFile2.is = is;
  })(CreateFile || (CreateFile = {}));
  var RenameFile;
  (function(RenameFile2) {
    function create2(oldUri, newUri, options, annotation) {
      let result = {
        kind: "rename",
        oldUri,
        newUri
      };
      if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
        result.options = options;
      }
      if (annotation !== void 0) {
        result.annotationId = annotation;
      }
      return result;
    }
    RenameFile2.create = create2;
    function is(value) {
      let candidate = value;
      return candidate && candidate.kind === "rename" && Is.string(candidate.oldUri) && Is.string(candidate.newUri) && (candidate.options === void 0 || (candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    RenameFile2.is = is;
  })(RenameFile || (RenameFile = {}));
  var DeleteFile;
  (function(DeleteFile2) {
    function create2(uri, options, annotation) {
      let result = {
        kind: "delete",
        uri
      };
      if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
        result.options = options;
      }
      if (annotation !== void 0) {
        result.annotationId = annotation;
      }
      return result;
    }
    DeleteFile2.create = create2;
    function is(value) {
      let candidate = value;
      return candidate && candidate.kind === "delete" && Is.string(candidate.uri) && (candidate.options === void 0 || (candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))) && (candidate.annotationId === void 0 || ChangeAnnotationIdentifier.is(candidate.annotationId));
    }
    DeleteFile2.is = is;
  })(DeleteFile || (DeleteFile = {}));
  var WorkspaceEdit;
  (function(WorkspaceEdit2) {
    function is(value) {
      let candidate = value;
      return candidate && (candidate.changes !== void 0 || candidate.documentChanges !== void 0) && (candidate.documentChanges === void 0 || candidate.documentChanges.every((change) => {
        if (Is.string(change.kind)) {
          return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
        } else {
          return TextDocumentEdit.is(change);
        }
      }));
    }
    WorkspaceEdit2.is = is;
  })(WorkspaceEdit || (WorkspaceEdit = {}));
  var TextDocumentIdentifier;
  (function(TextDocumentIdentifier2) {
    function create2(uri) {
      return { uri };
    }
    TextDocumentIdentifier2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri);
    }
    TextDocumentIdentifier2.is = is;
  })(TextDocumentIdentifier || (TextDocumentIdentifier = {}));
  var VersionedTextDocumentIdentifier;
  (function(VersionedTextDocumentIdentifier2) {
    function create2(uri, version) {
      return { uri, version };
    }
    VersionedTextDocumentIdentifier2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && Is.integer(candidate.version);
    }
    VersionedTextDocumentIdentifier2.is = is;
  })(VersionedTextDocumentIdentifier || (VersionedTextDocumentIdentifier = {}));
  var OptionalVersionedTextDocumentIdentifier;
  (function(OptionalVersionedTextDocumentIdentifier2) {
    function create2(uri, version) {
      return { uri, version };
    }
    OptionalVersionedTextDocumentIdentifier2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.integer(candidate.version));
    }
    OptionalVersionedTextDocumentIdentifier2.is = is;
  })(OptionalVersionedTextDocumentIdentifier || (OptionalVersionedTextDocumentIdentifier = {}));
  var TextDocumentItem;
  (function(TextDocumentItem2) {
    function create2(uri, languageId, version, text) {
      return { uri, languageId, version, text };
    }
    TextDocumentItem2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.integer(candidate.version) && Is.string(candidate.text);
    }
    TextDocumentItem2.is = is;
  })(TextDocumentItem || (TextDocumentItem = {}));
  var MarkupKind;
  (function(MarkupKind2) {
    MarkupKind2.PlainText = "plaintext";
    MarkupKind2.Markdown = "markdown";
    function is(value) {
      const candidate = value;
      return candidate === MarkupKind2.PlainText || candidate === MarkupKind2.Markdown;
    }
    MarkupKind2.is = is;
  })(MarkupKind || (MarkupKind = {}));
  var MarkupContent;
  (function(MarkupContent2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
    }
    MarkupContent2.is = is;
  })(MarkupContent || (MarkupContent = {}));
  var CompletionItemKind;
  (function(CompletionItemKind2) {
    CompletionItemKind2.Text = 1;
    CompletionItemKind2.Method = 2;
    CompletionItemKind2.Function = 3;
    CompletionItemKind2.Constructor = 4;
    CompletionItemKind2.Field = 5;
    CompletionItemKind2.Variable = 6;
    CompletionItemKind2.Class = 7;
    CompletionItemKind2.Interface = 8;
    CompletionItemKind2.Module = 9;
    CompletionItemKind2.Property = 10;
    CompletionItemKind2.Unit = 11;
    CompletionItemKind2.Value = 12;
    CompletionItemKind2.Enum = 13;
    CompletionItemKind2.Keyword = 14;
    CompletionItemKind2.Snippet = 15;
    CompletionItemKind2.Color = 16;
    CompletionItemKind2.File = 17;
    CompletionItemKind2.Reference = 18;
    CompletionItemKind2.Folder = 19;
    CompletionItemKind2.EnumMember = 20;
    CompletionItemKind2.Constant = 21;
    CompletionItemKind2.Struct = 22;
    CompletionItemKind2.Event = 23;
    CompletionItemKind2.Operator = 24;
    CompletionItemKind2.TypeParameter = 25;
  })(CompletionItemKind || (CompletionItemKind = {}));
  var InsertTextFormat;
  (function(InsertTextFormat2) {
    InsertTextFormat2.PlainText = 1;
    InsertTextFormat2.Snippet = 2;
  })(InsertTextFormat || (InsertTextFormat = {}));
  var CompletionItemTag;
  (function(CompletionItemTag2) {
    CompletionItemTag2.Deprecated = 1;
  })(CompletionItemTag || (CompletionItemTag = {}));
  var InsertReplaceEdit;
  (function(InsertReplaceEdit2) {
    function create2(newText, insert, replace) {
      return { newText, insert, replace };
    }
    InsertReplaceEdit2.create = create2;
    function is(value) {
      const candidate = value;
      return candidate && Is.string(candidate.newText) && Range.is(candidate.insert) && Range.is(candidate.replace);
    }
    InsertReplaceEdit2.is = is;
  })(InsertReplaceEdit || (InsertReplaceEdit = {}));
  var InsertTextMode;
  (function(InsertTextMode2) {
    InsertTextMode2.asIs = 1;
    InsertTextMode2.adjustIndentation = 2;
  })(InsertTextMode || (InsertTextMode = {}));
  var CompletionItemLabelDetails;
  (function(CompletionItemLabelDetails2) {
    function is(value) {
      const candidate = value;
      return candidate && (Is.string(candidate.detail) || candidate.detail === void 0) && (Is.string(candidate.description) || candidate.description === void 0);
    }
    CompletionItemLabelDetails2.is = is;
  })(CompletionItemLabelDetails || (CompletionItemLabelDetails = {}));
  var CompletionItem;
  (function(CompletionItem2) {
    function create2(label) {
      return { label };
    }
    CompletionItem2.create = create2;
  })(CompletionItem || (CompletionItem = {}));
  var CompletionList;
  (function(CompletionList2) {
    function create2(items, isIncomplete) {
      return { items: items ? items : [], isIncomplete: !!isIncomplete };
    }
    CompletionList2.create = create2;
  })(CompletionList || (CompletionList = {}));
  var MarkedString;
  (function(MarkedString2) {
    function fromPlainText(plainText) {
      return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
    }
    MarkedString2.fromPlainText = fromPlainText;
    function is(value) {
      const candidate = value;
      return Is.string(candidate) || Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value);
    }
    MarkedString2.is = is;
  })(MarkedString || (MarkedString = {}));
  var Hover;
  (function(Hover2) {
    function is(value) {
      let candidate = value;
      return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) || MarkedString.is(candidate.contents) || Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
    }
    Hover2.is = is;
  })(Hover || (Hover = {}));
  var ParameterInformation;
  (function(ParameterInformation2) {
    function create2(label, documentation) {
      return documentation ? { label, documentation } : { label };
    }
    ParameterInformation2.create = create2;
  })(ParameterInformation || (ParameterInformation = {}));
  var SignatureInformation;
  (function(SignatureInformation2) {
    function create2(label, documentation, ...parameters) {
      let result = { label };
      if (Is.defined(documentation)) {
        result.documentation = documentation;
      }
      if (Is.defined(parameters)) {
        result.parameters = parameters;
      } else {
        result.parameters = [];
      }
      return result;
    }
    SignatureInformation2.create = create2;
  })(SignatureInformation || (SignatureInformation = {}));
  var DocumentHighlightKind;
  (function(DocumentHighlightKind2) {
    DocumentHighlightKind2.Text = 1;
    DocumentHighlightKind2.Read = 2;
    DocumentHighlightKind2.Write = 3;
  })(DocumentHighlightKind || (DocumentHighlightKind = {}));
  var DocumentHighlight;
  (function(DocumentHighlight2) {
    function create2(range, kind) {
      let result = { range };
      if (Is.number(kind)) {
        result.kind = kind;
      }
      return result;
    }
    DocumentHighlight2.create = create2;
  })(DocumentHighlight || (DocumentHighlight = {}));
  var SymbolKind;
  (function(SymbolKind2) {
    SymbolKind2.File = 1;
    SymbolKind2.Module = 2;
    SymbolKind2.Namespace = 3;
    SymbolKind2.Package = 4;
    SymbolKind2.Class = 5;
    SymbolKind2.Method = 6;
    SymbolKind2.Property = 7;
    SymbolKind2.Field = 8;
    SymbolKind2.Constructor = 9;
    SymbolKind2.Enum = 10;
    SymbolKind2.Interface = 11;
    SymbolKind2.Function = 12;
    SymbolKind2.Variable = 13;
    SymbolKind2.Constant = 14;
    SymbolKind2.String = 15;
    SymbolKind2.Number = 16;
    SymbolKind2.Boolean = 17;
    SymbolKind2.Array = 18;
    SymbolKind2.Object = 19;
    SymbolKind2.Key = 20;
    SymbolKind2.Null = 21;
    SymbolKind2.EnumMember = 22;
    SymbolKind2.Struct = 23;
    SymbolKind2.Event = 24;
    SymbolKind2.Operator = 25;
    SymbolKind2.TypeParameter = 26;
  })(SymbolKind || (SymbolKind = {}));
  var SymbolTag;
  (function(SymbolTag2) {
    SymbolTag2.Deprecated = 1;
  })(SymbolTag || (SymbolTag = {}));
  var SymbolInformation;
  (function(SymbolInformation2) {
    function create2(name, kind, range, uri, containerName) {
      let result = {
        name,
        kind,
        location: { uri, range }
      };
      if (containerName) {
        result.containerName = containerName;
      }
      return result;
    }
    SymbolInformation2.create = create2;
  })(SymbolInformation || (SymbolInformation = {}));
  var WorkspaceSymbol;
  (function(WorkspaceSymbol2) {
    function create2(name, kind, uri, range) {
      return range !== void 0 ? { name, kind, location: { uri, range } } : { name, kind, location: { uri } };
    }
    WorkspaceSymbol2.create = create2;
  })(WorkspaceSymbol || (WorkspaceSymbol = {}));
  var DocumentSymbol;
  (function(DocumentSymbol2) {
    function create2(name, detail, kind, range, selectionRange, children) {
      let result = {
        name,
        detail,
        kind,
        range,
        selectionRange
      };
      if (children !== void 0) {
        result.children = children;
      }
      return result;
    }
    DocumentSymbol2.create = create2;
    function is(value) {
      let candidate = value;
      return candidate && Is.string(candidate.name) && Is.number(candidate.kind) && Range.is(candidate.range) && Range.is(candidate.selectionRange) && (candidate.detail === void 0 || Is.string(candidate.detail)) && (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) && (candidate.children === void 0 || Array.isArray(candidate.children)) && (candidate.tags === void 0 || Array.isArray(candidate.tags));
    }
    DocumentSymbol2.is = is;
  })(DocumentSymbol || (DocumentSymbol = {}));
  var CodeActionKind;
  (function(CodeActionKind2) {
    CodeActionKind2.Empty = "";
    CodeActionKind2.QuickFix = "quickfix";
    CodeActionKind2.Refactor = "refactor";
    CodeActionKind2.RefactorExtract = "refactor.extract";
    CodeActionKind2.RefactorInline = "refactor.inline";
    CodeActionKind2.RefactorRewrite = "refactor.rewrite";
    CodeActionKind2.Source = "source";
    CodeActionKind2.SourceOrganizeImports = "source.organizeImports";
    CodeActionKind2.SourceFixAll = "source.fixAll";
  })(CodeActionKind || (CodeActionKind = {}));
  var CodeActionTriggerKind;
  (function(CodeActionTriggerKind2) {
    CodeActionTriggerKind2.Invoked = 1;
    CodeActionTriggerKind2.Automatic = 2;
  })(CodeActionTriggerKind || (CodeActionTriggerKind = {}));
  var CodeActionContext;
  (function(CodeActionContext2) {
    function create2(diagnostics, only, triggerKind) {
      let result = { diagnostics };
      if (only !== void 0 && only !== null) {
        result.only = only;
      }
      if (triggerKind !== void 0 && triggerKind !== null) {
        result.triggerKind = triggerKind;
      }
      return result;
    }
    CodeActionContext2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string)) && (candidate.triggerKind === void 0 || candidate.triggerKind === CodeActionTriggerKind.Invoked || candidate.triggerKind === CodeActionTriggerKind.Automatic);
    }
    CodeActionContext2.is = is;
  })(CodeActionContext || (CodeActionContext = {}));
  var CodeAction;
  (function(CodeAction2) {
    function create2(title, kindOrCommandOrEdit, kind) {
      let result = { title };
      let checkKind = true;
      if (typeof kindOrCommandOrEdit === "string") {
        checkKind = false;
        result.kind = kindOrCommandOrEdit;
      } else if (Command.is(kindOrCommandOrEdit)) {
        result.command = kindOrCommandOrEdit;
      } else {
        result.edit = kindOrCommandOrEdit;
      }
      if (checkKind && kind !== void 0) {
        result.kind = kind;
      }
      return result;
    }
    CodeAction2.create = create2;
    function is(value) {
      let candidate = value;
      return candidate && Is.string(candidate.title) && (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) && (candidate.kind === void 0 || Is.string(candidate.kind)) && (candidate.edit !== void 0 || candidate.command !== void 0) && (candidate.command === void 0 || Command.is(candidate.command)) && (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) && (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
    }
    CodeAction2.is = is;
  })(CodeAction || (CodeAction = {}));
  var CodeLens;
  (function(CodeLens2) {
    function create2(range, data) {
      let result = { range };
      if (Is.defined(data)) {
        result.data = data;
      }
      return result;
    }
    CodeLens2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
    }
    CodeLens2.is = is;
  })(CodeLens || (CodeLens = {}));
  var FormattingOptions;
  (function(FormattingOptions2) {
    function create2(tabSize, insertSpaces) {
      return { tabSize, insertSpaces };
    }
    FormattingOptions2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.uinteger(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
    }
    FormattingOptions2.is = is;
  })(FormattingOptions || (FormattingOptions = {}));
  var DocumentLink;
  (function(DocumentLink2) {
    function create2(range, target, data) {
      return { range, target, data };
    }
    DocumentLink2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
    }
    DocumentLink2.is = is;
  })(DocumentLink || (DocumentLink = {}));
  var SelectionRange;
  (function(SelectionRange2) {
    function create2(range, parent) {
      return { range, parent };
    }
    SelectionRange2.create = create2;
    function is(value) {
      let candidate = value;
      return Is.objectLiteral(candidate) && Range.is(candidate.range) && (candidate.parent === void 0 || SelectionRange2.is(candidate.parent));
    }
    SelectionRange2.is = is;
  })(SelectionRange || (SelectionRange = {}));
  var SemanticTokenTypes;
  (function(SemanticTokenTypes2) {
    SemanticTokenTypes2["namespace"] = "namespace";
    SemanticTokenTypes2["type"] = "type";
    SemanticTokenTypes2["class"] = "class";
    SemanticTokenTypes2["enum"] = "enum";
    SemanticTokenTypes2["interface"] = "interface";
    SemanticTokenTypes2["struct"] = "struct";
    SemanticTokenTypes2["typeParameter"] = "typeParameter";
    SemanticTokenTypes2["parameter"] = "parameter";
    SemanticTokenTypes2["variable"] = "variable";
    SemanticTokenTypes2["property"] = "property";
    SemanticTokenTypes2["enumMember"] = "enumMember";
    SemanticTokenTypes2["event"] = "event";
    SemanticTokenTypes2["function"] = "function";
    SemanticTokenTypes2["method"] = "method";
    SemanticTokenTypes2["macro"] = "macro";
    SemanticTokenTypes2["keyword"] = "keyword";
    SemanticTokenTypes2["modifier"] = "modifier";
    SemanticTokenTypes2["comment"] = "comment";
    SemanticTokenTypes2["string"] = "string";
    SemanticTokenTypes2["number"] = "number";
    SemanticTokenTypes2["regexp"] = "regexp";
    SemanticTokenTypes2["operator"] = "operator";
    SemanticTokenTypes2["decorator"] = "decorator";
  })(SemanticTokenTypes || (SemanticTokenTypes = {}));
  var SemanticTokenModifiers;
  (function(SemanticTokenModifiers2) {
    SemanticTokenModifiers2["declaration"] = "declaration";
    SemanticTokenModifiers2["definition"] = "definition";
    SemanticTokenModifiers2["readonly"] = "readonly";
    SemanticTokenModifiers2["static"] = "static";
    SemanticTokenModifiers2["deprecated"] = "deprecated";
    SemanticTokenModifiers2["abstract"] = "abstract";
    SemanticTokenModifiers2["async"] = "async";
    SemanticTokenModifiers2["modification"] = "modification";
    SemanticTokenModifiers2["documentation"] = "documentation";
    SemanticTokenModifiers2["defaultLibrary"] = "defaultLibrary";
  })(SemanticTokenModifiers || (SemanticTokenModifiers = {}));
  var SemanticTokens;
  (function(SemanticTokens2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && (candidate.resultId === void 0 || typeof candidate.resultId === "string") && Array.isArray(candidate.data) && (candidate.data.length === 0 || typeof candidate.data[0] === "number");
    }
    SemanticTokens2.is = is;
  })(SemanticTokens || (SemanticTokens = {}));
  var InlineValueText;
  (function(InlineValueText2) {
    function create2(range, text) {
      return { range, text };
    }
    InlineValueText2.create = create2;
    function is(value) {
      const candidate = value;
      return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && Is.string(candidate.text);
    }
    InlineValueText2.is = is;
  })(InlineValueText || (InlineValueText = {}));
  var InlineValueVariableLookup;
  (function(InlineValueVariableLookup2) {
    function create2(range, variableName, caseSensitiveLookup) {
      return { range, variableName, caseSensitiveLookup };
    }
    InlineValueVariableLookup2.create = create2;
    function is(value) {
      const candidate = value;
      return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && Is.boolean(candidate.caseSensitiveLookup) && (Is.string(candidate.variableName) || candidate.variableName === void 0);
    }
    InlineValueVariableLookup2.is = is;
  })(InlineValueVariableLookup || (InlineValueVariableLookup = {}));
  var InlineValueEvaluatableExpression;
  (function(InlineValueEvaluatableExpression2) {
    function create2(range, expression) {
      return { range, expression };
    }
    InlineValueEvaluatableExpression2.create = create2;
    function is(value) {
      const candidate = value;
      return candidate !== void 0 && candidate !== null && Range.is(candidate.range) && (Is.string(candidate.expression) || candidate.expression === void 0);
    }
    InlineValueEvaluatableExpression2.is = is;
  })(InlineValueEvaluatableExpression || (InlineValueEvaluatableExpression = {}));
  var InlineValueContext;
  (function(InlineValueContext2) {
    function create2(frameId, stoppedLocation) {
      return { frameId, stoppedLocation };
    }
    InlineValueContext2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.defined(candidate) && Range.is(value.stoppedLocation);
    }
    InlineValueContext2.is = is;
  })(InlineValueContext || (InlineValueContext = {}));
  var InlayHintKind;
  (function(InlayHintKind2) {
    InlayHintKind2.Type = 1;
    InlayHintKind2.Parameter = 2;
    function is(value) {
      return value === 1 || value === 2;
    }
    InlayHintKind2.is = is;
  })(InlayHintKind || (InlayHintKind = {}));
  var InlayHintLabelPart;
  (function(InlayHintLabelPart2) {
    function create2(value) {
      return { value };
    }
    InlayHintLabelPart2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && (candidate.tooltip === void 0 || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip)) && (candidate.location === void 0 || Location.is(candidate.location)) && (candidate.command === void 0 || Command.is(candidate.command));
    }
    InlayHintLabelPart2.is = is;
  })(InlayHintLabelPart || (InlayHintLabelPart = {}));
  var InlayHint;
  (function(InlayHint2) {
    function create2(position, label, kind) {
      const result = { position, label };
      if (kind !== void 0) {
        result.kind = kind;
      }
      return result;
    }
    InlayHint2.create = create2;
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && Position.is(candidate.position) && (Is.string(candidate.label) || Is.typedArray(candidate.label, InlayHintLabelPart.is)) && (candidate.kind === void 0 || InlayHintKind.is(candidate.kind)) && candidate.textEdits === void 0 || Is.typedArray(candidate.textEdits, TextEdit.is) && (candidate.tooltip === void 0 || Is.string(candidate.tooltip) || MarkupContent.is(candidate.tooltip)) && (candidate.paddingLeft === void 0 || Is.boolean(candidate.paddingLeft)) && (candidate.paddingRight === void 0 || Is.boolean(candidate.paddingRight));
    }
    InlayHint2.is = is;
  })(InlayHint || (InlayHint = {}));
  var StringValue;
  (function(StringValue2) {
    function createSnippet(value) {
      return { kind: "snippet", value };
    }
    StringValue2.createSnippet = createSnippet;
  })(StringValue || (StringValue = {}));
  var InlineCompletionItem;
  (function(InlineCompletionItem2) {
    function create2(insertText, filterText, range, command) {
      return { insertText, filterText, range, command };
    }
    InlineCompletionItem2.create = create2;
  })(InlineCompletionItem || (InlineCompletionItem = {}));
  var InlineCompletionList;
  (function(InlineCompletionList2) {
    function create2(items) {
      return { items };
    }
    InlineCompletionList2.create = create2;
  })(InlineCompletionList || (InlineCompletionList = {}));
  var InlineCompletionTriggerKind;
  (function(InlineCompletionTriggerKind2) {
    InlineCompletionTriggerKind2.Invoked = 0;
    InlineCompletionTriggerKind2.Automatic = 1;
  })(InlineCompletionTriggerKind || (InlineCompletionTriggerKind = {}));
  var SelectedCompletionInfo;
  (function(SelectedCompletionInfo2) {
    function create2(range, text) {
      return { range, text };
    }
    SelectedCompletionInfo2.create = create2;
  })(SelectedCompletionInfo || (SelectedCompletionInfo = {}));
  var InlineCompletionContext;
  (function(InlineCompletionContext2) {
    function create2(triggerKind, selectedCompletionInfo) {
      return { triggerKind, selectedCompletionInfo };
    }
    InlineCompletionContext2.create = create2;
  })(InlineCompletionContext || (InlineCompletionContext = {}));
  var WorkspaceFolder;
  (function(WorkspaceFolder2) {
    function is(value) {
      const candidate = value;
      return Is.objectLiteral(candidate) && URI.is(candidate.uri) && Is.string(candidate.name);
    }
    WorkspaceFolder2.is = is;
  })(WorkspaceFolder || (WorkspaceFolder = {}));
  var TextDocument;
  (function(TextDocument3) {
    function create2(uri, languageId, version, content) {
      return new FullTextDocument(uri, languageId, version, content);
    }
    TextDocument3.create = create2;
    function is(value) {
      let candidate = value;
      return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.uinteger(candidate.lineCount) && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
    }
    TextDocument3.is = is;
    function applyEdits(document, edits) {
      let text = document.getText();
      let sortedEdits = mergeSort2(edits, (a2, b) => {
        let diff = a2.range.start.line - b.range.start.line;
        if (diff === 0) {
          return a2.range.start.character - b.range.start.character;
        }
        return diff;
      });
      let lastModifiedOffset = text.length;
      for (let i = sortedEdits.length - 1; i >= 0; i--) {
        let e = sortedEdits[i];
        let startOffset = document.offsetAt(e.range.start);
        let endOffset = document.offsetAt(e.range.end);
        if (endOffset <= lastModifiedOffset) {
          text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
        } else {
          throw new Error("Overlapping edit");
        }
        lastModifiedOffset = startOffset;
      }
      return text;
    }
    TextDocument3.applyEdits = applyEdits;
    function mergeSort2(data, compare) {
      if (data.length <= 1) {
        return data;
      }
      const p = data.length / 2 | 0;
      const left = data.slice(0, p);
      const right = data.slice(p);
      mergeSort2(left, compare);
      mergeSort2(right, compare);
      let leftIdx = 0;
      let rightIdx = 0;
      let i = 0;
      while (leftIdx < left.length && rightIdx < right.length) {
        let ret = compare(left[leftIdx], right[rightIdx]);
        if (ret <= 0) {
          data[i++] = left[leftIdx++];
        } else {
          data[i++] = right[rightIdx++];
        }
      }
      while (leftIdx < left.length) {
        data[i++] = left[leftIdx++];
      }
      while (rightIdx < right.length) {
        data[i++] = right[rightIdx++];
      }
      return data;
    }
  })(TextDocument || (TextDocument = {}));
  var FullTextDocument = class {
    constructor(uri, languageId, version, content) {
      this._uri = uri;
      this._languageId = languageId;
      this._version = version;
      this._content = content;
      this._lineOffsets = void 0;
    }
    get uri() {
      return this._uri;
    }
    get languageId() {
      return this._languageId;
    }
    get version() {
      return this._version;
    }
    getText(range) {
      if (range) {
        let start = this.offsetAt(range.start);
        let end = this.offsetAt(range.end);
        return this._content.substring(start, end);
      }
      return this._content;
    }
    update(event, version) {
      this._content = event.text;
      this._version = version;
      this._lineOffsets = void 0;
    }
    getLineOffsets() {
      if (this._lineOffsets === void 0) {
        let lineOffsets = [];
        let text = this._content;
        let isLineStart = true;
        for (let i = 0; i < text.length; i++) {
          if (isLineStart) {
            lineOffsets.push(i);
            isLineStart = false;
          }
          let ch = text.charAt(i);
          isLineStart = ch === "\r" || ch === "\n";
          if (ch === "\r" && i + 1 < text.length && text.charAt(i + 1) === "\n") {
            i++;
          }
        }
        if (isLineStart && text.length > 0) {
          lineOffsets.push(text.length);
        }
        this._lineOffsets = lineOffsets;
      }
      return this._lineOffsets;
    }
    positionAt(offset) {
      offset = Math.max(Math.min(offset, this._content.length), 0);
      let lineOffsets = this.getLineOffsets();
      let low = 0, high = lineOffsets.length;
      if (high === 0) {
        return Position.create(0, offset);
      }
      while (low < high) {
        let mid = Math.floor((low + high) / 2);
        if (lineOffsets[mid] > offset) {
          high = mid;
        } else {
          low = mid + 1;
        }
      }
      let line = low - 1;
      return Position.create(line, offset - lineOffsets[line]);
    }
    offsetAt(position) {
      let lineOffsets = this.getLineOffsets();
      if (position.line >= lineOffsets.length) {
        return this._content.length;
      } else if (position.line < 0) {
        return 0;
      }
      let lineOffset = lineOffsets[position.line];
      let nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
      return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    }
    get lineCount() {
      return this.getLineOffsets().length;
    }
  };
  var Is;
  (function(Is2) {
    const toString = Object.prototype.toString;
    function defined(value) {
      return typeof value !== "undefined";
    }
    Is2.defined = defined;
    function undefined2(value) {
      return typeof value === "undefined";
    }
    Is2.undefined = undefined2;
    function boolean(value) {
      return value === true || value === false;
    }
    Is2.boolean = boolean;
    function string(value) {
      return toString.call(value) === "[object String]";
    }
    Is2.string = string;
    function number(value) {
      return toString.call(value) === "[object Number]";
    }
    Is2.number = number;
    function numberRange(value, min, max) {
      return toString.call(value) === "[object Number]" && min <= value && value <= max;
    }
    Is2.numberRange = numberRange;
    function integer2(value) {
      return toString.call(value) === "[object Number]" && -2147483648 <= value && value <= 2147483647;
    }
    Is2.integer = integer2;
    function uinteger2(value) {
      return toString.call(value) === "[object Number]" && 0 <= value && value <= 2147483647;
    }
    Is2.uinteger = uinteger2;
    function func(value) {
      return toString.call(value) === "[object Function]";
    }
    Is2.func = func;
    function objectLiteral(value) {
      return value !== null && typeof value === "object";
    }
    Is2.objectLiteral = objectLiteral;
    function typedArray(value, check) {
      return Array.isArray(value) && value.every(check);
    }
    Is2.typedArray = typedArray;
  })(Is || (Is = {}));

  // node_modules/vscode-languageserver-textdocument/lib/esm/main.js
  var FullTextDocument2 = class _FullTextDocument {
    constructor(uri, languageId, version, content) {
      this._uri = uri;
      this._languageId = languageId;
      this._version = version;
      this._content = content;
      this._lineOffsets = void 0;
    }
    get uri() {
      return this._uri;
    }
    get languageId() {
      return this._languageId;
    }
    get version() {
      return this._version;
    }
    getText(range) {
      if (range) {
        const start = this.offsetAt(range.start);
        const end = this.offsetAt(range.end);
        return this._content.substring(start, end);
      }
      return this._content;
    }
    update(changes, version) {
      for (let change of changes) {
        if (_FullTextDocument.isIncremental(change)) {
          const range = getWellformedRange(change.range);
          const startOffset = this.offsetAt(range.start);
          const endOffset = this.offsetAt(range.end);
          this._content = this._content.substring(0, startOffset) + change.text + this._content.substring(endOffset, this._content.length);
          const startLine = Math.max(range.start.line, 0);
          const endLine = Math.max(range.end.line, 0);
          let lineOffsets = this._lineOffsets;
          const addedLineOffsets = computeLineOffsets(change.text, false, startOffset);
          if (endLine - startLine === addedLineOffsets.length) {
            for (let i = 0, len = addedLineOffsets.length; i < len; i++) {
              lineOffsets[i + startLine + 1] = addedLineOffsets[i];
            }
          } else {
            if (addedLineOffsets.length < 1e4) {
              lineOffsets.splice(startLine + 1, endLine - startLine, ...addedLineOffsets);
            } else {
              this._lineOffsets = lineOffsets = lineOffsets.slice(0, startLine + 1).concat(addedLineOffsets, lineOffsets.slice(endLine + 1));
            }
          }
          const diff = change.text.length - (endOffset - startOffset);
          if (diff !== 0) {
            for (let i = startLine + 1 + addedLineOffsets.length, len = lineOffsets.length; i < len; i++) {
              lineOffsets[i] = lineOffsets[i] + diff;
            }
          }
        } else if (_FullTextDocument.isFull(change)) {
          this._content = change.text;
          this._lineOffsets = void 0;
        } else {
          throw new Error("Unknown change event received");
        }
      }
      this._version = version;
    }
    getLineOffsets() {
      if (this._lineOffsets === void 0) {
        this._lineOffsets = computeLineOffsets(this._content, true);
      }
      return this._lineOffsets;
    }
    positionAt(offset) {
      offset = Math.max(Math.min(offset, this._content.length), 0);
      let lineOffsets = this.getLineOffsets();
      let low = 0, high = lineOffsets.length;
      if (high === 0) {
        return { line: 0, character: offset };
      }
      while (low < high) {
        let mid = Math.floor((low + high) / 2);
        if (lineOffsets[mid] > offset) {
          high = mid;
        } else {
          low = mid + 1;
        }
      }
      let line = low - 1;
      return { line, character: offset - lineOffsets[line] };
    }
    offsetAt(position) {
      let lineOffsets = this.getLineOffsets();
      if (position.line >= lineOffsets.length) {
        return this._content.length;
      } else if (position.line < 0) {
        return 0;
      }
      let lineOffset = lineOffsets[position.line];
      let nextLineOffset = position.line + 1 < lineOffsets.length ? lineOffsets[position.line + 1] : this._content.length;
      return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    }
    get lineCount() {
      return this.getLineOffsets().length;
    }
    static isIncremental(event) {
      let candidate = event;
      return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range !== void 0 && (candidate.rangeLength === void 0 || typeof candidate.rangeLength === "number");
    }
    static isFull(event) {
      let candidate = event;
      return candidate !== void 0 && candidate !== null && typeof candidate.text === "string" && candidate.range === void 0 && candidate.rangeLength === void 0;
    }
  };
  var TextDocument2;
  (function(TextDocument3) {
    function create2(uri, languageId, version, content) {
      return new FullTextDocument2(uri, languageId, version, content);
    }
    TextDocument3.create = create2;
    function update(document, changes, version) {
      if (document instanceof FullTextDocument2) {
        document.update(changes, version);
        return document;
      } else {
        throw new Error("TextDocument.update: document must be created by TextDocument.create");
      }
    }
    TextDocument3.update = update;
    function applyEdits(document, edits) {
      let text = document.getText();
      let sortedEdits = mergeSort(edits.map(getWellformedEdit), (a2, b) => {
        let diff = a2.range.start.line - b.range.start.line;
        if (diff === 0) {
          return a2.range.start.character - b.range.start.character;
        }
        return diff;
      });
      let lastModifiedOffset = 0;
      const spans = [];
      for (const e of sortedEdits) {
        let startOffset = document.offsetAt(e.range.start);
        if (startOffset < lastModifiedOffset) {
          throw new Error("Overlapping edit");
        } else if (startOffset > lastModifiedOffset) {
          spans.push(text.substring(lastModifiedOffset, startOffset));
        }
        if (e.newText.length) {
          spans.push(e.newText);
        }
        lastModifiedOffset = document.offsetAt(e.range.end);
      }
      spans.push(text.substr(lastModifiedOffset));
      return spans.join("");
    }
    TextDocument3.applyEdits = applyEdits;
  })(TextDocument2 || (TextDocument2 = {}));
  function mergeSort(data, compare) {
    if (data.length <= 1) {
      return data;
    }
    const p = data.length / 2 | 0;
    const left = data.slice(0, p);
    const right = data.slice(p);
    mergeSort(left, compare);
    mergeSort(right, compare);
    let leftIdx = 0;
    let rightIdx = 0;
    let i = 0;
    while (leftIdx < left.length && rightIdx < right.length) {
      let ret = compare(left[leftIdx], right[rightIdx]);
      if (ret <= 0) {
        data[i++] = left[leftIdx++];
      } else {
        data[i++] = right[rightIdx++];
      }
    }
    while (leftIdx < left.length) {
      data[i++] = left[leftIdx++];
    }
    while (rightIdx < right.length) {
      data[i++] = right[rightIdx++];
    }
    return data;
  }
  function computeLineOffsets(text, isAtLineStart, textOffset = 0) {
    const result = isAtLineStart ? [textOffset] : [];
    for (let i = 0; i < text.length; i++) {
      let ch = text.charCodeAt(i);
      if (ch === 13 || ch === 10) {
        if (ch === 13 && i + 1 < text.length && text.charCodeAt(i + 1) === 10) {
          i++;
        }
        result.push(textOffset + i + 1);
      }
    }
    return result;
  }
  function getWellformedRange(range) {
    const start = range.start;
    const end = range.end;
    if (start.line > end.line || start.line === end.line && start.character > end.character) {
      return { start: end, end: start };
    }
    return range;
  }
  function getWellformedEdit(textEdit) {
    const range = getWellformedRange(textEdit.range);
    if (range !== textEdit.range) {
      return { newText: textEdit.newText, range };
    }
    return textEdit;
  }

  // node_modules/vscode-css-languageservice/lib/esm/cssLanguageTypes.js
  var ClientCapabilities;
  (function(ClientCapabilities2) {
    ClientCapabilities2.LATEST = {
      textDocument: {
        completion: {
          completionItem: {
            documentationFormat: [MarkupKind.Markdown, MarkupKind.PlainText]
          }
        },
        hover: {
          contentFormat: [MarkupKind.Markdown, MarkupKind.PlainText]
        }
      }
    };
  })(ClientCapabilities || (ClientCapabilities = {}));
  var FileType;
  (function(FileType2) {
    FileType2[FileType2["Unknown"] = 0] = "Unknown";
    FileType2[FileType2["File"] = 1] = "File";
    FileType2[FileType2["Directory"] = 2] = "Directory";
    FileType2[FileType2["SymbolicLink"] = 64] = "SymbolicLink";
  })(FileType || (FileType = {}));

  // node_modules/vscode-css-languageservice/lib/esm/languageFacts/entry.js
  var browserNames = {
    E: "Edge",
    FF: "Firefox",
    S: "Safari",
    C: "Chrome",
    IE: "IE",
    O: "Opera"
  };
  function getEntryStatus(status) {
    switch (status) {
      case "experimental":
        return "\u26A0\uFE0F Property is experimental. Be cautious when using it.\uFE0F\n\n";
      case "nonstandard":
        return "\u{1F6A8}\uFE0F Property is nonstandard. Avoid using it.\n\n";
      case "obsolete":
        return "\u{1F6A8}\uFE0F\uFE0F\uFE0F Property is obsolete. Avoid using it.\n\n";
      default:
        return "";
    }
  }
  function getEntryDescription(entry, doesSupportMarkdown, settings) {
    let result;
    if (doesSupportMarkdown) {
      result = {
        kind: "markdown",
        value: getEntryMarkdownDescription(entry, settings)
      };
    } else {
      result = {
        kind: "plaintext",
        value: getEntryStringDescription(entry, settings)
      };
    }
    if (result.value === "") {
      return void 0;
    }
    return result;
  }
  function textToMarkedString(text) {
    text = text.replace(/[\\`*_{}[\]()#+\-.!]/g, "\\$&");
    return text.replace(/</g, "&lt;").replace(/>/g, "&gt;");
  }
  function getEntryStringDescription(entry, settings) {
    if (!entry.description || entry.description === "") {
      return "";
    }
    if (typeof entry.description !== "string") {
      return entry.description.value;
    }
    let result = "";
    if (settings?.documentation !== false) {
      if (entry.status) {
        result += getEntryStatus(entry.status);
      }
      result += entry.description;
      const browserLabel = getBrowserLabel(entry.browsers);
      if (browserLabel) {
        result += "\n(" + browserLabel + ")";
      }
      if ("syntax" in entry) {
        result += `

Syntax: ${entry.syntax}`;
      }
    }
    if (entry.references && entry.references.length > 0 && settings?.references !== false) {
      if (result.length > 0) {
        result += "\n\n";
      }
      result += entry.references.map((r) => {
        return `${r.name}: ${r.url}`;
      }).join(" | ");
    }
    return result;
  }
  function getEntryMarkdownDescription(entry, settings) {
    if (!entry.description || entry.description === "") {
      return "";
    }
    let result = "";
    if (settings?.documentation !== false) {
      if (entry.status) {
        result += getEntryStatus(entry.status);
      }
      if (typeof entry.description === "string") {
        result += textToMarkedString(entry.description);
      } else {
        result += entry.description.kind === MarkupKind.Markdown ? entry.description.value : textToMarkedString(entry.description.value);
      }
      const browserLabel = getBrowserLabel(entry.browsers);
      if (browserLabel) {
        result += "\n\n(" + textToMarkedString(browserLabel) + ")";
      }
      if ("syntax" in entry && entry.syntax) {
        result += `

Syntax: ${textToMarkedString(entry.syntax)}`;
      }
    }
    if (entry.references && entry.references.length > 0 && settings?.references !== false) {
      if (result.length > 0) {
        result += "\n\n";
      }
      result += entry.references.map((r) => {
        return `[${r.name}](${r.url})`;
      }).join(" | ");
    }
    return result;
  }
  function getBrowserLabel(browsers = []) {
    if (browsers.length === 0) {
      return null;
    }
    return browsers.map((b) => {
      let result = "";
      const matches2 = b.match(/([A-Z]+)(\d+)?/);
      const name = matches2[1];
      const version = matches2[2];
      if (name in browserNames) {
        result += browserNames[name];
      }
      if (version) {
        result += " " + version;
      }
      return result;
    }).join(", ");
  }

  // node_modules/vscode-css-languageservice/lib/esm/languageFacts/colors.js
  var hexColorRegExp = /(^#([0-9A-F]{3}){1,2}$)|(^#([0-9A-F]{4}){1,2}$)/i;
  var colorFunctions = [
    {
      label: "rgb",
      func: "rgb($red, $green, $blue)",
      insertText: "rgb(${1:red}, ${2:green}, ${3:blue})",
      desc: t("Creates a Color from red, green, and blue values.")
    },
    {
      label: "rgba",
      func: "rgba($red, $green, $blue, $alpha)",
      insertText: "rgba(${1:red}, ${2:green}, ${3:blue}, ${4:alpha})",
      desc: t("Creates a Color from red, green, blue, and alpha values.")
    },
    {
      label: "rgb relative",
      func: "rgb(from $color $red $green $blue)",
      insertText: "rgb(from ${1:color} ${2:r} ${3:g} ${4:b})",
      desc: t("Creates a Color from the red, green, and blue values of another Color.")
    },
    {
      label: "hsl",
      func: "hsl($hue, $saturation, $lightness)",
      insertText: "hsl(${1:hue}, ${2:saturation}, ${3:lightness})",
      desc: t("Creates a Color from hue, saturation, and lightness values.")
    },
    {
      label: "hsla",
      func: "hsla($hue, $saturation, $lightness, $alpha)",
      insertText: "hsla(${1:hue}, ${2:saturation}, ${3:lightness}, ${4:alpha})",
      desc: t("Creates a Color from hue, saturation, lightness, and alpha values.")
    },
    {
      label: "hsl relative",
      func: "hsl(from $color $hue $saturation $lightness)",
      insertText: "hsl(from ${1:color} ${2:h} ${3:s} ${4:l})",
      desc: t("Creates a Color from the hue, saturation, and lightness values of another Color.")
    },
    {
      label: "hwb",
      func: "hwb($hue $white $black)",
      insertText: "hwb(${1:hue} ${2:white} ${3:black})",
      desc: t("Creates a Color from hue, white, and black values.")
    },
    {
      label: "hwb relative",
      func: "hwb(from $color $hue $white $black)",
      insertText: "hwb(from ${1:color} ${2:h} ${3:w} ${4:b})",
      desc: t("Creates a Color from the hue, white, and black values of another Color.")
    },
    {
      label: "lab",
      func: "lab($lightness $a $b)",
      insertText: "lab(${1:lightness} ${2:a} ${3:b})",
      desc: t("Creates a Color from lightness, a, and b values.")
    },
    {
      label: "lab relative",
      func: "lab(from $color $lightness $a $b)",
      insertText: "lab(from ${1:color} ${2:l} ${3:a} ${4:b})",
      desc: t("Creates a Color from the lightness, a, and b values of another Color.")
    },
    {
      label: "oklab",
      func: "oklab($lightness $a $b)",
      insertText: "oklab(${1:lightness} ${2:a} ${3:b})",
      desc: t("Creates a Color from lightness, a, and b values.")
    },
    {
      label: "oklab relative",
      func: "oklab(from $color $lightness $a $b)",
      insertText: "oklab(from ${1:color} ${2:l} ${3:a} ${4:b})",
      desc: t("Creates a Color from the lightness, a, and b values of another Color.")
    },
    {
      label: "lch",
      func: "lch($lightness $chroma $hue)",
      insertText: "lch(${1:lightness} ${2:chroma} ${3:hue})",
      desc: t("Creates a Color from lightness, chroma, and hue values.")
    },
    {
      label: "lch relative",
      func: "lch(from $color $lightness $chroma $hue)",
      insertText: "lch(from ${1:color} ${2:l} ${3:c} ${4:h})",
      desc: t("Creates a Color from the lightness, chroma, and hue values of another Color.")
    },
    {
      label: "oklch",
      func: "oklch($lightness $chroma $hue)",
      insertText: "oklch(${1:lightness} ${2:chroma} ${3:hue})",
      desc: t("Creates a Color from lightness, chroma, and hue values.")
    },
    {
      label: "oklch relative",
      func: "oklch(from $color $lightness $chroma $hue)",
      insertText: "oklch(from ${1:color} ${2:l} ${3:c} ${4:h})",
      desc: t("Creates a Color from the lightness, chroma, and hue values of another Color.")
    },
    {
      label: "color",
      func: "color($color-space $red $green $blue)",
      insertText: "color(${1|srgb,srgb-linear,display-p3,a98-rgb,prophoto-rgb,rec2020,xyx,xyz-d50,xyz-d65|} ${2:red} ${3:green} ${4:blue})",
      desc: t("Creates a Color in a specific color space from red, green, and blue values.")
    },
    {
      label: "color relative",
      func: "color(from $color $color-space $red $green $blue)",
      insertText: "color(from ${1:color} ${2|srgb,srgb-linear,display-p3,a98-rgb,prophoto-rgb,rec2020,xyx,xyz-d50,xyz-d65|} ${3:r} ${4:g} ${5:b})",
      desc: t("Creates a Color in a specific color space from the red, green, and blue values of another Color.")
    },
    {
      label: "color-mix",
      func: "color-mix(in $color-space, $color $percentage, $color $percentage)",
      insertText: "color-mix(in ${1|srgb,srgb-linear,lab,oklab,xyz,xyz-d50,xyz-d65|}, ${3:color} ${4:percentage}, ${5:color} ${6:percentage})",
      desc: t("Mix two colors together in a rectangular color space.")
    },
    {
      label: "color-mix hue",
      func: "color-mix(in $color-space $interpolation-method hue, $color $percentage, $color $percentage)",
      insertText: "color-mix(in ${1|hsl,hwb,lch,oklch|} ${2|shorter hue,longer hue,increasing hue,decreasing hue|}, ${3:color} ${4:percentage}, ${5:color} ${6:percentage})",
      desc: t("Mix two colors together in a polar color space.")
    }
  ];
  var colorFunctionNameRegExp = /^(rgb|rgba|hsl|hsla|hwb)$/i;
  var colors = {
    aliceblue: "#f0f8ff",
    antiquewhite: "#faebd7",
    aqua: "#00ffff",
    aquamarine: "#7fffd4",
    azure: "#f0ffff",
    beige: "#f5f5dc",
    bisque: "#ffe4c4",
    black: "#000000",
    blanchedalmond: "#ffebcd",
    blue: "#0000ff",
    blueviolet: "#8a2be2",
    brown: "#a52a2a",
    burlywood: "#deb887",
    cadetblue: "#5f9ea0",
    chartreuse: "#7fff00",
    chocolate: "#d2691e",
    coral: "#ff7f50",
    cornflowerblue: "#6495ed",
    cornsilk: "#fff8dc",
    crimson: "#dc143c",
    cyan: "#00ffff",
    darkblue: "#00008b",
    darkcyan: "#008b8b",
    darkgoldenrod: "#b8860b",
    darkgray: "#a9a9a9",
    darkgrey: "#a9a9a9",
    darkgreen: "#006400",
    darkkhaki: "#bdb76b",
    darkmagenta: "#8b008b",
    darkolivegreen: "#556b2f",
    darkorange: "#ff8c00",
    darkorchid: "#9932cc",
    darkred: "#8b0000",
    darksalmon: "#e9967a",
    darkseagreen: "#8fbc8f",
    darkslateblue: "#483d8b",
    darkslategray: "#2f4f4f",
    darkslategrey: "#2f4f4f",
    darkturquoise: "#00ced1",
    darkviolet: "#9400d3",
    deeppink: "#ff1493",
    deepskyblue: "#00bfff",
    dimgray: "#696969",
    dimgrey: "#696969",
    dodgerblue: "#1e90ff",
    firebrick: "#b22222",
    floralwhite: "#fffaf0",
    forestgreen: "#228b22",
    fuchsia: "#ff00ff",
    gainsboro: "#dcdcdc",
    ghostwhite: "#f8f8ff",
    gold: "#ffd700",
    goldenrod: "#daa520",
    gray: "#808080",
    grey: "#808080",
    green: "#008000",
    greenyellow: "#adff2f",
    honeydew: "#f0fff0",
    hotpink: "#ff69b4",
    indianred: "#cd5c5c",
    indigo: "#4b0082",
    ivory: "#fffff0",
    khaki: "#f0e68c",
    lavender: "#e6e6fa",
    lavenderblush: "#fff0f5",
    lawngreen: "#7cfc00",
    lemonchiffon: "#fffacd",
    lightblue: "#add8e6",
    lightcoral: "#f08080",
    lightcyan: "#e0ffff",
    lightgoldenrodyellow: "#fafad2",
    lightgray: "#d3d3d3",
    lightgrey: "#d3d3d3",
    lightgreen: "#90ee90",
    lightpink: "#ffb6c1",
    lightsalmon: "#ffa07a",
    lightseagreen: "#20b2aa",
    lightskyblue: "#87cefa",
    lightslategray: "#778899",
    lightslategrey: "#778899",
    lightsteelblue: "#b0c4de",
    lightyellow: "#ffffe0",
    lime: "#00ff00",
    limegreen: "#32cd32",
    linen: "#faf0e6",
    magenta: "#ff00ff",
    maroon: "#800000",
    mediumaquamarine: "#66cdaa",
    mediumblue: "#0000cd",
    mediumorchid: "#ba55d3",
    mediumpurple: "#9370d8",
    mediumseagreen: "#3cb371",
    mediumslateblue: "#7b68ee",
    mediumspringgreen: "#00fa9a",
    mediumturquoise: "#48d1cc",
    mediumvioletred: "#c71585",
    midnightblue: "#191970",
    mintcream: "#f5fffa",
    mistyrose: "#ffe4e1",
    moccasin: "#ffe4b5",
    navajowhite: "#ffdead",
    navy: "#000080",
    oldlace: "#fdf5e6",
    olive: "#808000",
    olivedrab: "#6b8e23",
    orange: "#ffa500",
    orangered: "#ff4500",
    orchid: "#da70d6",
    palegoldenrod: "#eee8aa",
    palegreen: "#98fb98",
    paleturquoise: "#afeeee",
    palevioletred: "#d87093",
    papayawhip: "#ffefd5",
    peachpuff: "#ffdab9",
    peru: "#cd853f",
    pink: "#ffc0cb",
    plum: "#dda0dd",
    powderblue: "#b0e0e6",
    purple: "#800080",
    red: "#ff0000",
    rebeccapurple: "#663399",
    rosybrown: "#bc8f8f",
    royalblue: "#4169e1",
    saddlebrown: "#8b4513",
    salmon: "#fa8072",
    sandybrown: "#f4a460",
    seagreen: "#2e8b57",
    seashell: "#fff5ee",
    sienna: "#a0522d",
    silver: "#c0c0c0",
    skyblue: "#87ceeb",
    slateblue: "#6a5acd",
    slategray: "#708090",
    slategrey: "#708090",
    snow: "#fffafa",
    springgreen: "#00ff7f",
    steelblue: "#4682b4",
    tan: "#d2b48c",
    teal: "#008080",
    thistle: "#d8bfd8",
    tomato: "#ff6347",
    turquoise: "#40e0d0",
    violet: "#ee82ee",
    wheat: "#f5deb3",
    white: "#ffffff",
    whitesmoke: "#f5f5f5",
    yellow: "#ffff00",
    yellowgreen: "#9acd32"
  };
  var colorsRegExp = new RegExp(`^(${Object.keys(colors).join("|")})$`, "i");
  var colorKeywords = {
    "currentColor": "The value of the 'color' property. The computed value of the 'currentColor' keyword is the computed value of the 'color' property. If the 'currentColor' keyword is set on the 'color' property itself, it is treated as 'color:inherit' at parse time.",
    "transparent": "Fully transparent. This keyword can be considered a shorthand for rgba(0,0,0,0) which is its computed value."
  };
  var colorKeywordsRegExp = new RegExp(`^(${Object.keys(colorKeywords).join("|")})$`, "i");
  function getNumericValue(node, factor) {
    const val = node.getText();
    const m = val.match(/^([-+]?[0-9]*\.?[0-9]+)(%?)$/);
    if (m) {
      if (m[2]) {
        factor = 100;
      }
      const result = parseFloat(m[1]) / factor;
      if (result >= 0 && result <= 1) {
        return result;
      }
    }
    throw new Error();
  }
  function getAngle(node) {
    const val = node.getText();
    const m = val.match(/^([-+]?[0-9]*\.?[0-9]+)(deg|rad|grad|turn)?$/);
    if (m) {
      switch (m[2]) {
        case "deg":
          return parseFloat(val) % 360;
        case "rad":
          return parseFloat(val) * 180 / Math.PI % 360;
        case "grad":
          return parseFloat(val) * 0.9 % 360;
        case "turn":
          return parseFloat(val) * 360 % 360;
        default:
          if ("undefined" === typeof m[2]) {
            return parseFloat(val) % 360;
          }
      }
    }
    throw new Error();
  }
  function isColorConstructor(node) {
    const name = node.getName();
    if (!name) {
      return false;
    }
    return colorFunctionNameRegExp.test(name);
  }
  function isColorString(s) {
    return hexColorRegExp.test(s) || colorsRegExp.test(s) || colorKeywordsRegExp.test(s);
  }
  var Digit0 = 48;
  var Digit9 = 57;
  var A = 65;
  var a = 97;
  var f = 102;
  function hexDigit(charCode) {
    if (charCode < Digit0) {
      return 0;
    }
    if (charCode <= Digit9) {
      return charCode - Digit0;
    }
    if (charCode < a) {
      charCode += a - A;
    }
    if (charCode >= a && charCode <= f) {
      return charCode - a + 10;
    }
    return 0;
  }
  function colorFromHex(text) {
    if (text[0] !== "#") {
      return null;
    }
    switch (text.length) {
      case 4:
        return {
          red: hexDigit(text.charCodeAt(1)) * 17 / 255,
          green: hexDigit(text.charCodeAt(2)) * 17 / 255,
          blue: hexDigit(text.charCodeAt(3)) * 17 / 255,
          alpha: 1
        };
      case 5:
        return {
          red: hexDigit(text.charCodeAt(1)) * 17 / 255,
          green: hexDigit(text.charCodeAt(2)) * 17 / 255,
          blue: hexDigit(text.charCodeAt(3)) * 17 / 255,
          alpha: hexDigit(text.charCodeAt(4)) * 17 / 255
        };
      case 7:
        return {
          red: (hexDigit(text.charCodeAt(1)) * 16 + hexDigit(text.charCodeAt(2))) / 255,
          green: (hexDigit(text.charCodeAt(3)) * 16 + hexDigit(text.charCodeAt(4))) / 255,
          blue: (hexDigit(text.charCodeAt(5)) * 16 + hexDigit(text.charCodeAt(6))) / 255,
          alpha: 1
        };
      case 9:
        return {
          red: (hexDigit(text.charCodeAt(1)) * 16 + hexDigit(text.charCodeAt(2))) / 255,
          green: (hexDigit(text.charCodeAt(3)) * 16 + hexDigit(text.charCodeAt(4))) / 255,
          blue: (hexDigit(text.charCodeAt(5)) * 16 + hexDigit(text.charCodeAt(6))) / 255,
          alpha: (hexDigit(text.charCodeAt(7)) * 16 + hexDigit(text.charCodeAt(8))) / 255
        };
    }
    return null;
  }
  function colorFromHSL(hue, sat, light, alpha = 1) {
    hue = hue / 60;
    if (sat === 0) {
      return { red: light, green: light, blue: light, alpha };
    } else {
      const hueToRgb = (t12, t22, hue2) => {
        while (hue2 < 0) {
          hue2 += 6;
        }
        while (hue2 >= 6) {
          hue2 -= 6;
        }
        if (hue2 < 1) {
          return (t22 - t12) * hue2 + t12;
        }
        if (hue2 < 3) {
          return t22;
        }
        if (hue2 < 4) {
          return (t22 - t12) * (4 - hue2) + t12;
        }
        return t12;
      };
      const t2 = light <= 0.5 ? light * (sat + 1) : light + sat - light * sat;
      const t1 = light * 2 - t2;
      return { red: hueToRgb(t1, t2, hue + 2), green: hueToRgb(t1, t2, hue), blue: hueToRgb(t1, t2, hue - 2), alpha };
    }
  }
  function hslFromColor(rgba) {
    const r = rgba.red;
    const g = rgba.green;
    const b = rgba.blue;
    const a2 = rgba.alpha;
    const max = Math.max(r, g, b);
    const min = Math.min(r, g, b);
    let h = 0;
    let s = 0;
    const l = (min + max) / 2;
    const chroma = max - min;
    if (chroma > 0) {
      s = Math.min(l <= 0.5 ? chroma / (2 * l) : chroma / (2 - 2 * l), 1);
      switch (max) {
        case r:
          h = (g - b) / chroma + (g < b ? 6 : 0);
          break;
        case g:
          h = (b - r) / chroma + 2;
          break;
        case b:
          h = (r - g) / chroma + 4;
          break;
      }
      h *= 60;
      h = Math.round(h);
    }
    return { h, s, l, a: a2 };
  }
  function colorFromHWB(hue, white, black, alpha = 1) {
    if (white + black >= 1) {
      const gray = white / (white + black);
      return { red: gray, green: gray, blue: gray, alpha };
    }
    const rgb = colorFromHSL(hue, 1, 0.5, alpha);
    let red = rgb.red;
    red *= 1 - white - black;
    red += white;
    let green = rgb.green;
    green *= 1 - white - black;
    green += white;
    let blue = rgb.blue;
    blue *= 1 - white - black;
    blue += white;
    return {
      red,
      green,
      blue,
      alpha
    };
  }
  function hwbFromColor(rgba) {
    const hsl = hslFromColor(rgba);
    const white = Math.min(rgba.red, rgba.green, rgba.blue);
    const black = 1 - Math.max(rgba.red, rgba.green, rgba.blue);
    return {
      h: hsl.h,
      w: white,
      b: black,
      a: hsl.a
    };
  }
  function getColorValue(node) {
    if (node.type === NodeType.HexColorValue) {
      const text = node.getText();
      return colorFromHex(text);
    } else if (node.type === NodeType.Function) {
      const functionNode = node;
      const name = functionNode.getName();
      let colorValues = functionNode.getArguments().getChildren();
      if (colorValues.length === 1) {
        const functionArg = colorValues[0].getChildren();
        if (functionArg.length === 1 && functionArg[0].type === NodeType.Expression) {
          colorValues = functionArg[0].getChildren();
          if (colorValues.length === 3) {
            const lastValue = colorValues[2];
            if (lastValue instanceof BinaryExpression) {
              const left = lastValue.getLeft(), right = lastValue.getRight(), operator = lastValue.getOperator();
              if (left && right && operator && operator.matches("/")) {
                colorValues = [colorValues[0], colorValues[1], left, right];
              }
            }
          }
        }
      }
      if (!name || colorValues.length < 3 || colorValues.length > 4) {
        return null;
      }
      try {
        const alpha = colorValues.length === 4 ? getNumericValue(colorValues[3], 1) : 1;
        if (name === "rgb" || name === "rgba") {
          return {
            red: getNumericValue(colorValues[0], 255),
            green: getNumericValue(colorValues[1], 255),
            blue: getNumericValue(colorValues[2], 255),
            alpha
          };
        } else if (name === "hsl" || name === "hsla") {
          const h = getAngle(colorValues[0]);
          const s = getNumericValue(colorValues[1], 100);
          const l = getNumericValue(colorValues[2], 100);
          return colorFromHSL(h, s, l, alpha);
        } else if (name === "hwb") {
          const h = getAngle(colorValues[0]);
          const w = getNumericValue(colorValues[1], 100);
          const b = getNumericValue(colorValues[2], 100);
          return colorFromHWB(h, w, b, alpha);
        }
      } catch (e) {
        return null;
      }
    } else if (node.type === NodeType.Identifier) {
      if (node.parent && node.parent.type !== NodeType.Term) {
        return null;
      }
      const term = node.parent;
      if (term && term.parent && term.parent.type === NodeType.BinaryExpression) {
        const expression = term.parent;
        if (expression.parent && expression.parent.type === NodeType.ListEntry && expression.parent.key === expression) {
          return null;
        }
      }
      const candidateColor = node.getText().toLowerCase();
      if (candidateColor === "none") {
        return null;
      }
      const colorHex = colors[candidateColor];
      if (colorHex) {
        return colorFromHex(colorHex);
      }
    }
    return null;
  }

  // node_modules/vscode-css-languageservice/lib/esm/languageFacts/builtinData.js
  var positionKeywords = {
    "bottom": "Computes to \u2018100%\u2019 for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset.",
    "center": "Computes to \u201850%\u2019 (\u2018left 50%\u2019) for the horizontal position if the horizontal position is not otherwise specified, or \u201850%\u2019 (\u2018top 50%\u2019) for the vertical position if it is.",
    "left": "Computes to \u20180%\u2019 for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset.",
    "right": "Computes to \u2018100%\u2019 for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset.",
    "top": "Computes to \u20180%\u2019 for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."
  };
  var repeatStyleKeywords = {
    "no-repeat": "Placed once and not repeated in this direction.",
    "repeat": "Repeated in this direction as often as needed to cover the background painting area.",
    "repeat-x": "Computes to \u2018repeat no-repeat\u2019.",
    "repeat-y": "Computes to \u2018no-repeat repeat\u2019.",
    "round": "Repeated as often as will fit within the background positioning area. If it doesn\u2019t fit a whole number of times, it is rescaled so that it does.",
    "space": "Repeated as often as will fit within the background positioning area without being clipped and then the images are spaced out to fill the area."
  };
  var lineStyleKeywords = {
    "dashed": "A series of square-ended dashes.",
    "dotted": "A series of round dots.",
    "double": "Two parallel solid lines with some space between them.",
    "groove": "Looks as if it were carved in the canvas.",
    "hidden": "Same as \u2018none\u2019, but has different behavior in the border conflict resolution rules for border-collapsed tables.",
    "inset": "Looks as if the content on the inside of the border is sunken into the canvas.",
    "none": "No border. Color and width are ignored.",
    "outset": "Looks as if the content on the inside of the border is coming out of the canvas.",
    "ridge": "Looks as if it were coming out of the canvas.",
    "solid": "A single line segment."
  };
  var lineWidthKeywords = ["medium", "thick", "thin"];
  var boxKeywords = {
    "border-box": "The background is painted within (clipped to) the border box.",
    "content-box": "The background is painted within (clipped to) the content box.",
    "padding-box": "The background is painted within (clipped to) the padding box."
  };
  var geometryBoxKeywords = {
    "margin-box": "Uses the margin box as reference box.",
    "fill-box": "Uses the object bounding box as reference box.",
    "stroke-box": "Uses the stroke bounding box as reference box.",
    "view-box": "Uses the nearest SVG viewport as reference box."
  };
  var cssWideKeywords = {
    "initial": "Represents the value specified as the property\u2019s initial value.",
    "inherit": "Represents the computed value of the property on the element\u2019s parent.",
    "unset": "Acts as either `inherit` or `initial`, depending on whether the property is inherited or not."
  };
  var cssWideFunctions = {
    "var()": "Evaluates the value of a custom variable.",
    "calc()": "Evaluates an mathematical expression. The following operators can be used: + - * /."
  };
  var imageFunctions = {
    "url()": "Reference an image file by URL",
    "image()": "Provide image fallbacks and annotations.",
    "-webkit-image-set()": "Provide multiple resolutions. Remember to use unprefixed image-set() in addition.",
    "image-set()": "Provide multiple resolutions of an image and const the UA decide which is most appropriate in a given situation.",
    "-moz-element()": "Use an element in the document as an image. Remember to use unprefixed element() in addition.",
    "element()": "Use an element in the document as an image.",
    "cross-fade()": "Indicates the two images to be combined and how far along in the transition the combination is.",
    "-webkit-gradient()": "Deprecated. Use modern linear-gradient() or radial-gradient() instead.",
    "-webkit-linear-gradient()": "Linear gradient. Remember to use unprefixed version in addition.",
    "-moz-linear-gradient()": "Linear gradient. Remember to use unprefixed version in addition.",
    "-o-linear-gradient()": "Linear gradient. Remember to use unprefixed version in addition.",
    "linear-gradient()": "A linear gradient is created by specifying a straight gradient line, and then several colors placed along that line.",
    "-webkit-repeating-linear-gradient()": "Repeating Linear gradient. Remember to use unprefixed version in addition.",
    "-moz-repeating-linear-gradient()": "Repeating Linear gradient. Remember to use unprefixed version in addition.",
    "-o-repeating-linear-gradient()": "Repeating Linear gradient. Remember to use unprefixed version in addition.",
    "repeating-linear-gradient()": "Same as linear-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop\u2019s position and the first specified color-stop\u2019s position.",
    "-webkit-radial-gradient()": "Radial gradient. Remember to use unprefixed version in addition.",
    "-moz-radial-gradient()": "Radial gradient. Remember to use unprefixed version in addition.",
    "radial-gradient()": "Colors emerge from a single point and smoothly spread outward in a circular or elliptical shape.",
    "-webkit-repeating-radial-gradient()": "Repeating radial gradient. Remember to use unprefixed version in addition.",
    "-moz-repeating-radial-gradient()": "Repeating radial gradient. Remember to use unprefixed version in addition.",
    "repeating-radial-gradient()": "Same as radial-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop\u2019s position and the first specified color-stop\u2019s position."
  };
  var transitionTimingFunctions = {
    "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).",
    "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).",
    "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0).",
    "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",
    "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).",
    "step-end": "Equivalent to steps(1, end).",
    "step-start": "Equivalent to steps(1, start).",
    "steps()": "The first parameter specifies the number of intervals in the function. The second parameter, which is optional, is either the value \u201Cstart\u201D or \u201Cend\u201D.",
    "cubic-bezier()": "Specifies a cubic-bezier curve. The four values specify points P1 and P2  of the curve as (x1, y1, x2, y2).",
    "cubic-bezier(0.6, -0.28, 0.735, 0.045)": "Ease-in Back. Overshoots.",
    "cubic-bezier(0.68, -0.55, 0.265, 1.55)": "Ease-in-out Back. Overshoots.",
    "cubic-bezier(0.175, 0.885, 0.32, 1.275)": "Ease-out Back. Overshoots.",
    "cubic-bezier(0.6, 0.04, 0.98, 0.335)": "Ease-in Circular. Based on half circle.",
    "cubic-bezier(0.785, 0.135, 0.15, 0.86)": "Ease-in-out Circular. Based on half circle.",
    "cubic-bezier(0.075, 0.82, 0.165, 1)": "Ease-out Circular. Based on half circle.",
    "cubic-bezier(0.55, 0.055, 0.675, 0.19)": "Ease-in Cubic. Based on power of three.",
    "cubic-bezier(0.645, 0.045, 0.355, 1)": "Ease-in-out Cubic. Based on power of three.",
    "cubic-bezier(0.215, 0.610, 0.355, 1)": "Ease-out Cubic. Based on power of three.",
    "cubic-bezier(0.95, 0.05, 0.795, 0.035)": "Ease-in Exponential. Based on two to the power ten.",
    "cubic-bezier(1, 0, 0, 1)": "Ease-in-out Exponential. Based on two to the power ten.",
    "cubic-bezier(0.19, 1, 0.22, 1)": "Ease-out Exponential. Based on two to the power ten.",
    "cubic-bezier(0.47, 0, 0.745, 0.715)": "Ease-in Sine.",
    "cubic-bezier(0.445, 0.05, 0.55, 0.95)": "Ease-in-out Sine.",
    "cubic-bezier(0.39, 0.575, 0.565, 1)": "Ease-out Sine.",
    "cubic-bezier(0.55, 0.085, 0.68, 0.53)": "Ease-in Quadratic. Based on power of two.",
    "cubic-bezier(0.455, 0.03, 0.515, 0.955)": "Ease-in-out Quadratic. Based on power of two.",
    "cubic-bezier(0.25, 0.46, 0.45, 0.94)": "Ease-out Quadratic. Based on power of two.",
    "cubic-bezier(0.895, 0.03, 0.685, 0.22)": "Ease-in Quartic. Based on power of four.",
    "cubic-bezier(0.77, 0, 0.175, 1)": "Ease-in-out Quartic. Based on power of four.",
    "cubic-bezier(0.165, 0.84, 0.44, 1)": "Ease-out Quartic. Based on power of four.",
    "cubic-bezier(0.755, 0.05, 0.855, 0.06)": "Ease-in Quintic. Based on power of five.",
    "cubic-bezier(0.86, 0, 0.07, 1)": "Ease-in-out Quintic. Based on power of five.",
    "cubic-bezier(0.23, 1, 0.320, 1)": "Ease-out Quintic. Based on power of five."
  };
  var basicShapeFunctions = {
    "circle()": "Defines a circle.",
    "ellipse()": "Defines an ellipse.",
    "inset()": "Defines an inset rectangle.",
    "polygon()": "Defines a polygon."
  };
  var units = {
    "length": ["cap", "ch", "cm", "cqb", "cqh", "cqi", "cqmax", "cqmin", "cqw", "dvb", "dvh", "dvi", "dvw", "em", "ex", "ic", "in", "lh", "lvb", "lvh", "lvi", "lvw", "mm", "pc", "pt", "px", "q", "rcap", "rch", "rem", "rex", "ric", "rlh", "svb", "svh", "svi", "svw", "vb", "vh", "vi", "vmax", "vmin", "vw"],
    "angle": ["deg", "rad", "grad", "turn"],
    "time": ["ms", "s"],
    "frequency": ["Hz", "kHz"],
    "resolution": ["dpi", "dpcm", "dppx"],
    "percentage": ["%", "fr"]
  };
  var html5Tags = [
    "a",
    "abbr",
    "address",
    "area",
    "article",
    "aside",
    "audio",
    "b",
    "base",
    "bdi",
    "bdo",
    "blockquote",
    "body",
    "br",
    "button",
    "canvas",
    "caption",
    "cite",
    "code",
    "col",
    "colgroup",
    "data",
    "datalist",
    "dd",
    "del",
    "details",
    "dfn",
    "dialog",
    "div",
    "dl",
    "dt",
    "em",
    "embed",
    "fieldset",
    "figcaption",
    "figure",
    "footer",
    "form",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hgroup",
    "hr",
    "html",
    "i",
    "iframe",
    "img",
    "input",
    "ins",
    "kbd",
    "keygen",
    "label",
    "legend",
    "li",
    "link",
    "main",
    "map",
    "mark",
    "menu",
    "menuitem",
    "meta",
    "meter",
    "nav",
    "noscript",
    "object",
    "ol",
    "optgroup",
    "option",
    "output",
    "p",
    "param",
    "picture",
    "pre",
    "progress",
    "q",
    "rb",
    "rp",
    "rt",
    "rtc",
    "ruby",
    "s",
    "samp",
    "script",
    "section",
    "select",
    "small",
    "source",
    "span",
    "strong",
    "style",
    "sub",
    "summary",
    "sup",
    "table",
    "tbody",
    "td",
    "template",
    "textarea",
    "tfoot",
    "th",
    "thead",
    "time",
    "title",
    "tr",
    "track",
    "u",
    "ul",
    "const",
    "video",
    "wbr"
  ];
  var svgElements = [
    "circle",
    "clipPath",
    "cursor",
    "defs",
    "desc",
    "ellipse",
    "feBlend",
    "feColorMatrix",
    "feComponentTransfer",
    "feComposite",
    "feConvolveMatrix",
    "feDiffuseLighting",
    "feDisplacementMap",
    "feDistantLight",
    "feDropShadow",
    "feFlood",
    "feFuncA",
    "feFuncB",
    "feFuncG",
    "feFuncR",
    "feGaussianBlur",
    "feImage",
    "feMerge",
    "feMergeNode",
    "feMorphology",
    "feOffset",
    "fePointLight",
    "feSpecularLighting",
    "feSpotLight",
    "feTile",
    "feTurbulence",
    "filter",
    "foreignObject",
    "g",
    "hatch",
    "hatchpath",
    "image",
    "line",
    "linearGradient",
    "marker",
    "mask",
    "mesh",
    "meshpatch",
    "meshrow",
    "metadata",
    "mpath",
    "path",
    "pattern",
    "polygon",
    "polyline",
    "radialGradient",
    "rect",
    "set",
    "solidcolor",
    "stop",
    "svg",
    "switch",
    "symbol",
    "text",
    "textPath",
    "tspan",
    "use",
    "view"
  ];
  var pageBoxDirectives = [
    "@bottom-center",
    "@bottom-left",
    "@bottom-left-corner",
    "@bottom-right",
    "@bottom-right-corner",
    "@left-bottom",
    "@left-middle",
    "@left-top",
    "@right-bottom",
    "@right-middle",
    "@right-top",
    "@top-center",
    "@top-left",
    "@top-left-corner",
    "@top-right",
    "@top-right-corner"
  ];

  // node_modules/vscode-css-languageservice/lib/esm/utils/objects.js
  function values(obj) {
    return Object.keys(obj).map((key) => obj[key]);
  }
  function isDefined(obj) {
    return typeof obj !== "undefined";
  }

  // node_modules/vscode-css-languageservice/lib/esm/parser/cssParser.js
  var Parser = class {
    constructor(scnr = new Scanner()) {
      this.keyframeRegex = /^@(\-(webkit|ms|moz|o)\-)?keyframes$/i;
      this.scanner = scnr;
      this.token = { type: TokenType.EOF, offset: -1, len: 0, text: "" };
      this.prevToken = void 0;
    }
    peekIdent(text) {
      return TokenType.Ident === this.token.type && text.length === this.token.text.length && text === this.token.text.toLowerCase();
    }
    peekKeyword(text) {
      return TokenType.AtKeyword === this.token.type && text.length === this.token.text.length && text === this.token.text.toLowerCase();
    }
    peekDelim(text) {
      return TokenType.Delim === this.token.type && text === this.token.text;
    }
    peek(type) {
      return type === this.token.type;
    }
    peekOne(...types) {
      return types.indexOf(this.token.type) !== -1;
    }
    peekRegExp(type, regEx) {
      if (type !== this.token.type) {
        return false;
      }
      return regEx.test(this.token.text);
    }
    hasWhitespace() {
      return !!this.prevToken && this.prevToken.offset + this.prevToken.len !== this.token.offset;
    }
    consumeToken() {
      this.prevToken = this.token;
      this.token = this.scanner.scan();
    }
    acceptUnicodeRange() {
      const token = this.scanner.tryScanUnicode();
      if (token) {
        this.prevToken = token;
        this.token = this.scanner.scan();
        return true;
      }
      return false;
    }
    mark() {
      return {
        prev: this.prevToken,
        curr: this.token,
        pos: this.scanner.pos()
      };
    }
    restoreAtMark(mark) {
      this.prevToken = mark.prev;
      this.token = mark.curr;
      this.scanner.goBackTo(mark.pos);
    }
    try(func) {
      const pos = this.mark();
      const node = func();
      if (!node) {
        this.restoreAtMark(pos);
        return null;
      }
      return node;
    }
    acceptOneKeyword(keywords) {
      if (TokenType.AtKeyword === this.token.type) {
        for (const keyword of keywords) {
          if (keyword.length === this.token.text.length && keyword === this.token.text.toLowerCase()) {
            this.consumeToken();
            return true;
          }
        }
      }
      return false;
    }
    accept(type) {
      if (type === this.token.type) {
        this.consumeToken();
        return true;
      }
      return false;
    }
    acceptIdent(text) {
      if (this.peekIdent(text)) {
        this.consumeToken();
        return true;
      }
      return false;
    }
    acceptKeyword(text) {
      if (this.peekKeyword(text)) {
        this.consumeToken();
        return true;
      }
      return false;
    }
    acceptDelim(text) {
      if (this.peekDelim(text)) {
        this.consumeToken();
        return true;
      }
      return false;
    }
    acceptRegexp(regEx) {
      if (regEx.test(this.token.text)) {
        this.consumeToken();
        return true;
      }
      return false;
    }
    _parseRegexp(regEx) {
      let node = this.createNode(NodeType.Identifier);
      do {
      } while (this.acceptRegexp(regEx));
      return this.finish(node);
    }
    acceptUnquotedString() {
      const pos = this.scanner.pos();
      this.scanner.goBackTo(this.token.offset);
      const unquoted = this.scanner.scanUnquotedString();
      if (unquoted) {
        this.token = unquoted;
        this.consumeToken();
        return true;
      }
      this.scanner.goBackTo(pos);
      return false;
    }
    resync(resyncTokens, resyncStopTokens) {
      while (true) {
        if (resyncTokens && resyncTokens.indexOf(this.token.type) !== -1) {
          this.consumeToken();
          return true;
        } else if (resyncStopTokens && resyncStopTokens.indexOf(this.token.type) !== -1) {
          return true;
        } else {
          if (this.token.type === TokenType.EOF) {
            return false;
          }
          this.token = this.scanner.scan();
        }
      }
    }
    createNode(nodeType) {
      return new Node(this.token.offset, this.token.len, nodeType);
    }
    create(ctor) {
      return new ctor(this.token.offset, this.token.len);
    }
    finish(node, error, resyncTokens, resyncStopTokens) {
      if (!(node instanceof Nodelist)) {
        if (error) {
          this.markError(node, error, resyncTokens, resyncStopTokens);
        }
        if (this.prevToken) {
          const prevEnd = this.prevToken.offset + this.prevToken.len;
          node.length = prevEnd > node.offset ? prevEnd - node.offset : 0;
        }
      }
      return node;
    }
    markError(node, error, resyncTokens, resyncStopTokens) {
      if (this.token !== this.lastErrorToken) {
        node.addIssue(new Marker(node, error, Level.Error, void 0, this.token.offset, this.token.len));
        this.lastErrorToken = this.token;
      }
      if (resyncTokens || resyncStopTokens) {
        this.resync(resyncTokens, resyncStopTokens);
      }
    }
    parseStylesheet(textDocument) {
      const versionId = textDocument.version;
      const text = textDocument.getText();
      const textProvider = (offset, length) => {
        if (textDocument.version !== versionId) {
          throw new Error("Underlying model has changed, AST is no longer valid");
        }
        return text.substr(offset, length);
      };
      return this.internalParse(text, this._parseStylesheet, textProvider);
    }
    internalParse(input, parseFunc, textProvider) {
      this.scanner.setSource(input);
      this.token = this.scanner.scan();
      const node = parseFunc.bind(this)();
      if (node) {
        if (textProvider) {
          node.textProvider = textProvider;
        } else {
          node.textProvider = (offset, length) => {
            return input.substr(offset, length);
          };
        }
      }
      return node;
    }
    _parseStylesheet() {
      const node = this.create(Stylesheet);
      while (node.addChild(this._parseStylesheetStart())) {
      }
      let inRecovery = false;
      do {
        let hasMatch = false;
        do {
          hasMatch = false;
          const statement = this._parseStylesheetStatement();
          if (statement) {
            node.addChild(statement);
            hasMatch = true;
            inRecovery = false;
            if (!this.peek(TokenType.EOF) && this._needsSemicolonAfter(statement) && !this.accept(TokenType.SemiColon)) {
              this.markError(node, ParseError.SemiColonExpected);
            }
          }
          while (this.accept(TokenType.SemiColon) || this.accept(TokenType.CDO) || this.accept(TokenType.CDC)) {
            hasMatch = true;
            inRecovery = false;
          }
        } while (hasMatch);
        if (this.peek(TokenType.EOF)) {
          break;
        }
        if (!inRecovery) {
          if (this.peek(TokenType.AtKeyword)) {
            this.markError(node, ParseError.UnknownAtRule);
          } else {
            this.markError(node, ParseError.RuleOrSelectorExpected);
          }
          inRecovery = true;
        }
        this.consumeToken();
      } while (!this.peek(TokenType.EOF));
      return this.finish(node);
    }
    _parseStylesheetStart() {
      return this._parseCharset();
    }
    _parseStylesheetStatement(isNested = false) {
      if (this.peek(TokenType.AtKeyword)) {
        return this._parseStylesheetAtStatement(isNested);
      }
      return this._parseRuleset(isNested);
    }
    _parseStylesheetAtStatement(isNested = false) {
      return this._parseImport() || this._parseMedia(isNested) || this._parsePage() || this._parseFontFace() || this._parseKeyframe() || this._parseSupports(isNested) || this._parseLayer(isNested) || this._parsePropertyAtRule() || this._parseViewPort() || this._parseNamespace() || this._parseDocument() || this._parseContainer(isNested) || this._parseUnknownAtRule();
    }
    _tryParseRuleset(isNested) {
      const mark = this.mark();
      if (this._parseSelector(isNested)) {
        while (this.accept(TokenType.Comma) && this._parseSelector(isNested)) {
        }
        if (this.accept(TokenType.CurlyL)) {
          this.restoreAtMark(mark);
          return this._parseRuleset(isNested);
        }
      }
      this.restoreAtMark(mark);
      return null;
    }
    _parseRuleset(isNested = false) {
      const node = this.create(RuleSet);
      const selectors = node.getSelectors();
      if (!selectors.addChild(this._parseSelector(isNested))) {
        return null;
      }
      while (this.accept(TokenType.Comma)) {
        if (!selectors.addChild(this._parseSelector(isNested))) {
          return this.finish(node, ParseError.SelectorExpected);
        }
      }
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _parseRuleSetDeclarationAtStatement() {
      return this._parseMedia(true) || this._parseSupports(true) || this._parseLayer(true) || this._parseContainer(true) || this._parseUnknownAtRule();
    }
    _parseRuleSetDeclaration() {
      if (this.peek(TokenType.AtKeyword)) {
        return this._parseRuleSetDeclarationAtStatement();
      }
      if (!this.peek(TokenType.Ident)) {
        return this._parseRuleset(true);
      }
      return this._tryParseRuleset(true) || this._parseDeclaration();
    }
    _needsSemicolonAfter(node) {
      switch (node.type) {
        case NodeType.Keyframe:
        case NodeType.ViewPort:
        case NodeType.Media:
        case NodeType.Ruleset:
        case NodeType.Namespace:
        case NodeType.If:
        case NodeType.For:
        case NodeType.Each:
        case NodeType.While:
        case NodeType.MixinDeclaration:
        case NodeType.FunctionDeclaration:
        case NodeType.MixinContentDeclaration:
          return false;
        case NodeType.ExtendsReference:
        case NodeType.MixinContentReference:
        case NodeType.ReturnStatement:
        case NodeType.MediaQuery:
        case NodeType.Debug:
        case NodeType.Import:
        case NodeType.AtApplyRule:
        case NodeType.CustomPropertyDeclaration:
          return true;
        case NodeType.VariableDeclaration:
          return node.needsSemicolon;
        case NodeType.MixinReference:
          return !node.getContent();
        case NodeType.Declaration:
          return !node.getNestedProperties();
      }
      return false;
    }
    _parseDeclarations(parseDeclaration) {
      const node = this.create(Declarations);
      if (!this.accept(TokenType.CurlyL)) {
        return null;
      }
      let decl = parseDeclaration();
      while (node.addChild(decl)) {
        if (this.peek(TokenType.CurlyR)) {
          break;
        }
        if (this._needsSemicolonAfter(decl) && !this.accept(TokenType.SemiColon)) {
          return this.finish(node, ParseError.SemiColonExpected, [TokenType.SemiColon, TokenType.CurlyR]);
        }
        if (decl && this.prevToken && this.prevToken.type === TokenType.SemiColon) {
          decl.semicolonPosition = this.prevToken.offset;
        }
        while (this.accept(TokenType.SemiColon)) {
        }
        decl = parseDeclaration();
      }
      if (!this.accept(TokenType.CurlyR)) {
        return this.finish(node, ParseError.RightCurlyExpected, [TokenType.CurlyR, TokenType.SemiColon]);
      }
      return this.finish(node);
    }
    _parseBody(node, parseDeclaration) {
      if (!node.setDeclarations(this._parseDeclarations(parseDeclaration))) {
        return this.finish(node, ParseError.LeftCurlyExpected, [TokenType.CurlyR, TokenType.SemiColon]);
      }
      return this.finish(node);
    }
    _parseSelector(isNested) {
      const node = this.create(Selector);
      let hasContent = false;
      if (isNested) {
        hasContent = node.addChild(this._parseCombinator());
      }
      while (node.addChild(this._parseSimpleSelector())) {
        hasContent = true;
        node.addChild(this._parseCombinator());
      }
      return hasContent ? this.finish(node) : null;
    }
    _parseDeclaration(stopTokens) {
      const customProperty = this._tryParseCustomPropertyDeclaration(stopTokens);
      if (customProperty) {
        return customProperty;
      }
      const node = this.create(Declaration);
      if (!node.setProperty(this._parseProperty())) {
        return null;
      }
      if (!this.accept(TokenType.Colon)) {
        return this.finish(node, ParseError.ColonExpected, [TokenType.Colon], stopTokens || [TokenType.SemiColon]);
      }
      if (this.prevToken) {
        node.colonPosition = this.prevToken.offset;
      }
      if (!node.setValue(this._parseExpr())) {
        return this.finish(node, ParseError.PropertyValueExpected);
      }
      node.addChild(this._parsePrio());
      if (this.peek(TokenType.SemiColon)) {
        node.semicolonPosition = this.token.offset;
      }
      return this.finish(node);
    }
    _tryParseCustomPropertyDeclaration(stopTokens) {
      if (!this.peekRegExp(TokenType.Ident, /^--/)) {
        return null;
      }
      const node = this.create(CustomPropertyDeclaration);
      if (!node.setProperty(this._parseProperty())) {
        return null;
      }
      if (!this.accept(TokenType.Colon)) {
        return this.finish(node, ParseError.ColonExpected, [TokenType.Colon]);
      }
      if (this.prevToken) {
        node.colonPosition = this.prevToken.offset;
      }
      const mark = this.mark();
      if (this.peek(TokenType.CurlyL)) {
        const propertySet = this.create(CustomPropertySet);
        const declarations = this._parseDeclarations(this._parseRuleSetDeclaration.bind(this));
        if (propertySet.setDeclarations(declarations) && !declarations.isErroneous(true)) {
          propertySet.addChild(this._parsePrio());
          if (this.peek(TokenType.SemiColon)) {
            this.finish(propertySet);
            node.setPropertySet(propertySet);
            node.semicolonPosition = this.token.offset;
            return this.finish(node);
          }
        }
        this.restoreAtMark(mark);
      }
      const expression = this._parseExpr();
      if (expression && !expression.isErroneous(true)) {
        this._parsePrio();
        if (this.peekOne(...stopTokens || [], TokenType.SemiColon, TokenType.EOF)) {
          node.setValue(expression);
          if (this.peek(TokenType.SemiColon)) {
            node.semicolonPosition = this.token.offset;
          }
          return this.finish(node);
        }
      }
      this.restoreAtMark(mark);
      node.addChild(this._parseCustomPropertyValue(stopTokens));
      node.addChild(this._parsePrio());
      if (isDefined(node.colonPosition) && this.token.offset === node.colonPosition + 1) {
        return this.finish(node, ParseError.PropertyValueExpected);
      }
      return this.finish(node);
    }
    /**
     * Parse custom property values.
     *
     * Based on https://www.w3.org/TR/css-variables/#syntax
     *
     * This code is somewhat unusual, as the allowed syntax is incredibly broad,
     * parsing almost any sequence of tokens, save for a small set of exceptions.
     * Unbalanced delimitors, invalid tokens, and declaration
     * terminators like semicolons and !important directives (when not inside
     * of delimitors).
     */
    _parseCustomPropertyValue(stopTokens = [TokenType.CurlyR]) {
      const node = this.create(Node);
      const isTopLevel = () => curlyDepth === 0 && parensDepth === 0 && bracketsDepth === 0;
      const onStopToken = () => stopTokens.indexOf(this.token.type) !== -1;
      let curlyDepth = 0;
      let parensDepth = 0;
      let bracketsDepth = 0;
      done:
        while (true) {
          switch (this.token.type) {
            case TokenType.SemiColon:
              if (isTopLevel()) {
                break done;
              }
              break;
            case TokenType.Exclamation:
              if (isTopLevel()) {
                break done;
              }
              break;
            case TokenType.CurlyL:
              curlyDepth++;
              break;
            case TokenType.CurlyR:
              curlyDepth--;
              if (curlyDepth < 0) {
                if (onStopToken() && parensDepth === 0 && bracketsDepth === 0) {
                  break done;
                }
                return this.finish(node, ParseError.LeftCurlyExpected);
              }
              break;
            case TokenType.ParenthesisL:
              parensDepth++;
              break;
            case TokenType.ParenthesisR:
              parensDepth--;
              if (parensDepth < 0) {
                if (onStopToken() && bracketsDepth === 0 && curlyDepth === 0) {
                  break done;
                }
                return this.finish(node, ParseError.LeftParenthesisExpected);
              }
              break;
            case TokenType.BracketL:
              bracketsDepth++;
              break;
            case TokenType.BracketR:
              bracketsDepth--;
              if (bracketsDepth < 0) {
                return this.finish(node, ParseError.LeftSquareBracketExpected);
              }
              break;
            case TokenType.BadString:
              break done;
            case TokenType.EOF:
              let error = ParseError.RightCurlyExpected;
              if (bracketsDepth > 0) {
                error = ParseError.RightSquareBracketExpected;
              } else if (parensDepth > 0) {
                error = ParseError.RightParenthesisExpected;
              }
              return this.finish(node, error);
          }
          this.consumeToken();
        }
      return this.finish(node);
    }
    _tryToParseDeclaration(stopTokens) {
      const mark = this.mark();
      if (this._parseProperty() && this.accept(TokenType.Colon)) {
        this.restoreAtMark(mark);
        return this._parseDeclaration(stopTokens);
      }
      this.restoreAtMark(mark);
      return null;
    }
    _parseProperty() {
      const node = this.create(Property);
      const mark = this.mark();
      if (this.acceptDelim("*") || this.acceptDelim("_")) {
        if (this.hasWhitespace()) {
          this.restoreAtMark(mark);
          return null;
        }
      }
      if (node.setIdentifier(this._parsePropertyIdentifier())) {
        return this.finish(node);
      }
      return null;
    }
    _parsePropertyIdentifier() {
      return this._parseIdent();
    }
    _parseCharset() {
      if (!this.peek(TokenType.Charset)) {
        return null;
      }
      const node = this.create(Node);
      this.consumeToken();
      if (!this.accept(TokenType.String)) {
        return this.finish(node, ParseError.IdentifierExpected);
      }
      if (!this.accept(TokenType.SemiColon)) {
        return this.finish(node, ParseError.SemiColonExpected);
      }
      return this.finish(node);
    }
    _parseImport() {
      if (!this.peekKeyword("@import")) {
        return null;
      }
      const node = this.create(Import);
      this.consumeToken();
      if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
        return this.finish(node, ParseError.URIOrStringExpected);
      }
      return this._completeParseImport(node);
    }
    _completeParseImport(node) {
      if (this.acceptIdent("layer")) {
        if (this.accept(TokenType.ParenthesisL)) {
          if (!node.addChild(this._parseLayerName())) {
            return this.finish(node, ParseError.IdentifierExpected, [TokenType.SemiColon]);
          }
          if (!this.accept(TokenType.ParenthesisR)) {
            return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.ParenthesisR], []);
          }
        }
      }
      if (this.acceptIdent("supports")) {
        if (this.accept(TokenType.ParenthesisL)) {
          node.addChild(this._tryToParseDeclaration() || this._parseSupportsCondition());
          if (!this.accept(TokenType.ParenthesisR)) {
            return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.ParenthesisR], []);
          }
        }
      }
      if (!this.peek(TokenType.SemiColon) && !this.peek(TokenType.EOF)) {
        node.setMedialist(this._parseMediaQueryList());
      }
      return this.finish(node);
    }
    _parseNamespace() {
      if (!this.peekKeyword("@namespace")) {
        return null;
      }
      const node = this.create(Namespace);
      this.consumeToken();
      if (!node.addChild(this._parseURILiteral())) {
        node.addChild(this._parseIdent());
        if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
          return this.finish(node, ParseError.URIExpected, [TokenType.SemiColon]);
        }
      }
      if (!this.accept(TokenType.SemiColon)) {
        return this.finish(node, ParseError.SemiColonExpected);
      }
      return this.finish(node);
    }
    _parseFontFace() {
      if (!this.peekKeyword("@font-face")) {
        return null;
      }
      const node = this.create(FontFace);
      this.consumeToken();
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _parseViewPort() {
      if (!this.peekKeyword("@-ms-viewport") && !this.peekKeyword("@-o-viewport") && !this.peekKeyword("@viewport")) {
        return null;
      }
      const node = this.create(ViewPort);
      this.consumeToken();
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _parseKeyframe() {
      if (!this.peekRegExp(TokenType.AtKeyword, this.keyframeRegex)) {
        return null;
      }
      const node = this.create(Keyframe);
      const atNode = this.create(Node);
      this.consumeToken();
      node.setKeyword(this.finish(atNode));
      if (atNode.matches("@-ms-keyframes")) {
        this.markError(atNode, ParseError.UnknownKeyword);
      }
      if (!node.setIdentifier(this._parseKeyframeIdent())) {
        return this.finish(node, ParseError.IdentifierExpected, [TokenType.CurlyR]);
      }
      return this._parseBody(node, this._parseKeyframeSelector.bind(this));
    }
    _parseKeyframeIdent() {
      return this._parseIdent([ReferenceType.Keyframe]);
    }
    _parseKeyframeSelector() {
      const node = this.create(KeyframeSelector);
      let hasContent = false;
      if (node.addChild(this._parseIdent())) {
        hasContent = true;
      }
      if (this.accept(TokenType.Percentage)) {
        hasContent = true;
      }
      if (!hasContent) {
        return null;
      }
      while (this.accept(TokenType.Comma)) {
        hasContent = false;
        if (node.addChild(this._parseIdent())) {
          hasContent = true;
        }
        if (this.accept(TokenType.Percentage)) {
          hasContent = true;
        }
        if (!hasContent) {
          return this.finish(node, ParseError.PercentageExpected);
        }
      }
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _tryParseKeyframeSelector() {
      const node = this.create(KeyframeSelector);
      const pos = this.mark();
      let hasContent = false;
      if (node.addChild(this._parseIdent())) {
        hasContent = true;
      }
      if (this.accept(TokenType.Percentage)) {
        hasContent = true;
      }
      if (!hasContent) {
        return null;
      }
      while (this.accept(TokenType.Comma)) {
        hasContent = false;
        if (node.addChild(this._parseIdent())) {
          hasContent = true;
        }
        if (this.accept(TokenType.Percentage)) {
          hasContent = true;
        }
        if (!hasContent) {
          this.restoreAtMark(pos);
          return null;
        }
      }
      if (!this.peek(TokenType.CurlyL)) {
        this.restoreAtMark(pos);
        return null;
      }
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _parsePropertyAtRule() {
      if (!this.peekKeyword("@property")) {
        return null;
      }
      const node = this.create(PropertyAtRule);
      this.consumeToken();
      if (!this.peekRegExp(TokenType.Ident, /^--/) || !node.setName(this._parseIdent([ReferenceType.Property]))) {
        return this.finish(node, ParseError.IdentifierExpected);
      }
      return this._parseBody(node, this._parseDeclaration.bind(this));
    }
    _parseLayer(isNested = false) {
      if (!this.peekKeyword("@layer")) {
        return null;
      }
      const node = this.create(Layer);
      this.consumeToken();
      const names = this._parseLayerNameList();
      if (names) {
        node.setNames(names);
      }
      if ((!names || names.getChildren().length === 1) && this.peek(TokenType.CurlyL)) {
        return this._parseBody(node, this._parseLayerDeclaration.bind(this, isNested));
      }
      if (!this.accept(TokenType.SemiColon)) {
        return this.finish(node, ParseError.SemiColonExpected);
      }
      return this.finish(node);
    }
    _parseLayerDeclaration(isNested = false) {
      if (isNested) {
        return this._tryParseRuleset(true) || this._tryToParseDeclaration() || this._parseStylesheetStatement(true);
      }
      return this._parseStylesheetStatement(false);
    }
    _parseLayerNameList() {
      const node = this.createNode(NodeType.LayerNameList);
      if (!node.addChild(this._parseLayerName())) {
        return null;
      }
      while (this.accept(TokenType.Comma)) {
        if (!node.addChild(this._parseLayerName())) {
          return this.finish(node, ParseError.IdentifierExpected);
        }
      }
      return this.finish(node);
    }
    _parseLayerName() {
      const node = this.createNode(NodeType.LayerName);
      if (!node.addChild(this._parseIdent())) {
        return null;
      }
      while (!this.hasWhitespace() && this.acceptDelim(".")) {
        if (this.hasWhitespace() || !node.addChild(this._parseIdent())) {
          return this.finish(node, ParseError.IdentifierExpected);
        }
      }
      return this.finish(node);
    }
    _parseSupports(isNested = false) {
      if (!this.peekKeyword("@supports")) {
        return null;
      }
      const node = this.create(Supports);
      this.consumeToken();
      node.addChild(this._parseSupportsCondition());
      return this._parseBody(node, this._parseSupportsDeclaration.bind(this, isNested));
    }
    _parseSupportsDeclaration(isNested = false) {
      if (isNested) {
        return this._tryParseRuleset(true) || this._tryToParseDeclaration() || this._parseStylesheetStatement(true);
      }
      return this._parseStylesheetStatement(false);
    }
    _parseSupportsCondition() {
      const node = this.create(SupportsCondition);
      if (this.acceptIdent("not")) {
        node.addChild(this._parseSupportsConditionInParens());
      } else {
        node.addChild(this._parseSupportsConditionInParens());
        if (this.peekRegExp(TokenType.Ident, /^(and|or)$/i)) {
          const text = this.token.text.toLowerCase();
          while (this.acceptIdent(text)) {
            node.addChild(this._parseSupportsConditionInParens());
          }
        }
      }
      return this.finish(node);
    }
    _parseSupportsConditionInParens() {
      const node = this.create(SupportsCondition);
      if (this.accept(TokenType.ParenthesisL)) {
        if (this.prevToken) {
          node.lParent = this.prevToken.offset;
        }
        if (!node.addChild(this._tryToParseDeclaration([TokenType.ParenthesisR]))) {
          if (!this._parseSupportsCondition()) {
            return this.finish(node, ParseError.ConditionExpected);
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.ParenthesisR], []);
        }
        if (this.prevToken) {
          node.rParent = this.prevToken.offset;
        }
        return this.finish(node);
      } else if (this.peek(TokenType.Ident)) {
        const pos = this.mark();
        this.consumeToken();
        if (!this.hasWhitespace() && this.accept(TokenType.ParenthesisL)) {
          let openParentCount = 1;
          while (this.token.type !== TokenType.EOF && openParentCount !== 0) {
            if (this.token.type === TokenType.ParenthesisL) {
              openParentCount++;
            } else if (this.token.type === TokenType.ParenthesisR) {
              openParentCount--;
            }
            this.consumeToken();
          }
          return this.finish(node);
        } else {
          this.restoreAtMark(pos);
        }
      }
      return this.finish(node, ParseError.LeftParenthesisExpected, [], [TokenType.ParenthesisL]);
    }
    _parseMediaDeclaration(isNested = false) {
      if (isNested) {
        return this._tryParseRuleset(true) || this._tryToParseDeclaration() || this._parseStylesheetStatement(true);
      }
      return this._parseStylesheetStatement(false);
    }
    _parseMedia(isNested = false) {
      if (!this.peekKeyword("@media")) {
        return null;
      }
      const node = this.create(Media);
      this.consumeToken();
      if (!node.addChild(this._parseMediaQueryList())) {
        return this.finish(node, ParseError.MediaQueryExpected);
      }
      return this._parseBody(node, this._parseMediaDeclaration.bind(this, isNested));
    }
    _parseMediaQueryList() {
      const node = this.create(Medialist);
      if (!node.addChild(this._parseMediaQuery())) {
        return this.finish(node, ParseError.MediaQueryExpected);
      }
      while (this.accept(TokenType.Comma)) {
        if (!node.addChild(this._parseMediaQuery())) {
          return this.finish(node, ParseError.MediaQueryExpected);
        }
      }
      return this.finish(node);
    }
    _parseMediaQuery() {
      const node = this.create(MediaQuery);
      const pos = this.mark();
      this.acceptIdent("not");
      if (!this.peek(TokenType.ParenthesisL)) {
        if (this.acceptIdent("only")) {
        }
        if (!node.addChild(this._parseIdent())) {
          return null;
        }
        if (this.acceptIdent("and")) {
          node.addChild(this._parseMediaCondition());
        }
      } else {
        this.restoreAtMark(pos);
        node.addChild(this._parseMediaCondition());
      }
      return this.finish(node);
    }
    _parseRatio() {
      const pos = this.mark();
      const node = this.create(RatioValue);
      if (!this._parseNumeric()) {
        return null;
      }
      if (!this.acceptDelim("/")) {
        this.restoreAtMark(pos);
        return null;
      }
      if (!this._parseNumeric()) {
        return this.finish(node, ParseError.NumberExpected);
      }
      return this.finish(node);
    }
    _parseMediaCondition() {
      const node = this.create(MediaCondition);
      this.acceptIdent("not");
      let parseExpression = true;
      while (parseExpression) {
        if (!this.accept(TokenType.ParenthesisL)) {
          return this.finish(node, ParseError.LeftParenthesisExpected, [], [TokenType.CurlyL]);
        }
        if (this.peek(TokenType.ParenthesisL) || this.peekIdent("not")) {
          node.addChild(this._parseMediaCondition());
        } else {
          node.addChild(this._parseMediaFeature());
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [], [TokenType.CurlyL]);
        }
        parseExpression = this.acceptIdent("and") || this.acceptIdent("or");
      }
      return this.finish(node);
    }
    _parseMediaFeature() {
      const resyncStopToken = [TokenType.ParenthesisR];
      const node = this.create(MediaFeature);
      if (node.addChild(this._parseMediaFeatureName())) {
        if (this.accept(TokenType.Colon)) {
          if (!node.addChild(this._parseMediaFeatureValue())) {
            return this.finish(node, ParseError.TermExpected, [], resyncStopToken);
          }
        } else if (this._parseMediaFeatureRangeOperator()) {
          if (!node.addChild(this._parseMediaFeatureValue())) {
            return this.finish(node, ParseError.TermExpected, [], resyncStopToken);
          }
          if (this._parseMediaFeatureRangeOperator()) {
            if (!node.addChild(this._parseMediaFeatureValue())) {
              return this.finish(node, ParseError.TermExpected, [], resyncStopToken);
            }
          }
        } else {
        }
      } else if (node.addChild(this._parseMediaFeatureValue())) {
        if (!this._parseMediaFeatureRangeOperator()) {
          return this.finish(node, ParseError.OperatorExpected, [], resyncStopToken);
        }
        if (!node.addChild(this._parseMediaFeatureName())) {
          return this.finish(node, ParseError.IdentifierExpected, [], resyncStopToken);
        }
        if (this._parseMediaFeatureRangeOperator()) {
          if (!node.addChild(this._parseMediaFeatureValue())) {
            return this.finish(node, ParseError.TermExpected, [], resyncStopToken);
          }
        }
      } else {
        return this.finish(node, ParseError.IdentifierExpected, [], resyncStopToken);
      }
      return this.finish(node);
    }
    _parseMediaFeatureRangeOperator() {
      if (this.acceptDelim("<") || this.acceptDelim(">")) {
        if (!this.hasWhitespace()) {
          this.acceptDelim("=");
        }
        return true;
      } else if (this.acceptDelim("=")) {
        return true;
      }
      return false;
    }
    _parseMediaFeatureName() {
      return this._parseIdent();
    }
    _parseMediaFeatureValue() {
      return this._parseRatio() || this._parseTermExpression();
    }
    _parseMedium() {
      const node = this.create(Node);
      if (node.addChild(this._parseIdent())) {
        return this.finish(node);
      } else {
        return null;
      }
    }
    _parsePageDeclaration() {
      return this._parsePageMarginBox() || this._parseRuleSetDeclaration();
    }
    _parsePage() {
      if (!this.peekKeyword("@page")) {
        return null;
      }
      const node = this.create(Page);
      this.consumeToken();
      if (node.addChild(this._parsePageSelector())) {
        while (this.accept(TokenType.Comma)) {
          if (!node.addChild(this._parsePageSelector())) {
            return this.finish(node, ParseError.IdentifierExpected);
          }
        }
      }
      return this._parseBody(node, this._parsePageDeclaration.bind(this));
    }
    _parsePageMarginBox() {
      if (!this.peek(TokenType.AtKeyword)) {
        return null;
      }
      const node = this.create(PageBoxMarginBox);
      if (!this.acceptOneKeyword(pageBoxDirectives)) {
        this.markError(node, ParseError.UnknownAtRule, [], [TokenType.CurlyL]);
      }
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _parsePageSelector() {
      if (!this.peek(TokenType.Ident) && !this.peek(TokenType.Colon)) {
        return null;
      }
      const node = this.create(Node);
      node.addChild(this._parseIdent());
      if (this.accept(TokenType.Colon)) {
        if (!node.addChild(this._parseIdent())) {
          return this.finish(node, ParseError.IdentifierExpected);
        }
      }
      return this.finish(node);
    }
    _parseDocument() {
      if (!this.peekKeyword("@-moz-document")) {
        return null;
      }
      const node = this.create(Document);
      this.consumeToken();
      this.resync([], [TokenType.CurlyL]);
      return this._parseBody(node, this._parseStylesheetStatement.bind(this));
    }
    _parseContainerDeclaration(isNested = false) {
      if (isNested) {
        return this._tryParseRuleset(true) || this._tryToParseDeclaration() || this._parseStylesheetStatement(true);
      }
      return this._parseStylesheetStatement(false);
    }
    _parseContainer(isNested = false) {
      if (!this.peekKeyword("@container")) {
        return null;
      }
      const node = this.create(Container);
      this.consumeToken();
      node.addChild(this._parseIdent());
      node.addChild(this._parseContainerQuery());
      return this._parseBody(node, this._parseContainerDeclaration.bind(this, isNested));
    }
    _parseContainerQuery() {
      const node = this.create(Node);
      if (this.acceptIdent("not")) {
        node.addChild(this._parseContainerQueryInParens());
      } else {
        node.addChild(this._parseContainerQueryInParens());
        if (this.peekIdent("and")) {
          while (this.acceptIdent("and")) {
            node.addChild(this._parseContainerQueryInParens());
          }
        } else if (this.peekIdent("or")) {
          while (this.acceptIdent("or")) {
            node.addChild(this._parseContainerQueryInParens());
          }
        }
      }
      return this.finish(node);
    }
    _parseContainerQueryInParens() {
      const node = this.create(Node);
      if (this.accept(TokenType.ParenthesisL)) {
        if (this.peekIdent("not") || this.peek(TokenType.ParenthesisL)) {
          node.addChild(this._parseContainerQuery());
        } else {
          node.addChild(this._parseMediaFeature());
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [], [TokenType.CurlyL]);
        }
      } else if (this.acceptIdent("style")) {
        if (this.hasWhitespace() || !this.accept(TokenType.ParenthesisL)) {
          return this.finish(node, ParseError.LeftParenthesisExpected, [], [TokenType.CurlyL]);
        }
        node.addChild(this._parseStyleQuery());
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [], [TokenType.CurlyL]);
        }
      } else {
        return this.finish(node, ParseError.LeftParenthesisExpected, [], [TokenType.CurlyL]);
      }
      return this.finish(node);
    }
    _parseStyleQuery() {
      const node = this.create(Node);
      if (this.acceptIdent("not")) {
        node.addChild(this._parseStyleInParens());
      } else if (this.peek(TokenType.ParenthesisL)) {
        node.addChild(this._parseStyleInParens());
        if (this.peekIdent("and")) {
          while (this.acceptIdent("and")) {
            node.addChild(this._parseStyleInParens());
          }
        } else if (this.peekIdent("or")) {
          while (this.acceptIdent("or")) {
            node.addChild(this._parseStyleInParens());
          }
        }
      } else {
        node.addChild(this._parseDeclaration([TokenType.ParenthesisR]));
      }
      return this.finish(node);
    }
    _parseStyleInParens() {
      const node = this.create(Node);
      if (this.accept(TokenType.ParenthesisL)) {
        node.addChild(this._parseStyleQuery());
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [], [TokenType.CurlyL]);
        }
      } else {
        return this.finish(node, ParseError.LeftParenthesisExpected, [], [TokenType.CurlyL]);
      }
      return this.finish(node);
    }
    // https://www.w3.org/TR/css-syntax-3/#consume-an-at-rule
    _parseUnknownAtRule() {
      if (!this.peek(TokenType.AtKeyword)) {
        return null;
      }
      const node = this.create(UnknownAtRule);
      node.addChild(this._parseUnknownAtRuleName());
      const isTopLevel = () => curlyDepth === 0 && parensDepth === 0 && bracketsDepth === 0;
      let curlyLCount = 0;
      let curlyDepth = 0;
      let parensDepth = 0;
      let bracketsDepth = 0;
      done:
        while (true) {
          switch (this.token.type) {
            case TokenType.SemiColon:
              if (isTopLevel()) {
                break done;
              }
              break;
            case TokenType.EOF:
              if (curlyDepth > 0) {
                return this.finish(node, ParseError.RightCurlyExpected);
              } else if (bracketsDepth > 0) {
                return this.finish(node, ParseError.RightSquareBracketExpected);
              } else if (parensDepth > 0) {
                return this.finish(node, ParseError.RightParenthesisExpected);
              } else {
                return this.finish(node);
              }
            case TokenType.CurlyL:
              curlyLCount++;
              curlyDepth++;
              break;
            case TokenType.CurlyR:
              curlyDepth--;
              if (curlyLCount > 0 && curlyDepth === 0) {
                this.consumeToken();
                if (bracketsDepth > 0) {
                  return this.finish(node, ParseError.RightSquareBracketExpected);
                } else if (parensDepth > 0) {
                  return this.finish(node, ParseError.RightParenthesisExpected);
                }
                break done;
              }
              if (curlyDepth < 0) {
                if (parensDepth === 0 && bracketsDepth === 0) {
                  break done;
                }
                return this.finish(node, ParseError.LeftCurlyExpected);
              }
              break;
            case TokenType.ParenthesisL:
              parensDepth++;
              break;
            case TokenType.ParenthesisR:
              parensDepth--;
              if (parensDepth < 0) {
                return this.finish(node, ParseError.LeftParenthesisExpected);
              }
              break;
            case TokenType.BracketL:
              bracketsDepth++;
              break;
            case TokenType.BracketR:
              bracketsDepth--;
              if (bracketsDepth < 0) {
                return this.finish(node, ParseError.LeftSquareBracketExpected);
              }
              break;
          }
          this.consumeToken();
        }
      return node;
    }
    _parseUnknownAtRuleName() {
      const node = this.create(Node);
      if (this.accept(TokenType.AtKeyword)) {
        return this.finish(node);
      }
      return node;
    }
    _parseOperator() {
      if (this.peekDelim("/") || this.peekDelim("*") || this.peekDelim("+") || this.peekDelim("-") || this.peek(TokenType.Dashmatch) || this.peek(TokenType.Includes) || this.peek(TokenType.SubstringOperator) || this.peek(TokenType.PrefixOperator) || this.peek(TokenType.SuffixOperator) || this.peekDelim("=")) {
        const node = this.createNode(NodeType.Operator);
        this.consumeToken();
        return this.finish(node);
      } else {
        return null;
      }
    }
    _parseUnaryOperator() {
      if (!this.peekDelim("+") && !this.peekDelim("-")) {
        return null;
      }
      const node = this.create(Node);
      this.consumeToken();
      return this.finish(node);
    }
    _parseCombinator() {
      if (this.peekDelim(">")) {
        const node = this.create(Node);
        this.consumeToken();
        const mark = this.mark();
        if (!this.hasWhitespace() && this.acceptDelim(">")) {
          if (!this.hasWhitespace() && this.acceptDelim(">")) {
            node.type = NodeType.SelectorCombinatorShadowPiercingDescendant;
            return this.finish(node);
          }
          this.restoreAtMark(mark);
        }
        node.type = NodeType.SelectorCombinatorParent;
        return this.finish(node);
      } else if (this.peekDelim("+")) {
        const node = this.create(Node);
        this.consumeToken();
        node.type = NodeType.SelectorCombinatorSibling;
        return this.finish(node);
      } else if (this.peekDelim("~")) {
        const node = this.create(Node);
        this.consumeToken();
        node.type = NodeType.SelectorCombinatorAllSiblings;
        return this.finish(node);
      } else if (this.peekDelim("/")) {
        const node = this.create(Node);
        this.consumeToken();
        const mark = this.mark();
        if (!this.hasWhitespace() && this.acceptIdent("deep") && !this.hasWhitespace() && this.acceptDelim("/")) {
          node.type = NodeType.SelectorCombinatorShadowPiercingDescendant;
          return this.finish(node);
        }
        this.restoreAtMark(mark);
      }
      return null;
    }
    _parseSimpleSelector() {
      const node = this.create(SimpleSelector);
      let c = 0;
      if (node.addChild(this._parseElementName() || this._parseNestingSelector())) {
        c++;
      }
      while ((c === 0 || !this.hasWhitespace()) && node.addChild(this._parseSimpleSelectorBody())) {
        c++;
      }
      return c > 0 ? this.finish(node) : null;
    }
    _parseNestingSelector() {
      if (this.peekDelim("&")) {
        const node = this.createNode(NodeType.SelectorCombinator);
        this.consumeToken();
        return this.finish(node);
      }
      return null;
    }
    _parseSimpleSelectorBody() {
      return this._parsePseudo() || this._parseHash() || this._parseClass() || this._parseAttrib();
    }
    _parseSelectorIdent() {
      return this._parseIdent();
    }
    _parseHash() {
      if (!this.peek(TokenType.Hash) && !this.peekDelim("#")) {
        return null;
      }
      const node = this.createNode(NodeType.IdentifierSelector);
      if (this.acceptDelim("#")) {
        if (this.hasWhitespace() || !node.addChild(this._parseSelectorIdent())) {
          return this.finish(node, ParseError.IdentifierExpected);
        }
      } else {
        this.consumeToken();
      }
      return this.finish(node);
    }
    _parseClass() {
      if (!this.peekDelim(".")) {
        return null;
      }
      const node = this.createNode(NodeType.ClassSelector);
      this.consumeToken();
      if (this.hasWhitespace() || !node.addChild(this._parseSelectorIdent())) {
        return this.finish(node, ParseError.IdentifierExpected);
      }
      return this.finish(node);
    }
    _parseElementName() {
      const pos = this.mark();
      const node = this.createNode(NodeType.ElementNameSelector);
      node.addChild(this._parseNamespacePrefix());
      if (!node.addChild(this._parseSelectorIdent()) && !this.acceptDelim("*")) {
        this.restoreAtMark(pos);
        return null;
      }
      return this.finish(node);
    }
    _parseNamespacePrefix() {
      const pos = this.mark();
      const node = this.createNode(NodeType.NamespacePrefix);
      if (!node.addChild(this._parseIdent()) && !this.acceptDelim("*")) {
      }
      if (!this.acceptDelim("|")) {
        this.restoreAtMark(pos);
        return null;
      }
      return this.finish(node);
    }
    _parseAttrib() {
      if (!this.peek(TokenType.BracketL)) {
        return null;
      }
      const node = this.create(AttributeSelector);
      this.consumeToken();
      node.setNamespacePrefix(this._parseNamespacePrefix());
      if (!node.setIdentifier(this._parseIdent())) {
        return this.finish(node, ParseError.IdentifierExpected);
      }
      if (node.setOperator(this._parseOperator())) {
        node.setValue(this._parseBinaryExpr());
        this.acceptIdent("i");
        this.acceptIdent("s");
      }
      if (!this.accept(TokenType.BracketR)) {
        return this.finish(node, ParseError.RightSquareBracketExpected);
      }
      return this.finish(node);
    }
    _parsePseudo() {
      const node = this._tryParsePseudoIdentifier();
      if (node) {
        if (!this.hasWhitespace() && this.accept(TokenType.ParenthesisL)) {
          const tryAsSelector = () => {
            const selectors = this.create(Node);
            if (!selectors.addChild(this._parseSelector(true))) {
              return null;
            }
            while (this.accept(TokenType.Comma) && selectors.addChild(this._parseSelector(true))) {
            }
            if (this.peek(TokenType.ParenthesisR)) {
              return this.finish(selectors);
            }
            return null;
          };
          let hasSelector = node.addChild(this.try(tryAsSelector));
          if (!hasSelector) {
            if (node.addChild(this._parseBinaryExpr()) && this.acceptIdent("of") && !node.addChild(this.try(tryAsSelector))) {
              return this.finish(node, ParseError.SelectorExpected);
            }
          }
          if (!this.accept(TokenType.ParenthesisR)) {
            return this.finish(node, ParseError.RightParenthesisExpected);
          }
        }
        return this.finish(node);
      }
      return null;
    }
    _tryParsePseudoIdentifier() {
      if (!this.peek(TokenType.Colon)) {
        return null;
      }
      const pos = this.mark();
      const node = this.createNode(NodeType.PseudoSelector);
      this.consumeToken();
      if (this.hasWhitespace()) {
        this.restoreAtMark(pos);
        return null;
      }
      this.accept(TokenType.Colon);
      if (this.hasWhitespace() || !node.addChild(this._parseIdent())) {
        return this.finish(node, ParseError.IdentifierExpected);
      }
      return this.finish(node);
    }
    _tryParsePrio() {
      const mark = this.mark();
      const prio = this._parsePrio();
      if (prio) {
        return prio;
      }
      this.restoreAtMark(mark);
      return null;
    }
    _parsePrio() {
      if (!this.peek(TokenType.Exclamation)) {
        return null;
      }
      const node = this.createNode(NodeType.Prio);
      if (this.accept(TokenType.Exclamation) && this.acceptIdent("important")) {
        return this.finish(node);
      }
      return null;
    }
    _parseExpr(stopOnComma = false) {
      const node = this.create(Expression);
      if (!node.addChild(this._parseBinaryExpr())) {
        return null;
      }
      while (true) {
        if (this.peek(TokenType.Comma)) {
          if (stopOnComma) {
            return this.finish(node);
          }
          this.consumeToken();
        }
        if (!node.addChild(this._parseBinaryExpr())) {
          break;
        }
      }
      return this.finish(node);
    }
    _parseUnicodeRange() {
      if (!this.peekIdent("u")) {
        return null;
      }
      const node = this.create(UnicodeRange);
      if (!this.acceptUnicodeRange()) {
        return null;
      }
      return this.finish(node);
    }
    _parseNamedLine() {
      if (!this.peek(TokenType.BracketL)) {
        return null;
      }
      const node = this.createNode(NodeType.GridLine);
      this.consumeToken();
      while (node.addChild(this._parseIdent())) {
      }
      if (!this.accept(TokenType.BracketR)) {
        return this.finish(node, ParseError.RightSquareBracketExpected);
      }
      return this.finish(node);
    }
    _parseBinaryExpr(preparsedLeft, preparsedOper) {
      let node = this.create(BinaryExpression);
      if (!node.setLeft(preparsedLeft || this._parseTerm())) {
        return null;
      }
      if (!node.setOperator(preparsedOper || this._parseOperator())) {
        return this.finish(node);
      }
      if (!node.setRight(this._parseTerm())) {
        return this.finish(node, ParseError.TermExpected);
      }
      node = this.finish(node);
      const operator = this._parseOperator();
      if (operator) {
        node = this._parseBinaryExpr(node, operator);
      }
      return this.finish(node);
    }
    _parseTerm() {
      let node = this.create(Term);
      node.setOperator(this._parseUnaryOperator());
      if (node.setExpression(this._parseTermExpression())) {
        return this.finish(node);
      }
      return null;
    }
    _parseTermExpression() {
      return this._parseURILiteral() || // url before function
      this._parseUnicodeRange() || this._parseFunction() || // function before ident
      this._parseIdent() || this._parseStringLiteral() || this._parseNumeric() || this._parseHexColor() || this._parseOperation() || this._parseNamedLine();
    }
    _parseOperation() {
      if (!this.peek(TokenType.ParenthesisL)) {
        return null;
      }
      const node = this.create(Node);
      this.consumeToken();
      node.addChild(this._parseExpr());
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseNumeric() {
      if (this.peek(TokenType.Num) || this.peek(TokenType.Percentage) || this.peek(TokenType.Resolution) || this.peek(TokenType.Length) || this.peek(TokenType.EMS) || this.peek(TokenType.EXS) || this.peek(TokenType.Angle) || this.peek(TokenType.Time) || this.peek(TokenType.Dimension) || this.peek(TokenType.ContainerQueryLength) || this.peek(TokenType.Freq)) {
        const node = this.create(NumericValue);
        this.consumeToken();
        return this.finish(node);
      }
      return null;
    }
    _parseStringLiteral() {
      if (!this.peek(TokenType.String) && !this.peek(TokenType.BadString)) {
        return null;
      }
      const node = this.createNode(NodeType.StringLiteral);
      this.consumeToken();
      return this.finish(node);
    }
    _parseURILiteral() {
      if (!this.peekRegExp(TokenType.Ident, /^url(-prefix)?$/i)) {
        return null;
      }
      const pos = this.mark();
      const node = this.createNode(NodeType.URILiteral);
      this.accept(TokenType.Ident);
      if (this.hasWhitespace() || !this.peek(TokenType.ParenthesisL)) {
        this.restoreAtMark(pos);
        return null;
      }
      this.scanner.inURL = true;
      this.consumeToken();
      node.addChild(this._parseURLArgument());
      this.scanner.inURL = false;
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseURLArgument() {
      const node = this.create(Node);
      if (!this.accept(TokenType.String) && !this.accept(TokenType.BadString) && !this.acceptUnquotedString()) {
        return null;
      }
      return this.finish(node);
    }
    _parseIdent(referenceTypes) {
      if (!this.peek(TokenType.Ident)) {
        return null;
      }
      const node = this.create(Identifier);
      if (referenceTypes) {
        node.referenceTypes = referenceTypes;
      }
      node.isCustomProperty = this.peekRegExp(TokenType.Ident, /^--/);
      this.consumeToken();
      return this.finish(node);
    }
    _parseFunction() {
      const pos = this.mark();
      const node = this.create(Function);
      if (!node.setIdentifier(this._parseFunctionIdentifier())) {
        return null;
      }
      if (this.hasWhitespace() || !this.accept(TokenType.ParenthesisL)) {
        this.restoreAtMark(pos);
        return null;
      }
      if (node.getArguments().addChild(this._parseFunctionArgument())) {
        while (this.accept(TokenType.Comma)) {
          if (this.peek(TokenType.ParenthesisR)) {
            break;
          }
          if (!node.getArguments().addChild(this._parseFunctionArgument())) {
            this.markError(node, ParseError.ExpressionExpected);
          }
        }
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseFunctionIdentifier() {
      if (!this.peek(TokenType.Ident)) {
        return null;
      }
      const node = this.create(Identifier);
      node.referenceTypes = [ReferenceType.Function];
      if (this.acceptIdent("progid")) {
        if (this.accept(TokenType.Colon)) {
          while (this.accept(TokenType.Ident) && this.acceptDelim(".")) {
          }
        }
        return this.finish(node);
      }
      this.consumeToken();
      return this.finish(node);
    }
    _parseFunctionArgument() {
      const node = this.create(FunctionArgument);
      if (node.setValue(this._parseExpr(true))) {
        return this.finish(node);
      }
      return null;
    }
    _parseHexColor() {
      if (this.peekRegExp(TokenType.Hash, /^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{4}|[A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$/g)) {
        const node = this.create(HexColorValue);
        this.consumeToken();
        return this.finish(node);
      } else {
        return null;
      }
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/utils/arrays.js
  function findFirst(array, p) {
    let low = 0, high = array.length;
    if (high === 0) {
      return 0;
    }
    while (low < high) {
      let mid = Math.floor((low + high) / 2);
      if (p(array[mid])) {
        high = mid;
      } else {
        low = mid + 1;
      }
    }
    return low;
  }
  function includes(array, item) {
    return array.indexOf(item) !== -1;
  }
  function union(...arrays) {
    const result = [];
    for (const array of arrays) {
      for (const item of array) {
        if (!includes(result, item)) {
          result.push(item);
        }
      }
    }
    return result;
  }

  // node_modules/vscode-css-languageservice/lib/esm/parser/cssSymbolScope.js
  var Scope = class {
    constructor(offset, length) {
      this.offset = offset;
      this.length = length;
      this.symbols = [];
      this.parent = null;
      this.children = [];
    }
    addChild(scope) {
      this.children.push(scope);
      scope.setParent(this);
    }
    setParent(scope) {
      this.parent = scope;
    }
    findScope(offset, length = 0) {
      if (this.offset <= offset && this.offset + this.length > offset + length || this.offset === offset && this.length === length) {
        return this.findInScope(offset, length);
      }
      return null;
    }
    findInScope(offset, length = 0) {
      const end = offset + length;
      const idx = findFirst(this.children, (s) => s.offset > end);
      if (idx === 0) {
        return this;
      }
      const res = this.children[idx - 1];
      if (res.offset <= offset && res.offset + res.length >= offset + length) {
        return res.findInScope(offset, length);
      }
      return this;
    }
    addSymbol(symbol) {
      this.symbols.push(symbol);
    }
    getSymbol(name, type) {
      for (let index = 0; index < this.symbols.length; index++) {
        const symbol = this.symbols[index];
        if (symbol.name === name && symbol.type === type) {
          return symbol;
        }
      }
      return null;
    }
    getSymbols() {
      return this.symbols;
    }
  };
  var GlobalScope = class extends Scope {
    constructor() {
      super(0, Number.MAX_VALUE);
    }
  };
  var Symbol2 = class {
    constructor(name, value, node, type) {
      this.name = name;
      this.value = value;
      this.node = node;
      this.type = type;
    }
  };
  var ScopeBuilder = class {
    constructor(scope) {
      this.scope = scope;
    }
    addSymbol(node, name, value, type) {
      if (node.offset !== -1) {
        const current = this.scope.findScope(node.offset, node.length);
        if (current) {
          current.addSymbol(new Symbol2(name, value, node, type));
        }
      }
    }
    addScope(node) {
      if (node.offset !== -1) {
        const current = this.scope.findScope(node.offset, node.length);
        if (current && (current.offset !== node.offset || current.length !== node.length)) {
          const newScope = new Scope(node.offset, node.length);
          current.addChild(newScope);
          return newScope;
        }
        return current;
      }
      return null;
    }
    addSymbolToChildScope(scopeNode, node, name, value, type) {
      if (scopeNode && scopeNode.offset !== -1) {
        const current = this.addScope(scopeNode);
        if (current) {
          current.addSymbol(new Symbol2(name, value, node, type));
        }
      }
    }
    visitNode(node) {
      switch (node.type) {
        case NodeType.Keyframe:
          this.addSymbol(node, node.getName(), void 0, ReferenceType.Keyframe);
          return true;
        case NodeType.CustomPropertyDeclaration:
          return this.visitCustomPropertyDeclarationNode(node);
        case NodeType.VariableDeclaration:
          return this.visitVariableDeclarationNode(node);
        case NodeType.Ruleset:
          return this.visitRuleSet(node);
        case NodeType.MixinDeclaration:
          this.addSymbol(node, node.getName(), void 0, ReferenceType.Mixin);
          return true;
        case NodeType.FunctionDeclaration:
          this.addSymbol(node, node.getName(), void 0, ReferenceType.Function);
          return true;
        case NodeType.FunctionParameter: {
          return this.visitFunctionParameterNode(node);
        }
        case NodeType.Declarations:
          this.addScope(node);
          return true;
        case NodeType.For:
          const forNode = node;
          const scopeNode = forNode.getDeclarations();
          if (scopeNode && forNode.variable) {
            this.addSymbolToChildScope(scopeNode, forNode.variable, forNode.variable.getName(), void 0, ReferenceType.Variable);
          }
          return true;
        case NodeType.Each: {
          const eachNode = node;
          const scopeNode2 = eachNode.getDeclarations();
          if (scopeNode2) {
            const variables = eachNode.getVariables().getChildren();
            for (const variable of variables) {
              this.addSymbolToChildScope(scopeNode2, variable, variable.getName(), void 0, ReferenceType.Variable);
            }
          }
          return true;
        }
      }
      return true;
    }
    visitRuleSet(node) {
      const current = this.scope.findScope(node.offset, node.length);
      if (current) {
        for (const child of node.getSelectors().getChildren()) {
          if (child instanceof Selector) {
            if (child.getChildren().length === 1) {
              current.addSymbol(new Symbol2(child.getChild(0).getText(), void 0, child, ReferenceType.Rule));
            }
          }
        }
      }
      return true;
    }
    visitVariableDeclarationNode(node) {
      const value = node.getValue() ? node.getValue().getText() : void 0;
      this.addSymbol(node, node.getName(), value, ReferenceType.Variable);
      return true;
    }
    visitFunctionParameterNode(node) {
      const scopeNode = node.getParent().getDeclarations();
      if (scopeNode) {
        const valueNode = node.getDefaultValue();
        const value = valueNode ? valueNode.getText() : void 0;
        this.addSymbolToChildScope(scopeNode, node, node.getName(), value, ReferenceType.Variable);
      }
      return true;
    }
    visitCustomPropertyDeclarationNode(node) {
      const value = node.getValue() ? node.getValue().getText() : "";
      this.addCSSVariable(node.getProperty(), node.getProperty().getName(), value, ReferenceType.Variable);
      return true;
    }
    addCSSVariable(node, name, value, type) {
      if (node.offset !== -1) {
        this.scope.addSymbol(new Symbol2(name, value, node, type));
      }
    }
  };
  var Symbols = class {
    constructor(node) {
      this.global = new GlobalScope();
      node.acceptVisitor(new ScopeBuilder(this.global));
    }
    findSymbolsAtOffset(offset, referenceType) {
      let scope = this.global.findScope(offset, 0);
      const result = [];
      const names = {};
      while (scope) {
        const symbols = scope.getSymbols();
        for (let i = 0; i < symbols.length; i++) {
          const symbol = symbols[i];
          if (symbol.type === referenceType && !names[symbol.name]) {
            result.push(symbol);
            names[symbol.name] = true;
          }
        }
        scope = scope.parent;
      }
      return result;
    }
    internalFindSymbol(node, referenceTypes) {
      let scopeNode = node;
      if (node.parent instanceof FunctionParameter && node.parent.getParent() instanceof BodyDeclaration) {
        scopeNode = node.parent.getParent().getDeclarations();
      }
      if (node.parent instanceof FunctionArgument && node.parent.getParent() instanceof Function) {
        const funcId = node.parent.getParent().getIdentifier();
        if (funcId) {
          const functionSymbol = this.internalFindSymbol(funcId, [ReferenceType.Function]);
          if (functionSymbol) {
            scopeNode = functionSymbol.node.getDeclarations();
          }
        }
      }
      if (!scopeNode) {
        return null;
      }
      const name = node.getText();
      let scope = this.global.findScope(scopeNode.offset, scopeNode.length);
      while (scope) {
        for (let index = 0; index < referenceTypes.length; index++) {
          const type = referenceTypes[index];
          const symbol = scope.getSymbol(name, type);
          if (symbol) {
            return symbol;
          }
        }
        scope = scope.parent;
      }
      return null;
    }
    evaluateReferenceTypes(node) {
      if (node instanceof Identifier) {
        const referenceTypes = node.referenceTypes;
        if (referenceTypes) {
          return referenceTypes;
        } else {
          if (node.isCustomProperty) {
            return [ReferenceType.Variable];
          }
          const decl = getParentDeclaration(node);
          if (decl) {
            const propertyName = decl.getNonPrefixedPropertyName();
            if ((propertyName === "animation" || propertyName === "animation-name") && decl.getValue() && decl.getValue().offset === node.offset) {
              return [ReferenceType.Keyframe];
            }
          }
        }
      } else if (node instanceof Variable) {
        return [ReferenceType.Variable];
      }
      const selector = node.findAParent(NodeType.Selector, NodeType.ExtendsReference);
      if (selector) {
        return [ReferenceType.Rule];
      }
      return null;
    }
    findSymbolFromNode(node) {
      if (!node) {
        return null;
      }
      while (node.type === NodeType.Interpolation) {
        node = node.getParent();
      }
      const referenceTypes = this.evaluateReferenceTypes(node);
      if (referenceTypes) {
        return this.internalFindSymbol(node, referenceTypes);
      }
      return null;
    }
    matchesSymbol(node, symbol) {
      if (!node) {
        return false;
      }
      while (node.type === NodeType.Interpolation) {
        node = node.getParent();
      }
      if (!node.matches(symbol.name)) {
        return false;
      }
      const referenceTypes = this.evaluateReferenceTypes(node);
      if (!referenceTypes || referenceTypes.indexOf(symbol.type) === -1) {
        return false;
      }
      const nodeSymbol = this.internalFindSymbol(node, referenceTypes);
      return nodeSymbol === symbol;
    }
    findSymbol(name, type, offset) {
      let scope = this.global.findScope(offset);
      while (scope) {
        const symbol = scope.getSymbol(name, type);
        if (symbol) {
          return symbol;
        }
        scope = scope.parent;
      }
      return null;
    }
  };

  // node_modules/vscode-uri/lib/esm/index.mjs
  var LIB;
  (() => {
    "use strict";
    var t2 = { 470: (t3) => {
      function e2(t4) {
        if ("string" != typeof t4)
          throw new TypeError("Path must be a string. Received " + JSON.stringify(t4));
      }
      function r2(t4, e3) {
        for (var r3, n3 = "", i = 0, o = -1, s = 0, h = 0; h <= t4.length; ++h) {
          if (h < t4.length)
            r3 = t4.charCodeAt(h);
          else {
            if (47 === r3)
              break;
            r3 = 47;
          }
          if (47 === r3) {
            if (o === h - 1 || 1 === s)
              ;
            else if (o !== h - 1 && 2 === s) {
              if (n3.length < 2 || 2 !== i || 46 !== n3.charCodeAt(n3.length - 1) || 46 !== n3.charCodeAt(n3.length - 2)) {
                if (n3.length > 2) {
                  var a2 = n3.lastIndexOf("/");
                  if (a2 !== n3.length - 1) {
                    -1 === a2 ? (n3 = "", i = 0) : i = (n3 = n3.slice(0, a2)).length - 1 - n3.lastIndexOf("/"), o = h, s = 0;
                    continue;
                  }
                } else if (2 === n3.length || 1 === n3.length) {
                  n3 = "", i = 0, o = h, s = 0;
                  continue;
                }
              }
              e3 && (n3.length > 0 ? n3 += "/.." : n3 = "..", i = 2);
            } else
              n3.length > 0 ? n3 += "/" + t4.slice(o + 1, h) : n3 = t4.slice(o + 1, h), i = h - o - 1;
            o = h, s = 0;
          } else
            46 === r3 && -1 !== s ? ++s : s = -1;
        }
        return n3;
      }
      var n2 = { resolve: function() {
        for (var t4, n3 = "", i = false, o = arguments.length - 1; o >= -1 && !i; o--) {
          var s;
          o >= 0 ? s = arguments[o] : (void 0 === t4 && (t4 = process.cwd()), s = t4), e2(s), 0 !== s.length && (n3 = s + "/" + n3, i = 47 === s.charCodeAt(0));
        }
        return n3 = r2(n3, !i), i ? n3.length > 0 ? "/" + n3 : "/" : n3.length > 0 ? n3 : ".";
      }, normalize: function(t4) {
        if (e2(t4), 0 === t4.length)
          return ".";
        var n3 = 47 === t4.charCodeAt(0), i = 47 === t4.charCodeAt(t4.length - 1);
        return 0 !== (t4 = r2(t4, !n3)).length || n3 || (t4 = "."), t4.length > 0 && i && (t4 += "/"), n3 ? "/" + t4 : t4;
      }, isAbsolute: function(t4) {
        return e2(t4), t4.length > 0 && 47 === t4.charCodeAt(0);
      }, join: function() {
        if (0 === arguments.length)
          return ".";
        for (var t4, r3 = 0; r3 < arguments.length; ++r3) {
          var i = arguments[r3];
          e2(i), i.length > 0 && (void 0 === t4 ? t4 = i : t4 += "/" + i);
        }
        return void 0 === t4 ? "." : n2.normalize(t4);
      }, relative: function(t4, r3) {
        if (e2(t4), e2(r3), t4 === r3)
          return "";
        if ((t4 = n2.resolve(t4)) === (r3 = n2.resolve(r3)))
          return "";
        for (var i = 1; i < t4.length && 47 === t4.charCodeAt(i); ++i)
          ;
        for (var o = t4.length, s = o - i, h = 1; h < r3.length && 47 === r3.charCodeAt(h); ++h)
          ;
        for (var a2 = r3.length - h, c = s < a2 ? s : a2, f2 = -1, u = 0; u <= c; ++u) {
          if (u === c) {
            if (a2 > c) {
              if (47 === r3.charCodeAt(h + u))
                return r3.slice(h + u + 1);
              if (0 === u)
                return r3.slice(h + u);
            } else
              s > c && (47 === t4.charCodeAt(i + u) ? f2 = u : 0 === u && (f2 = 0));
            break;
          }
          var l = t4.charCodeAt(i + u);
          if (l !== r3.charCodeAt(h + u))
            break;
          47 === l && (f2 = u);
        }
        var g = "";
        for (u = i + f2 + 1; u <= o; ++u)
          u !== o && 47 !== t4.charCodeAt(u) || (0 === g.length ? g += ".." : g += "/..");
        return g.length > 0 ? g + r3.slice(h + f2) : (h += f2, 47 === r3.charCodeAt(h) && ++h, r3.slice(h));
      }, _makeLong: function(t4) {
        return t4;
      }, dirname: function(t4) {
        if (e2(t4), 0 === t4.length)
          return ".";
        for (var r3 = t4.charCodeAt(0), n3 = 47 === r3, i = -1, o = true, s = t4.length - 1; s >= 1; --s)
          if (47 === (r3 = t4.charCodeAt(s))) {
            if (!o) {
              i = s;
              break;
            }
          } else
            o = false;
        return -1 === i ? n3 ? "/" : "." : n3 && 1 === i ? "//" : t4.slice(0, i);
      }, basename: function(t4, r3) {
        if (void 0 !== r3 && "string" != typeof r3)
          throw new TypeError('"ext" argument must be a string');
        e2(t4);
        var n3, i = 0, o = -1, s = true;
        if (void 0 !== r3 && r3.length > 0 && r3.length <= t4.length) {
          if (r3.length === t4.length && r3 === t4)
            return "";
          var h = r3.length - 1, a2 = -1;
          for (n3 = t4.length - 1; n3 >= 0; --n3) {
            var c = t4.charCodeAt(n3);
            if (47 === c) {
              if (!s) {
                i = n3 + 1;
                break;
              }
            } else
              -1 === a2 && (s = false, a2 = n3 + 1), h >= 0 && (c === r3.charCodeAt(h) ? -1 == --h && (o = n3) : (h = -1, o = a2));
          }
          return i === o ? o = a2 : -1 === o && (o = t4.length), t4.slice(i, o);
        }
        for (n3 = t4.length - 1; n3 >= 0; --n3)
          if (47 === t4.charCodeAt(n3)) {
            if (!s) {
              i = n3 + 1;
              break;
            }
          } else
            -1 === o && (s = false, o = n3 + 1);
        return -1 === o ? "" : t4.slice(i, o);
      }, extname: function(t4) {
        e2(t4);
        for (var r3 = -1, n3 = 0, i = -1, o = true, s = 0, h = t4.length - 1; h >= 0; --h) {
          var a2 = t4.charCodeAt(h);
          if (47 !== a2)
            -1 === i && (o = false, i = h + 1), 46 === a2 ? -1 === r3 ? r3 = h : 1 !== s && (s = 1) : -1 !== r3 && (s = -1);
          else if (!o) {
            n3 = h + 1;
            break;
          }
        }
        return -1 === r3 || -1 === i || 0 === s || 1 === s && r3 === i - 1 && r3 === n3 + 1 ? "" : t4.slice(r3, i);
      }, format: function(t4) {
        if (null === t4 || "object" != typeof t4)
          throw new TypeError('The "pathObject" argument must be of type Object. Received type ' + typeof t4);
        return function(t5, e3) {
          var r3 = e3.dir || e3.root, n3 = e3.base || (e3.name || "") + (e3.ext || "");
          return r3 ? r3 === e3.root ? r3 + n3 : r3 + "/" + n3 : n3;
        }(0, t4);
      }, parse: function(t4) {
        e2(t4);
        var r3 = { root: "", dir: "", base: "", ext: "", name: "" };
        if (0 === t4.length)
          return r3;
        var n3, i = t4.charCodeAt(0), o = 47 === i;
        o ? (r3.root = "/", n3 = 1) : n3 = 0;
        for (var s = -1, h = 0, a2 = -1, c = true, f2 = t4.length - 1, u = 0; f2 >= n3; --f2)
          if (47 !== (i = t4.charCodeAt(f2)))
            -1 === a2 && (c = false, a2 = f2 + 1), 46 === i ? -1 === s ? s = f2 : 1 !== u && (u = 1) : -1 !== s && (u = -1);
          else if (!c) {
            h = f2 + 1;
            break;
          }
        return -1 === s || -1 === a2 || 0 === u || 1 === u && s === a2 - 1 && s === h + 1 ? -1 !== a2 && (r3.base = r3.name = 0 === h && o ? t4.slice(1, a2) : t4.slice(h, a2)) : (0 === h && o ? (r3.name = t4.slice(1, s), r3.base = t4.slice(1, a2)) : (r3.name = t4.slice(h, s), r3.base = t4.slice(h, a2)), r3.ext = t4.slice(s, a2)), h > 0 ? r3.dir = t4.slice(0, h - 1) : o && (r3.dir = "/"), r3;
      }, sep: "/", delimiter: ":", win32: null, posix: null };
      n2.posix = n2, t3.exports = n2;
    } }, e = {};
    function r(n2) {
      var i = e[n2];
      if (void 0 !== i)
        return i.exports;
      var o = e[n2] = { exports: {} };
      return t2[n2](o, o.exports, r), o.exports;
    }
    r.d = (t3, e2) => {
      for (var n2 in e2)
        r.o(e2, n2) && !r.o(t3, n2) && Object.defineProperty(t3, n2, { enumerable: true, get: e2[n2] });
    }, r.o = (t3, e2) => Object.prototype.hasOwnProperty.call(t3, e2), r.r = (t3) => {
      "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(t3, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(t3, "__esModule", { value: true });
    };
    var n = {};
    (() => {
      let t3;
      if (r.r(n), r.d(n, { URI: () => f2, Utils: () => P }), "object" == typeof process)
        t3 = "win32" === process.platform;
      else if ("object" == typeof navigator) {
        let e3 = navigator.userAgent;
        t3 = e3.indexOf("Windows") >= 0;
      }
      const e2 = /^\w[\w\d+.-]*$/, i = /^\//, o = /^\/\//;
      function s(t4, r2) {
        if (!t4.scheme && r2)
          throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${t4.authority}", path: "${t4.path}", query: "${t4.query}", fragment: "${t4.fragment}"}`);
        if (t4.scheme && !e2.test(t4.scheme))
          throw new Error("[UriError]: Scheme contains illegal characters.");
        if (t4.path) {
          if (t4.authority) {
            if (!i.test(t4.path))
              throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
          } else if (o.test(t4.path))
            throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
        }
      }
      const h = "", a2 = "/", c = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
      class f2 {
        static isUri(t4) {
          return t4 instanceof f2 || !!t4 && "string" == typeof t4.authority && "string" == typeof t4.fragment && "string" == typeof t4.path && "string" == typeof t4.query && "string" == typeof t4.scheme && "string" == typeof t4.fsPath && "function" == typeof t4.with && "function" == typeof t4.toString;
        }
        scheme;
        authority;
        path;
        query;
        fragment;
        constructor(t4, e3, r2, n2, i2, o2 = false) {
          "object" == typeof t4 ? (this.scheme = t4.scheme || h, this.authority = t4.authority || h, this.path = t4.path || h, this.query = t4.query || h, this.fragment = t4.fragment || h) : (this.scheme = /* @__PURE__ */ function(t5, e4) {
            return t5 || e4 ? t5 : "file";
          }(t4, o2), this.authority = e3 || h, this.path = function(t5, e4) {
            switch (t5) {
              case "https":
              case "http":
              case "file":
                e4 ? e4[0] !== a2 && (e4 = a2 + e4) : e4 = a2;
            }
            return e4;
          }(this.scheme, r2 || h), this.query = n2 || h, this.fragment = i2 || h, s(this, o2));
        }
        get fsPath() {
          return m(this, false);
        }
        with(t4) {
          if (!t4)
            return this;
          let { scheme: e3, authority: r2, path: n2, query: i2, fragment: o2 } = t4;
          return void 0 === e3 ? e3 = this.scheme : null === e3 && (e3 = h), void 0 === r2 ? r2 = this.authority : null === r2 && (r2 = h), void 0 === n2 ? n2 = this.path : null === n2 && (n2 = h), void 0 === i2 ? i2 = this.query : null === i2 && (i2 = h), void 0 === o2 ? o2 = this.fragment : null === o2 && (o2 = h), e3 === this.scheme && r2 === this.authority && n2 === this.path && i2 === this.query && o2 === this.fragment ? this : new l(e3, r2, n2, i2, o2);
        }
        static parse(t4, e3 = false) {
          const r2 = c.exec(t4);
          return r2 ? new l(r2[2] || h, C(r2[4] || h), C(r2[5] || h), C(r2[7] || h), C(r2[9] || h), e3) : new l(h, h, h, h, h);
        }
        static file(e3) {
          let r2 = h;
          if (t3 && (e3 = e3.replace(/\\/g, a2)), e3[0] === a2 && e3[1] === a2) {
            const t4 = e3.indexOf(a2, 2);
            -1 === t4 ? (r2 = e3.substring(2), e3 = a2) : (r2 = e3.substring(2, t4), e3 = e3.substring(t4) || a2);
          }
          return new l("file", r2, e3, h, h);
        }
        static from(t4) {
          const e3 = new l(t4.scheme, t4.authority, t4.path, t4.query, t4.fragment);
          return s(e3, true), e3;
        }
        toString(t4 = false) {
          return y(this, t4);
        }
        toJSON() {
          return this;
        }
        static revive(t4) {
          if (t4) {
            if (t4 instanceof f2)
              return t4;
            {
              const e3 = new l(t4);
              return e3._formatted = t4.external, e3._fsPath = t4._sep === u ? t4.fsPath : null, e3;
            }
          }
          return t4;
        }
      }
      const u = t3 ? 1 : void 0;
      class l extends f2 {
        _formatted = null;
        _fsPath = null;
        get fsPath() {
          return this._fsPath || (this._fsPath = m(this, false)), this._fsPath;
        }
        toString(t4 = false) {
          return t4 ? y(this, true) : (this._formatted || (this._formatted = y(this, false)), this._formatted);
        }
        toJSON() {
          const t4 = { $mid: 1 };
          return this._fsPath && (t4.fsPath = this._fsPath, t4._sep = u), this._formatted && (t4.external = this._formatted), this.path && (t4.path = this.path), this.scheme && (t4.scheme = this.scheme), this.authority && (t4.authority = this.authority), this.query && (t4.query = this.query), this.fragment && (t4.fragment = this.fragment), t4;
        }
      }
      const g = { 58: "%3A", 47: "%2F", 63: "%3F", 35: "%23", 91: "%5B", 93: "%5D", 64: "%40", 33: "%21", 36: "%24", 38: "%26", 39: "%27", 40: "%28", 41: "%29", 42: "%2A", 43: "%2B", 44: "%2C", 59: "%3B", 61: "%3D", 32: "%20" };
      function d(t4, e3, r2) {
        let n2, i2 = -1;
        for (let o2 = 0; o2 < t4.length; o2++) {
          const s2 = t4.charCodeAt(o2);
          if (s2 >= 97 && s2 <= 122 || s2 >= 65 && s2 <= 90 || s2 >= 48 && s2 <= 57 || 45 === s2 || 46 === s2 || 95 === s2 || 126 === s2 || e3 && 47 === s2 || r2 && 91 === s2 || r2 && 93 === s2 || r2 && 58 === s2)
            -1 !== i2 && (n2 += encodeURIComponent(t4.substring(i2, o2)), i2 = -1), void 0 !== n2 && (n2 += t4.charAt(o2));
          else {
            void 0 === n2 && (n2 = t4.substr(0, o2));
            const e4 = g[s2];
            void 0 !== e4 ? (-1 !== i2 && (n2 += encodeURIComponent(t4.substring(i2, o2)), i2 = -1), n2 += e4) : -1 === i2 && (i2 = o2);
          }
        }
        return -1 !== i2 && (n2 += encodeURIComponent(t4.substring(i2))), void 0 !== n2 ? n2 : t4;
      }
      function p(t4) {
        let e3;
        for (let r2 = 0; r2 < t4.length; r2++) {
          const n2 = t4.charCodeAt(r2);
          35 === n2 || 63 === n2 ? (void 0 === e3 && (e3 = t4.substr(0, r2)), e3 += g[n2]) : void 0 !== e3 && (e3 += t4[r2]);
        }
        return void 0 !== e3 ? e3 : t4;
      }
      function m(e3, r2) {
        let n2;
        return n2 = e3.authority && e3.path.length > 1 && "file" === e3.scheme ? `//${e3.authority}${e3.path}` : 47 === e3.path.charCodeAt(0) && (e3.path.charCodeAt(1) >= 65 && e3.path.charCodeAt(1) <= 90 || e3.path.charCodeAt(1) >= 97 && e3.path.charCodeAt(1) <= 122) && 58 === e3.path.charCodeAt(2) ? r2 ? e3.path.substr(1) : e3.path[1].toLowerCase() + e3.path.substr(2) : e3.path, t3 && (n2 = n2.replace(/\//g, "\\")), n2;
      }
      function y(t4, e3) {
        const r2 = e3 ? p : d;
        let n2 = "", { scheme: i2, authority: o2, path: s2, query: h2, fragment: c2 } = t4;
        if (i2 && (n2 += i2, n2 += ":"), (o2 || "file" === i2) && (n2 += a2, n2 += a2), o2) {
          let t5 = o2.indexOf("@");
          if (-1 !== t5) {
            const e4 = o2.substr(0, t5);
            o2 = o2.substr(t5 + 1), t5 = e4.lastIndexOf(":"), -1 === t5 ? n2 += r2(e4, false, false) : (n2 += r2(e4.substr(0, t5), false, false), n2 += ":", n2 += r2(e4.substr(t5 + 1), false, true)), n2 += "@";
          }
          o2 = o2.toLowerCase(), t5 = o2.lastIndexOf(":"), -1 === t5 ? n2 += r2(o2, false, true) : (n2 += r2(o2.substr(0, t5), false, true), n2 += o2.substr(t5));
        }
        if (s2) {
          if (s2.length >= 3 && 47 === s2.charCodeAt(0) && 58 === s2.charCodeAt(2)) {
            const t5 = s2.charCodeAt(1);
            t5 >= 65 && t5 <= 90 && (s2 = `/${String.fromCharCode(t5 + 32)}:${s2.substr(3)}`);
          } else if (s2.length >= 2 && 58 === s2.charCodeAt(1)) {
            const t5 = s2.charCodeAt(0);
            t5 >= 65 && t5 <= 90 && (s2 = `${String.fromCharCode(t5 + 32)}:${s2.substr(2)}`);
          }
          n2 += r2(s2, true, false);
        }
        return h2 && (n2 += "?", n2 += r2(h2, false, false)), c2 && (n2 += "#", n2 += e3 ? c2 : d(c2, false, false)), n2;
      }
      function v(t4) {
        try {
          return decodeURIComponent(t4);
        } catch {
          return t4.length > 3 ? t4.substr(0, 3) + v(t4.substr(3)) : t4;
        }
      }
      const b = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
      function C(t4) {
        return t4.match(b) ? t4.replace(b, (t5) => v(t5)) : t4;
      }
      var A2 = r(470);
      const w = A2.posix || A2, x = "/";
      var P;
      !function(t4) {
        t4.joinPath = function(t5, ...e3) {
          return t5.with({ path: w.join(t5.path, ...e3) });
        }, t4.resolvePath = function(t5, ...e3) {
          let r2 = t5.path, n2 = false;
          r2[0] !== x && (r2 = x + r2, n2 = true);
          let i2 = w.resolve(r2, ...e3);
          return n2 && i2[0] === x && !t5.authority && (i2 = i2.substring(1)), t5.with({ path: i2 });
        }, t4.dirname = function(t5) {
          if (0 === t5.path.length || t5.path === x)
            return t5;
          let e3 = w.dirname(t5.path);
          return 1 === e3.length && 46 === e3.charCodeAt(0) && (e3 = ""), t5.with({ path: e3 });
        }, t4.basename = function(t5) {
          return w.basename(t5.path);
        }, t4.extname = function(t5) {
          return w.extname(t5.path);
        };
      }(P || (P = {}));
    })(), LIB = n;
  })();
  var { URI: URI2, Utils } = LIB;

  // node_modules/vscode-css-languageservice/lib/esm/utils/resources.js
  function dirname(uriString) {
    return Utils.dirname(URI2.parse(uriString)).toString(true);
  }
  function joinPath(uriString, ...paths) {
    return Utils.joinPath(URI2.parse(uriString), ...paths).toString(true);
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/pathCompletion.js
  var PathCompletionParticipant = class {
    constructor(readDirectory) {
      this.readDirectory = readDirectory;
      this.literalCompletions = [];
      this.importCompletions = [];
    }
    onCssURILiteralValue(context) {
      this.literalCompletions.push(context);
    }
    onCssImportPath(context) {
      this.importCompletions.push(context);
    }
    async computeCompletions(document, documentContext) {
      const result = { items: [], isIncomplete: false };
      for (const literalCompletion of this.literalCompletions) {
        const uriValue = literalCompletion.uriValue;
        const fullValue = stripQuotes(uriValue);
        if (fullValue === "." || fullValue === "..") {
          result.isIncomplete = true;
        } else {
          const items = await this.providePathSuggestions(uriValue, literalCompletion.position, literalCompletion.range, document, documentContext);
          for (let item of items) {
            result.items.push(item);
          }
        }
      }
      for (const importCompletion of this.importCompletions) {
        const pathValue = importCompletion.pathValue;
        const fullValue = stripQuotes(pathValue);
        if (fullValue === "." || fullValue === "..") {
          result.isIncomplete = true;
        } else {
          let suggestions = await this.providePathSuggestions(pathValue, importCompletion.position, importCompletion.range, document, documentContext);
          if (document.languageId === "scss") {
            suggestions.forEach((s) => {
              if (startsWith(s.label, "_") && endsWith(s.label, ".scss")) {
                if (s.textEdit) {
                  s.textEdit.newText = s.label.slice(1, -5);
                } else {
                  s.label = s.label.slice(1, -5);
                }
              }
            });
          }
          for (let item of suggestions) {
            result.items.push(item);
          }
        }
      }
      return result;
    }
    async providePathSuggestions(pathValue, position, range, document, documentContext) {
      const fullValue = stripQuotes(pathValue);
      const isValueQuoted = startsWith(pathValue, `'`) || startsWith(pathValue, `"`);
      const valueBeforeCursor = isValueQuoted ? fullValue.slice(0, position.character - (range.start.character + 1)) : fullValue.slice(0, position.character - range.start.character);
      const currentDocUri = document.uri;
      const fullValueRange = isValueQuoted ? shiftRange(range, 1, -1) : range;
      const replaceRange = pathToReplaceRange(valueBeforeCursor, fullValue, fullValueRange);
      const valueBeforeLastSlash = valueBeforeCursor.substring(0, valueBeforeCursor.lastIndexOf("/") + 1);
      let parentDir = documentContext.resolveReference(valueBeforeLastSlash || ".", currentDocUri);
      if (parentDir) {
        try {
          const result = [];
          const infos = await this.readDirectory(parentDir);
          for (const [name, type] of infos) {
            if (name.charCodeAt(0) !== CharCode_dot && (type === FileType.Directory || joinPath(parentDir, name) !== currentDocUri)) {
              result.push(createCompletionItem(name, type === FileType.Directory, replaceRange));
            }
          }
          return result;
        } catch (e) {
        }
      }
      return [];
    }
  };
  var CharCode_dot = ".".charCodeAt(0);
  function stripQuotes(fullValue) {
    if (startsWith(fullValue, `'`) || startsWith(fullValue, `"`)) {
      return fullValue.slice(1, -1);
    } else {
      return fullValue;
    }
  }
  function pathToReplaceRange(valueBeforeCursor, fullValue, fullValueRange) {
    let replaceRange;
    const lastIndexOfSlash = valueBeforeCursor.lastIndexOf("/");
    if (lastIndexOfSlash === -1) {
      replaceRange = fullValueRange;
    } else {
      const valueAfterLastSlash = fullValue.slice(lastIndexOfSlash + 1);
      const startPos = shiftPosition(fullValueRange.end, -valueAfterLastSlash.length);
      const whitespaceIndex = valueAfterLastSlash.indexOf(" ");
      let endPos;
      if (whitespaceIndex !== -1) {
        endPos = shiftPosition(startPos, whitespaceIndex);
      } else {
        endPos = fullValueRange.end;
      }
      replaceRange = Range.create(startPos, endPos);
    }
    return replaceRange;
  }
  function createCompletionItem(name, isDir, replaceRange) {
    if (isDir) {
      name = name + "/";
      return {
        label: escapePath(name),
        kind: CompletionItemKind.Folder,
        textEdit: TextEdit.replace(replaceRange, escapePath(name)),
        command: {
          title: "Suggest",
          command: "editor.action.triggerSuggest"
        }
      };
    } else {
      return {
        label: escapePath(name),
        kind: CompletionItemKind.File,
        textEdit: TextEdit.replace(replaceRange, escapePath(name))
      };
    }
  }
  function escapePath(p) {
    return p.replace(/(\s|\(|\)|,|"|')/g, "\\$1");
  }
  function shiftPosition(pos, offset) {
    return Position.create(pos.line, pos.character + offset);
  }
  function shiftRange(range, startOffset, endOffset) {
    const start = shiftPosition(range.start, startOffset);
    const end = shiftPosition(range.end, endOffset);
    return Range.create(start, end);
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/cssCompletion.js
  var SnippetFormat = InsertTextFormat.Snippet;
  var retriggerCommand = {
    title: "Suggest",
    command: "editor.action.triggerSuggest"
  };
  var SortTexts;
  (function(SortTexts2) {
    SortTexts2["Enums"] = " ";
    SortTexts2["Normal"] = "d";
    SortTexts2["VendorPrefixed"] = "x";
    SortTexts2["Term"] = "y";
    SortTexts2["Variable"] = "z";
  })(SortTexts || (SortTexts = {}));
  var CSSCompletion = class {
    constructor(variablePrefix = null, lsOptions, cssDataManager) {
      this.variablePrefix = variablePrefix;
      this.lsOptions = lsOptions;
      this.cssDataManager = cssDataManager;
      this.completionParticipants = [];
    }
    configure(settings) {
      this.defaultSettings = settings;
    }
    getSymbolContext() {
      if (!this.symbolContext) {
        this.symbolContext = new Symbols(this.styleSheet);
      }
      return this.symbolContext;
    }
    setCompletionParticipants(registeredCompletionParticipants) {
      this.completionParticipants = registeredCompletionParticipants || [];
    }
    async doComplete2(document, position, styleSheet, documentContext, completionSettings = this.defaultSettings) {
      if (!this.lsOptions.fileSystemProvider || !this.lsOptions.fileSystemProvider.readDirectory) {
        return this.doComplete(document, position, styleSheet, completionSettings);
      }
      const participant = new PathCompletionParticipant(this.lsOptions.fileSystemProvider.readDirectory);
      const contributedParticipants = this.completionParticipants;
      this.completionParticipants = [participant].concat(contributedParticipants);
      const result = this.doComplete(document, position, styleSheet, completionSettings);
      try {
        const pathCompletionResult = await participant.computeCompletions(document, documentContext);
        return {
          isIncomplete: result.isIncomplete || pathCompletionResult.isIncomplete,
          itemDefaults: result.itemDefaults,
          items: pathCompletionResult.items.concat(result.items)
        };
      } finally {
        this.completionParticipants = contributedParticipants;
      }
    }
    doComplete(document, position, styleSheet, documentSettings) {
      this.offset = document.offsetAt(position);
      this.position = position;
      this.currentWord = getCurrentWord(document, this.offset);
      this.defaultReplaceRange = Range.create(Position.create(this.position.line, this.position.character - this.currentWord.length), this.position);
      this.textDocument = document;
      this.styleSheet = styleSheet;
      this.documentSettings = documentSettings;
      try {
        const result = {
          isIncomplete: false,
          itemDefaults: {
            editRange: {
              start: { line: position.line, character: position.character - this.currentWord.length },
              end: position
            }
          },
          items: []
        };
        this.nodePath = getNodePath(this.styleSheet, this.offset);
        for (let i = this.nodePath.length - 1; i >= 0; i--) {
          const node = this.nodePath[i];
          if (node instanceof Property) {
            this.getCompletionsForDeclarationProperty(node.getParent(), result);
          } else if (node instanceof Expression) {
            if (node.parent instanceof Interpolation) {
              this.getVariableProposals(null, result);
            } else {
              this.getCompletionsForExpression(node, result);
            }
          } else if (node instanceof SimpleSelector) {
            const parentRef = node.findAParent(NodeType.ExtendsReference, NodeType.Ruleset);
            if (parentRef) {
              if (parentRef.type === NodeType.ExtendsReference) {
                this.getCompletionsForExtendsReference(parentRef, node, result);
              } else {
                const parentRuleSet = parentRef;
                this.getCompletionsForSelector(parentRuleSet, parentRuleSet && parentRuleSet.isNested(), result);
              }
            }
          } else if (node instanceof FunctionArgument) {
            this.getCompletionsForFunctionArgument(node, node.getParent(), result);
          } else if (node instanceof Declarations) {
            this.getCompletionsForDeclarations(node, result);
          } else if (node instanceof VariableDeclaration) {
            this.getCompletionsForVariableDeclaration(node, result);
          } else if (node instanceof RuleSet) {
            this.getCompletionsForRuleSet(node, result);
          } else if (node instanceof Interpolation) {
            this.getCompletionsForInterpolation(node, result);
          } else if (node instanceof FunctionDeclaration) {
            this.getCompletionsForFunctionDeclaration(node, result);
          } else if (node instanceof MixinReference) {
            this.getCompletionsForMixinReference(node, result);
          } else if (node instanceof Function) {
            this.getCompletionsForFunctionArgument(null, node, result);
          } else if (node instanceof Supports) {
            this.getCompletionsForSupports(node, result);
          } else if (node instanceof SupportsCondition) {
            this.getCompletionsForSupportsCondition(node, result);
          } else if (node instanceof ExtendsReference) {
            this.getCompletionsForExtendsReference(node, null, result);
          } else if (node.type === NodeType.URILiteral) {
            this.getCompletionForUriLiteralValue(node, result);
          } else if (node.parent === null) {
            this.getCompletionForTopLevel(result);
          } else if (node.type === NodeType.StringLiteral && this.isImportPathParent(node.parent.type)) {
            this.getCompletionForImportPath(node, result);
          } else {
            continue;
          }
          if (result.items.length > 0 || this.offset > node.offset) {
            return this.finalize(result);
          }
        }
        this.getCompletionsForStylesheet(result);
        if (result.items.length === 0) {
          if (this.variablePrefix && this.currentWord.indexOf(this.variablePrefix) === 0) {
            this.getVariableProposals(null, result);
          }
        }
        return this.finalize(result);
      } finally {
        this.position = null;
        this.currentWord = null;
        this.textDocument = null;
        this.styleSheet = null;
        this.symbolContext = null;
        this.defaultReplaceRange = null;
        this.nodePath = null;
      }
    }
    isImportPathParent(type) {
      return type === NodeType.Import;
    }
    finalize(result) {
      return result;
    }
    findInNodePath(...types) {
      for (let i = this.nodePath.length - 1; i >= 0; i--) {
        const node = this.nodePath[i];
        if (types.indexOf(node.type) !== -1) {
          return node;
        }
      }
      return null;
    }
    getCompletionsForDeclarationProperty(declaration, result) {
      return this.getPropertyProposals(declaration, result);
    }
    getPropertyProposals(declaration, result) {
      const triggerPropertyValueCompletion = this.isTriggerPropertyValueCompletionEnabled;
      const completePropertyWithSemicolon = this.isCompletePropertyWithSemicolonEnabled;
      const properties = this.cssDataManager.getProperties();
      properties.forEach((entry) => {
        let range;
        let insertText;
        let retrigger = false;
        if (declaration) {
          range = this.getCompletionRange(declaration.getProperty());
          insertText = entry.name;
          if (!isDefined(declaration.colonPosition)) {
            insertText += ": ";
            retrigger = true;
          }
        } else {
          range = this.getCompletionRange(null);
          insertText = entry.name + ": ";
          retrigger = true;
        }
        if (!declaration && completePropertyWithSemicolon) {
          insertText += "$0;";
        }
        if (declaration && !declaration.semicolonPosition) {
          if (completePropertyWithSemicolon && this.offset >= this.textDocument.offsetAt(range.end)) {
            insertText += "$0;";
          }
        }
        const item = {
          label: entry.name,
          documentation: getEntryDescription(entry, this.doesSupportMarkdown()),
          tags: isDeprecated(entry) ? [CompletionItemTag.Deprecated] : [],
          textEdit: TextEdit.replace(range, insertText),
          insertTextFormat: InsertTextFormat.Snippet,
          kind: CompletionItemKind.Property
        };
        if (!entry.restrictions) {
          retrigger = false;
        }
        if (triggerPropertyValueCompletion && retrigger) {
          item.command = retriggerCommand;
        }
        const relevance = typeof entry.relevance === "number" ? Math.min(Math.max(entry.relevance, 0), 99) : 50;
        const sortTextSuffix = (255 - relevance).toString(16);
        const sortTextPrefix = startsWith(entry.name, "-") ? SortTexts.VendorPrefixed : SortTexts.Normal;
        item.sortText = sortTextPrefix + "_" + sortTextSuffix;
        result.items.push(item);
      });
      this.completionParticipants.forEach((participant) => {
        if (participant.onCssProperty) {
          participant.onCssProperty({
            propertyName: this.currentWord,
            range: this.defaultReplaceRange
          });
        }
      });
      return result;
    }
    get isTriggerPropertyValueCompletionEnabled() {
      return this.documentSettings?.triggerPropertyValueCompletion ?? true;
    }
    get isCompletePropertyWithSemicolonEnabled() {
      return this.documentSettings?.completePropertyWithSemicolon ?? true;
    }
    getCompletionsForDeclarationValue(node, result) {
      const propertyName = node.getFullPropertyName();
      const entry = this.cssDataManager.getProperty(propertyName);
      let existingNode = node.getValue() || null;
      while (existingNode && existingNode.hasChildren()) {
        existingNode = existingNode.findChildAtOffset(this.offset, false);
      }
      this.completionParticipants.forEach((participant) => {
        if (participant.onCssPropertyValue) {
          participant.onCssPropertyValue({
            propertyName,
            propertyValue: this.currentWord,
            range: this.getCompletionRange(existingNode)
          });
        }
      });
      if (entry) {
        if (entry.restrictions) {
          for (const restriction of entry.restrictions) {
            switch (restriction) {
              case "color":
                this.getColorProposals(entry, existingNode, result);
                break;
              case "position":
                this.getPositionProposals(entry, existingNode, result);
                break;
              case "repeat":
                this.getRepeatStyleProposals(entry, existingNode, result);
                break;
              case "line-style":
                this.getLineStyleProposals(entry, existingNode, result);
                break;
              case "line-width":
                this.getLineWidthProposals(entry, existingNode, result);
                break;
              case "geometry-box":
                this.getGeometryBoxProposals(entry, existingNode, result);
                break;
              case "box":
                this.getBoxProposals(entry, existingNode, result);
                break;
              case "image":
                this.getImageProposals(entry, existingNode, result);
                break;
              case "timing-function":
                this.getTimingFunctionProposals(entry, existingNode, result);
                break;
              case "shape":
                this.getBasicShapeProposals(entry, existingNode, result);
                break;
            }
          }
        }
        this.getValueEnumProposals(entry, existingNode, result);
        this.getCSSWideKeywordProposals(entry, existingNode, result);
        this.getUnitProposals(entry, existingNode, result);
      } else {
        const existingValues = collectValues(this.styleSheet, node);
        for (const existingValue of existingValues.getEntries()) {
          result.items.push({
            label: existingValue,
            textEdit: TextEdit.replace(this.getCompletionRange(existingNode), existingValue),
            kind: CompletionItemKind.Value
          });
        }
      }
      this.getVariableProposals(existingNode, result);
      this.getTermProposals(entry, existingNode, result);
      return result;
    }
    getValueEnumProposals(entry, existingNode, result) {
      if (entry.values) {
        for (const value of entry.values) {
          let insertString = value.name;
          let insertTextFormat;
          if (endsWith(insertString, ")")) {
            const from = insertString.lastIndexOf("(");
            if (from !== -1) {
              insertString = insertString.substring(0, from + 1) + "$1" + insertString.substring(from + 1);
              insertTextFormat = SnippetFormat;
            }
          }
          let sortText = SortTexts.Enums;
          if (startsWith(value.name, "-")) {
            sortText += SortTexts.VendorPrefixed;
          }
          const item = {
            label: value.name,
            documentation: getEntryDescription(value, this.doesSupportMarkdown()),
            tags: isDeprecated(entry) ? [CompletionItemTag.Deprecated] : [],
            textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertString),
            sortText,
            kind: CompletionItemKind.Value,
            insertTextFormat
          };
          result.items.push(item);
        }
      }
      return result;
    }
    getCSSWideKeywordProposals(entry, existingNode, result) {
      for (const keywords in cssWideKeywords) {
        result.items.push({
          label: keywords,
          documentation: cssWideKeywords[keywords],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), keywords),
          kind: CompletionItemKind.Value
        });
      }
      for (const func in cssWideFunctions) {
        const insertText = moveCursorInsideParenthesis(func);
        result.items.push({
          label: func,
          documentation: cssWideFunctions[func],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          kind: CompletionItemKind.Function,
          insertTextFormat: SnippetFormat,
          command: startsWith(func, "var") ? retriggerCommand : void 0
        });
      }
      return result;
    }
    getCompletionsForInterpolation(node, result) {
      if (this.offset >= node.offset + 2) {
        this.getVariableProposals(null, result);
      }
      return result;
    }
    getVariableProposals(existingNode, result) {
      const symbols = this.getSymbolContext().findSymbolsAtOffset(this.offset, ReferenceType.Variable);
      for (const symbol of symbols) {
        const insertText = startsWith(symbol.name, "--") ? `var(${symbol.name})` : symbol.name;
        const completionItem = {
          label: symbol.name,
          documentation: symbol.value ? getLimitedString(symbol.value) : symbol.value,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          kind: CompletionItemKind.Variable,
          sortText: SortTexts.Variable
        };
        if (typeof completionItem.documentation === "string" && isColorString(completionItem.documentation)) {
          completionItem.kind = CompletionItemKind.Color;
        }
        if (symbol.node.type === NodeType.FunctionParameter) {
          const mixinNode = symbol.node.getParent();
          if (mixinNode.type === NodeType.MixinDeclaration) {
            completionItem.detail = t("argument from '{0}'", mixinNode.getName());
          }
        }
        result.items.push(completionItem);
      }
      return result;
    }
    getVariableProposalsForCSSVarFunction(result) {
      const allReferencedVariables = new Set2();
      this.styleSheet.acceptVisitor(new VariableCollector(allReferencedVariables, this.offset));
      let symbols = this.getSymbolContext().findSymbolsAtOffset(this.offset, ReferenceType.Variable);
      for (const symbol of symbols) {
        if (startsWith(symbol.name, "--")) {
          const completionItem = {
            label: symbol.name,
            documentation: symbol.value ? getLimitedString(symbol.value) : symbol.value,
            textEdit: TextEdit.replace(this.getCompletionRange(null), symbol.name),
            kind: CompletionItemKind.Variable
          };
          if (typeof completionItem.documentation === "string" && isColorString(completionItem.documentation)) {
            completionItem.kind = CompletionItemKind.Color;
          }
          result.items.push(completionItem);
        }
        allReferencedVariables.remove(symbol.name);
      }
      for (const name of allReferencedVariables.getEntries()) {
        if (startsWith(name, "--")) {
          const completionItem = {
            label: name,
            textEdit: TextEdit.replace(this.getCompletionRange(null), name),
            kind: CompletionItemKind.Variable
          };
          result.items.push(completionItem);
        }
      }
      return result;
    }
    getUnitProposals(entry, existingNode, result) {
      let currentWord = "0";
      if (this.currentWord.length > 0) {
        const numMatch = this.currentWord.match(/^-?\d[\.\d+]*/);
        if (numMatch) {
          currentWord = numMatch[0];
          result.isIncomplete = currentWord.length === this.currentWord.length;
        }
      } else if (this.currentWord.length === 0) {
        result.isIncomplete = true;
      }
      if (existingNode && existingNode.parent && existingNode.parent.type === NodeType.Term) {
        existingNode = existingNode.getParent();
      }
      if (entry.restrictions) {
        for (const restriction of entry.restrictions) {
          const units2 = units[restriction];
          if (units2) {
            for (const unit of units2) {
              const insertText = currentWord + unit;
              result.items.push({
                label: insertText,
                textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
                kind: CompletionItemKind.Unit
              });
            }
          }
        }
      }
      return result;
    }
    getCompletionRange(existingNode) {
      if (existingNode && existingNode.offset <= this.offset && this.offset <= existingNode.end) {
        const end = existingNode.end !== -1 ? this.textDocument.positionAt(existingNode.end) : this.position;
        const start = this.textDocument.positionAt(existingNode.offset);
        if (start.line === end.line) {
          return Range.create(start, end);
        }
      }
      return this.defaultReplaceRange;
    }
    getColorProposals(entry, existingNode, result) {
      for (const color in colors) {
        result.items.push({
          label: color,
          documentation: colors[color],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), color),
          kind: CompletionItemKind.Color
        });
      }
      for (const color in colorKeywords) {
        result.items.push({
          label: color,
          documentation: colorKeywords[color],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), color),
          kind: CompletionItemKind.Value
        });
      }
      const colorValues = new Set2();
      this.styleSheet.acceptVisitor(new ColorValueCollector(colorValues, this.offset));
      for (const color of colorValues.getEntries()) {
        result.items.push({
          label: color,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), color),
          kind: CompletionItemKind.Color
        });
      }
      for (const p of colorFunctions) {
        result.items.push({
          label: p.label,
          detail: p.func,
          documentation: p.desc,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), p.insertText),
          insertTextFormat: SnippetFormat,
          kind: CompletionItemKind.Function
        });
      }
      return result;
    }
    getPositionProposals(entry, existingNode, result) {
      for (const position in positionKeywords) {
        result.items.push({
          label: position,
          documentation: positionKeywords[position],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), position),
          kind: CompletionItemKind.Value
        });
      }
      return result;
    }
    getRepeatStyleProposals(entry, existingNode, result) {
      for (const repeat2 in repeatStyleKeywords) {
        result.items.push({
          label: repeat2,
          documentation: repeatStyleKeywords[repeat2],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), repeat2),
          kind: CompletionItemKind.Value
        });
      }
      return result;
    }
    getLineStyleProposals(entry, existingNode, result) {
      for (const lineStyle in lineStyleKeywords) {
        result.items.push({
          label: lineStyle,
          documentation: lineStyleKeywords[lineStyle],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), lineStyle),
          kind: CompletionItemKind.Value
        });
      }
      return result;
    }
    getLineWidthProposals(entry, existingNode, result) {
      for (const lineWidth of lineWidthKeywords) {
        result.items.push({
          label: lineWidth,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), lineWidth),
          kind: CompletionItemKind.Value
        });
      }
      return result;
    }
    getGeometryBoxProposals(entry, existingNode, result) {
      for (const box in geometryBoxKeywords) {
        result.items.push({
          label: box,
          documentation: geometryBoxKeywords[box],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), box),
          kind: CompletionItemKind.Value
        });
      }
      return result;
    }
    getBoxProposals(entry, existingNode, result) {
      for (const box in boxKeywords) {
        result.items.push({
          label: box,
          documentation: boxKeywords[box],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), box),
          kind: CompletionItemKind.Value
        });
      }
      return result;
    }
    getImageProposals(entry, existingNode, result) {
      for (const image in imageFunctions) {
        const insertText = moveCursorInsideParenthesis(image);
        result.items.push({
          label: image,
          documentation: imageFunctions[image],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          kind: CompletionItemKind.Function,
          insertTextFormat: image !== insertText ? SnippetFormat : void 0
        });
      }
      return result;
    }
    getTimingFunctionProposals(entry, existingNode, result) {
      for (const timing in transitionTimingFunctions) {
        const insertText = moveCursorInsideParenthesis(timing);
        result.items.push({
          label: timing,
          documentation: transitionTimingFunctions[timing],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          kind: CompletionItemKind.Function,
          insertTextFormat: timing !== insertText ? SnippetFormat : void 0
        });
      }
      return result;
    }
    getBasicShapeProposals(entry, existingNode, result) {
      for (const shape in basicShapeFunctions) {
        const insertText = moveCursorInsideParenthesis(shape);
        result.items.push({
          label: shape,
          documentation: basicShapeFunctions[shape],
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          kind: CompletionItemKind.Function,
          insertTextFormat: shape !== insertText ? SnippetFormat : void 0
        });
      }
      return result;
    }
    getCompletionsForStylesheet(result) {
      const node = this.styleSheet.findFirstChildBeforeOffset(this.offset);
      if (!node) {
        return this.getCompletionForTopLevel(result);
      }
      if (node instanceof RuleSet) {
        return this.getCompletionsForRuleSet(node, result);
      }
      if (node instanceof Supports) {
        return this.getCompletionsForSupports(node, result);
      }
      return result;
    }
    getCompletionForTopLevel(result) {
      this.cssDataManager.getAtDirectives().forEach((entry) => {
        result.items.push({
          label: entry.name,
          textEdit: TextEdit.replace(this.getCompletionRange(null), entry.name),
          documentation: getEntryDescription(entry, this.doesSupportMarkdown()),
          tags: isDeprecated(entry) ? [CompletionItemTag.Deprecated] : [],
          kind: CompletionItemKind.Keyword
        });
      });
      this.getCompletionsForSelector(null, false, result);
      return result;
    }
    getCompletionsForRuleSet(ruleSet, result) {
      const declarations = ruleSet.getDeclarations();
      const isAfter = declarations && declarations.endsWith("}") && this.offset >= declarations.end;
      if (isAfter) {
        return this.getCompletionForTopLevel(result);
      }
      const isInSelectors = !declarations || this.offset <= declarations.offset;
      if (isInSelectors) {
        return this.getCompletionsForSelector(ruleSet, ruleSet.isNested(), result);
      }
      return this.getCompletionsForDeclarations(ruleSet.getDeclarations(), result);
    }
    getCompletionsForSelector(ruleSet, isNested, result) {
      const existingNode = this.findInNodePath(NodeType.PseudoSelector, NodeType.IdentifierSelector, NodeType.ClassSelector, NodeType.ElementNameSelector);
      if (!existingNode && this.hasCharacterAtPosition(this.offset - this.currentWord.length - 1, ":")) {
        this.currentWord = ":" + this.currentWord;
        if (this.hasCharacterAtPosition(this.offset - this.currentWord.length - 1, ":")) {
          this.currentWord = ":" + this.currentWord;
        }
        this.defaultReplaceRange = Range.create(Position.create(this.position.line, this.position.character - this.currentWord.length), this.position);
      }
      const pseudoClasses = this.cssDataManager.getPseudoClasses();
      pseudoClasses.forEach((entry) => {
        const insertText = moveCursorInsideParenthesis(entry.name);
        const item = {
          label: entry.name,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          documentation: getEntryDescription(entry, this.doesSupportMarkdown()),
          tags: isDeprecated(entry) ? [CompletionItemTag.Deprecated] : [],
          kind: CompletionItemKind.Function,
          insertTextFormat: entry.name !== insertText ? SnippetFormat : void 0
        };
        if (startsWith(entry.name, ":-")) {
          item.sortText = SortTexts.VendorPrefixed;
        }
        result.items.push(item);
      });
      const pseudoElements = this.cssDataManager.getPseudoElements();
      pseudoElements.forEach((entry) => {
        const insertText = moveCursorInsideParenthesis(entry.name);
        const item = {
          label: entry.name,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          documentation: getEntryDescription(entry, this.doesSupportMarkdown()),
          tags: isDeprecated(entry) ? [CompletionItemTag.Deprecated] : [],
          kind: CompletionItemKind.Function,
          insertTextFormat: entry.name !== insertText ? SnippetFormat : void 0
        };
        if (startsWith(entry.name, "::-")) {
          item.sortText = SortTexts.VendorPrefixed;
        }
        result.items.push(item);
      });
      if (!isNested) {
        for (const entry of html5Tags) {
          result.items.push({
            label: entry,
            textEdit: TextEdit.replace(this.getCompletionRange(existingNode), entry),
            kind: CompletionItemKind.Keyword
          });
        }
        for (const entry of svgElements) {
          result.items.push({
            label: entry,
            textEdit: TextEdit.replace(this.getCompletionRange(existingNode), entry),
            kind: CompletionItemKind.Keyword
          });
        }
      }
      const visited = {};
      visited[this.currentWord] = true;
      const docText = this.textDocument.getText();
      this.styleSheet.accept((n) => {
        if (n.type === NodeType.SimpleSelector && n.length > 0) {
          const selector = docText.substr(n.offset, n.length);
          if (selector.charAt(0) === "." && !visited[selector]) {
            visited[selector] = true;
            result.items.push({
              label: selector,
              textEdit: TextEdit.replace(this.getCompletionRange(existingNode), selector),
              kind: CompletionItemKind.Keyword
            });
          }
          return false;
        }
        return true;
      });
      if (ruleSet && ruleSet.isNested()) {
        const selector = ruleSet.getSelectors().findFirstChildBeforeOffset(this.offset);
        if (selector && ruleSet.getSelectors().getChildren().indexOf(selector) === 0) {
          this.getPropertyProposals(null, result);
        }
      }
      return result;
    }
    getCompletionsForDeclarations(declarations, result) {
      if (!declarations || this.offset === declarations.offset) {
        return result;
      }
      const node = declarations.findFirstChildBeforeOffset(this.offset);
      if (!node) {
        return this.getCompletionsForDeclarationProperty(null, result);
      }
      if (node instanceof AbstractDeclaration) {
        const declaration = node;
        if (!isDefined(declaration.colonPosition) || this.offset <= declaration.colonPosition) {
          return this.getCompletionsForDeclarationProperty(declaration, result);
        } else if (isDefined(declaration.semicolonPosition) && declaration.semicolonPosition < this.offset) {
          if (this.offset === declaration.semicolonPosition + 1) {
            return result;
          }
          return this.getCompletionsForDeclarationProperty(null, result);
        }
        if (declaration instanceof Declaration) {
          return this.getCompletionsForDeclarationValue(declaration, result);
        }
      } else if (node instanceof ExtendsReference) {
        this.getCompletionsForExtendsReference(node, null, result);
      } else if (this.currentWord && this.currentWord[0] === "@") {
        this.getCompletionsForDeclarationProperty(null, result);
      } else if (node instanceof RuleSet) {
        this.getCompletionsForDeclarationProperty(null, result);
      }
      return result;
    }
    getCompletionsForVariableDeclaration(declaration, result) {
      if (this.offset && isDefined(declaration.colonPosition) && this.offset > declaration.colonPosition) {
        this.getVariableProposals(declaration.getValue() || null, result);
      }
      return result;
    }
    getCompletionsForExpression(expression, result) {
      const parent = expression.getParent();
      if (parent instanceof FunctionArgument) {
        this.getCompletionsForFunctionArgument(parent, parent.getParent(), result);
        return result;
      }
      const declaration = expression.findParent(NodeType.Declaration);
      if (!declaration) {
        this.getTermProposals(void 0, null, result);
        return result;
      }
      const node = expression.findChildAtOffset(this.offset, true);
      if (!node) {
        return this.getCompletionsForDeclarationValue(declaration, result);
      }
      if (node instanceof NumericValue || node instanceof Identifier) {
        return this.getCompletionsForDeclarationValue(declaration, result);
      }
      return result;
    }
    getCompletionsForFunctionArgument(arg, func, result) {
      const identifier = func.getIdentifier();
      if (identifier && identifier.matches("var")) {
        if (!func.getArguments().hasChildren() || func.getArguments().getChild(0) === arg) {
          this.getVariableProposalsForCSSVarFunction(result);
        }
      }
      return result;
    }
    getCompletionsForFunctionDeclaration(decl, result) {
      const declarations = decl.getDeclarations();
      if (declarations && this.offset > declarations.offset && this.offset < declarations.end) {
        this.getTermProposals(void 0, null, result);
      }
      return result;
    }
    getCompletionsForMixinReference(ref, result) {
      const allMixins = this.getSymbolContext().findSymbolsAtOffset(this.offset, ReferenceType.Mixin);
      for (const mixinSymbol of allMixins) {
        if (mixinSymbol.node instanceof MixinDeclaration) {
          result.items.push(this.makeTermProposal(mixinSymbol, mixinSymbol.node.getParameters(), null));
        }
      }
      const identifierNode = ref.getIdentifier() || null;
      this.completionParticipants.forEach((participant) => {
        if (participant.onCssMixinReference) {
          participant.onCssMixinReference({
            mixinName: this.currentWord,
            range: this.getCompletionRange(identifierNode)
          });
        }
      });
      return result;
    }
    getTermProposals(entry, existingNode, result) {
      const allFunctions = this.getSymbolContext().findSymbolsAtOffset(this.offset, ReferenceType.Function);
      for (const functionSymbol of allFunctions) {
        if (functionSymbol.node instanceof FunctionDeclaration) {
          result.items.push(this.makeTermProposal(functionSymbol, functionSymbol.node.getParameters(), existingNode));
        }
      }
      return result;
    }
    makeTermProposal(symbol, parameters, existingNode) {
      const decl = symbol.node;
      const params = parameters.getChildren().map((c) => {
        return c instanceof FunctionParameter ? c.getName() : c.getText();
      });
      const insertText = symbol.name + "(" + params.map((p, index) => "${" + (index + 1) + ":" + p + "}").join(", ") + ")";
      return {
        label: symbol.name,
        detail: symbol.name + "(" + params.join(", ") + ")",
        textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
        insertTextFormat: SnippetFormat,
        kind: CompletionItemKind.Function,
        sortText: SortTexts.Term
      };
    }
    getCompletionsForSupportsCondition(supportsCondition, result) {
      const child = supportsCondition.findFirstChildBeforeOffset(this.offset);
      if (child) {
        if (child instanceof Declaration) {
          if (!isDefined(child.colonPosition) || this.offset <= child.colonPosition) {
            return this.getCompletionsForDeclarationProperty(child, result);
          } else {
            return this.getCompletionsForDeclarationValue(child, result);
          }
        } else if (child instanceof SupportsCondition) {
          return this.getCompletionsForSupportsCondition(child, result);
        }
      }
      if (isDefined(supportsCondition.lParent) && this.offset > supportsCondition.lParent && (!isDefined(supportsCondition.rParent) || this.offset <= supportsCondition.rParent)) {
        return this.getCompletionsForDeclarationProperty(null, result);
      }
      return result;
    }
    getCompletionsForSupports(supports, result) {
      const declarations = supports.getDeclarations();
      const inInCondition = !declarations || this.offset <= declarations.offset;
      if (inInCondition) {
        const child = supports.findFirstChildBeforeOffset(this.offset);
        if (child instanceof SupportsCondition) {
          return this.getCompletionsForSupportsCondition(child, result);
        }
        return result;
      }
      return this.getCompletionForTopLevel(result);
    }
    getCompletionsForExtendsReference(extendsRef, existingNode, result) {
      return result;
    }
    getCompletionForUriLiteralValue(uriLiteralNode, result) {
      let uriValue;
      let position;
      let range;
      if (!uriLiteralNode.hasChildren()) {
        uriValue = "";
        position = this.position;
        const emptyURIValuePosition = this.textDocument.positionAt(uriLiteralNode.offset + "url(".length);
        range = Range.create(emptyURIValuePosition, emptyURIValuePosition);
      } else {
        const uriValueNode = uriLiteralNode.getChild(0);
        uriValue = uriValueNode.getText();
        position = this.position;
        range = this.getCompletionRange(uriValueNode);
      }
      this.completionParticipants.forEach((participant) => {
        if (participant.onCssURILiteralValue) {
          participant.onCssURILiteralValue({
            uriValue,
            position,
            range
          });
        }
      });
      return result;
    }
    getCompletionForImportPath(importPathNode, result) {
      this.completionParticipants.forEach((participant) => {
        if (participant.onCssImportPath) {
          participant.onCssImportPath({
            pathValue: importPathNode.getText(),
            position: this.position,
            range: this.getCompletionRange(importPathNode)
          });
        }
      });
      return result;
    }
    hasCharacterAtPosition(offset, char) {
      const text = this.textDocument.getText();
      return offset >= 0 && offset < text.length && text.charAt(offset) === char;
    }
    doesSupportMarkdown() {
      if (!isDefined(this.supportsMarkdown)) {
        if (!isDefined(this.lsOptions.clientCapabilities)) {
          this.supportsMarkdown = true;
          return this.supportsMarkdown;
        }
        const documentationFormat = this.lsOptions.clientCapabilities.textDocument?.completion?.completionItem?.documentationFormat;
        this.supportsMarkdown = Array.isArray(documentationFormat) && documentationFormat.indexOf(MarkupKind.Markdown) !== -1;
      }
      return this.supportsMarkdown;
    }
  };
  function isDeprecated(entry) {
    if (entry.status && (entry.status === "nonstandard" || entry.status === "obsolete")) {
      return true;
    }
    return false;
  }
  var Set2 = class {
    constructor() {
      this.entries = {};
    }
    add(entry) {
      this.entries[entry] = true;
    }
    remove(entry) {
      delete this.entries[entry];
    }
    getEntries() {
      return Object.keys(this.entries);
    }
  };
  function moveCursorInsideParenthesis(text) {
    return text.replace(/\(\)$/, "($1)");
  }
  function collectValues(styleSheet, declaration) {
    const fullPropertyName = declaration.getFullPropertyName();
    const entries = new Set2();
    function visitValue(node) {
      if (node instanceof Identifier || node instanceof NumericValue || node instanceof HexColorValue) {
        entries.add(node.getText());
      }
      return true;
    }
    function matchesProperty(decl) {
      const propertyName = decl.getFullPropertyName();
      return fullPropertyName === propertyName;
    }
    function vistNode(node) {
      if (node instanceof Declaration && node !== declaration) {
        if (matchesProperty(node)) {
          const value = node.getValue();
          if (value) {
            value.accept(visitValue);
          }
        }
      }
      return true;
    }
    styleSheet.accept(vistNode);
    return entries;
  }
  var ColorValueCollector = class {
    constructor(entries, currentOffset) {
      this.entries = entries;
      this.currentOffset = currentOffset;
    }
    visitNode(node) {
      if (node instanceof HexColorValue || node instanceof Function && isColorConstructor(node)) {
        if (this.currentOffset < node.offset || node.end < this.currentOffset) {
          this.entries.add(node.getText());
        }
      }
      return true;
    }
  };
  var VariableCollector = class {
    constructor(entries, currentOffset) {
      this.entries = entries;
      this.currentOffset = currentOffset;
    }
    visitNode(node) {
      if (node instanceof Identifier && node.isCustomProperty) {
        if (this.currentOffset < node.offset || node.end < this.currentOffset) {
          this.entries.add(node.getText());
        }
      }
      return true;
    }
  };
  function getCurrentWord(document, offset) {
    let i = offset - 1;
    const text = document.getText();
    while (i >= 0 && ' 	\n\r":{[()]},*>+'.indexOf(text.charAt(i)) === -1) {
      i--;
    }
    return text.substring(i + 1, offset);
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/selectorPrinting.js
  var Element = class _Element {
    constructor() {
      this.parent = null;
      this.children = null;
      this.attributes = null;
    }
    findAttribute(name) {
      if (this.attributes) {
        for (const attribute of this.attributes) {
          if (attribute.name === name) {
            return attribute.value;
          }
        }
      }
      return null;
    }
    addChild(child) {
      if (child instanceof _Element) {
        child.parent = this;
      }
      if (!this.children) {
        this.children = [];
      }
      this.children.push(child);
    }
    append(text) {
      if (this.attributes) {
        const last = this.attributes[this.attributes.length - 1];
        last.value = last.value + text;
      }
    }
    prepend(text) {
      if (this.attributes) {
        const first = this.attributes[0];
        first.value = text + first.value;
      }
    }
    findRoot() {
      let curr = this;
      while (curr.parent && !(curr.parent instanceof RootElement)) {
        curr = curr.parent;
      }
      return curr;
    }
    removeChild(child) {
      if (this.children) {
        const index = this.children.indexOf(child);
        if (index !== -1) {
          this.children.splice(index, 1);
          return true;
        }
      }
      return false;
    }
    addAttr(name, value) {
      if (!this.attributes) {
        this.attributes = [];
      }
      for (const attribute of this.attributes) {
        if (attribute.name === name) {
          attribute.value += " " + value;
          return;
        }
      }
      this.attributes.push({ name, value });
    }
    clone(cloneChildren = true) {
      const elem = new _Element();
      if (this.attributes) {
        elem.attributes = [];
        for (const attribute of this.attributes) {
          elem.addAttr(attribute.name, attribute.value);
        }
      }
      if (cloneChildren && this.children) {
        elem.children = [];
        for (let index = 0; index < this.children.length; index++) {
          elem.addChild(this.children[index].clone());
        }
      }
      return elem;
    }
    cloneWithParent() {
      const clone = this.clone(false);
      if (this.parent && !(this.parent instanceof RootElement)) {
        const parentClone = this.parent.cloneWithParent();
        parentClone.addChild(clone);
      }
      return clone;
    }
  };
  var RootElement = class extends Element {
  };
  var LabelElement = class extends Element {
    constructor(label) {
      super();
      this.addAttr("name", label);
    }
  };
  var MarkedStringPrinter = class {
    constructor(quote) {
      this.quote = quote;
      this.result = [];
    }
    print(element, flagOpts) {
      this.result = [];
      if (element instanceof RootElement) {
        if (element.children) {
          this.doPrint(element.children, 0);
        }
      } else {
        this.doPrint([element], 0);
      }
      let value;
      if (flagOpts) {
        value = `${flagOpts.text}
 \u2026 ` + this.result.join("\n");
      } else {
        value = this.result.join("\n");
      }
      return [{ language: "html", value }];
    }
    doPrint(elements, indent) {
      for (const element of elements) {
        this.doPrintElement(element, indent);
        if (element.children) {
          this.doPrint(element.children, indent + 1);
        }
      }
    }
    writeLine(level, content) {
      const indent = new Array(level + 1).join("  ");
      this.result.push(indent + content);
    }
    doPrintElement(element, indent) {
      const name = element.findAttribute("name");
      if (element instanceof LabelElement || name === "\u2026") {
        this.writeLine(indent, name);
        return;
      }
      const content = ["<"];
      if (name) {
        content.push(name);
      } else {
        content.push("element");
      }
      if (element.attributes) {
        for (const attr of element.attributes) {
          if (attr.name !== "name") {
            content.push(" ");
            content.push(attr.name);
            const value = attr.value;
            if (value) {
              content.push("=");
              content.push(quotes.ensure(value, this.quote));
            }
          }
        }
      }
      content.push(">");
      this.writeLine(indent, content.join(""));
    }
  };
  var quotes;
  (function(quotes2) {
    function ensure(value, which) {
      return which + remove(value) + which;
    }
    quotes2.ensure = ensure;
    function remove(value) {
      const match = value.match(/^['"](.*)["']$/);
      if (match) {
        return match[1];
      }
      return value;
    }
    quotes2.remove = remove;
  })(quotes || (quotes = {}));
  var Specificity = class {
    constructor() {
      this.id = 0;
      this.attr = 0;
      this.tag = 0;
    }
  };
  function toElement(node, parentElement) {
    let result = new Element();
    for (const child of node.getChildren()) {
      switch (child.type) {
        case NodeType.SelectorCombinator:
          if (parentElement) {
            const segments = child.getText().split("&");
            if (segments.length === 1) {
              result.addAttr("name", segments[0]);
              break;
            }
            result = parentElement.cloneWithParent();
            if (segments[0]) {
              const root = result.findRoot();
              root.prepend(segments[0]);
            }
            for (let i = 1; i < segments.length; i++) {
              if (i > 1) {
                const clone = parentElement.cloneWithParent();
                result.addChild(clone.findRoot());
                result = clone;
              }
              result.append(segments[i]);
            }
          }
          break;
        case NodeType.SelectorPlaceholder:
          if (child.matches("@at-root")) {
            return result;
          }
        case NodeType.ElementNameSelector:
          const text = child.getText();
          result.addAttr("name", text === "*" ? "element" : unescape(text));
          break;
        case NodeType.ClassSelector:
          result.addAttr("class", unescape(child.getText().substring(1)));
          break;
        case NodeType.IdentifierSelector:
          result.addAttr("id", unescape(child.getText().substring(1)));
          break;
        case NodeType.MixinDeclaration:
          result.addAttr("class", child.getName());
          break;
        case NodeType.PseudoSelector:
          result.addAttr(unescape(child.getText()), "");
          break;
        case NodeType.AttributeSelector:
          const selector = child;
          const identifier = selector.getIdentifier();
          if (identifier) {
            const expression = selector.getValue();
            const operator = selector.getOperator();
            let value;
            if (expression && operator) {
              switch (unescape(operator.getText())) {
                case "|=":
                  value = `${quotes.remove(unescape(expression.getText()))}-\u2026`;
                  break;
                case "^=":
                  value = `${quotes.remove(unescape(expression.getText()))}\u2026`;
                  break;
                case "$=":
                  value = `\u2026${quotes.remove(unescape(expression.getText()))}`;
                  break;
                case "~=":
                  value = ` \u2026 ${quotes.remove(unescape(expression.getText()))} \u2026 `;
                  break;
                case "*=":
                  value = `\u2026${quotes.remove(unescape(expression.getText()))}\u2026`;
                  break;
                default:
                  value = quotes.remove(unescape(expression.getText()));
                  break;
              }
            }
            result.addAttr(unescape(identifier.getText()), value);
          }
          break;
      }
    }
    return result;
  }
  function unescape(content) {
    const scanner = new Scanner();
    scanner.setSource(content);
    const token = scanner.scanUnquotedString();
    if (token) {
      return token.text;
    }
    return content;
  }
  var SelectorPrinting = class {
    constructor(cssDataManager) {
      this.cssDataManager = cssDataManager;
    }
    selectorToMarkedString(node, flagOpts) {
      const root = selectorToElement(node);
      if (root) {
        const markedStrings = new MarkedStringPrinter('"').print(root, flagOpts);
        markedStrings.push(this.selectorToSpecificityMarkedString(node));
        return markedStrings;
      } else {
        return [];
      }
    }
    simpleSelectorToMarkedString(node) {
      const element = toElement(node);
      const markedStrings = new MarkedStringPrinter('"').print(element);
      markedStrings.push(this.selectorToSpecificityMarkedString(node));
      return markedStrings;
    }
    isPseudoElementIdentifier(text) {
      const match = text.match(/^::?([\w-]+)/);
      if (!match) {
        return false;
      }
      return !!this.cssDataManager.getPseudoElement("::" + match[1]);
    }
    selectorToSpecificityMarkedString(node) {
      const calculateMostSpecificListItem = (childElements) => {
        const specificity2 = new Specificity();
        let mostSpecificListItem = new Specificity();
        for (const containerElement of childElements) {
          for (const childElement of containerElement.getChildren()) {
            const itemSpecificity = calculateScore(childElement);
            if (itemSpecificity.id > mostSpecificListItem.id) {
              mostSpecificListItem = itemSpecificity;
              continue;
            } else if (itemSpecificity.id < mostSpecificListItem.id) {
              continue;
            }
            if (itemSpecificity.attr > mostSpecificListItem.attr) {
              mostSpecificListItem = itemSpecificity;
              continue;
            } else if (itemSpecificity.attr < mostSpecificListItem.attr) {
              continue;
            }
            if (itemSpecificity.tag > mostSpecificListItem.tag) {
              mostSpecificListItem = itemSpecificity;
              continue;
            }
          }
        }
        specificity2.id += mostSpecificListItem.id;
        specificity2.attr += mostSpecificListItem.attr;
        specificity2.tag += mostSpecificListItem.tag;
        return specificity2;
      };
      const calculateScore = (node2) => {
        const specificity2 = new Specificity();
        elementLoop:
          for (const element of node2.getChildren()) {
            switch (element.type) {
              case NodeType.IdentifierSelector:
                specificity2.id++;
                break;
              case NodeType.ClassSelector:
              case NodeType.AttributeSelector:
                specificity2.attr++;
                break;
              case NodeType.ElementNameSelector:
                if (element.matches("*")) {
                  break;
                }
                specificity2.tag++;
                break;
              case NodeType.PseudoSelector:
                const text = element.getText();
                const childElements = element.getChildren();
                if (this.isPseudoElementIdentifier(text)) {
                  if (text.match(/^::slotted/i) && childElements.length > 0) {
                    specificity2.tag++;
                    let mostSpecificListItem = calculateMostSpecificListItem(childElements);
                    specificity2.id += mostSpecificListItem.id;
                    specificity2.attr += mostSpecificListItem.attr;
                    specificity2.tag += mostSpecificListItem.tag;
                    continue elementLoop;
                  }
                  specificity2.tag++;
                  continue elementLoop;
                }
                if (text.match(/^:where/i)) {
                  continue elementLoop;
                }
                if (text.match(/^:(?:not|has|is)/i) && childElements.length > 0) {
                  let mostSpecificListItem = calculateMostSpecificListItem(childElements);
                  specificity2.id += mostSpecificListItem.id;
                  specificity2.attr += mostSpecificListItem.attr;
                  specificity2.tag += mostSpecificListItem.tag;
                  continue elementLoop;
                }
                if (text.match(/^:(?:host|host-context)/i) && childElements.length > 0) {
                  specificity2.attr++;
                  let mostSpecificListItem = calculateMostSpecificListItem(childElements);
                  specificity2.id += mostSpecificListItem.id;
                  specificity2.attr += mostSpecificListItem.attr;
                  specificity2.tag += mostSpecificListItem.tag;
                  continue elementLoop;
                }
                if (text.match(/^:(?:nth-child|nth-last-child)/i) && childElements.length > 0) {
                  specificity2.attr++;
                  if (childElements.length === 3 && childElements[1].type === 23) {
                    let mostSpecificListItem = calculateMostSpecificListItem(childElements[2].getChildren());
                    specificity2.id += mostSpecificListItem.id;
                    specificity2.attr += mostSpecificListItem.attr;
                    specificity2.tag += mostSpecificListItem.tag;
                    continue elementLoop;
                  }
                  const parser = new Parser();
                  const pseudoSelectorText = childElements[1].getText();
                  parser.scanner.setSource(pseudoSelectorText);
                  const firstToken = parser.scanner.scan();
                  const secondToken = parser.scanner.scan();
                  if (firstToken.text === "n" || firstToken.text === "-n" && secondToken.text === "of") {
                    const complexSelectorListNodes = [];
                    const complexSelectorText = pseudoSelectorText.slice(secondToken.offset + 2);
                    const complexSelectorArray = complexSelectorText.split(",");
                    for (const selector of complexSelectorArray) {
                      const node3 = parser.internalParse(selector, parser._parseSelector);
                      if (node3) {
                        complexSelectorListNodes.push(node3);
                      }
                    }
                    let mostSpecificListItem = calculateMostSpecificListItem(complexSelectorListNodes);
                    specificity2.id += mostSpecificListItem.id;
                    specificity2.attr += mostSpecificListItem.attr;
                    specificity2.tag += mostSpecificListItem.tag;
                    continue elementLoop;
                  }
                  continue elementLoop;
                }
                specificity2.attr++;
                continue elementLoop;
            }
            if (element.getChildren().length > 0) {
              const itemSpecificity = calculateScore(element);
              specificity2.id += itemSpecificity.id;
              specificity2.attr += itemSpecificity.attr;
              specificity2.tag += itemSpecificity.tag;
            }
          }
        return specificity2;
      };
      const specificity = calculateScore(node);
      return `[${t("Selector Specificity")}](https://developer.mozilla.org/docs/Web/CSS/Specificity): (${specificity.id}, ${specificity.attr}, ${specificity.tag})`;
    }
  };
  var SelectorElementBuilder = class {
    constructor(element) {
      this.prev = null;
      this.element = element;
    }
    processSelector(selector) {
      let parentElement = null;
      if (!(this.element instanceof RootElement)) {
        if (selector.getChildren().some((c) => c.hasChildren() && c.getChild(0).type === NodeType.SelectorCombinator)) {
          const curr = this.element.findRoot();
          if (curr.parent instanceof RootElement) {
            parentElement = this.element;
            this.element = curr.parent;
            this.element.removeChild(curr);
            this.prev = null;
          }
        }
      }
      for (const selectorChild of selector.getChildren()) {
        if (selectorChild instanceof SimpleSelector) {
          if (this.prev instanceof SimpleSelector) {
            const labelElement = new LabelElement("\u2026");
            this.element.addChild(labelElement);
            this.element = labelElement;
          } else if (this.prev && (this.prev.matches("+") || this.prev.matches("~")) && this.element.parent) {
            this.element = this.element.parent;
          }
          if (this.prev && this.prev.matches("~")) {
            this.element.addChild(new LabelElement("\u22EE"));
          }
          const thisElement = toElement(selectorChild, parentElement);
          const root = thisElement.findRoot();
          this.element.addChild(root);
          this.element = thisElement;
        }
        if (selectorChild instanceof SimpleSelector || selectorChild.type === NodeType.SelectorCombinatorParent || selectorChild.type === NodeType.SelectorCombinatorShadowPiercingDescendant || selectorChild.type === NodeType.SelectorCombinatorSibling || selectorChild.type === NodeType.SelectorCombinatorAllSiblings) {
          this.prev = selectorChild;
        }
      }
    }
  };
  function isNewSelectorContext(node) {
    switch (node.type) {
      case NodeType.MixinDeclaration:
      case NodeType.Stylesheet:
        return true;
    }
    return false;
  }
  function selectorToElement(node) {
    if (node.matches("@at-root")) {
      return null;
    }
    const root = new RootElement();
    const parentRuleSets = [];
    const ruleSet = node.getParent();
    if (ruleSet instanceof RuleSet) {
      let parent = ruleSet.getParent();
      while (parent && !isNewSelectorContext(parent)) {
        if (parent instanceof RuleSet) {
          if (parent.getSelectors().matches("@at-root")) {
            break;
          }
          parentRuleSets.push(parent);
        }
        parent = parent.getParent();
      }
    }
    const builder = new SelectorElementBuilder(root);
    for (let i = parentRuleSets.length - 1; i >= 0; i--) {
      const selector = parentRuleSets[i].getSelectors().getChild(0);
      if (selector) {
        builder.processSelector(selector);
      }
    }
    builder.processSelector(node);
    return root;
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/cssHover.js
  var CSSHover = class {
    constructor(clientCapabilities, cssDataManager) {
      this.clientCapabilities = clientCapabilities;
      this.cssDataManager = cssDataManager;
      this.selectorPrinting = new SelectorPrinting(cssDataManager);
    }
    configure(settings) {
      this.defaultSettings = settings;
    }
    doHover(document, position, stylesheet, settings = this.defaultSettings) {
      function getRange2(node) {
        return Range.create(document.positionAt(node.offset), document.positionAt(node.end));
      }
      const offset = document.offsetAt(position);
      const nodepath = getNodePath(stylesheet, offset);
      let hover = null;
      let flagOpts;
      for (let i = 0; i < nodepath.length; i++) {
        const node = nodepath[i];
        if (node instanceof Media) {
          const regex = /@media[^\{]+/g;
          const matches2 = node.getText().match(regex);
          flagOpts = {
            isMedia: true,
            text: matches2?.[0]
          };
        }
        if (node instanceof Selector) {
          hover = {
            contents: this.selectorPrinting.selectorToMarkedString(node, flagOpts),
            range: getRange2(node)
          };
          break;
        }
        if (node instanceof SimpleSelector) {
          if (!startsWith(node.getText(), "@")) {
            hover = {
              contents: this.selectorPrinting.simpleSelectorToMarkedString(node),
              range: getRange2(node)
            };
          }
          break;
        }
        if (node instanceof Declaration) {
          const propertyName = node.getFullPropertyName();
          const entry = this.cssDataManager.getProperty(propertyName);
          if (entry) {
            const contents = getEntryDescription(entry, this.doesSupportMarkdown(), settings);
            if (contents) {
              hover = {
                contents,
                range: getRange2(node)
              };
            } else {
              hover = null;
            }
          }
          continue;
        }
        if (node instanceof UnknownAtRule) {
          const atRuleName = node.getText();
          const entry = this.cssDataManager.getAtDirective(atRuleName);
          if (entry) {
            const contents = getEntryDescription(entry, this.doesSupportMarkdown(), settings);
            if (contents) {
              hover = {
                contents,
                range: getRange2(node)
              };
            } else {
              hover = null;
            }
          }
          continue;
        }
        if (node instanceof Node && node.type === NodeType.PseudoSelector) {
          const selectorName = node.getText();
          const entry = selectorName.slice(0, 2) === "::" ? this.cssDataManager.getPseudoElement(selectorName) : this.cssDataManager.getPseudoClass(selectorName);
          if (entry) {
            const contents = getEntryDescription(entry, this.doesSupportMarkdown(), settings);
            if (contents) {
              hover = {
                contents,
                range: getRange2(node)
              };
            } else {
              hover = null;
            }
          }
          continue;
        }
      }
      if (hover) {
        hover.contents = this.convertContents(hover.contents);
      }
      return hover;
    }
    convertContents(contents) {
      if (!this.doesSupportMarkdown()) {
        if (typeof contents === "string") {
          return contents;
        } else if ("kind" in contents) {
          return {
            kind: "plaintext",
            value: contents.value
          };
        } else if (Array.isArray(contents)) {
          return contents.map((c) => {
            return typeof c === "string" ? c : c.value;
          });
        } else {
          return contents.value;
        }
      }
      return contents;
    }
    doesSupportMarkdown() {
      if (!isDefined(this.supportsMarkdown)) {
        if (!isDefined(this.clientCapabilities)) {
          this.supportsMarkdown = true;
          return this.supportsMarkdown;
        }
        const hover = this.clientCapabilities.textDocument && this.clientCapabilities.textDocument.hover;
        this.supportsMarkdown = hover && hover.contentFormat && Array.isArray(hover.contentFormat) && hover.contentFormat.indexOf(MarkupKind.Markdown) !== -1;
      }
      return this.supportsMarkdown;
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/services/cssNavigation.js
  var startsWithSchemeRegex = /^\w+:\/\//;
  var startsWithData = /^data:/;
  var CSSNavigation = class {
    constructor(fileSystemProvider, resolveModuleReferences) {
      this.fileSystemProvider = fileSystemProvider;
      this.resolveModuleReferences = resolveModuleReferences;
    }
    configure(settings) {
      this.defaultSettings = settings;
    }
    findDefinition(document, position, stylesheet) {
      const symbols = new Symbols(stylesheet);
      const offset = document.offsetAt(position);
      const node = getNodeAtOffset(stylesheet, offset);
      if (!node) {
        return null;
      }
      const symbol = symbols.findSymbolFromNode(node);
      if (!symbol) {
        return null;
      }
      return {
        uri: document.uri,
        range: getRange(symbol.node, document)
      };
    }
    findReferences(document, position, stylesheet) {
      const highlights = this.findDocumentHighlights(document, position, stylesheet);
      return highlights.map((h) => {
        return {
          uri: document.uri,
          range: h.range
        };
      });
    }
    getHighlightNode(document, position, stylesheet) {
      const offset = document.offsetAt(position);
      let node = getNodeAtOffset(stylesheet, offset);
      if (!node || node.type === NodeType.Stylesheet || node.type === NodeType.Declarations) {
        return;
      }
      if (node.type === NodeType.Identifier && node.parent && node.parent.type === NodeType.ClassSelector) {
        node = node.parent;
      }
      return node;
    }
    findDocumentHighlights(document, position, stylesheet) {
      const result = [];
      const node = this.getHighlightNode(document, position, stylesheet);
      if (!node) {
        return result;
      }
      const symbols = new Symbols(stylesheet);
      const symbol = symbols.findSymbolFromNode(node);
      const name = node.getText();
      stylesheet.accept((candidate) => {
        if (symbol) {
          if (symbols.matchesSymbol(candidate, symbol)) {
            result.push({
              kind: getHighlightKind(candidate),
              range: getRange(candidate, document)
            });
            return false;
          }
        } else if (node && node.type === candidate.type && candidate.matches(name)) {
          result.push({
            kind: getHighlightKind(candidate),
            range: getRange(candidate, document)
          });
        }
        return true;
      });
      return result;
    }
    isRawStringDocumentLinkNode(node) {
      return node.type === NodeType.Import;
    }
    findDocumentLinks(document, stylesheet, documentContext) {
      const linkData = this.findUnresolvedLinks(document, stylesheet);
      const resolvedLinks = [];
      for (let data of linkData) {
        const link = data.link;
        const target = link.target;
        if (!target || startsWithData.test(target)) {
        } else if (startsWithSchemeRegex.test(target)) {
          resolvedLinks.push(link);
        } else {
          const resolved = documentContext.resolveReference(target, document.uri);
          if (resolved) {
            link.target = resolved;
          }
          resolvedLinks.push(link);
        }
      }
      return resolvedLinks;
    }
    async findDocumentLinks2(document, stylesheet, documentContext) {
      const linkData = this.findUnresolvedLinks(document, stylesheet);
      const resolvedLinks = [];
      for (let data of linkData) {
        const link = data.link;
        const target = link.target;
        if (!target || startsWithData.test(target)) {
        } else if (startsWithSchemeRegex.test(target)) {
          resolvedLinks.push(link);
        } else {
          const resolvedTarget = await this.resolveReference(target, document.uri, documentContext, data.isRawLink);
          if (resolvedTarget !== void 0) {
            link.target = resolvedTarget;
            resolvedLinks.push(link);
          }
        }
      }
      return resolvedLinks;
    }
    findUnresolvedLinks(document, stylesheet) {
      const result = [];
      const collect = (uriStringNode) => {
        let rawUri = uriStringNode.getText();
        const range = getRange(uriStringNode, document);
        if (range.start.line === range.end.line && range.start.character === range.end.character) {
          return;
        }
        if (startsWith(rawUri, `'`) || startsWith(rawUri, `"`)) {
          rawUri = rawUri.slice(1, -1);
        }
        const isRawLink = uriStringNode.parent ? this.isRawStringDocumentLinkNode(uriStringNode.parent) : false;
        result.push({ link: { target: rawUri, range }, isRawLink });
      };
      stylesheet.accept((candidate) => {
        if (candidate.type === NodeType.URILiteral) {
          const first = candidate.getChild(0);
          if (first) {
            collect(first);
          }
          return false;
        }
        if (candidate.parent && this.isRawStringDocumentLinkNode(candidate.parent)) {
          const rawText = candidate.getText();
          if (startsWith(rawText, `'`) || startsWith(rawText, `"`)) {
            collect(candidate);
          }
          return false;
        }
        return true;
      });
      return result;
    }
    findSymbolInformations(document, stylesheet) {
      const result = [];
      const addSymbolInformation = (name, kind, symbolNodeOrRange) => {
        const range = symbolNodeOrRange instanceof Node ? getRange(symbolNodeOrRange, document) : symbolNodeOrRange;
        const entry = {
          name: name || t("<undefined>"),
          kind,
          location: Location.create(document.uri, range)
        };
        result.push(entry);
      };
      this.collectDocumentSymbols(document, stylesheet, addSymbolInformation);
      return result;
    }
    findDocumentSymbols(document, stylesheet) {
      const result = [];
      const parents = [];
      const addDocumentSymbol = (name, kind, symbolNodeOrRange, nameNodeOrRange, bodyNode) => {
        const range = symbolNodeOrRange instanceof Node ? getRange(symbolNodeOrRange, document) : symbolNodeOrRange;
        let selectionRange = nameNodeOrRange instanceof Node ? getRange(nameNodeOrRange, document) : nameNodeOrRange;
        if (!selectionRange || !containsRange(range, selectionRange)) {
          selectionRange = Range.create(range.start, range.start);
        }
        const entry = {
          name: name || t("<undefined>"),
          kind,
          range,
          selectionRange
        };
        let top = parents.pop();
        while (top && !containsRange(top[1], range)) {
          top = parents.pop();
        }
        if (top) {
          const topSymbol = top[0];
          if (!topSymbol.children) {
            topSymbol.children = [];
          }
          topSymbol.children.push(entry);
          parents.push(top);
        } else {
          result.push(entry);
        }
        if (bodyNode) {
          parents.push([entry, getRange(bodyNode, document)]);
        }
      };
      this.collectDocumentSymbols(document, stylesheet, addDocumentSymbol);
      return result;
    }
    collectDocumentSymbols(document, stylesheet, collect) {
      stylesheet.accept((node) => {
        if (node instanceof RuleSet) {
          for (const selector of node.getSelectors().getChildren()) {
            if (selector instanceof Selector) {
              const range = Range.create(document.positionAt(selector.offset), document.positionAt(node.end));
              collect(selector.getText(), SymbolKind.Class, range, selector, node.getDeclarations());
            }
          }
        } else if (node instanceof VariableDeclaration) {
          collect(node.getName(), SymbolKind.Variable, node, node.getVariable(), void 0);
        } else if (node instanceof MixinDeclaration) {
          collect(node.getName(), SymbolKind.Method, node, node.getIdentifier(), node.getDeclarations());
        } else if (node instanceof FunctionDeclaration) {
          collect(node.getName(), SymbolKind.Function, node, node.getIdentifier(), node.getDeclarations());
        } else if (node instanceof Keyframe) {
          const name = t("@keyframes {0}", node.getName());
          collect(name, SymbolKind.Class, node, node.getIdentifier(), node.getDeclarations());
        } else if (node instanceof FontFace) {
          const name = t("@font-face");
          collect(name, SymbolKind.Class, node, void 0, node.getDeclarations());
        } else if (node instanceof Media) {
          const mediaList = node.getChild(0);
          if (mediaList instanceof Medialist) {
            const name = "@media " + mediaList.getText();
            collect(name, SymbolKind.Module, node, mediaList, node.getDeclarations());
          }
        }
        return true;
      });
    }
    findDocumentColors(document, stylesheet) {
      const result = [];
      stylesheet.accept((node) => {
        const colorInfo = getColorInformation(node, document);
        if (colorInfo) {
          result.push(colorInfo);
        }
        return true;
      });
      return result;
    }
    getColorPresentations(document, stylesheet, color, range) {
      const result = [];
      const red256 = Math.round(color.red * 255), green256 = Math.round(color.green * 255), blue256 = Math.round(color.blue * 255);
      let label;
      if (color.alpha === 1) {
        label = `rgb(${red256}, ${green256}, ${blue256})`;
      } else {
        label = `rgba(${red256}, ${green256}, ${blue256}, ${color.alpha})`;
      }
      result.push({ label, textEdit: TextEdit.replace(range, label) });
      if (color.alpha === 1) {
        label = `#${toTwoDigitHex(red256)}${toTwoDigitHex(green256)}${toTwoDigitHex(blue256)}`;
      } else {
        label = `#${toTwoDigitHex(red256)}${toTwoDigitHex(green256)}${toTwoDigitHex(blue256)}${toTwoDigitHex(Math.round(color.alpha * 255))}`;
      }
      result.push({ label, textEdit: TextEdit.replace(range, label) });
      const hsl = hslFromColor(color);
      if (hsl.a === 1) {
        label = `hsl(${hsl.h}, ${Math.round(hsl.s * 100)}%, ${Math.round(hsl.l * 100)}%)`;
      } else {
        label = `hsla(${hsl.h}, ${Math.round(hsl.s * 100)}%, ${Math.round(hsl.l * 100)}%, ${hsl.a})`;
      }
      result.push({ label, textEdit: TextEdit.replace(range, label) });
      const hwb = hwbFromColor(color);
      if (hwb.a === 1) {
        label = `hwb(${hwb.h} ${Math.round(hwb.w * 100)}% ${Math.round(hwb.b * 100)}%)`;
      } else {
        label = `hwb(${hwb.h} ${Math.round(hwb.w * 100)}% ${Math.round(hwb.b * 100)}% / ${hwb.a})`;
      }
      result.push({ label, textEdit: TextEdit.replace(range, label) });
      return result;
    }
    prepareRename(document, position, stylesheet) {
      const node = this.getHighlightNode(document, position, stylesheet);
      if (node) {
        return Range.create(document.positionAt(node.offset), document.positionAt(node.end));
      }
    }
    doRename(document, position, newName, stylesheet) {
      const highlights = this.findDocumentHighlights(document, position, stylesheet);
      const edits = highlights.map((h) => TextEdit.replace(h.range, newName));
      return {
        changes: { [document.uri]: edits }
      };
    }
    async resolveModuleReference(ref, documentUri, documentContext) {
      if (startsWith(documentUri, "file://")) {
        const moduleName = getModuleNameFromPath(ref);
        if (moduleName && moduleName !== "." && moduleName !== "..") {
          const rootFolderUri = documentContext.resolveReference("/", documentUri);
          const documentFolderUri = dirname(documentUri);
          const modulePath = await this.resolvePathToModule(moduleName, documentFolderUri, rootFolderUri);
          if (modulePath) {
            const pathWithinModule = ref.substring(moduleName.length + 1);
            return joinPath(modulePath, pathWithinModule);
          }
        }
      }
      return void 0;
    }
    async mapReference(target, isRawLink) {
      return target;
    }
    async resolveReference(target, documentUri, documentContext, isRawLink = false, settings = this.defaultSettings) {
      if (target[0] === "~" && target[1] !== "/" && this.fileSystemProvider) {
        target = target.substring(1);
        return this.mapReference(await this.resolveModuleReference(target, documentUri, documentContext), isRawLink);
      }
      const ref = await this.mapReference(documentContext.resolveReference(target, documentUri), isRawLink);
      if (this.resolveModuleReferences) {
        if (ref && await this.fileExists(ref)) {
          return ref;
        }
        const moduleReference = await this.mapReference(await this.resolveModuleReference(target, documentUri, documentContext), isRawLink);
        if (moduleReference) {
          return moduleReference;
        }
      }
      if (ref && !await this.fileExists(ref)) {
        const rootFolderUri = documentContext.resolveReference("/", documentUri);
        if (settings && rootFolderUri) {
          if (target in settings) {
            return this.mapReference(joinPath(rootFolderUri, settings[target]), isRawLink);
          }
          const firstSlash = target.indexOf("/");
          const prefix = `${target.substring(0, firstSlash)}/`;
          if (prefix in settings) {
            const aliasPath = settings[prefix].slice(0, -1);
            let newPath = joinPath(rootFolderUri, aliasPath);
            return this.mapReference(newPath = joinPath(newPath, target.substring(prefix.length - 1)), isRawLink);
          }
        }
      }
      return ref;
    }
    async resolvePathToModule(_moduleName, documentFolderUri, rootFolderUri) {
      const packPath = joinPath(documentFolderUri, "node_modules", _moduleName, "package.json");
      if (await this.fileExists(packPath)) {
        return dirname(packPath);
      } else if (rootFolderUri && documentFolderUri.startsWith(rootFolderUri) && documentFolderUri.length !== rootFolderUri.length) {
        return this.resolvePathToModule(_moduleName, dirname(documentFolderUri), rootFolderUri);
      }
      return void 0;
    }
    async fileExists(uri) {
      if (!this.fileSystemProvider) {
        return false;
      }
      try {
        const stat = await this.fileSystemProvider.stat(uri);
        if (stat.type === FileType.Unknown && stat.size === -1) {
          return false;
        }
        return true;
      } catch (err) {
        return false;
      }
    }
  };
  function getColorInformation(node, document) {
    const color = getColorValue(node);
    if (color) {
      const range = getRange(node, document);
      return { color, range };
    }
    return null;
  }
  function getRange(node, document) {
    return Range.create(document.positionAt(node.offset), document.positionAt(node.end));
  }
  function containsRange(range, otherRange) {
    const otherStartLine = otherRange.start.line, otherEndLine = otherRange.end.line;
    const rangeStartLine = range.start.line, rangeEndLine = range.end.line;
    if (otherStartLine < rangeStartLine || otherEndLine < rangeStartLine) {
      return false;
    }
    if (otherStartLine > rangeEndLine || otherEndLine > rangeEndLine) {
      return false;
    }
    if (otherStartLine === rangeStartLine && otherRange.start.character < range.start.character) {
      return false;
    }
    if (otherEndLine === rangeEndLine && otherRange.end.character > range.end.character) {
      return false;
    }
    return true;
  }
  function getHighlightKind(node) {
    if (node.type === NodeType.Selector) {
      return DocumentHighlightKind.Write;
    }
    if (node instanceof Identifier) {
      if (node.parent && node.parent instanceof Property) {
        if (node.isCustomProperty) {
          return DocumentHighlightKind.Write;
        }
      }
    }
    if (node.parent) {
      switch (node.parent.type) {
        case NodeType.FunctionDeclaration:
        case NodeType.MixinDeclaration:
        case NodeType.Keyframe:
        case NodeType.VariableDeclaration:
        case NodeType.FunctionParameter:
          return DocumentHighlightKind.Write;
      }
    }
    return DocumentHighlightKind.Read;
  }
  function toTwoDigitHex(n) {
    const r = n.toString(16);
    return r.length !== 2 ? "0" + r : r;
  }
  function getModuleNameFromPath(path) {
    const firstSlash = path.indexOf("/");
    if (firstSlash === -1) {
      return "";
    }
    if (path[0] === "@") {
      const secondSlash = path.indexOf("/", firstSlash + 1);
      if (secondSlash === -1) {
        return path;
      }
      return path.substring(0, secondSlash);
    }
    return path.substring(0, firstSlash);
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/lintRules.js
  var Warning = Level.Warning;
  var Error2 = Level.Error;
  var Ignore = Level.Ignore;
  var Rule = class {
    constructor(id, message, defaultValue) {
      this.id = id;
      this.message = message;
      this.defaultValue = defaultValue;
    }
  };
  var Setting = class {
    constructor(id, message, defaultValue) {
      this.id = id;
      this.message = message;
      this.defaultValue = defaultValue;
    }
  };
  var Rules = {
    AllVendorPrefixes: new Rule("compatibleVendorPrefixes", t("When using a vendor-specific prefix make sure to also include all other vendor-specific properties"), Ignore),
    IncludeStandardPropertyWhenUsingVendorPrefix: new Rule("vendorPrefix", t("When using a vendor-specific prefix also include the standard property"), Warning),
    DuplicateDeclarations: new Rule("duplicateProperties", t("Do not use duplicate style definitions"), Ignore),
    EmptyRuleSet: new Rule("emptyRules", t("Do not use empty rulesets"), Warning),
    ImportStatemement: new Rule("importStatement", t("Import statements do not load in parallel"), Ignore),
    BewareOfBoxModelSize: new Rule("boxModel", t("Do not use width or height when using padding or border"), Ignore),
    UniversalSelector: new Rule("universalSelector", t("The universal selector (*) is known to be slow"), Ignore),
    ZeroWithUnit: new Rule("zeroUnits", t("No unit for zero needed"), Ignore),
    RequiredPropertiesForFontFace: new Rule("fontFaceProperties", t("@font-face rule must define 'src' and 'font-family' properties"), Warning),
    HexColorLength: new Rule("hexColorLength", t("Hex colors must consist of three, four, six or eight hex numbers"), Error2),
    ArgsInColorFunction: new Rule("argumentsInColorFunction", t("Invalid number of parameters"), Error2),
    UnknownProperty: new Rule("unknownProperties", t("Unknown property."), Warning),
    UnknownAtRules: new Rule("unknownAtRules", t("Unknown at-rule."), Warning),
    IEStarHack: new Rule("ieHack", t("IE hacks are only necessary when supporting IE7 and older"), Ignore),
    UnknownVendorSpecificProperty: new Rule("unknownVendorSpecificProperties", t("Unknown vendor specific property."), Ignore),
    PropertyIgnoredDueToDisplay: new Rule("propertyIgnoredDueToDisplay", t("Property is ignored due to the display."), Warning),
    AvoidImportant: new Rule("important", t("Avoid using !important. It is an indication that the specificity of the entire CSS has gotten out of control and needs to be refactored."), Ignore),
    AvoidFloat: new Rule("float", t("Avoid using 'float'. Floats lead to fragile CSS that is easy to break if one aspect of the layout changes."), Ignore),
    AvoidIdSelector: new Rule("idSelector", t("Selectors should not contain IDs because these rules are too tightly coupled with the HTML."), Ignore)
  };
  var Settings = {
    ValidProperties: new Setting("validProperties", t("A list of properties that are not validated against the `unknownProperties` rule."), [])
  };
  var LintConfigurationSettings = class {
    constructor(conf = {}) {
      this.conf = conf;
    }
    getRule(rule) {
      if (this.conf.hasOwnProperty(rule.id)) {
        const level = toLevel(this.conf[rule.id]);
        if (level) {
          return level;
        }
      }
      return rule.defaultValue;
    }
    getSetting(setting) {
      return this.conf[setting.id];
    }
  };
  function toLevel(level) {
    switch (level) {
      case "ignore":
        return Level.Ignore;
      case "warning":
        return Level.Warning;
      case "error":
        return Level.Error;
    }
    return null;
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/cssCodeActions.js
  var CSSCodeActions = class {
    constructor(cssDataManager) {
      this.cssDataManager = cssDataManager;
    }
    doCodeActions(document, range, context, stylesheet) {
      return this.doCodeActions2(document, range, context, stylesheet).map((ca) => {
        const textDocumentEdit = ca.edit && ca.edit.documentChanges && ca.edit.documentChanges[0];
        return Command.create(ca.title, "_css.applyCodeAction", document.uri, document.version, textDocumentEdit && textDocumentEdit.edits);
      });
    }
    doCodeActions2(document, range, context, stylesheet) {
      const result = [];
      if (context.diagnostics) {
        for (const diagnostic of context.diagnostics) {
          this.appendFixesForMarker(document, stylesheet, diagnostic, result);
        }
      }
      return result;
    }
    getFixesForUnknownProperty(document, property, marker, result) {
      const propertyName = property.getName();
      const candidates = [];
      this.cssDataManager.getProperties().forEach((p) => {
        const score = difference(propertyName, p.name);
        if (score >= propertyName.length / 2) {
          candidates.push({ property: p.name, score });
        }
      });
      candidates.sort((a2, b) => {
        return b.score - a2.score || a2.property.localeCompare(b.property);
      });
      let maxActions = 3;
      for (const candidate of candidates) {
        const propertyName2 = candidate.property;
        const title = t("Rename to '{0}'", propertyName2);
        const edit = TextEdit.replace(marker.range, propertyName2);
        const documentIdentifier = VersionedTextDocumentIdentifier.create(document.uri, document.version);
        const workspaceEdit = { documentChanges: [TextDocumentEdit.create(documentIdentifier, [edit])] };
        const codeAction = CodeAction.create(title, workspaceEdit, CodeActionKind.QuickFix);
        codeAction.diagnostics = [marker];
        result.push(codeAction);
        if (--maxActions <= 0) {
          return;
        }
      }
    }
    appendFixesForMarker(document, stylesheet, marker, result) {
      if (marker.code !== Rules.UnknownProperty.id) {
        return;
      }
      const offset = document.offsetAt(marker.range.start);
      const end = document.offsetAt(marker.range.end);
      const nodepath = getNodePath(stylesheet, offset);
      for (let i = nodepath.length - 1; i >= 0; i--) {
        const node = nodepath[i];
        if (node instanceof Declaration) {
          const property = node.getProperty();
          if (property && property.offset === offset && property.end === end) {
            this.getFixesForUnknownProperty(document, property, marker, result);
            return;
          }
        }
      }
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/services/lintUtil.js
  var Element2 = class {
    constructor(decl) {
      this.fullPropertyName = decl.getFullPropertyName().toLowerCase();
      this.node = decl;
    }
  };
  function setSide(model, side, value, property) {
    const state = model[side];
    state.value = value;
    if (value) {
      if (!includes(state.properties, property)) {
        state.properties.push(property);
      }
    }
  }
  function setAllSides(model, value, property) {
    setSide(model, "top", value, property);
    setSide(model, "right", value, property);
    setSide(model, "bottom", value, property);
    setSide(model, "left", value, property);
  }
  function updateModelWithValue(model, side, value, property) {
    if (side === "top" || side === "right" || side === "bottom" || side === "left") {
      setSide(model, side, value, property);
    } else {
      setAllSides(model, value, property);
    }
  }
  function updateModelWithList(model, values2, property) {
    switch (values2.length) {
      case 1:
        updateModelWithValue(model, void 0, values2[0], property);
        break;
      case 2:
        updateModelWithValue(model, "top", values2[0], property);
        updateModelWithValue(model, "bottom", values2[0], property);
        updateModelWithValue(model, "right", values2[1], property);
        updateModelWithValue(model, "left", values2[1], property);
        break;
      case 3:
        updateModelWithValue(model, "top", values2[0], property);
        updateModelWithValue(model, "right", values2[1], property);
        updateModelWithValue(model, "left", values2[1], property);
        updateModelWithValue(model, "bottom", values2[2], property);
        break;
      case 4:
        updateModelWithValue(model, "top", values2[0], property);
        updateModelWithValue(model, "right", values2[1], property);
        updateModelWithValue(model, "bottom", values2[2], property);
        updateModelWithValue(model, "left", values2[3], property);
        break;
    }
  }
  function matches(value, candidates) {
    for (let candidate of candidates) {
      if (value.matches(candidate)) {
        return true;
      }
    }
    return false;
  }
  function checkLineWidth(value, allowsKeywords = true) {
    if (allowsKeywords && matches(value, ["initial", "unset"])) {
      return false;
    }
    return parseFloat(value.getText()) !== 0;
  }
  function checkLineWidthList(nodes, allowsKeywords = true) {
    return nodes.map((node) => checkLineWidth(node, allowsKeywords));
  }
  function checkLineStyle(valueNode, allowsKeywords = true) {
    if (matches(valueNode, ["none", "hidden"])) {
      return false;
    }
    if (allowsKeywords && matches(valueNode, ["initial", "unset"])) {
      return false;
    }
    return true;
  }
  function checkLineStyleList(nodes, allowsKeywords = true) {
    return nodes.map((node) => checkLineStyle(node, allowsKeywords));
  }
  function checkBorderShorthand(node) {
    const children = node.getChildren();
    if (children.length === 1) {
      const value = children[0];
      return checkLineWidth(value) && checkLineStyle(value);
    }
    for (const child of children) {
      const value = child;
      if (!checkLineWidth(
        value,
        /* allowsKeywords: */
        false
      ) || !checkLineStyle(
        value,
        /* allowsKeywords: */
        false
      )) {
        return false;
      }
    }
    return true;
  }
  function calculateBoxModel(propertyTable) {
    const model = {
      top: { value: false, properties: [] },
      right: { value: false, properties: [] },
      bottom: { value: false, properties: [] },
      left: { value: false, properties: [] }
    };
    for (const property of propertyTable) {
      const value = property.node.value;
      if (typeof value === "undefined") {
        continue;
      }
      switch (property.fullPropertyName) {
        case "box-sizing":
          return {
            top: { value: false, properties: [] },
            right: { value: false, properties: [] },
            bottom: { value: false, properties: [] },
            left: { value: false, properties: [] }
          };
        case "width":
          model.width = property;
          break;
        case "height":
          model.height = property;
          break;
        default:
          const segments = property.fullPropertyName.split("-");
          switch (segments[0]) {
            case "border":
              switch (segments[1]) {
                case void 0:
                case "top":
                case "right":
                case "bottom":
                case "left":
                  switch (segments[2]) {
                    case void 0:
                      updateModelWithValue(model, segments[1], checkBorderShorthand(value), property);
                      break;
                    case "width":
                      updateModelWithValue(model, segments[1], checkLineWidth(value, false), property);
                      break;
                    case "style":
                      updateModelWithValue(model, segments[1], checkLineStyle(value, true), property);
                      break;
                  }
                  break;
                case "width":
                  updateModelWithList(model, checkLineWidthList(value.getChildren(), false), property);
                  break;
                case "style":
                  updateModelWithList(model, checkLineStyleList(value.getChildren(), true), property);
                  break;
              }
              break;
            case "padding":
              if (segments.length === 1) {
                updateModelWithList(model, checkLineWidthList(value.getChildren(), true), property);
              } else {
                updateModelWithValue(model, segments[1], checkLineWidth(value, true), property);
              }
              break;
          }
          break;
      }
    }
    return model;
  }

  // node_modules/vscode-css-languageservice/lib/esm/services/lint.js
  var NodesByRootMap = class {
    constructor() {
      this.data = {};
    }
    add(root, name, node) {
      let entry = this.data[root];
      if (!entry) {
        entry = { nodes: [], names: [] };
        this.data[root] = entry;
      }
      entry.names.push(name);
      if (node) {
        entry.nodes.push(node);
      }
    }
  };
  var LintVisitor = class _LintVisitor {
    static entries(node, document, settings, cssDataManager, entryFilter) {
      const visitor = new _LintVisitor(document, settings, cssDataManager);
      node.acceptVisitor(visitor);
      visitor.completeValidations();
      return visitor.getEntries(entryFilter);
    }
    constructor(document, settings, cssDataManager) {
      this.cssDataManager = cssDataManager;
      this.warnings = [];
      this.settings = settings;
      this.documentText = document.getText();
      this.keyframes = new NodesByRootMap();
      this.validProperties = {};
      const properties = settings.getSetting(Settings.ValidProperties);
      if (Array.isArray(properties)) {
        properties.forEach((p) => {
          if (typeof p === "string") {
            const name = p.trim().toLowerCase();
            if (name.length) {
              this.validProperties[name] = true;
            }
          }
        });
      }
    }
    isValidPropertyDeclaration(element) {
      const propertyName = element.fullPropertyName;
      return this.validProperties[propertyName];
    }
    fetch(input, s) {
      const elements = [];
      for (const curr of input) {
        if (curr.fullPropertyName === s) {
          elements.push(curr);
        }
      }
      return elements;
    }
    fetchWithValue(input, s, v) {
      const elements = [];
      for (const inputElement of input) {
        if (inputElement.fullPropertyName === s) {
          const expression = inputElement.node.getValue();
          if (expression && this.findValueInExpression(expression, v)) {
            elements.push(inputElement);
          }
        }
      }
      return elements;
    }
    findValueInExpression(expression, v) {
      let found = false;
      expression.accept((node) => {
        if (node.type === NodeType.Identifier && node.matches(v)) {
          found = true;
        }
        return !found;
      });
      return found;
    }
    getEntries(filter = Level.Warning | Level.Error) {
      return this.warnings.filter((entry) => {
        return (entry.getLevel() & filter) !== 0;
      });
    }
    addEntry(node, rule, details) {
      const entry = new Marker(node, rule, this.settings.getRule(rule), details);
      this.warnings.push(entry);
    }
    getMissingNames(expected, actual) {
      const expectedClone = expected.slice(0);
      for (let i = 0; i < actual.length; i++) {
        const k = expectedClone.indexOf(actual[i]);
        if (k !== -1) {
          expectedClone[k] = null;
        }
      }
      let result = null;
      for (let i = 0; i < expectedClone.length; i++) {
        const curr = expectedClone[i];
        if (curr) {
          if (result === null) {
            result = t("'{0}'", curr);
          } else {
            result = t("{0}, '{1}'", result, curr);
          }
        }
      }
      return result;
    }
    visitNode(node) {
      switch (node.type) {
        case NodeType.UnknownAtRule:
          return this.visitUnknownAtRule(node);
        case NodeType.Keyframe:
          return this.visitKeyframe(node);
        case NodeType.FontFace:
          return this.visitFontFace(node);
        case NodeType.Ruleset:
          return this.visitRuleSet(node);
        case NodeType.SimpleSelector:
          return this.visitSimpleSelector(node);
        case NodeType.Function:
          return this.visitFunction(node);
        case NodeType.NumericValue:
          return this.visitNumericValue(node);
        case NodeType.Import:
          return this.visitImport(node);
        case NodeType.HexColorValue:
          return this.visitHexColorValue(node);
        case NodeType.Prio:
          return this.visitPrio(node);
        case NodeType.IdentifierSelector:
          return this.visitIdentifierSelector(node);
      }
      return true;
    }
    completeValidations() {
      this.validateKeyframes();
    }
    visitUnknownAtRule(node) {
      const atRuleName = node.getChild(0);
      if (!atRuleName) {
        return false;
      }
      const atDirective = this.cssDataManager.getAtDirective(atRuleName.getText());
      if (atDirective) {
        return false;
      }
      this.addEntry(atRuleName, Rules.UnknownAtRules, `Unknown at rule ${atRuleName.getText()}`);
      return true;
    }
    visitKeyframe(node) {
      const keyword = node.getKeyword();
      if (!keyword) {
        return false;
      }
      const text = keyword.getText();
      this.keyframes.add(node.getName(), text, text !== "@keyframes" ? keyword : null);
      return true;
    }
    validateKeyframes() {
      const expected = ["@-webkit-keyframes", "@-moz-keyframes", "@-o-keyframes"];
      for (const name in this.keyframes.data) {
        const actual = this.keyframes.data[name].names;
        const needsStandard = actual.indexOf("@keyframes") === -1;
        if (!needsStandard && actual.length === 1) {
          continue;
        }
        const missingVendorSpecific = this.getMissingNames(expected, actual);
        if (missingVendorSpecific || needsStandard) {
          for (const node of this.keyframes.data[name].nodes) {
            if (needsStandard) {
              const message = t("Always define standard rule '@keyframes' when defining keyframes.");
              this.addEntry(node, Rules.IncludeStandardPropertyWhenUsingVendorPrefix, message);
            }
            if (missingVendorSpecific) {
              const message = t("Always include all vendor specific rules: Missing: {0}", missingVendorSpecific);
              this.addEntry(node, Rules.AllVendorPrefixes, message);
            }
          }
        }
      }
      return true;
    }
    visitSimpleSelector(node) {
      const firstChar = this.documentText.charAt(node.offset);
      if (node.length === 1 && firstChar === "*") {
        this.addEntry(node, Rules.UniversalSelector);
      }
      return true;
    }
    visitIdentifierSelector(node) {
      this.addEntry(node, Rules.AvoidIdSelector);
      return true;
    }
    visitImport(node) {
      this.addEntry(node, Rules.ImportStatemement);
      return true;
    }
    visitRuleSet(node) {
      const declarations = node.getDeclarations();
      if (!declarations) {
        return false;
      }
      if (!declarations.hasChildren()) {
        this.addEntry(node.getSelectors(), Rules.EmptyRuleSet);
      }
      const propertyTable = [];
      for (const element of declarations.getChildren()) {
        if (element instanceof Declaration) {
          propertyTable.push(new Element2(element));
        }
      }
      const boxModel = calculateBoxModel(propertyTable);
      if (boxModel.width) {
        let properties = [];
        if (boxModel.right.value) {
          properties = union(properties, boxModel.right.properties);
        }
        if (boxModel.left.value) {
          properties = union(properties, boxModel.left.properties);
        }
        if (properties.length !== 0) {
          for (const item of properties) {
            this.addEntry(item.node, Rules.BewareOfBoxModelSize);
          }
          this.addEntry(boxModel.width.node, Rules.BewareOfBoxModelSize);
        }
      }
      if (boxModel.height) {
        let properties = [];
        if (boxModel.top.value) {
          properties = union(properties, boxModel.top.properties);
        }
        if (boxModel.bottom.value) {
          properties = union(properties, boxModel.bottom.properties);
        }
        if (properties.length !== 0) {
          for (const item of properties) {
            this.addEntry(item.node, Rules.BewareOfBoxModelSize);
          }
          this.addEntry(boxModel.height.node, Rules.BewareOfBoxModelSize);
        }
      }
      let displayElems = this.fetchWithValue(propertyTable, "display", "inline-block");
      if (displayElems.length > 0) {
        const elem = this.fetch(propertyTable, "float");
        for (let index = 0; index < elem.length; index++) {
          const node2 = elem[index].node;
          const value = node2.getValue();
          if (value && !value.matches("none")) {
            this.addEntry(node2, Rules.PropertyIgnoredDueToDisplay, t("inline-block is ignored due to the float. If 'float' has a value other than 'none', the box is floated and 'display' is treated as 'block'"));
          }
        }
      }
      displayElems = this.fetchWithValue(propertyTable, "display", "block");
      if (displayElems.length > 0) {
        const elem = this.fetch(propertyTable, "vertical-align");
        for (let index = 0; index < elem.length; index++) {
          this.addEntry(elem[index].node, Rules.PropertyIgnoredDueToDisplay, t("Property is ignored due to the display. With 'display: block', vertical-align should not be used."));
        }
      }
      const elements = this.fetch(propertyTable, "float");
      for (let index = 0; index < elements.length; index++) {
        const element = elements[index];
        if (!this.isValidPropertyDeclaration(element)) {
          this.addEntry(element.node, Rules.AvoidFloat);
        }
      }
      for (let i = 0; i < propertyTable.length; i++) {
        const element = propertyTable[i];
        if (element.fullPropertyName !== "background" && !this.validProperties[element.fullPropertyName]) {
          const value = element.node.getValue();
          if (value && this.documentText.charAt(value.offset) !== "-") {
            const elements2 = this.fetch(propertyTable, element.fullPropertyName);
            if (elements2.length > 1) {
              for (let k = 0; k < elements2.length; k++) {
                const value2 = elements2[k].node.getValue();
                if (value2 && this.documentText.charAt(value2.offset) !== "-" && elements2[k] !== element) {
                  this.addEntry(element.node, Rules.DuplicateDeclarations);
                }
              }
            }
          }
        }
      }
      const isExportBlock = node.getSelectors().matches(":export");
      if (!isExportBlock) {
        const propertiesBySuffix = new NodesByRootMap();
        let containsUnknowns = false;
        for (const element of propertyTable) {
          const decl = element.node;
          if (this.isCSSDeclaration(decl)) {
            let name = element.fullPropertyName;
            const firstChar = name.charAt(0);
            if (firstChar === "-") {
              if (name.charAt(1) !== "-") {
                if (!this.cssDataManager.isKnownProperty(name) && !this.validProperties[name]) {
                  this.addEntry(decl.getProperty(), Rules.UnknownVendorSpecificProperty);
                }
                const nonPrefixedName = decl.getNonPrefixedPropertyName();
                propertiesBySuffix.add(nonPrefixedName, name, decl.getProperty());
              }
            } else {
              const fullName = name;
              if (firstChar === "*" || firstChar === "_") {
                this.addEntry(decl.getProperty(), Rules.IEStarHack);
                name = name.substr(1);
              }
              if (!this.cssDataManager.isKnownProperty(fullName) && !this.cssDataManager.isKnownProperty(name)) {
                if (!this.validProperties[name]) {
                  this.addEntry(decl.getProperty(), Rules.UnknownProperty, t("Unknown property: '{0}'", decl.getFullPropertyName()));
                }
              }
              propertiesBySuffix.add(name, name, null);
            }
          } else {
            containsUnknowns = true;
          }
        }
        if (!containsUnknowns) {
          for (const suffix in propertiesBySuffix.data) {
            const entry = propertiesBySuffix.data[suffix];
            const actual = entry.names;
            const needsStandard = this.cssDataManager.isStandardProperty(suffix) && actual.indexOf(suffix) === -1;
            if (!needsStandard && actual.length === 1) {
              continue;
            }
            const entriesThatNeedStandard = new Set(needsStandard ? entry.nodes : []);
            if (needsStandard) {
              const pseudoElements = this.getContextualVendorSpecificPseudoElements(node);
              for (const node2 of entry.nodes) {
                const propertyName = node2.getName();
                const prefix = propertyName.substring(0, propertyName.length - suffix.length);
                if (pseudoElements.some((x) => x.startsWith(prefix))) {
                  entriesThatNeedStandard.delete(node2);
                }
              }
            }
            const expected = [];
            for (let i = 0, len = _LintVisitor.prefixes.length; i < len; i++) {
              const prefix = _LintVisitor.prefixes[i];
              if (this.cssDataManager.isStandardProperty(prefix + suffix)) {
                expected.push(prefix + suffix);
              }
            }
            const missingVendorSpecific = this.getMissingNames(expected, actual);
            if (missingVendorSpecific || needsStandard) {
              for (const node2 of entry.nodes) {
                if (needsStandard && entriesThatNeedStandard.has(node2)) {
                  const message = t("Also define the standard property '{0}' for compatibility", suffix);
                  this.addEntry(node2, Rules.IncludeStandardPropertyWhenUsingVendorPrefix, message);
                }
                if (missingVendorSpecific) {
                  const message = t("Always include all vendor specific properties: Missing: {0}", missingVendorSpecific);
                  this.addEntry(node2, Rules.AllVendorPrefixes, message);
                }
              }
            }
          }
        }
      }
      return true;
    }
    /**
     * Walks up the syntax tree (starting from given `node`) and captures vendor
     * specific pseudo-element selectors.
     * @returns An array of vendor specific pseudo-elements; or empty if none
     * was found.
     */
    getContextualVendorSpecificPseudoElements(node) {
      function walkDown(s, n) {
        for (const child of n.getChildren()) {
          if (child.type === NodeType.PseudoSelector) {
            const pseudoElement = child.getChildren()[0]?.getText();
            if (pseudoElement) {
              s.add(pseudoElement);
            }
          }
          walkDown(s, child);
        }
      }
      function walkUp(s, n) {
        if (n.type === NodeType.Ruleset) {
          for (const selector of n.getSelectors().getChildren()) {
            walkDown(s, selector);
          }
        }
        return n.parent ? walkUp(s, n.parent) : void 0;
      }
      const result = /* @__PURE__ */ new Set();
      walkUp(result, node);
      return Array.from(result);
    }
    visitPrio(node) {
      this.addEntry(node, Rules.AvoidImportant);
      return true;
    }
    visitNumericValue(node) {
      const funcDecl = node.findParent(NodeType.Function);
      if (funcDecl && funcDecl.getName() === "calc") {
        return true;
      }
      const decl = node.findParent(NodeType.Declaration);
      if (decl) {
        const declValue = decl.getValue();
        if (declValue) {
          const value = node.getValue();
          if (!value.unit || units.length.indexOf(value.unit.toLowerCase()) === -1) {
            return true;
          }
          if (parseFloat(value.value) === 0 && !!value.unit && !this.validProperties[decl.getFullPropertyName()]) {
            this.addEntry(node, Rules.ZeroWithUnit);
          }
        }
      }
      return true;
    }
    visitFontFace(node) {
      const declarations = node.getDeclarations();
      if (!declarations) {
        return false;
      }
      let definesSrc = false, definesFontFamily = false;
      let containsUnknowns = false;
      for (const node2 of declarations.getChildren()) {
        if (this.isCSSDeclaration(node2)) {
          const name = node2.getProperty().getName().toLowerCase();
          if (name === "src") {
            definesSrc = true;
          }
          if (name === "font-family") {
            definesFontFamily = true;
          }
        } else {
          containsUnknowns = true;
        }
      }
      if (!containsUnknowns && (!definesSrc || !definesFontFamily)) {
        this.addEntry(node, Rules.RequiredPropertiesForFontFace);
      }
      return true;
    }
    isCSSDeclaration(node) {
      if (node instanceof Declaration) {
        if (!node.getValue()) {
          return false;
        }
        const property = node.getProperty();
        if (!property) {
          return false;
        }
        const identifier = property.getIdentifier();
        if (!identifier || identifier.containsInterpolation()) {
          return false;
        }
        return true;
      }
      return false;
    }
    visitHexColorValue(node) {
      const length = node.length;
      if (length !== 9 && length !== 7 && length !== 5 && length !== 4) {
        this.addEntry(node, Rules.HexColorLength);
      }
      return false;
    }
    visitFunction(node) {
      const fnName = node.getName().toLowerCase();
      let expectedAttrCount = -1;
      let actualAttrCount = 0;
      switch (fnName) {
        case "rgb(":
        case "hsl(":
          expectedAttrCount = 3;
          break;
        case "rgba(":
        case "hsla(":
          expectedAttrCount = 4;
          break;
      }
      if (expectedAttrCount !== -1) {
        node.getArguments().accept((n) => {
          if (n instanceof BinaryExpression) {
            actualAttrCount += 1;
            return false;
          }
          return true;
        });
        if (actualAttrCount !== expectedAttrCount) {
          this.addEntry(node, Rules.ArgsInColorFunction);
        }
      }
      return true;
    }
  };
  LintVisitor.prefixes = [
    "-ms-",
    "-moz-",
    "-o-",
    "-webkit-"
    // Quite common
    //		'-xv-', '-atsc-', '-wap-', '-khtml-', 'mso-', 'prince-', '-ah-', '-hp-', '-ro-', '-rim-', '-tc-' // Quite un-common
  ];

  // node_modules/vscode-css-languageservice/lib/esm/services/cssValidation.js
  var CSSValidation = class {
    constructor(cssDataManager) {
      this.cssDataManager = cssDataManager;
    }
    configure(settings) {
      this.settings = settings;
    }
    doValidation(document, stylesheet, settings = this.settings) {
      if (settings && settings.validate === false) {
        return [];
      }
      const entries = [];
      entries.push.apply(entries, ParseErrorCollector.entries(stylesheet));
      entries.push.apply(entries, LintVisitor.entries(stylesheet, document, new LintConfigurationSettings(settings && settings.lint), this.cssDataManager));
      const ruleIds = [];
      for (const r in Rules) {
        ruleIds.push(Rules[r].id);
      }
      function toDiagnostic(marker) {
        const range = Range.create(document.positionAt(marker.getOffset()), document.positionAt(marker.getOffset() + marker.getLength()));
        const source = document.languageId;
        return {
          code: marker.getRule().id,
          source,
          message: marker.getMessage(),
          severity: marker.getLevel() === Level.Warning ? DiagnosticSeverity.Warning : DiagnosticSeverity.Error,
          range
        };
      }
      return entries.filter((entry) => entry.getLevel() !== Level.Ignore).map(toDiagnostic);
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/parser/scssScanner.js
  var _FSL2 = "/".charCodeAt(0);
  var _NWL2 = "\n".charCodeAt(0);
  var _CAR2 = "\r".charCodeAt(0);
  var _LFD2 = "\f".charCodeAt(0);
  var _DLR2 = "$".charCodeAt(0);
  var _HSH2 = "#".charCodeAt(0);
  var _CUL2 = "{".charCodeAt(0);
  var _EQS2 = "=".charCodeAt(0);
  var _BNG2 = "!".charCodeAt(0);
  var _LAN2 = "<".charCodeAt(0);
  var _RAN2 = ">".charCodeAt(0);
  var _DOT2 = ".".charCodeAt(0);
  var _ATS2 = "@".charCodeAt(0);
  var customTokenValue = TokenType.CustomToken;
  var VariableName = customTokenValue++;
  var InterpolationFunction = customTokenValue++;
  var Default = customTokenValue++;
  var EqualsOperator = customTokenValue++;
  var NotEqualsOperator = customTokenValue++;
  var GreaterEqualsOperator = customTokenValue++;
  var SmallerEqualsOperator = customTokenValue++;
  var Ellipsis = customTokenValue++;
  var Module2 = customTokenValue++;
  var SCSSScanner = class extends Scanner {
    scanNext(offset) {
      if (this.stream.advanceIfChar(_DLR2)) {
        const content = ["$"];
        if (this.ident(content)) {
          return this.finishToken(offset, VariableName, content.join(""));
        } else {
          this.stream.goBackTo(offset);
        }
      }
      if (this.stream.advanceIfChars([_HSH2, _CUL2])) {
        return this.finishToken(offset, InterpolationFunction);
      }
      if (this.stream.advanceIfChars([_EQS2, _EQS2])) {
        return this.finishToken(offset, EqualsOperator);
      }
      if (this.stream.advanceIfChars([_BNG2, _EQS2])) {
        return this.finishToken(offset, NotEqualsOperator);
      }
      if (this.stream.advanceIfChar(_LAN2)) {
        if (this.stream.advanceIfChar(_EQS2)) {
          return this.finishToken(offset, SmallerEqualsOperator);
        }
        return this.finishToken(offset, TokenType.Delim);
      }
      if (this.stream.advanceIfChar(_RAN2)) {
        if (this.stream.advanceIfChar(_EQS2)) {
          return this.finishToken(offset, GreaterEqualsOperator);
        }
        return this.finishToken(offset, TokenType.Delim);
      }
      if (this.stream.advanceIfChars([_DOT2, _DOT2, _DOT2])) {
        return this.finishToken(offset, Ellipsis);
      }
      return super.scanNext(offset);
    }
    comment() {
      if (super.comment()) {
        return true;
      }
      if (!this.inURL && this.stream.advanceIfChars([_FSL2, _FSL2])) {
        this.stream.advanceWhileChar((ch) => {
          switch (ch) {
            case _NWL2:
            case _CAR2:
            case _LFD2:
              return false;
            default:
              return true;
          }
        });
        return true;
      } else {
        return false;
      }
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/parser/scssErrors.js
  var SCSSIssueType = class {
    constructor(id, message) {
      this.id = id;
      this.message = message;
    }
  };
  var SCSSParseError = {
    FromExpected: new SCSSIssueType("scss-fromexpected", t("'from' expected")),
    ThroughOrToExpected: new SCSSIssueType("scss-throughexpected", t("'through' or 'to' expected")),
    InExpected: new SCSSIssueType("scss-fromexpected", t("'in' expected"))
  };

  // node_modules/vscode-css-languageservice/lib/esm/parser/scssParser.js
  var SCSSParser = class extends Parser {
    constructor() {
      super(new SCSSScanner());
    }
    _parseStylesheetStatement(isNested = false) {
      if (this.peek(TokenType.AtKeyword)) {
        return this._parseWarnAndDebug() || this._parseControlStatement() || this._parseMixinDeclaration() || this._parseMixinContent() || this._parseMixinReference() || this._parseFunctionDeclaration() || this._parseForward() || this._parseUse() || this._parseRuleset(isNested) || super._parseStylesheetAtStatement(isNested);
      }
      return this._parseRuleset(true) || this._parseVariableDeclaration();
    }
    _parseImport() {
      if (!this.peekKeyword("@import")) {
        return null;
      }
      const node = this.create(Import);
      this.consumeToken();
      if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
        return this.finish(node, ParseError.URIOrStringExpected);
      }
      while (this.accept(TokenType.Comma)) {
        if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
          return this.finish(node, ParseError.URIOrStringExpected);
        }
      }
      return this._completeParseImport(node);
    }
    // scss variables: $font-size: 12px;
    _parseVariableDeclaration(panic = []) {
      if (!this.peek(VariableName)) {
        return null;
      }
      const node = this.create(VariableDeclaration);
      if (!node.setVariable(this._parseVariable())) {
        return null;
      }
      if (!this.accept(TokenType.Colon)) {
        return this.finish(node, ParseError.ColonExpected);
      }
      if (this.prevToken) {
        node.colonPosition = this.prevToken.offset;
      }
      if (!node.setValue(this._parseExpr())) {
        return this.finish(node, ParseError.VariableValueExpected, [], panic);
      }
      while (this.peek(TokenType.Exclamation)) {
        if (node.addChild(this._tryParsePrio())) {
        } else {
          this.consumeToken();
          if (!this.peekRegExp(TokenType.Ident, /^(default|global)$/)) {
            return this.finish(node, ParseError.UnknownKeyword);
          }
          this.consumeToken();
        }
      }
      if (this.peek(TokenType.SemiColon)) {
        node.semicolonPosition = this.token.offset;
      }
      return this.finish(node);
    }
    _parseMediaCondition() {
      return this._parseInterpolation() || super._parseMediaCondition();
    }
    _parseMediaFeatureRangeOperator() {
      return this.accept(SmallerEqualsOperator) || this.accept(GreaterEqualsOperator) || super._parseMediaFeatureRangeOperator();
    }
    _parseMediaFeatureName() {
      return this._parseModuleMember() || this._parseFunction() || this._parseIdent() || this._parseVariable();
    }
    _parseKeyframeSelector() {
      return this._tryParseKeyframeSelector() || this._parseControlStatement(this._parseKeyframeSelector.bind(this)) || this._parseWarnAndDebug() || this._parseMixinReference() || this._parseFunctionDeclaration() || this._parseVariableDeclaration() || this._parseMixinContent();
    }
    _parseVariable() {
      if (!this.peek(VariableName)) {
        return null;
      }
      const node = this.create(Variable);
      this.consumeToken();
      return node;
    }
    _parseModuleMember() {
      const pos = this.mark();
      const node = this.create(Module);
      if (!node.setIdentifier(this._parseIdent([ReferenceType.Module]))) {
        return null;
      }
      if (this.hasWhitespace() || !this.acceptDelim(".") || this.hasWhitespace()) {
        this.restoreAtMark(pos);
        return null;
      }
      if (!node.addChild(this._parseVariable() || this._parseFunction())) {
        return this.finish(node, ParseError.IdentifierOrVariableExpected);
      }
      return node;
    }
    _parseIdent(referenceTypes) {
      if (!this.peek(TokenType.Ident) && !this.peek(InterpolationFunction) && !this.peekDelim("-")) {
        return null;
      }
      const node = this.create(Identifier);
      node.referenceTypes = referenceTypes;
      node.isCustomProperty = this.peekRegExp(TokenType.Ident, /^--/);
      let hasContent = false;
      const indentInterpolation = () => {
        const pos = this.mark();
        if (this.acceptDelim("-")) {
          if (!this.hasWhitespace()) {
            this.acceptDelim("-");
          }
          if (this.hasWhitespace()) {
            this.restoreAtMark(pos);
            return null;
          }
        }
        return this._parseInterpolation();
      };
      while (this.accept(TokenType.Ident) || node.addChild(indentInterpolation()) || hasContent && this.acceptRegexp(/^[\w-]/)) {
        hasContent = true;
        if (this.hasWhitespace()) {
          break;
        }
      }
      return hasContent ? this.finish(node) : null;
    }
    _parseTermExpression() {
      return this._parseModuleMember() || this._parseVariable() || this._parseNestingSelector() || //this._tryParsePrio() ||
      super._parseTermExpression();
    }
    _parseInterpolation() {
      if (this.peek(InterpolationFunction)) {
        const node = this.create(Interpolation);
        this.consumeToken();
        if (!node.addChild(this._parseExpr()) && !this._parseNestingSelector()) {
          if (this.accept(TokenType.CurlyR)) {
            return this.finish(node);
          }
          return this.finish(node, ParseError.ExpressionExpected);
        }
        if (!this.accept(TokenType.CurlyR)) {
          return this.finish(node, ParseError.RightCurlyExpected);
        }
        return this.finish(node);
      }
      return null;
    }
    _parseOperator() {
      if (this.peek(EqualsOperator) || this.peek(NotEqualsOperator) || this.peek(GreaterEqualsOperator) || this.peek(SmallerEqualsOperator) || this.peekDelim(">") || this.peekDelim("<") || this.peekIdent("and") || this.peekIdent("or") || this.peekDelim("%")) {
        const node = this.createNode(NodeType.Operator);
        this.consumeToken();
        return this.finish(node);
      }
      return super._parseOperator();
    }
    _parseUnaryOperator() {
      if (this.peekIdent("not")) {
        const node = this.create(Node);
        this.consumeToken();
        return this.finish(node);
      }
      return super._parseUnaryOperator();
    }
    _parseRuleSetDeclaration() {
      if (this.peek(TokenType.AtKeyword)) {
        return this._parseKeyframe() || this._parseImport() || this._parseMedia(true) || this._parseFontFace() || this._parseWarnAndDebug() || this._parseControlStatement() || this._parseFunctionDeclaration() || this._parseExtends() || this._parseMixinReference() || this._parseMixinContent() || this._parseMixinDeclaration() || this._parseRuleset(true) || this._parseSupports(true) || this._parseLayer() || this._parsePropertyAtRule() || this._parseContainer(true) || this._parseRuleSetDeclarationAtStatement();
      }
      return this._parseVariableDeclaration() || this._tryParseRuleset(true) || this._parseDeclaration();
    }
    _parseDeclaration(stopTokens) {
      const custonProperty = this._tryParseCustomPropertyDeclaration(stopTokens);
      if (custonProperty) {
        return custonProperty;
      }
      const node = this.create(Declaration);
      if (!node.setProperty(this._parseProperty())) {
        return null;
      }
      if (!this.accept(TokenType.Colon)) {
        return this.finish(node, ParseError.ColonExpected, [TokenType.Colon], stopTokens || [TokenType.SemiColon]);
      }
      if (this.prevToken) {
        node.colonPosition = this.prevToken.offset;
      }
      let hasContent = false;
      if (node.setValue(this._parseExpr())) {
        hasContent = true;
        node.addChild(this._parsePrio());
      }
      if (this.peek(TokenType.CurlyL)) {
        node.setNestedProperties(this._parseNestedProperties());
      } else {
        if (!hasContent) {
          return this.finish(node, ParseError.PropertyValueExpected);
        }
      }
      if (this.peek(TokenType.SemiColon)) {
        node.semicolonPosition = this.token.offset;
      }
      return this.finish(node);
    }
    _parseNestedProperties() {
      const node = this.create(NestedProperties);
      return this._parseBody(node, this._parseDeclaration.bind(this));
    }
    _parseExtends() {
      if (this.peekKeyword("@extend")) {
        const node = this.create(ExtendsReference);
        this.consumeToken();
        if (!node.getSelectors().addChild(this._parseSimpleSelector())) {
          return this.finish(node, ParseError.SelectorExpected);
        }
        while (this.accept(TokenType.Comma)) {
          node.getSelectors().addChild(this._parseSimpleSelector());
        }
        if (this.accept(TokenType.Exclamation)) {
          if (!this.acceptIdent("optional")) {
            return this.finish(node, ParseError.UnknownKeyword);
          }
        }
        return this.finish(node);
      }
      return null;
    }
    _parseSimpleSelectorBody() {
      return this._parseSelectorPlaceholder() || super._parseSimpleSelectorBody();
    }
    _parseNestingSelector() {
      if (this.peekDelim("&")) {
        const node = this.createNode(NodeType.SelectorCombinator);
        this.consumeToken();
        while (!this.hasWhitespace() && (this.acceptDelim("-") || this.accept(TokenType.Num) || this.accept(TokenType.Dimension) || node.addChild(this._parseIdent()) || this.acceptDelim("&"))) {
        }
        return this.finish(node);
      }
      return null;
    }
    _parseSelectorPlaceholder() {
      if (this.peekDelim("%")) {
        const node = this.createNode(NodeType.SelectorPlaceholder);
        this.consumeToken();
        this._parseIdent();
        return this.finish(node);
      } else if (this.peekKeyword("@at-root")) {
        const node = this.createNode(NodeType.SelectorPlaceholder);
        this.consumeToken();
        if (this.accept(TokenType.ParenthesisL)) {
          if (!this.acceptIdent("with") && !this.acceptIdent("without")) {
            return this.finish(node, ParseError.IdentifierExpected);
          }
          if (!this.accept(TokenType.Colon)) {
            return this.finish(node, ParseError.ColonExpected);
          }
          if (!node.addChild(this._parseIdent())) {
            return this.finish(node, ParseError.IdentifierExpected);
          }
          if (!this.accept(TokenType.ParenthesisR)) {
            return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.CurlyR]);
          }
        }
        return this.finish(node);
      }
      return null;
    }
    _parseElementName() {
      const pos = this.mark();
      const node = super._parseElementName();
      if (node && !this.hasWhitespace() && this.peek(TokenType.ParenthesisL)) {
        this.restoreAtMark(pos);
        return null;
      }
      return node;
    }
    _tryParsePseudoIdentifier() {
      return this._parseInterpolation() || super._tryParsePseudoIdentifier();
    }
    _parseWarnAndDebug() {
      if (!this.peekKeyword("@debug") && !this.peekKeyword("@warn") && !this.peekKeyword("@error")) {
        return null;
      }
      const node = this.createNode(NodeType.Debug);
      this.consumeToken();
      node.addChild(this._parseExpr());
      return this.finish(node);
    }
    _parseControlStatement(parseStatement = this._parseRuleSetDeclaration.bind(this)) {
      if (!this.peek(TokenType.AtKeyword)) {
        return null;
      }
      return this._parseIfStatement(parseStatement) || this._parseForStatement(parseStatement) || this._parseEachStatement(parseStatement) || this._parseWhileStatement(parseStatement);
    }
    _parseIfStatement(parseStatement) {
      if (!this.peekKeyword("@if")) {
        return null;
      }
      return this._internalParseIfStatement(parseStatement);
    }
    _internalParseIfStatement(parseStatement) {
      const node = this.create(IfStatement);
      this.consumeToken();
      if (!node.setExpression(this._parseExpr(true))) {
        return this.finish(node, ParseError.ExpressionExpected);
      }
      this._parseBody(node, parseStatement);
      if (this.acceptKeyword("@else")) {
        if (this.peekIdent("if")) {
          node.setElseClause(this._internalParseIfStatement(parseStatement));
        } else if (this.peek(TokenType.CurlyL)) {
          const elseNode = this.create(ElseStatement);
          this._parseBody(elseNode, parseStatement);
          node.setElseClause(elseNode);
        }
      }
      return this.finish(node);
    }
    _parseForStatement(parseStatement) {
      if (!this.peekKeyword("@for")) {
        return null;
      }
      const node = this.create(ForStatement);
      this.consumeToken();
      if (!node.setVariable(this._parseVariable())) {
        return this.finish(node, ParseError.VariableNameExpected, [TokenType.CurlyR]);
      }
      if (!this.acceptIdent("from")) {
        return this.finish(node, SCSSParseError.FromExpected, [TokenType.CurlyR]);
      }
      if (!node.addChild(this._parseBinaryExpr())) {
        return this.finish(node, ParseError.ExpressionExpected, [TokenType.CurlyR]);
      }
      if (!this.acceptIdent("to") && !this.acceptIdent("through")) {
        return this.finish(node, SCSSParseError.ThroughOrToExpected, [TokenType.CurlyR]);
      }
      if (!node.addChild(this._parseBinaryExpr())) {
        return this.finish(node, ParseError.ExpressionExpected, [TokenType.CurlyR]);
      }
      return this._parseBody(node, parseStatement);
    }
    _parseEachStatement(parseStatement) {
      if (!this.peekKeyword("@each")) {
        return null;
      }
      const node = this.create(EachStatement);
      this.consumeToken();
      const variables = node.getVariables();
      if (!variables.addChild(this._parseVariable())) {
        return this.finish(node, ParseError.VariableNameExpected, [TokenType.CurlyR]);
      }
      while (this.accept(TokenType.Comma)) {
        if (!variables.addChild(this._parseVariable())) {
          return this.finish(node, ParseError.VariableNameExpected, [TokenType.CurlyR]);
        }
      }
      this.finish(variables);
      if (!this.acceptIdent("in")) {
        return this.finish(node, SCSSParseError.InExpected, [TokenType.CurlyR]);
      }
      if (!node.addChild(this._parseExpr())) {
        return this.finish(node, ParseError.ExpressionExpected, [TokenType.CurlyR]);
      }
      return this._parseBody(node, parseStatement);
    }
    _parseWhileStatement(parseStatement) {
      if (!this.peekKeyword("@while")) {
        return null;
      }
      const node = this.create(WhileStatement);
      this.consumeToken();
      if (!node.addChild(this._parseBinaryExpr())) {
        return this.finish(node, ParseError.ExpressionExpected, [TokenType.CurlyR]);
      }
      return this._parseBody(node, parseStatement);
    }
    _parseFunctionBodyDeclaration() {
      return this._parseVariableDeclaration() || this._parseReturnStatement() || this._parseWarnAndDebug() || this._parseControlStatement(this._parseFunctionBodyDeclaration.bind(this));
    }
    _parseFunctionDeclaration() {
      if (!this.peekKeyword("@function")) {
        return null;
      }
      const node = this.create(FunctionDeclaration);
      this.consumeToken();
      if (!node.setIdentifier(this._parseIdent([ReferenceType.Function]))) {
        return this.finish(node, ParseError.IdentifierExpected, [TokenType.CurlyR]);
      }
      if (!this.accept(TokenType.ParenthesisL)) {
        return this.finish(node, ParseError.LeftParenthesisExpected, [TokenType.CurlyR]);
      }
      if (node.getParameters().addChild(this._parseParameterDeclaration())) {
        while (this.accept(TokenType.Comma)) {
          if (this.peek(TokenType.ParenthesisR)) {
            break;
          }
          if (!node.getParameters().addChild(this._parseParameterDeclaration())) {
            return this.finish(node, ParseError.VariableNameExpected);
          }
        }
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.CurlyR]);
      }
      return this._parseBody(node, this._parseFunctionBodyDeclaration.bind(this));
    }
    _parseReturnStatement() {
      if (!this.peekKeyword("@return")) {
        return null;
      }
      const node = this.createNode(NodeType.ReturnStatement);
      this.consumeToken();
      if (!node.addChild(this._parseExpr())) {
        return this.finish(node, ParseError.ExpressionExpected);
      }
      return this.finish(node);
    }
    _parseMixinDeclaration() {
      if (!this.peekKeyword("@mixin")) {
        return null;
      }
      const node = this.create(MixinDeclaration);
      this.consumeToken();
      if (!node.setIdentifier(this._parseIdent([ReferenceType.Mixin]))) {
        return this.finish(node, ParseError.IdentifierExpected, [TokenType.CurlyR]);
      }
      if (this.accept(TokenType.ParenthesisL)) {
        if (node.getParameters().addChild(this._parseParameterDeclaration())) {
          while (this.accept(TokenType.Comma)) {
            if (this.peek(TokenType.ParenthesisR)) {
              break;
            }
            if (!node.getParameters().addChild(this._parseParameterDeclaration())) {
              return this.finish(node, ParseError.VariableNameExpected);
            }
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.CurlyR]);
        }
      }
      return this._parseBody(node, this._parseRuleSetDeclaration.bind(this));
    }
    _parseParameterDeclaration() {
      const node = this.create(FunctionParameter);
      if (!node.setIdentifier(this._parseVariable())) {
        return null;
      }
      if (this.accept(Ellipsis)) {
      }
      if (this.accept(TokenType.Colon)) {
        if (!node.setDefaultValue(this._parseExpr(true))) {
          return this.finish(node, ParseError.VariableValueExpected, [], [TokenType.Comma, TokenType.ParenthesisR]);
        }
      }
      return this.finish(node);
    }
    _parseMixinContent() {
      if (!this.peekKeyword("@content")) {
        return null;
      }
      const node = this.create(MixinContentReference);
      this.consumeToken();
      if (this.accept(TokenType.ParenthesisL)) {
        if (node.getArguments().addChild(this._parseFunctionArgument())) {
          while (this.accept(TokenType.Comma)) {
            if (this.peek(TokenType.ParenthesisR)) {
              break;
            }
            if (!node.getArguments().addChild(this._parseFunctionArgument())) {
              return this.finish(node, ParseError.ExpressionExpected);
            }
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected);
        }
      }
      return this.finish(node);
    }
    _parseMixinReference() {
      if (!this.peekKeyword("@include")) {
        return null;
      }
      const node = this.create(MixinReference);
      this.consumeToken();
      const firstIdent = this._parseIdent([ReferenceType.Mixin]);
      if (!node.setIdentifier(firstIdent)) {
        return this.finish(node, ParseError.IdentifierExpected, [TokenType.CurlyR]);
      }
      if (!this.hasWhitespace() && this.acceptDelim(".") && !this.hasWhitespace()) {
        const secondIdent = this._parseIdent([ReferenceType.Mixin]);
        if (!secondIdent) {
          return this.finish(node, ParseError.IdentifierExpected, [TokenType.CurlyR]);
        }
        const moduleToken = this.create(Module);
        firstIdent.referenceTypes = [ReferenceType.Module];
        moduleToken.setIdentifier(firstIdent);
        node.setIdentifier(secondIdent);
        node.addChild(moduleToken);
      }
      if (this.accept(TokenType.ParenthesisL)) {
        if (node.getArguments().addChild(this._parseFunctionArgument())) {
          while (this.accept(TokenType.Comma)) {
            if (this.peek(TokenType.ParenthesisR)) {
              break;
            }
            if (!node.getArguments().addChild(this._parseFunctionArgument())) {
              return this.finish(node, ParseError.ExpressionExpected);
            }
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected);
        }
      }
      if (this.peekIdent("using") || this.peek(TokenType.CurlyL)) {
        node.setContent(this._parseMixinContentDeclaration());
      }
      return this.finish(node);
    }
    _parseMixinContentDeclaration() {
      const node = this.create(MixinContentDeclaration);
      if (this.acceptIdent("using")) {
        if (!this.accept(TokenType.ParenthesisL)) {
          return this.finish(node, ParseError.LeftParenthesisExpected, [TokenType.CurlyL]);
        }
        if (node.getParameters().addChild(this._parseParameterDeclaration())) {
          while (this.accept(TokenType.Comma)) {
            if (this.peek(TokenType.ParenthesisR)) {
              break;
            }
            if (!node.getParameters().addChild(this._parseParameterDeclaration())) {
              return this.finish(node, ParseError.VariableNameExpected);
            }
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.CurlyL]);
        }
      }
      if (this.peek(TokenType.CurlyL)) {
        this._parseBody(node, this._parseMixinReferenceBodyStatement.bind(this));
      }
      return this.finish(node);
    }
    _parseMixinReferenceBodyStatement() {
      return this._tryParseKeyframeSelector() || this._parseRuleSetDeclaration();
    }
    _parseFunctionArgument() {
      const node = this.create(FunctionArgument);
      const pos = this.mark();
      const argument = this._parseVariable();
      if (argument) {
        if (!this.accept(TokenType.Colon)) {
          if (this.accept(Ellipsis)) {
            node.setValue(argument);
            return this.finish(node);
          } else {
            this.restoreAtMark(pos);
          }
        } else {
          node.setIdentifier(argument);
        }
      }
      if (node.setValue(this._parseExpr(true))) {
        this.accept(Ellipsis);
        node.addChild(this._parsePrio());
        return this.finish(node);
      } else if (node.setValue(this._tryParsePrio())) {
        return this.finish(node);
      }
      return null;
    }
    _parseURLArgument() {
      const pos = this.mark();
      const node = super._parseURLArgument();
      if (!node || !this.peek(TokenType.ParenthesisR)) {
        this.restoreAtMark(pos);
        const node2 = this.create(Node);
        node2.addChild(this._parseBinaryExpr());
        return this.finish(node2);
      }
      return node;
    }
    _parseOperation() {
      if (!this.peek(TokenType.ParenthesisL)) {
        return null;
      }
      const node = this.create(Node);
      this.consumeToken();
      while (node.addChild(this._parseListElement())) {
        this.accept(TokenType.Comma);
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseListElement() {
      const node = this.create(ListEntry);
      const child = this._parseBinaryExpr();
      if (!child) {
        return null;
      }
      if (this.accept(TokenType.Colon)) {
        node.setKey(child);
        if (!node.setValue(this._parseBinaryExpr())) {
          return this.finish(node, ParseError.ExpressionExpected);
        }
      } else {
        node.setValue(child);
      }
      return this.finish(node);
    }
    _parseUse() {
      if (!this.peekKeyword("@use")) {
        return null;
      }
      const node = this.create(Use);
      this.consumeToken();
      if (!node.addChild(this._parseStringLiteral())) {
        return this.finish(node, ParseError.StringLiteralExpected);
      }
      if (!this.peek(TokenType.SemiColon) && !this.peek(TokenType.EOF)) {
        if (!this.peekRegExp(TokenType.Ident, /as|with/)) {
          return this.finish(node, ParseError.UnknownKeyword);
        }
        if (this.acceptIdent("as") && (!node.setIdentifier(this._parseIdent([ReferenceType.Module])) && !this.acceptDelim("*"))) {
          return this.finish(node, ParseError.IdentifierOrWildcardExpected);
        }
        if (this.acceptIdent("with")) {
          if (!this.accept(TokenType.ParenthesisL)) {
            return this.finish(node, ParseError.LeftParenthesisExpected, [TokenType.ParenthesisR]);
          }
          if (!node.getParameters().addChild(this._parseModuleConfigDeclaration())) {
            return this.finish(node, ParseError.VariableNameExpected);
          }
          while (this.accept(TokenType.Comma)) {
            if (this.peek(TokenType.ParenthesisR)) {
              break;
            }
            if (!node.getParameters().addChild(this._parseModuleConfigDeclaration())) {
              return this.finish(node, ParseError.VariableNameExpected);
            }
          }
          if (!this.accept(TokenType.ParenthesisR)) {
            return this.finish(node, ParseError.RightParenthesisExpected);
          }
        }
      }
      if (!this.accept(TokenType.SemiColon) && !this.accept(TokenType.EOF)) {
        return this.finish(node, ParseError.SemiColonExpected);
      }
      return this.finish(node);
    }
    _parseModuleConfigDeclaration() {
      const node = this.create(ModuleConfiguration);
      if (!node.setIdentifier(this._parseVariable())) {
        return null;
      }
      if (!this.accept(TokenType.Colon) || !node.setValue(this._parseExpr(true))) {
        return this.finish(node, ParseError.VariableValueExpected, [], [TokenType.Comma, TokenType.ParenthesisR]);
      }
      if (this.accept(TokenType.Exclamation)) {
        if (this.hasWhitespace() || !this.acceptIdent("default")) {
          return this.finish(node, ParseError.UnknownKeyword);
        }
      }
      return this.finish(node);
    }
    _parseForward() {
      if (!this.peekKeyword("@forward")) {
        return null;
      }
      const node = this.create(Forward);
      this.consumeToken();
      if (!node.addChild(this._parseStringLiteral())) {
        return this.finish(node, ParseError.StringLiteralExpected);
      }
      if (this.acceptIdent("as")) {
        const identifier = this._parseIdent([ReferenceType.Forward]);
        if (!node.setIdentifier(identifier)) {
          return this.finish(node, ParseError.IdentifierExpected);
        }
        if (this.hasWhitespace() || !this.acceptDelim("*")) {
          return this.finish(node, ParseError.WildcardExpected);
        }
      }
      if (this.acceptIdent("with")) {
        if (!this.accept(TokenType.ParenthesisL)) {
          return this.finish(node, ParseError.LeftParenthesisExpected, [TokenType.ParenthesisR]);
        }
        if (!node.getParameters().addChild(this._parseModuleConfigDeclaration())) {
          return this.finish(node, ParseError.VariableNameExpected);
        }
        while (this.accept(TokenType.Comma)) {
          if (this.peek(TokenType.ParenthesisR)) {
            break;
          }
          if (!node.getParameters().addChild(this._parseModuleConfigDeclaration())) {
            return this.finish(node, ParseError.VariableNameExpected);
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected);
        }
      } else if (this.peekIdent("hide") || this.peekIdent("show")) {
        if (!node.addChild(this._parseForwardVisibility())) {
          return this.finish(node, ParseError.IdentifierOrVariableExpected);
        }
      }
      if (!this.accept(TokenType.SemiColon) && !this.accept(TokenType.EOF)) {
        return this.finish(node, ParseError.SemiColonExpected);
      }
      return this.finish(node);
    }
    _parseForwardVisibility() {
      const node = this.create(ForwardVisibility);
      node.setIdentifier(this._parseIdent());
      while (node.addChild(this._parseVariable() || this._parseIdent())) {
        this.accept(TokenType.Comma);
      }
      return node.getChildren().length > 1 ? node : null;
    }
    _parseSupportsCondition() {
      return this._parseInterpolation() || super._parseSupportsCondition();
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/services/scssCompletion.js
  var sassDocumentationName = t("Sass documentation");
  var SCSSCompletion = class _SCSSCompletion extends CSSCompletion {
    constructor(lsServiceOptions, cssDataManager) {
      super("$", lsServiceOptions, cssDataManager);
      addReferencesToDocumentation(_SCSSCompletion.scssModuleLoaders);
      addReferencesToDocumentation(_SCSSCompletion.scssModuleBuiltIns);
    }
    isImportPathParent(type) {
      return type === NodeType.Forward || type === NodeType.Use || super.isImportPathParent(type);
    }
    getCompletionForImportPath(importPathNode, result) {
      const parentType = importPathNode.getParent().type;
      if (parentType === NodeType.Forward || parentType === NodeType.Use) {
        for (let p of _SCSSCompletion.scssModuleBuiltIns) {
          const item = {
            label: p.label,
            documentation: p.documentation,
            textEdit: TextEdit.replace(this.getCompletionRange(importPathNode), `'${p.label}'`),
            kind: CompletionItemKind.Module
          };
          result.items.push(item);
        }
      }
      return super.getCompletionForImportPath(importPathNode, result);
    }
    createReplaceFunction() {
      let tabStopCounter = 1;
      return (_match, p1) => {
        return "\\" + p1 + ": ${" + tabStopCounter++ + ":" + (_SCSSCompletion.variableDefaults[p1] || "") + "}";
      };
    }
    createFunctionProposals(proposals, existingNode, sortToEnd, result) {
      for (const p of proposals) {
        const insertText = p.func.replace(/\[?(\$\w+)\]?/g, this.createReplaceFunction());
        const label = p.func.substr(0, p.func.indexOf("("));
        const item = {
          label,
          detail: p.func,
          documentation: p.desc,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), insertText),
          insertTextFormat: InsertTextFormat.Snippet,
          kind: CompletionItemKind.Function
        };
        if (sortToEnd) {
          item.sortText = "z";
        }
        result.items.push(item);
      }
      return result;
    }
    getCompletionsForSelector(ruleSet, isNested, result) {
      this.createFunctionProposals(_SCSSCompletion.selectorFuncs, null, true, result);
      return super.getCompletionsForSelector(ruleSet, isNested, result);
    }
    getTermProposals(entry, existingNode, result) {
      let functions = _SCSSCompletion.builtInFuncs;
      if (entry) {
        functions = functions.filter((f2) => !f2.type || !entry.restrictions || entry.restrictions.indexOf(f2.type) !== -1);
      }
      this.createFunctionProposals(functions, existingNode, true, result);
      return super.getTermProposals(entry, existingNode, result);
    }
    getColorProposals(entry, existingNode, result) {
      this.createFunctionProposals(_SCSSCompletion.colorProposals, existingNode, false, result);
      return super.getColorProposals(entry, existingNode, result);
    }
    getCompletionsForDeclarationProperty(declaration, result) {
      this.getCompletionForAtDirectives(result);
      this.getCompletionsForSelector(null, true, result);
      return super.getCompletionsForDeclarationProperty(declaration, result);
    }
    getCompletionsForExtendsReference(_extendsRef, existingNode, result) {
      const symbols = this.getSymbolContext().findSymbolsAtOffset(this.offset, ReferenceType.Rule);
      for (const symbol of symbols) {
        const suggest = {
          label: symbol.name,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), symbol.name),
          kind: CompletionItemKind.Function
        };
        result.items.push(suggest);
      }
      return result;
    }
    getCompletionForAtDirectives(result) {
      result.items.push(..._SCSSCompletion.scssAtDirectives);
      return result;
    }
    getCompletionForTopLevel(result) {
      this.getCompletionForAtDirectives(result);
      this.getCompletionForModuleLoaders(result);
      super.getCompletionForTopLevel(result);
      return result;
    }
    getCompletionForModuleLoaders(result) {
      result.items.push(..._SCSSCompletion.scssModuleLoaders);
      return result;
    }
  };
  SCSSCompletion.variableDefaults = {
    "$red": "1",
    "$green": "2",
    "$blue": "3",
    "$alpha": "1.0",
    "$color": "#000000",
    "$weight": "0.5",
    "$hue": "0",
    "$saturation": "0%",
    "$lightness": "0%",
    "$degrees": "0",
    "$amount": "0",
    "$string": '""',
    "$substring": '"s"',
    "$number": "0",
    "$limit": "1"
  };
  SCSSCompletion.colorProposals = [
    { func: "red($color)", desc: t("Gets the red component of a color.") },
    { func: "green($color)", desc: t("Gets the green component of a color.") },
    { func: "blue($color)", desc: t("Gets the blue component of a color.") },
    { func: "mix($color, $color, [$weight])", desc: t("Mixes two colors together.") },
    { func: "hue($color)", desc: t("Gets the hue component of a color.") },
    { func: "saturation($color)", desc: t("Gets the saturation component of a color.") },
    { func: "lightness($color)", desc: t("Gets the lightness component of a color.") },
    { func: "adjust-hue($color, $degrees)", desc: t("Changes the hue of a color.") },
    { func: "lighten($color, $amount)", desc: t("Makes a color lighter.") },
    { func: "darken($color, $amount)", desc: t("Makes a color darker.") },
    { func: "saturate($color, $amount)", desc: t("Makes a color more saturated.") },
    { func: "desaturate($color, $amount)", desc: t("Makes a color less saturated.") },
    { func: "grayscale($color)", desc: t("Converts a color to grayscale.") },
    { func: "complement($color)", desc: t("Returns the complement of a color.") },
    { func: "invert($color)", desc: t("Returns the inverse of a color.") },
    { func: "alpha($color)", desc: t("Gets the opacity component of a color.") },
    { func: "opacity($color)", desc: "Gets the alpha component (opacity) of a color." },
    { func: "rgba($color, $alpha)", desc: t("Changes the alpha component for a color.") },
    { func: "opacify($color, $amount)", desc: t("Makes a color more opaque.") },
    { func: "fade-in($color, $amount)", desc: t("Makes a color more opaque.") },
    { func: "transparentize($color, $amount)", desc: t("Makes a color more transparent.") },
    { func: "fade-out($color, $amount)", desc: t("Makes a color more transparent.") },
    { func: "adjust-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])", desc: t("Increases or decreases one or more components of a color.") },
    { func: "scale-color($color, [$red], [$green], [$blue], [$saturation], [$lightness], [$alpha])", desc: t("Fluidly scales one or more properties of a color.") },
    { func: "change-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])", desc: t("Changes one or more properties of a color.") },
    { func: "ie-hex-str($color)", desc: t("Converts a color into the format understood by IE filters.") }
  ];
  SCSSCompletion.selectorFuncs = [
    { func: "selector-nest($selectors\u2026)", desc: t("Nests selector beneath one another like they would be nested in the stylesheet.") },
    { func: "selector-append($selectors\u2026)", desc: t("Appends selectors to one another without spaces in between.") },
    { func: "selector-extend($selector, $extendee, $extender)", desc: t("Extends $extendee with $extender within $selector.") },
    { func: "selector-replace($selector, $original, $replacement)", desc: t("Replaces $original with $replacement within $selector.") },
    { func: "selector-unify($selector1, $selector2)", desc: t("Unifies two selectors to produce a selector that matches elements matched by both.") },
    { func: "is-superselector($super, $sub)", desc: t("Returns whether $super matches all the elements $sub does, and possibly more.") },
    { func: "simple-selectors($selector)", desc: t("Returns the simple selectors that comprise a compound selector.") },
    { func: "selector-parse($selector)", desc: t("Parses a selector into the format returned by &.") }
  ];
  SCSSCompletion.builtInFuncs = [
    { func: "unquote($string)", desc: t("Removes quotes from a string.") },
    { func: "quote($string)", desc: t("Adds quotes to a string.") },
    { func: "str-length($string)", desc: t("Returns the number of characters in a string.") },
    { func: "str-insert($string, $insert, $index)", desc: t("Inserts $insert into $string at $index.") },
    { func: "str-index($string, $substring)", desc: t("Returns the index of the first occurance of $substring in $string.") },
    { func: "str-slice($string, $start-at, [$end-at])", desc: t("Extracts a substring from $string.") },
    { func: "to-upper-case($string)", desc: t("Converts a string to upper case.") },
    { func: "to-lower-case($string)", desc: t("Converts a string to lower case.") },
    { func: "percentage($number)", desc: t("Converts a unitless number to a percentage."), type: "percentage" },
    { func: "round($number)", desc: t("Rounds a number to the nearest whole number.") },
    { func: "ceil($number)", desc: t("Rounds a number up to the next whole number.") },
    { func: "floor($number)", desc: t("Rounds a number down to the previous whole number.") },
    { func: "abs($number)", desc: t("Returns the absolute value of a number.") },
    { func: "min($numbers)", desc: t("Finds the minimum of several numbers.") },
    { func: "max($numbers)", desc: t("Finds the maximum of several numbers.") },
    { func: "random([$limit])", desc: t("Returns a random number.") },
    { func: "length($list)", desc: t("Returns the length of a list.") },
    { func: "nth($list, $n)", desc: t("Returns a specific item in a list.") },
    { func: "set-nth($list, $n, $value)", desc: t("Replaces the nth item in a list.") },
    { func: "join($list1, $list2, [$separator])", desc: t("Joins together two lists into one.") },
    { func: "append($list1, $val, [$separator])", desc: t("Appends a single value onto the end of a list.") },
    { func: "zip($lists)", desc: t("Combines several lists into a single multidimensional list.") },
    { func: "index($list, $value)", desc: t("Returns the position of a value within a list.") },
    { func: "list-separator(#list)", desc: t("Returns the separator of a list.") },
    { func: "map-get($map, $key)", desc: t("Returns the value in a map associated with a given key.") },
    { func: "map-merge($map1, $map2)", desc: t("Merges two maps together into a new map.") },
    { func: "map-remove($map, $keys)", desc: t("Returns a new map with keys removed.") },
    { func: "map-keys($map)", desc: t("Returns a list of all keys in a map.") },
    { func: "map-values($map)", desc: t("Returns a list of all values in a map.") },
    { func: "map-has-key($map, $key)", desc: t("Returns whether a map has a value associated with a given key.") },
    { func: "keywords($args)", desc: t("Returns the keywords passed to a function that takes variable arguments.") },
    { func: "feature-exists($feature)", desc: t("Returns whether a feature exists in the current Sass runtime.") },
    { func: "variable-exists($name)", desc: t("Returns whether a variable with the given name exists in the current scope.") },
    { func: "global-variable-exists($name)", desc: t("Returns whether a variable with the given name exists in the global scope.") },
    { func: "function-exists($name)", desc: t("Returns whether a function with the given name exists.") },
    { func: "mixin-exists($name)", desc: t("Returns whether a mixin with the given name exists.") },
    { func: "inspect($value)", desc: t("Returns the string representation of a value as it would be represented in Sass.") },
    { func: "type-of($value)", desc: t("Returns the type of a value.") },
    { func: "unit($number)", desc: t("Returns the unit(s) associated with a number.") },
    { func: "unitless($number)", desc: t("Returns whether a number has units.") },
    { func: "comparable($number1, $number2)", desc: t("Returns whether two numbers can be added, subtracted, or compared.") },
    { func: "call($name, $args\u2026)", desc: t("Dynamically calls a Sass function.") }
  ];
  SCSSCompletion.scssAtDirectives = [
    {
      label: "@extend",
      documentation: t("Inherits the styles of another selector."),
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@at-root",
      documentation: t("Causes one or more rules to be emitted at the root of the document."),
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@debug",
      documentation: t("Prints the value of an expression to the standard error output stream. Useful for debugging complicated Sass files."),
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@warn",
      documentation: t("Prints the value of an expression to the standard error output stream. Useful for libraries that need to warn users of deprecations or recovering from minor mixin usage mistakes. Warnings can be turned off with the `--quiet` command-line option or the `:quiet` Sass option."),
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@error",
      documentation: t("Throws the value of an expression as a fatal error with stack trace. Useful for validating arguments to mixins and functions."),
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@if",
      documentation: t("Includes the body if the expression does not evaluate to `false` or `null`."),
      insertText: "@if ${1:expr} {\n	$0\n}",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@for",
      documentation: t("For loop that repeatedly outputs a set of styles for each `$var` in the `from/through` or `from/to` clause."),
      insertText: "@for \\$${1:var} from ${2:start} ${3|to,through|} ${4:end} {\n	$0\n}",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@each",
      documentation: t("Each loop that sets `$var` to each item in the list or map, then outputs the styles it contains using that value of `$var`."),
      insertText: "@each \\$${1:var} in ${2:list} {\n	$0\n}",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@while",
      documentation: t("While loop that takes an expression and repeatedly outputs the nested styles until the statement evaluates to `false`."),
      insertText: "@while ${1:condition} {\n	$0\n}",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@mixin",
      documentation: t("Defines styles that can be re-used throughout the stylesheet with `@include`."),
      insertText: "@mixin ${1:name} {\n	$0\n}",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@include",
      documentation: t("Includes the styles defined by another mixin into the current rule."),
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@function",
      documentation: t("Defines complex operations that can be re-used throughout stylesheets."),
      kind: CompletionItemKind.Keyword
    }
  ];
  SCSSCompletion.scssModuleLoaders = [
    {
      label: "@use",
      documentation: t("Loads mixins, functions, and variables from other Sass stylesheets as 'modules', and combines CSS from multiple stylesheets together."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/at-rules/use" }],
      insertText: "@use $0;",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    },
    {
      label: "@forward",
      documentation: t("Loads a Sass stylesheet and makes its mixins, functions, and variables available when this stylesheet is loaded with the @use rule."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/at-rules/forward" }],
      insertText: "@forward $0;",
      insertTextFormat: InsertTextFormat.Snippet,
      kind: CompletionItemKind.Keyword
    }
  ];
  SCSSCompletion.scssModuleBuiltIns = [
    {
      label: "sass:math",
      documentation: t("Provides functions that operate on numbers."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/math" }]
    },
    {
      label: "sass:string",
      documentation: t("Makes it easy to combine, search, or split apart strings."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/string" }]
    },
    {
      label: "sass:color",
      documentation: t("Generates new colors based on existing ones, making it easy to build color themes."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/color" }]
    },
    {
      label: "sass:list",
      documentation: t("Lets you access and modify values in lists."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/list" }]
    },
    {
      label: "sass:map",
      documentation: t("Makes it possible to look up the value associated with a key in a map, and much more."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/map" }]
    },
    {
      label: "sass:selector",
      documentation: t("Provides access to Sass\u2019s powerful selector engine."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/selector" }]
    },
    {
      label: "sass:meta",
      documentation: t("Exposes the details of Sass\u2019s inner workings."),
      references: [{ name: sassDocumentationName, url: "https://sass-lang.com/documentation/modules/meta" }]
    }
  ];
  function addReferencesToDocumentation(items) {
    items.forEach((i) => {
      if (i.documentation && i.references && i.references.length > 0) {
        const markdownDoc = typeof i.documentation === "string" ? { kind: "markdown", value: i.documentation } : { kind: "markdown", value: i.documentation.value };
        markdownDoc.value += "\n\n";
        markdownDoc.value += i.references.map((r) => {
          return `[${r.name}](${r.url})`;
        }).join(" | ");
        i.documentation = markdownDoc;
      }
    });
  }

  // node_modules/vscode-css-languageservice/lib/esm/parser/lessScanner.js
  var _FSL3 = "/".charCodeAt(0);
  var _NWL3 = "\n".charCodeAt(0);
  var _CAR3 = "\r".charCodeAt(0);
  var _LFD3 = "\f".charCodeAt(0);
  var _TIC = "`".charCodeAt(0);
  var _DOT3 = ".".charCodeAt(0);
  var customTokenValue2 = TokenType.CustomToken;
  var Ellipsis2 = customTokenValue2++;
  var LESSScanner = class extends Scanner {
    scanNext(offset) {
      const tokenType = this.escapedJavaScript();
      if (tokenType !== null) {
        return this.finishToken(offset, tokenType);
      }
      if (this.stream.advanceIfChars([_DOT3, _DOT3, _DOT3])) {
        return this.finishToken(offset, Ellipsis2);
      }
      return super.scanNext(offset);
    }
    comment() {
      if (super.comment()) {
        return true;
      }
      if (!this.inURL && this.stream.advanceIfChars([_FSL3, _FSL3])) {
        this.stream.advanceWhileChar((ch) => {
          switch (ch) {
            case _NWL3:
            case _CAR3:
            case _LFD3:
              return false;
            default:
              return true;
          }
        });
        return true;
      } else {
        return false;
      }
    }
    escapedJavaScript() {
      const ch = this.stream.peekChar();
      if (ch === _TIC) {
        this.stream.advance(1);
        this.stream.advanceWhileChar((ch2) => {
          return ch2 !== _TIC;
        });
        return this.stream.advanceIfChar(_TIC) ? TokenType.EscapedJavaScript : TokenType.BadEscapedJavaScript;
      }
      return null;
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/parser/lessParser.js
  var LESSParser = class extends Parser {
    constructor() {
      super(new LESSScanner());
    }
    _parseStylesheetStatement(isNested = false) {
      if (this.peek(TokenType.AtKeyword)) {
        return this._parseVariableDeclaration() || this._parsePlugin() || super._parseStylesheetAtStatement(isNested);
      }
      return this._tryParseMixinDeclaration() || this._tryParseMixinReference() || this._parseFunction() || this._parseRuleset(true);
    }
    _parseImport() {
      if (!this.peekKeyword("@import") && !this.peekKeyword("@import-once")) {
        return null;
      }
      const node = this.create(Import);
      this.consumeToken();
      if (this.accept(TokenType.ParenthesisL)) {
        if (!this.accept(TokenType.Ident)) {
          return this.finish(node, ParseError.IdentifierExpected, [TokenType.SemiColon]);
        }
        do {
          if (!this.accept(TokenType.Comma)) {
            break;
          }
        } while (this.accept(TokenType.Ident));
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected, [TokenType.SemiColon]);
        }
      }
      if (!node.addChild(this._parseURILiteral()) && !node.addChild(this._parseStringLiteral())) {
        return this.finish(node, ParseError.URIOrStringExpected, [TokenType.SemiColon]);
      }
      if (!this.peek(TokenType.SemiColon) && !this.peek(TokenType.EOF)) {
        node.setMedialist(this._parseMediaQueryList());
      }
      return this._completeParseImport(node);
    }
    _parsePlugin() {
      if (!this.peekKeyword("@plugin")) {
        return null;
      }
      const node = this.createNode(NodeType.Plugin);
      this.consumeToken();
      if (!node.addChild(this._parseStringLiteral())) {
        return this.finish(node, ParseError.StringLiteralExpected);
      }
      if (!this.accept(TokenType.SemiColon)) {
        return this.finish(node, ParseError.SemiColonExpected);
      }
      return this.finish(node);
    }
    _parseMediaQuery() {
      const node = super._parseMediaQuery();
      if (!node) {
        const node2 = this.create(MediaQuery);
        if (node2.addChild(this._parseVariable())) {
          return this.finish(node2);
        }
        return null;
      }
      return node;
    }
    _parseMediaDeclaration(isNested = false) {
      return this._tryParseRuleset(isNested) || this._tryToParseDeclaration() || this._tryParseMixinDeclaration() || this._tryParseMixinReference() || this._parseDetachedRuleSetMixin() || this._parseStylesheetStatement(isNested);
    }
    _parseMediaFeatureName() {
      return this._parseIdent() || this._parseVariable();
    }
    _parseVariableDeclaration(panic = []) {
      const node = this.create(VariableDeclaration);
      const mark = this.mark();
      if (!node.setVariable(this._parseVariable(true))) {
        return null;
      }
      if (this.accept(TokenType.Colon)) {
        if (this.prevToken) {
          node.colonPosition = this.prevToken.offset;
        }
        if (node.setValue(this._parseDetachedRuleSet())) {
          node.needsSemicolon = false;
        } else if (!node.setValue(this._parseExpr())) {
          return this.finish(node, ParseError.VariableValueExpected, [], panic);
        }
        node.addChild(this._parsePrio());
      } else {
        this.restoreAtMark(mark);
        return null;
      }
      if (this.peek(TokenType.SemiColon)) {
        node.semicolonPosition = this.token.offset;
      }
      return this.finish(node);
    }
    _parseDetachedRuleSet() {
      let mark = this.mark();
      if (this.peekDelim("#") || this.peekDelim(".")) {
        this.consumeToken();
        if (!this.hasWhitespace() && this.accept(TokenType.ParenthesisL)) {
          let node = this.create(MixinDeclaration);
          if (node.getParameters().addChild(this._parseMixinParameter())) {
            while (this.accept(TokenType.Comma) || this.accept(TokenType.SemiColon)) {
              if (this.peek(TokenType.ParenthesisR)) {
                break;
              }
              if (!node.getParameters().addChild(this._parseMixinParameter())) {
                this.markError(node, ParseError.IdentifierExpected, [], [TokenType.ParenthesisR]);
              }
            }
          }
          if (!this.accept(TokenType.ParenthesisR)) {
            this.restoreAtMark(mark);
            return null;
          }
        } else {
          this.restoreAtMark(mark);
          return null;
        }
      }
      if (!this.peek(TokenType.CurlyL)) {
        return null;
      }
      const content = this.create(BodyDeclaration);
      this._parseBody(content, this._parseDetachedRuleSetBody.bind(this));
      return this.finish(content);
    }
    _parseDetachedRuleSetBody() {
      return this._tryParseKeyframeSelector() || this._parseRuleSetDeclaration();
    }
    _addLookupChildren(node) {
      if (!node.addChild(this._parseLookupValue())) {
        return false;
      }
      let expectsValue = false;
      while (true) {
        if (this.peek(TokenType.BracketL)) {
          expectsValue = true;
        }
        if (!node.addChild(this._parseLookupValue())) {
          break;
        }
        expectsValue = false;
      }
      return !expectsValue;
    }
    _parseLookupValue() {
      const node = this.create(Node);
      const mark = this.mark();
      if (!this.accept(TokenType.BracketL)) {
        this.restoreAtMark(mark);
        return null;
      }
      if ((node.addChild(this._parseVariable(false, true)) || node.addChild(this._parsePropertyIdentifier())) && this.accept(TokenType.BracketR) || this.accept(TokenType.BracketR)) {
        return node;
      }
      this.restoreAtMark(mark);
      return null;
    }
    _parseVariable(declaration = false, insideLookup = false) {
      const isPropertyReference = !declaration && this.peekDelim("$");
      if (!this.peekDelim("@") && !isPropertyReference && !this.peek(TokenType.AtKeyword)) {
        return null;
      }
      const node = this.create(Variable);
      const mark = this.mark();
      while (this.acceptDelim("@") || !declaration && this.acceptDelim("$")) {
        if (this.hasWhitespace()) {
          this.restoreAtMark(mark);
          return null;
        }
      }
      if (!this.accept(TokenType.AtKeyword) && !this.accept(TokenType.Ident)) {
        this.restoreAtMark(mark);
        return null;
      }
      if (!insideLookup && this.peek(TokenType.BracketL)) {
        if (!this._addLookupChildren(node)) {
          this.restoreAtMark(mark);
          return null;
        }
      }
      return node;
    }
    _parseTermExpression() {
      return this._parseVariable() || this._parseEscaped() || super._parseTermExpression() || // preference for colors before mixin references
      this._tryParseMixinReference(false);
    }
    _parseEscaped() {
      if (this.peek(TokenType.EscapedJavaScript) || this.peek(TokenType.BadEscapedJavaScript)) {
        const node = this.createNode(NodeType.EscapedValue);
        this.consumeToken();
        return this.finish(node);
      }
      if (this.peekDelim("~")) {
        const node = this.createNode(NodeType.EscapedValue);
        this.consumeToken();
        if (this.accept(TokenType.String) || this.accept(TokenType.EscapedJavaScript)) {
          return this.finish(node);
        } else {
          return this.finish(node, ParseError.TermExpected);
        }
      }
      return null;
    }
    _parseOperator() {
      const node = this._parseGuardOperator();
      if (node) {
        return node;
      } else {
        return super._parseOperator();
      }
    }
    _parseGuardOperator() {
      if (this.peekDelim(">")) {
        const node = this.createNode(NodeType.Operator);
        this.consumeToken();
        this.acceptDelim("=");
        return node;
      } else if (this.peekDelim("=")) {
        const node = this.createNode(NodeType.Operator);
        this.consumeToken();
        this.acceptDelim("<");
        return node;
      } else if (this.peekDelim("<")) {
        const node = this.createNode(NodeType.Operator);
        this.consumeToken();
        this.acceptDelim("=");
        return node;
      }
      return null;
    }
    _parseRuleSetDeclaration() {
      if (this.peek(TokenType.AtKeyword)) {
        return this._parseKeyframe() || this._parseMedia(true) || this._parseImport() || this._parseSupports(true) || this._parseLayer() || this._parsePropertyAtRule() || this._parseContainer(true) || this._parseDetachedRuleSetMixin() || this._parseVariableDeclaration() || this._parseRuleSetDeclarationAtStatement();
      }
      return this._tryParseMixinDeclaration() || this._tryParseRuleset(true) || this._tryParseMixinReference() || this._parseFunction() || this._parseExtend() || this._parseDeclaration();
    }
    _parseKeyframeIdent() {
      return this._parseIdent([ReferenceType.Keyframe]) || this._parseVariable();
    }
    _parseKeyframeSelector() {
      return this._parseDetachedRuleSetMixin() || super._parseKeyframeSelector();
    }
    // public _parseSimpleSelectorBody(): nodes.Node | null {
    // 	return this._parseNestingSelector() || super._parseSimpleSelectorBody();
    // }
    _parseSelector(isNested) {
      const node = this.create(Selector);
      let hasContent = false;
      if (isNested) {
        hasContent = node.addChild(this._parseCombinator());
      }
      while (node.addChild(this._parseSimpleSelector())) {
        hasContent = true;
        const mark = this.mark();
        if (node.addChild(this._parseGuard()) && this.peek(TokenType.CurlyL)) {
          break;
        }
        this.restoreAtMark(mark);
        node.addChild(this._parseCombinator());
      }
      return hasContent ? this.finish(node) : null;
    }
    _parseNestingSelector() {
      if (this.peekDelim("&")) {
        const node = this.createNode(NodeType.SelectorCombinator);
        this.consumeToken();
        while (!this.hasWhitespace() && (this.acceptDelim("-") || this.accept(TokenType.Num) || this.accept(TokenType.Dimension) || node.addChild(this._parseIdent()) || this.acceptDelim("&"))) {
        }
        return this.finish(node);
      }
      return null;
    }
    _parseSelectorIdent() {
      if (!this.peekInterpolatedIdent()) {
        return null;
      }
      const node = this.createNode(NodeType.SelectorInterpolation);
      const hasContent = this._acceptInterpolatedIdent(node);
      return hasContent ? this.finish(node) : null;
    }
    _parsePropertyIdentifier(inLookup = false) {
      const propertyRegex = /^[\w-]+/;
      if (!this.peekInterpolatedIdent() && !this.peekRegExp(this.token.type, propertyRegex)) {
        return null;
      }
      const mark = this.mark();
      const node = this.create(Identifier);
      node.isCustomProperty = this.acceptDelim("-") && this.acceptDelim("-");
      let childAdded = false;
      if (!inLookup) {
        if (node.isCustomProperty) {
          childAdded = this._acceptInterpolatedIdent(node);
        } else {
          childAdded = this._acceptInterpolatedIdent(node, propertyRegex);
        }
      } else {
        if (node.isCustomProperty) {
          childAdded = node.addChild(this._parseIdent());
        } else {
          childAdded = node.addChild(this._parseRegexp(propertyRegex));
        }
      }
      if (!childAdded) {
        this.restoreAtMark(mark);
        return null;
      }
      if (!inLookup && !this.hasWhitespace()) {
        this.acceptDelim("+");
        if (!this.hasWhitespace()) {
          this.acceptIdent("_");
        }
      }
      return this.finish(node);
    }
    peekInterpolatedIdent() {
      return this.peek(TokenType.Ident) || this.peekDelim("@") || this.peekDelim("$") || this.peekDelim("-");
    }
    _acceptInterpolatedIdent(node, identRegex) {
      let hasContent = false;
      const indentInterpolation = () => {
        const pos = this.mark();
        if (this.acceptDelim("-")) {
          if (!this.hasWhitespace()) {
            this.acceptDelim("-");
          }
          if (this.hasWhitespace()) {
            this.restoreAtMark(pos);
            return null;
          }
        }
        return this._parseInterpolation();
      };
      const accept = identRegex ? () => this.acceptRegexp(identRegex) : () => this.accept(TokenType.Ident);
      while (accept() || node.addChild(this._parseInterpolation() || this.try(indentInterpolation))) {
        hasContent = true;
        if (this.hasWhitespace()) {
          break;
        }
      }
      return hasContent;
    }
    _parseInterpolation() {
      const mark = this.mark();
      if (this.peekDelim("@") || this.peekDelim("$")) {
        const node = this.createNode(NodeType.Interpolation);
        this.consumeToken();
        if (this.hasWhitespace() || !this.accept(TokenType.CurlyL)) {
          this.restoreAtMark(mark);
          return null;
        }
        if (!node.addChild(this._parseIdent())) {
          return this.finish(node, ParseError.IdentifierExpected);
        }
        if (!this.accept(TokenType.CurlyR)) {
          return this.finish(node, ParseError.RightCurlyExpected);
        }
        return this.finish(node);
      }
      return null;
    }
    _tryParseMixinDeclaration() {
      const mark = this.mark();
      const node = this.create(MixinDeclaration);
      if (!node.setIdentifier(this._parseMixinDeclarationIdentifier()) || !this.accept(TokenType.ParenthesisL)) {
        this.restoreAtMark(mark);
        return null;
      }
      if (node.getParameters().addChild(this._parseMixinParameter())) {
        while (this.accept(TokenType.Comma) || this.accept(TokenType.SemiColon)) {
          if (this.peek(TokenType.ParenthesisR)) {
            break;
          }
          if (!node.getParameters().addChild(this._parseMixinParameter())) {
            this.markError(node, ParseError.IdentifierExpected, [], [TokenType.ParenthesisR]);
          }
        }
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        this.restoreAtMark(mark);
        return null;
      }
      node.setGuard(this._parseGuard());
      if (!this.peek(TokenType.CurlyL)) {
        this.restoreAtMark(mark);
        return null;
      }
      return this._parseBody(node, this._parseMixInBodyDeclaration.bind(this));
    }
    _parseMixInBodyDeclaration() {
      return this._parseFontFace() || this._parseRuleSetDeclaration();
    }
    _parseMixinDeclarationIdentifier() {
      let identifier;
      if (this.peekDelim("#") || this.peekDelim(".")) {
        identifier = this.create(Identifier);
        this.consumeToken();
        if (this.hasWhitespace() || !identifier.addChild(this._parseIdent())) {
          return null;
        }
      } else if (this.peek(TokenType.Hash)) {
        identifier = this.create(Identifier);
        this.consumeToken();
      } else {
        return null;
      }
      identifier.referenceTypes = [ReferenceType.Mixin];
      return this.finish(identifier);
    }
    _parsePseudo() {
      if (!this.peek(TokenType.Colon)) {
        return null;
      }
      const mark = this.mark();
      const node = this.create(ExtendsReference);
      this.consumeToken();
      if (this.acceptIdent("extend")) {
        return this._completeExtends(node);
      }
      this.restoreAtMark(mark);
      return super._parsePseudo();
    }
    _parseExtend() {
      if (!this.peekDelim("&")) {
        return null;
      }
      const mark = this.mark();
      const node = this.create(ExtendsReference);
      this.consumeToken();
      if (this.hasWhitespace() || !this.accept(TokenType.Colon) || !this.acceptIdent("extend")) {
        this.restoreAtMark(mark);
        return null;
      }
      return this._completeExtends(node);
    }
    _completeExtends(node) {
      if (!this.accept(TokenType.ParenthesisL)) {
        return this.finish(node, ParseError.LeftParenthesisExpected);
      }
      const selectors = node.getSelectors();
      if (!selectors.addChild(this._parseSelector(true))) {
        return this.finish(node, ParseError.SelectorExpected);
      }
      while (this.accept(TokenType.Comma)) {
        if (!selectors.addChild(this._parseSelector(true))) {
          return this.finish(node, ParseError.SelectorExpected);
        }
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseDetachedRuleSetMixin() {
      if (!this.peek(TokenType.AtKeyword)) {
        return null;
      }
      const mark = this.mark();
      const node = this.create(MixinReference);
      if (node.addChild(this._parseVariable(true)) && (this.hasWhitespace() || !this.accept(TokenType.ParenthesisL))) {
        this.restoreAtMark(mark);
        return null;
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _tryParseMixinReference(atRoot = true) {
      const mark = this.mark();
      const node = this.create(MixinReference);
      let identifier = this._parseMixinDeclarationIdentifier();
      while (identifier) {
        this.acceptDelim(">");
        const nextId = this._parseMixinDeclarationIdentifier();
        if (nextId) {
          node.getNamespaces().addChild(identifier);
          identifier = nextId;
        } else {
          break;
        }
      }
      if (!node.setIdentifier(identifier)) {
        this.restoreAtMark(mark);
        return null;
      }
      let hasArguments = false;
      if (this.accept(TokenType.ParenthesisL)) {
        hasArguments = true;
        if (node.getArguments().addChild(this._parseMixinArgument())) {
          while (this.accept(TokenType.Comma) || this.accept(TokenType.SemiColon)) {
            if (this.peek(TokenType.ParenthesisR)) {
              break;
            }
            if (!node.getArguments().addChild(this._parseMixinArgument())) {
              return this.finish(node, ParseError.ExpressionExpected);
            }
          }
        }
        if (!this.accept(TokenType.ParenthesisR)) {
          return this.finish(node, ParseError.RightParenthesisExpected);
        }
        identifier.referenceTypes = [ReferenceType.Mixin];
      } else {
        identifier.referenceTypes = [ReferenceType.Mixin, ReferenceType.Rule];
      }
      if (this.peek(TokenType.BracketL)) {
        if (!atRoot) {
          this._addLookupChildren(node);
        }
      } else {
        node.addChild(this._parsePrio());
      }
      if (!hasArguments && !this.peek(TokenType.SemiColon) && !this.peek(TokenType.CurlyR) && !this.peek(TokenType.EOF)) {
        this.restoreAtMark(mark);
        return null;
      }
      return this.finish(node);
    }
    _parseMixinArgument() {
      const node = this.create(FunctionArgument);
      const pos = this.mark();
      const argument = this._parseVariable();
      if (argument) {
        if (!this.accept(TokenType.Colon)) {
          this.restoreAtMark(pos);
        } else {
          node.setIdentifier(argument);
        }
      }
      if (node.setValue(this._parseDetachedRuleSet() || this._parseExpr(true))) {
        return this.finish(node);
      }
      this.restoreAtMark(pos);
      return null;
    }
    _parseMixinParameter() {
      const node = this.create(FunctionParameter);
      if (this.peekKeyword("@rest")) {
        const restNode = this.create(Node);
        this.consumeToken();
        if (!this.accept(Ellipsis2)) {
          return this.finish(node, ParseError.DotExpected, [], [TokenType.Comma, TokenType.ParenthesisR]);
        }
        node.setIdentifier(this.finish(restNode));
        return this.finish(node);
      }
      if (this.peek(Ellipsis2)) {
        const varargsNode = this.create(Node);
        this.consumeToken();
        node.setIdentifier(this.finish(varargsNode));
        return this.finish(node);
      }
      let hasContent = false;
      if (node.setIdentifier(this._parseVariable())) {
        this.accept(TokenType.Colon);
        hasContent = true;
      }
      if (!node.setDefaultValue(this._parseDetachedRuleSet() || this._parseExpr(true)) && !hasContent) {
        return null;
      }
      return this.finish(node);
    }
    _parseGuard() {
      if (!this.peekIdent("when")) {
        return null;
      }
      const node = this.create(LessGuard);
      this.consumeToken();
      if (!node.getConditions().addChild(this._parseGuardCondition())) {
        return this.finish(node, ParseError.ConditionExpected);
      }
      while (this.acceptIdent("and") || this.accept(TokenType.Comma)) {
        if (!node.getConditions().addChild(this._parseGuardCondition())) {
          return this.finish(node, ParseError.ConditionExpected);
        }
      }
      return this.finish(node);
    }
    _parseGuardCondition() {
      const node = this.create(GuardCondition);
      node.isNegated = this.acceptIdent("not");
      if (!this.accept(TokenType.ParenthesisL)) {
        if (node.isNegated) {
          return this.finish(node, ParseError.LeftParenthesisExpected);
        }
        return null;
      }
      if (!node.addChild(this._parseExpr())) {
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseFunction() {
      const pos = this.mark();
      const node = this.create(Function);
      if (!node.setIdentifier(this._parseFunctionIdentifier())) {
        return null;
      }
      if (this.hasWhitespace() || !this.accept(TokenType.ParenthesisL)) {
        this.restoreAtMark(pos);
        return null;
      }
      if (node.getArguments().addChild(this._parseMixinArgument())) {
        while (this.accept(TokenType.Comma) || this.accept(TokenType.SemiColon)) {
          if (this.peek(TokenType.ParenthesisR)) {
            break;
          }
          if (!node.getArguments().addChild(this._parseMixinArgument())) {
            return this.finish(node, ParseError.ExpressionExpected);
          }
        }
      }
      if (!this.accept(TokenType.ParenthesisR)) {
        return this.finish(node, ParseError.RightParenthesisExpected);
      }
      return this.finish(node);
    }
    _parseFunctionIdentifier() {
      if (this.peekDelim("%")) {
        const node = this.create(Identifier);
        node.referenceTypes = [ReferenceType.Function];
        this.consumeToken();
        return this.finish(node);
      }
      return super._parseFunctionIdentifier();
    }
    _parseURLArgument() {
      const pos = this.mark();
      const node = super._parseURLArgument();
      if (!node || !this.peek(TokenType.ParenthesisR)) {
        this.restoreAtMark(pos);
        const node2 = this.create(Node);
        node2.addChild(this._parseBinaryExpr());
        return this.finish(node2);
      }
      return node;
    }
  };

  // node_modules/vscode-css-languageservice/lib/esm/services/lessCompletion.js
  var LESSCompletion = class _LESSCompletion extends CSSCompletion {
    constructor(lsOptions, cssDataManager) {
      super("@", lsOptions, cssDataManager);
    }
    createFunctionProposals(proposals, existingNode, sortToEnd, result) {
      for (const p of proposals) {
        const item = {
          label: p.name,
          detail: p.example,
          documentation: p.description,
          textEdit: TextEdit.replace(this.getCompletionRange(existingNode), p.name + "($0)"),
          insertTextFormat: InsertTextFormat.Snippet,
          kind: CompletionItemKind.Function
        };
        if (sortToEnd) {
          item.sortText = "z";
        }
        result.items.push(item);
      }
      return result;
    }
    getTermProposals(entry, existingNode, result) {
      let functions = _LESSCompletion.builtInProposals;
      if (entry) {
        functions = functions.filter((f2) => !f2.type || !entry.restrictions || entry.restrictions.indexOf(f2.type) !== -1);
      }
      this.createFunctionProposals(functions, existingNode, true, result);
      return super.getTermProposals(entry, existingNode, result);
    }
    getColorProposals(entry, existingNode, result) {
      this.createFunctionProposals(_LESSCompletion.colorProposals, existingNode, false, result);
      return super.getColorProposals(entry, existingNode, result);
    }
    getCompletionsForDeclarationProperty(declaration, result) {
      this.getCompletionsForSelector(null, true, result);
      return super.getCompletionsForDeclarationProperty(declaration, result);
    }
  };
  LESSCompletion.builtInProposals = [
    // Boolean functions
    {
      "name": "if",
      "example": "if(condition, trueValue [, falseValue]);",
      "description": t("returns one of two values depending on a condition.")
    },
    {
      "name": "boolean",
      "example": "boolean(condition);",
      "description": t('"store" a boolean test for later evaluation in a guard or if().')
    },
    // List functions
    {
      "name": "length",
      "example": "length(@list);",
      "description": t("returns the number of elements in a value list")
    },
    {
      "name": "extract",
      "example": "extract(@list, index);",
      "description": t("returns a value at the specified position in the list")
    },
    {
      "name": "range",
      "example": "range([start, ] end [, step]);",
      "description": t("generate a list spanning a range of values")
    },
    {
      "name": "each",
      "example": "each(@list, ruleset);",
      "description": t("bind the evaluation of a ruleset to each member of a list.")
    },
    // Other built-ins
    {
      "name": "escape",
      "example": "escape(@string);",
      "description": t("URL encodes a string")
    },
    {
      "name": "e",
      "example": "e(@string);",
      "description": t("escape string content")
    },
    {
      "name": "replace",
      "example": "replace(@string, @pattern, @replacement[, @flags]);",
      "description": t("string replace")
    },
    {
      "name": "unit",
      "example": "unit(@dimension, [@unit: '']);",
      "description": t("remove or change the unit of a dimension")
    },
    {
      "name": "color",
      "example": "color(@string);",
      "description": t("parses a string to a color"),
      "type": "color"
    },
    {
      "name": "convert",
      "example": "convert(@value, unit);",
      "description": t("converts numbers from one type into another")
    },
    {
      "name": "data-uri",
      "example": "data-uri([mimetype,] url);",
      "description": t("inlines a resource and falls back to `url()`"),
      "type": "url"
    },
    {
      "name": "abs",
      "description": t("absolute value of a number"),
      "example": "abs(number);"
    },
    {
      "name": "acos",
      "description": t("arccosine - inverse of cosine function"),
      "example": "acos(number);"
    },
    {
      "name": "asin",
      "description": t("arcsine - inverse of sine function"),
      "example": "asin(number);"
    },
    {
      "name": "ceil",
      "example": "ceil(@number);",
      "description": t("rounds up to an integer")
    },
    {
      "name": "cos",
      "description": t("cosine function"),
      "example": "cos(number);"
    },
    {
      "name": "floor",
      "description": t("rounds down to an integer"),
      "example": "floor(@number);"
    },
    {
      "name": "percentage",
      "description": t("converts to a %, e.g. 0.5 > 50%"),
      "example": "percentage(@number);",
      "type": "percentage"
    },
    {
      "name": "round",
      "description": t("rounds a number to a number of places"),
      "example": "round(number, [places: 0]);"
    },
    {
      "name": "sqrt",
      "description": t("calculates square root of a number"),
      "example": "sqrt(number);"
    },
    {
      "name": "sin",
      "description": t("sine function"),
      "example": "sin(number);"
    },
    {
      "name": "tan",
      "description": t("tangent function"),
      "example": "tan(number);"
    },
    {
      "name": "atan",
      "description": t("arctangent - inverse of tangent function"),
      "example": "atan(number);"
    },
    {
      "name": "pi",
      "description": t("returns pi"),
      "example": "pi();"
    },
    {
      "name": "pow",
      "description": t("first argument raised to the power of the second argument"),
      "example": "pow(@base, @exponent);"
    },
    {
      "name": "mod",
      "description": t("first argument modulus second argument"),
      "example": "mod(number, number);"
    },
    {
      "name": "min",
      "description": t("returns the lowest of one or more values"),
      "example": "min(@x, @y);"
    },
    {
      "name": "max",
      "description": t("returns the lowest of one or more values"),
      "example": "max(@x, @y);"
    }
  ];
  LESSCompletion.colorProposals = [
    {
      "name": "argb",
      "example": "argb(@color);",
      "description": t("creates a #AARRGGBB")
    },
    {
      "name": "hsl",
      "example": "hsl(@hue, @saturation, @lightness);",
      "description": t("creates a color")
    },
    {
      "name": "hsla",
      "example": "hsla(@hue, @saturation, @lightness, @alpha);",
      "description": t("creates a color")
    },
    {
      "name": "hsv",
      "example": "hsv(@hue, @saturation, @value);",
      "description": t("creates a color")
    },
    {
      "name": "hsva",
      "example": "hsva(@hue, @saturation, @value, @alpha);",
      "description": t("creates a color")
    },
    {
      "name": "hue",
      "example": "hue(@color);",
      "description": t("returns the `hue` channel of `@color` in the HSL space")
    },
    {
      "name": "saturation",
      "example": "saturation(@color);",
      "description": t("returns the `saturation` channel of `@color` in the HSL space")
    },
    {
      "name": "lightness",
      "example": "lightness(@color);",
      "description": t("returns the `lightness` channel of `@color` in the HSL space")
    },
    {
      "name": "hsvhue",
      "example": "hsvhue(@color);",
      "description": t("returns the `hue` channel of `@color` in the HSV space")
    },
    {
      "name": "hsvsaturation",
      "example": "hsvsaturation(@color);",
      "description": t("returns the `saturation` channel of `@color` in the HSV space")
    },
    {
      "name": "hsvvalue",
      "example": "hsvvalue(@color);",
      "description": t("returns the `value` channel of `@color` in the HSV space")
    },
    {
      "name": "red",
      "example": "red(@color);",
      "description": t("returns the `red` channel of `@color`")
    },
    {
      "name": "green",
      "example": "green(@color);",
      "description": t("returns the `green` channel of `@color`")
    },
    {
      "name": "blue",
      "example": "blue(@color);",
      "description": t("returns the `blue` channel of `@color`")
    },
    {
      "name": "alpha",
      "example": "alpha(@color);",
      "description": t("returns the `alpha` channel of `@color`")
    },
    {
      "name": "luma",
      "example": "luma(@color);",
      "description": t("returns the `luma` value (perceptual brightness) of `@color`")
    },
    {
      "name": "saturate",
      "example": "saturate(@color, 10%);",
      "description": t("return `@color` 10% points more saturated")
    },
    {
      "name": "desaturate",
      "example": "desaturate(@color, 10%);",
      "description": t("return `@color` 10% points less saturated")
    },
    {
      "name": "lighten",
      "example": "lighten(@color, 10%);",
      "description": t("return `@color` 10% points lighter")
    },
    {
      "name": "darken",
      "example": "darken(@color, 10%);",
      "description": t("return `@color` 10% points darker")
    },
    {
      "name": "fadein",
      "example": "fadein(@color, 10%);",
      "description": t("return `@color` 10% points less transparent")
    },
    {
      "name": "fadeout",
      "example": "fadeout(@color, 10%);",
      "description": t("return `@color` 10% points more transparent")
    },
    {
      "name": "fade",
      "example": "fade(@color, 50%);",
      "description": t("return `@color` with 50% transparency")
    },
    {
      "name": "spin",
      "example": "spin(@color, 10);",
      "description": t("return `@color` with a 10 degree larger in hue")
    },
    {
      "name": "mix",
      "example": "mix(@color1, @color2, [@weight: 50%]);",
      "description": t("return a mix of `@color1` and `@color2`")
    },
    {
      "name": "greyscale",
      "example": "greyscale(@color);",
      "description": t("returns a grey, 100% desaturated color")
    },
    {
      "name": "contrast",
      "example": "contrast(@color1, [@darkcolor: black], [@lightcolor: white], [@threshold: 43%]);",
      "description": t("return `@darkcolor` if `@color1 is> 43% luma` otherwise return `@lightcolor`, see notes")
    },
    {
      "name": "multiply",
      "example": "multiply(@color1, @color2);"
    },
    {
      "name": "screen",
      "example": "screen(@color1, @color2);"
    },
    {
      "name": "overlay",
      "example": "overlay(@color1, @color2);"
    },
    {
      "name": "softlight",
      "example": "softlight(@color1, @color2);"
    },
    {
      "name": "hardlight",
      "example": "hardlight(@color1, @color2);"
    },
    {
      "name": "difference",
      "example": "difference(@color1, @color2);"
    },
    {
      "name": "exclusion",
      "example": "exclusion(@color1, @color2);"
    },
    {
      "name": "average",
      "example": "average(@color1, @color2);"
    },
    {
      "name": "negation",
      "example": "negation(@color1, @color2);"
    }
  ];

  // node_modules/vscode-css-languageservice/lib/esm/services/cssFolding.js
  function getFoldingRanges(document, context) {
    const ranges = computeFoldingRanges(document);
    return limitFoldingRanges(ranges, context);
  }
  function computeFoldingRanges(document) {
    function getStartLine(t2) {
      return document.positionAt(t2.offset).line;
    }
    function getEndLine(t2) {
      return document.positionAt(t2.offset + t2.len).line;
    }
    function getScanner() {
      switch (document.languageId) {
        case "scss":
          return new SCSSScanner();
        case "less":
          return new LESSScanner();
        default:
          return new Scanner();
      }
    }
    function tokenToRange(t2, kind) {
      const startLine = getStartLine(t2);
      const endLine = getEndLine(t2);
      if (startLine !== endLine) {
        return {
          startLine,
          endLine,
          kind
        };
      } else {
        return null;
      }
    }
    const ranges = [];
    const delimiterStack = [];
    const scanner = getScanner();
    scanner.ignoreComment = false;
    scanner.setSource(document.getText());
    let token = scanner.scan();
    let prevToken = null;
    while (token.type !== TokenType.EOF) {
      switch (token.type) {
        case TokenType.CurlyL:
        case InterpolationFunction: {
          delimiterStack.push({ line: getStartLine(token), type: "brace", isStart: true });
          break;
        }
        case TokenType.CurlyR: {
          if (delimiterStack.length !== 0) {
            const prevDelimiter = popPrevStartDelimiterOfType(delimiterStack, "brace");
            if (!prevDelimiter) {
              break;
            }
            let endLine = getEndLine(token);
            if (prevDelimiter.type === "brace") {
              if (prevToken && getEndLine(prevToken) !== endLine) {
                endLine--;
              }
              if (prevDelimiter.line !== endLine) {
                ranges.push({
                  startLine: prevDelimiter.line,
                  endLine,
                  kind: void 0
                });
              }
            }
          }
          break;
        }
        case TokenType.Comment: {
          const commentRegionMarkerToDelimiter = (marker) => {
            if (marker === "#region") {
              return { line: getStartLine(token), type: "comment", isStart: true };
            } else {
              return { line: getEndLine(token), type: "comment", isStart: false };
            }
          };
          const getCurrDelimiter = (token2) => {
            const matches2 = token2.text.match(/^\s*\/\*\s*(#region|#endregion)\b\s*(.*?)\s*\*\//);
            if (matches2) {
              return commentRegionMarkerToDelimiter(matches2[1]);
            } else if (document.languageId === "scss" || document.languageId === "less") {
              const matches3 = token2.text.match(/^\s*\/\/\s*(#region|#endregion)\b\s*(.*?)\s*/);
              if (matches3) {
                return commentRegionMarkerToDelimiter(matches3[1]);
              }
            }
            return null;
          };
          const currDelimiter = getCurrDelimiter(token);
          if (currDelimiter) {
            if (currDelimiter.isStart) {
              delimiterStack.push(currDelimiter);
            } else {
              const prevDelimiter = popPrevStartDelimiterOfType(delimiterStack, "comment");
              if (!prevDelimiter) {
                break;
              }
              if (prevDelimiter.type === "comment") {
                if (prevDelimiter.line !== currDelimiter.line) {
                  ranges.push({
                    startLine: prevDelimiter.line,
                    endLine: currDelimiter.line,
                    kind: "region"
                  });
                }
              }
            }
          } else {
            const range = tokenToRange(token, "comment");
            if (range) {
              ranges.push(range);
            }
          }
          break;
        }
      }
      prevToken = token;
      token = scanner.scan();
    }
    return ranges;
  }
  function popPrevStartDelimiterOfType(stack, type) {
    if (stack.length === 0) {
      return null;
    }
    for (let i = stack.length - 1; i >= 0; i--) {
      if (stack[i].type === type && stack[i].isStart) {
        return stack.splice(i, 1)[0];
      }
    }
    return null;
  }
  function limitFoldingRanges(ranges, context) {
    const maxRanges = context && context.rangeLimit || Number.MAX_VALUE;
    const sortedRanges = ranges.sort((r1, r2) => {
      let diff = r1.startLine - r2.startLine;
      if (diff === 0) {
        diff = r1.endLine - r2.endLine;
      }
      return diff;
    });
    const validRanges = [];
    let prevEndLine = -1;
    sortedRanges.forEach((r) => {
      if (!(r.startLine < prevEndLine && prevEndLine < r.endLine)) {
        validRanges.push(r);
        prevEndLine = r.endLine;
      }
    });
    if (validRanges.length < maxRanges) {
      return validRanges;
    } else {
      return validRanges.slice(0, maxRanges);
    }
  }

  // node_modules/vscode-css-languageservice/lib/esm/beautify/beautify-css.js
  var legacy_beautify_css;
  (function() {
    "use strict";
    var __webpack_modules__ = [
      ,
      ,
      /* 2 */
      /***/
      function(module) {
        function OutputLine(parent) {
          this.__parent = parent;
          this.__character_count = 0;
          this.__indent_count = -1;
          this.__alignment_count = 0;
          this.__wrap_point_index = 0;
          this.__wrap_point_character_count = 0;
          this.__wrap_point_indent_count = -1;
          this.__wrap_point_alignment_count = 0;
          this.__items = [];
        }
        OutputLine.prototype.clone_empty = function() {
          var line = new OutputLine(this.__parent);
          line.set_indent(this.__indent_count, this.__alignment_count);
          return line;
        };
        OutputLine.prototype.item = function(index) {
          if (index < 0) {
            return this.__items[this.__items.length + index];
          } else {
            return this.__items[index];
          }
        };
        OutputLine.prototype.has_match = function(pattern) {
          for (var lastCheckedOutput = this.__items.length - 1; lastCheckedOutput >= 0; lastCheckedOutput--) {
            if (this.__items[lastCheckedOutput].match(pattern)) {
              return true;
            }
          }
          return false;
        };
        OutputLine.prototype.set_indent = function(indent, alignment) {
          if (this.is_empty()) {
            this.__indent_count = indent || 0;
            this.__alignment_count = alignment || 0;
            this.__character_count = this.__parent.get_indent_size(this.__indent_count, this.__alignment_count);
          }
        };
        OutputLine.prototype._set_wrap_point = function() {
          if (this.__parent.wrap_line_length) {
            this.__wrap_point_index = this.__items.length;
            this.__wrap_point_character_count = this.__character_count;
            this.__wrap_point_indent_count = this.__parent.next_line.__indent_count;
            this.__wrap_point_alignment_count = this.__parent.next_line.__alignment_count;
          }
        };
        OutputLine.prototype._should_wrap = function() {
          return this.__wrap_point_index && this.__character_count > this.__parent.wrap_line_length && this.__wrap_point_character_count > this.__parent.next_line.__character_count;
        };
        OutputLine.prototype._allow_wrap = function() {
          if (this._should_wrap()) {
            this.__parent.add_new_line();
            var next = this.__parent.current_line;
            next.set_indent(this.__wrap_point_indent_count, this.__wrap_point_alignment_count);
            next.__items = this.__items.slice(this.__wrap_point_index);
            this.__items = this.__items.slice(0, this.__wrap_point_index);
            next.__character_count += this.__character_count - this.__wrap_point_character_count;
            this.__character_count = this.__wrap_point_character_count;
            if (next.__items[0] === " ") {
              next.__items.splice(0, 1);
              next.__character_count -= 1;
            }
            return true;
          }
          return false;
        };
        OutputLine.prototype.is_empty = function() {
          return this.__items.length === 0;
        };
        OutputLine.prototype.last = function() {
          if (!this.is_empty()) {
            return this.__items[this.__items.length - 1];
          } else {
            return null;
          }
        };
        OutputLine.prototype.push = function(item) {
          this.__items.push(item);
          var last_newline_index = item.lastIndexOf("\n");
          if (last_newline_index !== -1) {
            this.__character_count = item.length - last_newline_index;
          } else {
            this.__character_count += item.length;
          }
        };
        OutputLine.prototype.pop = function() {
          var item = null;
          if (!this.is_empty()) {
            item = this.__items.pop();
            this.__character_count -= item.length;
          }
          return item;
        };
        OutputLine.prototype._remove_indent = function() {
          if (this.__indent_count > 0) {
            this.__indent_count -= 1;
            this.__character_count -= this.__parent.indent_size;
          }
        };
        OutputLine.prototype._remove_wrap_indent = function() {
          if (this.__wrap_point_indent_count > 0) {
            this.__wrap_point_indent_count -= 1;
          }
        };
        OutputLine.prototype.trim = function() {
          while (this.last() === " ") {
            this.__items.pop();
            this.__character_count -= 1;
          }
        };
        OutputLine.prototype.toString = function() {
          var result = "";
          if (this.is_empty()) {
            if (this.__parent.indent_empty_lines) {
              result = this.__parent.get_indent_string(this.__indent_count);
            }
          } else {
            result = this.__parent.get_indent_string(this.__indent_count, this.__alignment_count);
            result += this.__items.join("");
          }
          return result;
        };
        function IndentStringCache(options, baseIndentString) {
          this.__cache = [""];
          this.__indent_size = options.indent_size;
          this.__indent_string = options.indent_char;
          if (!options.indent_with_tabs) {
            this.__indent_string = new Array(options.indent_size + 1).join(options.indent_char);
          }
          baseIndentString = baseIndentString || "";
          if (options.indent_level > 0) {
            baseIndentString = new Array(options.indent_level + 1).join(this.__indent_string);
          }
          this.__base_string = baseIndentString;
          this.__base_string_length = baseIndentString.length;
        }
        IndentStringCache.prototype.get_indent_size = function(indent, column) {
          var result = this.__base_string_length;
          column = column || 0;
          if (indent < 0) {
            result = 0;
          }
          result += indent * this.__indent_size;
          result += column;
          return result;
        };
        IndentStringCache.prototype.get_indent_string = function(indent_level, column) {
          var result = this.__base_string;
          column = column || 0;
          if (indent_level < 0) {
            indent_level = 0;
            result = "";
          }
          column += indent_level * this.__indent_size;
          this.__ensure_cache(column);
          result += this.__cache[column];
          return result;
        };
        IndentStringCache.prototype.__ensure_cache = function(column) {
          while (column >= this.__cache.length) {
            this.__add_column();
          }
        };
        IndentStringCache.prototype.__add_column = function() {
          var column = this.__cache.length;
          var indent = 0;
          var result = "";
          if (this.__indent_size && column >= this.__indent_size) {
            indent = Math.floor(column / this.__indent_size);
            column -= indent * this.__indent_size;
            result = new Array(indent + 1).join(this.__indent_string);
          }
          if (column) {
            result += new Array(column + 1).join(" ");
          }
          this.__cache.push(result);
        };
        function Output(options, baseIndentString) {
          this.__indent_cache = new IndentStringCache(options, baseIndentString);
          this.raw = false;
          this._end_with_newline = options.end_with_newline;
          this.indent_size = options.indent_size;
          this.wrap_line_length = options.wrap_line_length;
          this.indent_empty_lines = options.indent_empty_lines;
          this.__lines = [];
          this.previous_line = null;
          this.current_line = null;
          this.next_line = new OutputLine(this);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = false;
          this.__add_outputline();
        }
        Output.prototype.__add_outputline = function() {
          this.previous_line = this.current_line;
          this.current_line = this.next_line.clone_empty();
          this.__lines.push(this.current_line);
        };
        Output.prototype.get_line_number = function() {
          return this.__lines.length;
        };
        Output.prototype.get_indent_string = function(indent, column) {
          return this.__indent_cache.get_indent_string(indent, column);
        };
        Output.prototype.get_indent_size = function(indent, column) {
          return this.__indent_cache.get_indent_size(indent, column);
        };
        Output.prototype.is_empty = function() {
          return !this.previous_line && this.current_line.is_empty();
        };
        Output.prototype.add_new_line = function(force_newline) {
          if (this.is_empty() || !force_newline && this.just_added_newline()) {
            return false;
          }
          if (!this.raw) {
            this.__add_outputline();
          }
          return true;
        };
        Output.prototype.get_code = function(eol) {
          this.trim(true);
          var last_item = this.current_line.pop();
          if (last_item) {
            if (last_item[last_item.length - 1] === "\n") {
              last_item = last_item.replace(/\n+$/g, "");
            }
            this.current_line.push(last_item);
          }
          if (this._end_with_newline) {
            this.__add_outputline();
          }
          var sweet_code = this.__lines.join("\n");
          if (eol !== "\n") {
            sweet_code = sweet_code.replace(/[\n]/g, eol);
          }
          return sweet_code;
        };
        Output.prototype.set_wrap_point = function() {
          this.current_line._set_wrap_point();
        };
        Output.prototype.set_indent = function(indent, alignment) {
          indent = indent || 0;
          alignment = alignment || 0;
          this.next_line.set_indent(indent, alignment);
          if (this.__lines.length > 1) {
            this.current_line.set_indent(indent, alignment);
            return true;
          }
          this.current_line.set_indent();
          return false;
        };
        Output.prototype.add_raw_token = function(token) {
          for (var x = 0; x < token.newlines; x++) {
            this.__add_outputline();
          }
          this.current_line.set_indent(-1);
          this.current_line.push(token.whitespace_before);
          this.current_line.push(token.text);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = false;
        };
        Output.prototype.add_token = function(printable_token) {
          this.__add_space_before_token();
          this.current_line.push(printable_token);
          this.space_before_token = false;
          this.non_breaking_space = false;
          this.previous_token_wrapped = this.current_line._allow_wrap();
        };
        Output.prototype.__add_space_before_token = function() {
          if (this.space_before_token && !this.just_added_newline()) {
            if (!this.non_breaking_space) {
              this.set_wrap_point();
            }
            this.current_line.push(" ");
          }
        };
        Output.prototype.remove_indent = function(index) {
          var output_length = this.__lines.length;
          while (index < output_length) {
            this.__lines[index]._remove_indent();
            index++;
          }
          this.current_line._remove_wrap_indent();
        };
        Output.prototype.trim = function(eat_newlines) {
          eat_newlines = eat_newlines === void 0 ? false : eat_newlines;
          this.current_line.trim();
          while (eat_newlines && this.__lines.length > 1 && this.current_line.is_empty()) {
            this.__lines.pop();
            this.current_line = this.__lines[this.__lines.length - 1];
            this.current_line.trim();
          }
          this.previous_line = this.__lines.length > 1 ? this.__lines[this.__lines.length - 2] : null;
        };
        Output.prototype.just_added_newline = function() {
          return this.current_line.is_empty();
        };
        Output.prototype.just_added_blankline = function() {
          return this.is_empty() || this.current_line.is_empty() && this.previous_line.is_empty();
        };
        Output.prototype.ensure_empty_line_above = function(starts_with, ends_with) {
          var index = this.__lines.length - 2;
          while (index >= 0) {
            var potentialEmptyLine = this.__lines[index];
            if (potentialEmptyLine.is_empty()) {
              break;
            } else if (potentialEmptyLine.item(0).indexOf(starts_with) !== 0 && potentialEmptyLine.item(-1) !== ends_with) {
              this.__lines.splice(index + 1, 0, new OutputLine(this));
              this.previous_line = this.__lines[this.__lines.length - 2];
              break;
            }
            index--;
          }
        };
        module.exports.Output = Output;
      },
      ,
      ,
      ,
      /* 6 */
      /***/
      function(module) {
        function Options(options, merge_child_field) {
          this.raw_options = _mergeOpts(options, merge_child_field);
          this.disabled = this._get_boolean("disabled");
          this.eol = this._get_characters("eol", "auto");
          this.end_with_newline = this._get_boolean("end_with_newline");
          this.indent_size = this._get_number("indent_size", 4);
          this.indent_char = this._get_characters("indent_char", " ");
          this.indent_level = this._get_number("indent_level");
          this.preserve_newlines = this._get_boolean("preserve_newlines", true);
          this.max_preserve_newlines = this._get_number("max_preserve_newlines", 32786);
          if (!this.preserve_newlines) {
            this.max_preserve_newlines = 0;
          }
          this.indent_with_tabs = this._get_boolean("indent_with_tabs", this.indent_char === "	");
          if (this.indent_with_tabs) {
            this.indent_char = "	";
            if (this.indent_size === 1) {
              this.indent_size = 4;
            }
          }
          this.wrap_line_length = this._get_number("wrap_line_length", this._get_number("max_char"));
          this.indent_empty_lines = this._get_boolean("indent_empty_lines");
          this.templating = this._get_selection_list("templating", ["auto", "none", "angular", "django", "erb", "handlebars", "php", "smarty"], ["auto"]);
        }
        Options.prototype._get_array = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = default_value || [];
          if (typeof option_value === "object") {
            if (option_value !== null && typeof option_value.concat === "function") {
              result = option_value.concat();
            }
          } else if (typeof option_value === "string") {
            result = option_value.split(/[^a-zA-Z0-9_\/\-]+/);
          }
          return result;
        };
        Options.prototype._get_boolean = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = option_value === void 0 ? !!default_value : !!option_value;
          return result;
        };
        Options.prototype._get_characters = function(name, default_value) {
          var option_value = this.raw_options[name];
          var result = default_value || "";
          if (typeof option_value === "string") {
            result = option_value.replace(/\\r/, "\r").replace(/\\n/, "\n").replace(/\\t/, "	");
          }
          return result;
        };
        Options.prototype._get_number = function(name, default_value) {
          var option_value = this.raw_options[name];
          default_value = parseInt(default_value, 10);
          if (isNaN(default_value)) {
            default_value = 0;
          }
          var result = parseInt(option_value, 10);
          if (isNaN(result)) {
            result = default_value;
          }
          return result;
        };
        Options.prototype._get_selection = function(name, selection_list, default_value) {
          var result = this._get_selection_list(name, selection_list, default_value);
          if (result.length !== 1) {
            throw new Error(
              "Invalid Option Value: The option '" + name + "' can only be one of the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
            );
          }
          return result[0];
        };
        Options.prototype._get_selection_list = function(name, selection_list, default_value) {
          if (!selection_list || selection_list.length === 0) {
            throw new Error("Selection list cannot be empty.");
          }
          default_value = default_value || [selection_list[0]];
          if (!this._is_valid_selection(default_value, selection_list)) {
            throw new Error("Invalid Default Value!");
          }
          var result = this._get_array(name, default_value);
          if (!this._is_valid_selection(result, selection_list)) {
            throw new Error(
              "Invalid Option Value: The option '" + name + "' can contain only the following values:\n" + selection_list + "\nYou passed in: '" + this.raw_options[name] + "'"
            );
          }
          return result;
        };
        Options.prototype._is_valid_selection = function(result, selection_list) {
          return result.length && selection_list.length && !result.some(function(item) {
            return selection_list.indexOf(item) === -1;
          });
        };
        function _mergeOpts(allOptions, childFieldName) {
          var finalOpts = {};
          allOptions = _normalizeOpts(allOptions);
          var name;
          for (name in allOptions) {
            if (name !== childFieldName) {
              finalOpts[name] = allOptions[name];
            }
          }
          if (childFieldName && allOptions[childFieldName]) {
            for (name in allOptions[childFieldName]) {
              finalOpts[name] = allOptions[childFieldName][name];
            }
          }
          return finalOpts;
        }
        function _normalizeOpts(options) {
          var convertedOpts = {};
          var key;
          for (key in options) {
            var newKey = key.replace(/-/g, "_");
            convertedOpts[newKey] = options[key];
          }
          return convertedOpts;
        }
        module.exports.Options = Options;
        module.exports.normalizeOpts = _normalizeOpts;
        module.exports.mergeOpts = _mergeOpts;
      },
      ,
      /* 8 */
      /***/
      function(module) {
        var regexp_has_sticky = RegExp.prototype.hasOwnProperty("sticky");
        function InputScanner(input_string) {
          this.__input = input_string || "";
          this.__input_length = this.__input.length;
          this.__position = 0;
        }
        InputScanner.prototype.restart = function() {
          this.__position = 0;
        };
        InputScanner.prototype.back = function() {
          if (this.__position > 0) {
            this.__position -= 1;
          }
        };
        InputScanner.prototype.hasNext = function() {
          return this.__position < this.__input_length;
        };
        InputScanner.prototype.next = function() {
          var val = null;
          if (this.hasNext()) {
            val = this.__input.charAt(this.__position);
            this.__position += 1;
          }
          return val;
        };
        InputScanner.prototype.peek = function(index) {
          var val = null;
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__input_length) {
            val = this.__input.charAt(index);
          }
          return val;
        };
        InputScanner.prototype.__match = function(pattern, index) {
          pattern.lastIndex = index;
          var pattern_match = pattern.exec(this.__input);
          if (pattern_match && !(regexp_has_sticky && pattern.sticky)) {
            if (pattern_match.index !== index) {
              pattern_match = null;
            }
          }
          return pattern_match;
        };
        InputScanner.prototype.test = function(pattern, index) {
          index = index || 0;
          index += this.__position;
          if (index >= 0 && index < this.__input_length) {
            return !!this.__match(pattern, index);
          } else {
            return false;
          }
        };
        InputScanner.prototype.testChar = function(pattern, index) {
          var val = this.peek(index);
          pattern.lastIndex = 0;
          return val !== null && pattern.test(val);
        };
        InputScanner.prototype.match = function(pattern) {
          var pattern_match = this.__match(pattern, this.__position);
          if (pattern_match) {
            this.__position += pattern_match[0].length;
          } else {
            pattern_match = null;
          }
          return pattern_match;
        };
        InputScanner.prototype.read = function(starting_pattern, until_pattern, until_after) {
          var val = "";
          var match;
          if (starting_pattern) {
            match = this.match(starting_pattern);
            if (match) {
              val += match[0];
            }
          }
          if (until_pattern && (match || !starting_pattern)) {
            val += this.readUntil(until_pattern, until_after);
          }
          return val;
        };
        InputScanner.prototype.readUntil = function(pattern, until_after) {
          var val = "";
          var match_index = this.__position;
          pattern.lastIndex = this.__position;
          var pattern_match = pattern.exec(this.__input);
          if (pattern_match) {
            match_index = pattern_match.index;
            if (until_after) {
              match_index += pattern_match[0].length;
            }
          } else {
            match_index = this.__input_length;
          }
          val = this.__input.substring(this.__position, match_index);
          this.__position = match_index;
          return val;
        };
        InputScanner.prototype.readUntilAfter = function(pattern) {
          return this.readUntil(pattern, true);
        };
        InputScanner.prototype.get_regexp = function(pattern, match_from) {
          var result = null;
          var flags = "g";
          if (match_from && regexp_has_sticky) {
            flags = "y";
          }
          if (typeof pattern === "string" && pattern !== "") {
            result = new RegExp(pattern, flags);
          } else if (pattern) {
            result = new RegExp(pattern.source, flags);
          }
          return result;
        };
        InputScanner.prototype.get_literal_regexp = function(literal_string) {
          return RegExp(literal_string.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&"));
        };
        InputScanner.prototype.peekUntilAfter = function(pattern) {
          var start = this.__position;
          var val = this.readUntilAfter(pattern);
          this.__position = start;
          return val;
        };
        InputScanner.prototype.lookBack = function(testVal) {
          var start = this.__position - 1;
          return start >= testVal.length && this.__input.substring(start - testVal.length, start).toLowerCase() === testVal;
        };
        module.exports.InputScanner = InputScanner;
      },
      ,
      ,
      ,
      ,
      /* 13 */
      /***/
      function(module) {
        function Directives(start_block_pattern, end_block_pattern) {
          start_block_pattern = typeof start_block_pattern === "string" ? start_block_pattern : start_block_pattern.source;
          end_block_pattern = typeof end_block_pattern === "string" ? end_block_pattern : end_block_pattern.source;
          this.__directives_block_pattern = new RegExp(start_block_pattern + / beautify( \w+[:]\w+)+ /.source + end_block_pattern, "g");
          this.__directive_pattern = / (\w+)[:](\w+)/g;
          this.__directives_end_ignore_pattern = new RegExp(start_block_pattern + /\sbeautify\signore:end\s/.source + end_block_pattern, "g");
        }
        Directives.prototype.get_directives = function(text) {
          if (!text.match(this.__directives_block_pattern)) {
            return null;
          }
          var directives = {};
          this.__directive_pattern.lastIndex = 0;
          var directive_match = this.__directive_pattern.exec(text);
          while (directive_match) {
            directives[directive_match[1]] = directive_match[2];
            directive_match = this.__directive_pattern.exec(text);
          }
          return directives;
        };
        Directives.prototype.readIgnored = function(input) {
          return input.readUntilAfter(this.__directives_end_ignore_pattern);
        };
        module.exports.Directives = Directives;
      },
      ,
      /* 15 */
      /***/
      function(module, __unused_webpack_exports, __webpack_require__2) {
        var Beautifier = __webpack_require__2(16).Beautifier, Options = __webpack_require__2(17).Options;
        function css_beautify2(source_text, options) {
          var beautifier = new Beautifier(source_text, options);
          return beautifier.beautify();
        }
        module.exports = css_beautify2;
        module.exports.defaultOptions = function() {
          return new Options();
        };
      },
      /* 16 */
      /***/
      function(module, __unused_webpack_exports, __webpack_require__2) {
        var Options = __webpack_require__2(17).Options;
        var Output = __webpack_require__2(2).Output;
        var InputScanner = __webpack_require__2(8).InputScanner;
        var Directives = __webpack_require__2(13).Directives;
        var directives_core = new Directives(/\/\*/, /\*\//);
        var lineBreak = /\r\n|[\r\n]/;
        var allLineBreaks = /\r\n|[\r\n]/g;
        var whitespaceChar = /\s/;
        var whitespacePattern = /(?:\s|\n)+/g;
        var block_comment_pattern = /\/\*(?:[\s\S]*?)((?:\*\/)|$)/g;
        var comment_pattern = /\/\/(?:[^\n\r\u2028\u2029]*)/g;
        function Beautifier(source_text, options) {
          this._source_text = source_text || "";
          this._options = new Options(options);
          this._ch = null;
          this._input = null;
          this.NESTED_AT_RULE = {
            "page": true,
            "font-face": true,
            "keyframes": true,
            // also in CONDITIONAL_GROUP_RULE below
            "media": true,
            "supports": true,
            "document": true
          };
          this.CONDITIONAL_GROUP_RULE = {
            "media": true,
            "supports": true,
            "document": true
          };
          this.NON_SEMICOLON_NEWLINE_PROPERTY = [
            "grid-template-areas",
            "grid-template"
          ];
        }
        Beautifier.prototype.eatString = function(endChars) {
          var result = "";
          this._ch = this._input.next();
          while (this._ch) {
            result += this._ch;
            if (this._ch === "\\") {
              result += this._input.next();
            } else if (endChars.indexOf(this._ch) !== -1 || this._ch === "\n") {
              break;
            }
            this._ch = this._input.next();
          }
          return result;
        };
        Beautifier.prototype.eatWhitespace = function(allowAtLeastOneNewLine) {
          var result = whitespaceChar.test(this._input.peek());
          var newline_count = 0;
          while (whitespaceChar.test(this._input.peek())) {
            this._ch = this._input.next();
            if (allowAtLeastOneNewLine && this._ch === "\n") {
              if (newline_count === 0 || newline_count < this._options.max_preserve_newlines) {
                newline_count++;
                this._output.add_new_line(true);
              }
            }
          }
          return result;
        };
        Beautifier.prototype.foundNestedPseudoClass = function() {
          var openParen = 0;
          var i = 1;
          var ch = this._input.peek(i);
          while (ch) {
            if (ch === "{") {
              return true;
            } else if (ch === "(") {
              openParen += 1;
            } else if (ch === ")") {
              if (openParen === 0) {
                return false;
              }
              openParen -= 1;
            } else if (ch === ";" || ch === "}") {
              return false;
            }
            i++;
            ch = this._input.peek(i);
          }
          return false;
        };
        Beautifier.prototype.print_string = function(output_string) {
          this._output.set_indent(this._indentLevel);
          this._output.non_breaking_space = true;
          this._output.add_token(output_string);
        };
        Beautifier.prototype.preserveSingleSpace = function(isAfterSpace) {
          if (isAfterSpace) {
            this._output.space_before_token = true;
          }
        };
        Beautifier.prototype.indent = function() {
          this._indentLevel++;
        };
        Beautifier.prototype.outdent = function() {
          if (this._indentLevel > 0) {
            this._indentLevel--;
          }
        };
        Beautifier.prototype.beautify = function() {
          if (this._options.disabled) {
            return this._source_text;
          }
          var source_text = this._source_text;
          var eol = this._options.eol;
          if (eol === "auto") {
            eol = "\n";
            if (source_text && lineBreak.test(source_text || "")) {
              eol = source_text.match(lineBreak)[0];
            }
          }
          source_text = source_text.replace(allLineBreaks, "\n");
          var baseIndentString = source_text.match(/^[\t ]*/)[0];
          this._output = new Output(this._options, baseIndentString);
          this._input = new InputScanner(source_text);
          this._indentLevel = 0;
          this._nestedLevel = 0;
          this._ch = null;
          var parenLevel = 0;
          var insideRule = false;
          var insidePropertyValue = false;
          var enteringConditionalGroup = false;
          var insideNonNestedAtRule = false;
          var insideScssMap = false;
          var topCharacter = this._ch;
          var insideNonSemiColonValues = false;
          var whitespace;
          var isAfterSpace;
          var previous_ch;
          while (true) {
            whitespace = this._input.read(whitespacePattern);
            isAfterSpace = whitespace !== "";
            previous_ch = topCharacter;
            this._ch = this._input.next();
            if (this._ch === "\\" && this._input.hasNext()) {
              this._ch += this._input.next();
            }
            topCharacter = this._ch;
            if (!this._ch) {
              break;
            } else if (this._ch === "/" && this._input.peek() === "*") {
              this._output.add_new_line();
              this._input.back();
              var comment = this._input.read(block_comment_pattern);
              var directives = directives_core.get_directives(comment);
              if (directives && directives.ignore === "start") {
                comment += directives_core.readIgnored(this._input);
              }
              this.print_string(comment);
              this.eatWhitespace(true);
              this._output.add_new_line();
            } else if (this._ch === "/" && this._input.peek() === "/") {
              this._output.space_before_token = true;
              this._input.back();
              this.print_string(this._input.read(comment_pattern));
              this.eatWhitespace(true);
            } else if (this._ch === "$") {
              this.preserveSingleSpace(isAfterSpace);
              this.print_string(this._ch);
              var variable = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
              if (variable.match(/[ :]$/)) {
                variable = this.eatString(": ").replace(/\s+$/, "");
                this.print_string(variable);
                this._output.space_before_token = true;
              }
              if (parenLevel === 0 && variable.indexOf(":") !== -1) {
                insidePropertyValue = true;
                this.indent();
              }
            } else if (this._ch === "@") {
              this.preserveSingleSpace(isAfterSpace);
              if (this._input.peek() === "{") {
                this.print_string(this._ch + this.eatString("}"));
              } else {
                this.print_string(this._ch);
                var variableOrRule = this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);
                if (variableOrRule.match(/[ :]$/)) {
                  variableOrRule = this.eatString(": ").replace(/\s+$/, "");
                  this.print_string(variableOrRule);
                  this._output.space_before_token = true;
                }
                if (parenLevel === 0 && variableOrRule.indexOf(":") !== -1) {
                  insidePropertyValue = true;
                  this.indent();
                } else if (variableOrRule in this.NESTED_AT_RULE) {
                  this._nestedLevel += 1;
                  if (variableOrRule in this.CONDITIONAL_GROUP_RULE) {
                    enteringConditionalGroup = true;
                  }
                } else if (parenLevel === 0 && !insidePropertyValue) {
                  insideNonNestedAtRule = true;
                }
              }
            } else if (this._ch === "#" && this._input.peek() === "{") {
              this.preserveSingleSpace(isAfterSpace);
              this.print_string(this._ch + this.eatString("}"));
            } else if (this._ch === "{") {
              if (insidePropertyValue) {
                insidePropertyValue = false;
                this.outdent();
              }
              insideNonNestedAtRule = false;
              if (enteringConditionalGroup) {
                enteringConditionalGroup = false;
                insideRule = this._indentLevel >= this._nestedLevel;
              } else {
                insideRule = this._indentLevel >= this._nestedLevel - 1;
              }
              if (this._options.newline_between_rules && insideRule) {
                if (this._output.previous_line && this._output.previous_line.item(-1) !== "{") {
                  this._output.ensure_empty_line_above("/", ",");
                }
              }
              this._output.space_before_token = true;
              if (this._options.brace_style === "expand") {
                this._output.add_new_line();
                this.print_string(this._ch);
                this.indent();
                this._output.set_indent(this._indentLevel);
              } else {
                if (previous_ch === "(") {
                  this._output.space_before_token = false;
                } else if (previous_ch !== ",") {
                  this.indent();
                }
                this.print_string(this._ch);
              }
              this.eatWhitespace(true);
              this._output.add_new_line();
            } else if (this._ch === "}") {
              this.outdent();
              this._output.add_new_line();
              if (previous_ch === "{") {
                this._output.trim(true);
              }
              if (insidePropertyValue) {
                this.outdent();
                insidePropertyValue = false;
              }
              this.print_string(this._ch);
              insideRule = false;
              if (this._nestedLevel) {
                this._nestedLevel--;
              }
              this.eatWhitespace(true);
              this._output.add_new_line();
              if (this._options.newline_between_rules && !this._output.just_added_blankline()) {
                if (this._input.peek() !== "}") {
                  this._output.add_new_line(true);
                }
              }
              if (this._input.peek() === ")") {
                this._output.trim(true);
                if (this._options.brace_style === "expand") {
                  this._output.add_new_line(true);
                }
              }
            } else if (this._ch === ":") {
              for (var i = 0; i < this.NON_SEMICOLON_NEWLINE_PROPERTY.length; i++) {
                if (this._input.lookBack(this.NON_SEMICOLON_NEWLINE_PROPERTY[i])) {
                  insideNonSemiColonValues = true;
                  break;
                }
              }
              if ((insideRule || enteringConditionalGroup) && !(this._input.lookBack("&") || this.foundNestedPseudoClass()) && !this._input.lookBack("(") && !insideNonNestedAtRule && parenLevel === 0) {
                this.print_string(":");
                if (!insidePropertyValue) {
                  insidePropertyValue = true;
                  this._output.space_before_token = true;
                  this.eatWhitespace(true);
                  this.indent();
                }
              } else {
                if (this._input.lookBack(" ")) {
                  this._output.space_before_token = true;
                }
                if (this._input.peek() === ":") {
                  this._ch = this._input.next();
                  this.print_string("::");
                } else {
                  this.print_string(":");
                }
              }
            } else if (this._ch === '"' || this._ch === "'") {
              var preserveQuoteSpace = previous_ch === '"' || previous_ch === "'";
              this.preserveSingleSpace(preserveQuoteSpace || isAfterSpace);
              this.print_string(this._ch + this.eatString(this._ch));
              this.eatWhitespace(true);
            } else if (this._ch === ";") {
              insideNonSemiColonValues = false;
              if (parenLevel === 0) {
                if (insidePropertyValue) {
                  this.outdent();
                  insidePropertyValue = false;
                }
                insideNonNestedAtRule = false;
                this.print_string(this._ch);
                this.eatWhitespace(true);
                if (this._input.peek() !== "/") {
                  this._output.add_new_line();
                }
              } else {
                this.print_string(this._ch);
                this.eatWhitespace(true);
                this._output.space_before_token = true;
              }
            } else if (this._ch === "(") {
              if (this._input.lookBack("url")) {
                this.print_string(this._ch);
                this.eatWhitespace();
                parenLevel++;
                this.indent();
                this._ch = this._input.next();
                if (this._ch === ")" || this._ch === '"' || this._ch === "'") {
                  this._input.back();
                } else if (this._ch) {
                  this.print_string(this._ch + this.eatString(")"));
                  if (parenLevel) {
                    parenLevel--;
                    this.outdent();
                  }
                }
              } else {
                var space_needed = false;
                if (this._input.lookBack("with")) {
                  space_needed = true;
                }
                this.preserveSingleSpace(isAfterSpace || space_needed);
                this.print_string(this._ch);
                if (insidePropertyValue && previous_ch === "$" && this._options.selector_separator_newline) {
                  this._output.add_new_line();
                  insideScssMap = true;
                } else {
                  this.eatWhitespace();
                  parenLevel++;
                  this.indent();
                }
              }
            } else if (this._ch === ")") {
              if (parenLevel) {
                parenLevel--;
                this.outdent();
              }
              if (insideScssMap && this._input.peek() === ";" && this._options.selector_separator_newline) {
                insideScssMap = false;
                this.outdent();
                this._output.add_new_line();
              }
              this.print_string(this._ch);
            } else if (this._ch === ",") {
              this.print_string(this._ch);
              this.eatWhitespace(true);
              if (this._options.selector_separator_newline && (!insidePropertyValue || insideScssMap) && parenLevel === 0 && !insideNonNestedAtRule) {
                this._output.add_new_line();
              } else {
                this._output.space_before_token = true;
              }
            } else if ((this._ch === ">" || this._ch === "+" || this._ch === "~") && !insidePropertyValue && parenLevel === 0) {
              if (this._options.space_around_combinator) {
                this._output.space_before_token = true;
                this.print_string(this._ch);
                this._output.space_before_token = true;
              } else {
                this.print_string(this._ch);
                this.eatWhitespace();
                if (this._ch && whitespaceChar.test(this._ch)) {
                  this._ch = "";
                }
              }
            } else if (this._ch === "]") {
              this.print_string(this._ch);
            } else if (this._ch === "[") {
              this.preserveSingleSpace(isAfterSpace);
              this.print_string(this._ch);
            } else if (this._ch === "=") {
              this.eatWhitespace();
              this.print_string("=");
              if (whitespaceChar.test(this._ch)) {
                this._ch = "";
              }
            } else if (this._ch === "!" && !this._input.lookBack("\\")) {
              this._output.space_before_token = true;
              this.print_string(this._ch);
            } else {
              var preserveAfterSpace = previous_ch === '"' || previous_ch === "'";
              this.preserveSingleSpace(preserveAfterSpace || isAfterSpace);
              this.print_string(this._ch);
              if (!this._output.just_added_newline() && this._input.peek() === "\n" && insideNonSemiColonValues) {
                this._output.add_new_line();
              }
            }
          }
          var sweetCode = this._output.get_code(eol);
          return sweetCode;
        };
        module.exports.Beautifier = Beautifier;
      },
      /* 17 */
      /***/
      function(module, __unused_webpack_exports, __webpack_require__2) {
        var BaseOptions = __webpack_require__2(6).Options;
        function Options(options) {
          BaseOptions.call(this, options, "css");
          this.selector_separator_newline = this._get_boolean("selector_separator_newline", true);
          this.newline_between_rules = this._get_boolean("newline_between_rules", true);
          var space_around_selector_separator = this._get_boolean("space_around_selector_separator");
          this.space_around_combinator = this._get_boolean("space_around_combinator") || space_around_selector_separator;
          var brace_style_split = this._get_selection_list("brace_style", ["collapse", "expand", "end-expand", "none", "preserve-inline"]);
          this.brace_style = "collapse";
          for (var bs = 0; bs < brace_style_split.length; bs++) {
            if (brace_style_split[bs] !== "expand") {
              this.brace_style = "collapse";
            } else {
              this.brace_style = brace_style_split[bs];
            }
          }
        }
        Options.prototype = new BaseOptions();
        module.exports.Options = Options;
      }
      /******/
    ];
    var __webpack_module_cache__ = {};
    function __webpack_require__(moduleId) {
      var cachedModule = __webpack_module_cache__[moduleId];
      if (cachedModule !== void 0) {
        return cachedModule.exports;
      }
      var module = __webpack_module_cache__[moduleId] = {
        /******/
        // no module.id needed
        /******/
        // no module.loaded needed
        /******/
        exports: {}
        /******/
      };
      __webpack_modules__[moduleId](module, module.exports, __webpack_require__);
      return module.exports;
    }
    var __webpack_exports__ = __webpack_require__(15);
    legacy_beautify_css = __webpack_exports__;
  })();
  var css_beautify = legacy_beautify_css;

  // node_modules/vscode-css-languageservice/lib/esm/services/cssFormatter.js
  function format2(document, range, options) {
    let value = document.getText();
    let includesEnd = true;
    let initialIndentLevel = 0;
    let inRule = false;
    const tabSize = options.tabSize || 4;
    if (range) {
      let startOffset = document.offsetAt(range.start);
      let extendedStart = startOffset;
      while (extendedStart > 0 && isWhitespace(value, extendedStart - 1)) {
        extendedStart--;
      }
      if (extendedStart === 0 || isEOL(value, extendedStart - 1)) {
        startOffset = extendedStart;
      } else {
        if (extendedStart < startOffset) {
          startOffset = extendedStart + 1;
        }
      }
      let endOffset = document.offsetAt(range.end);
      let extendedEnd = endOffset;
      while (extendedEnd < value.length && isWhitespace(value, extendedEnd)) {
        extendedEnd++;
      }
      if (extendedEnd === value.length || isEOL(value, extendedEnd)) {
        endOffset = extendedEnd;
      }
      range = Range.create(document.positionAt(startOffset), document.positionAt(endOffset));
      inRule = isInRule(value, startOffset);
      includesEnd = endOffset === value.length;
      value = value.substring(startOffset, endOffset);
      if (startOffset !== 0) {
        const startOfLineOffset = document.offsetAt(Position.create(range.start.line, 0));
        initialIndentLevel = computeIndentLevel(document.getText(), startOfLineOffset, options);
      }
      if (inRule) {
        value = `{
${trimLeft(value)}`;
      }
    } else {
      range = Range.create(Position.create(0, 0), document.positionAt(value.length));
    }
    const cssOptions = {
      indent_size: tabSize,
      indent_char: options.insertSpaces ? " " : "	",
      end_with_newline: includesEnd && getFormatOption(options, "insertFinalNewline", false),
      selector_separator_newline: getFormatOption(options, "newlineBetweenSelectors", true),
      newline_between_rules: getFormatOption(options, "newlineBetweenRules", true),
      space_around_selector_separator: getFormatOption(options, "spaceAroundSelectorSeparator", false),
      brace_style: getFormatOption(options, "braceStyle", "collapse"),
      indent_empty_lines: getFormatOption(options, "indentEmptyLines", false),
      max_preserve_newlines: getFormatOption(options, "maxPreserveNewLines", void 0),
      preserve_newlines: getFormatOption(options, "preserveNewLines", true),
      wrap_line_length: getFormatOption(options, "wrapLineLength", void 0),
      eol: "\n"
    };
    let result = css_beautify(value, cssOptions);
    if (inRule) {
      result = trimLeft(result.substring(2));
    }
    if (initialIndentLevel > 0) {
      const indent = options.insertSpaces ? repeat(" ", tabSize * initialIndentLevel) : repeat("	", initialIndentLevel);
      result = result.split("\n").join("\n" + indent);
      if (range.start.character === 0) {
        result = indent + result;
      }
    }
    return [{
      range,
      newText: result
    }];
  }
  function trimLeft(str) {
    return str.replace(/^\s+/, "");
  }
  var _CUL3 = "{".charCodeAt(0);
  var _CUR2 = "}".charCodeAt(0);
  function isInRule(str, offset) {
    while (offset >= 0) {
      const ch = str.charCodeAt(offset);
      if (ch === _CUL3) {
        return true;
      } else if (ch === _CUR2) {
        return false;
      }
      offset--;
    }
    return false;
  }
  function getFormatOption(options, key, dflt) {
    if (options && options.hasOwnProperty(key)) {
      const value = options[key];
      if (value !== null) {
        return value;
      }
    }
    return dflt;
  }
  function computeIndentLevel(content, offset, options) {
    let i = offset;
    let nChars = 0;
    const tabSize = options.tabSize || 4;
    while (i < content.length) {
      const ch = content.charAt(i);
      if (ch === " ") {
        nChars++;
      } else if (ch === "	") {
        nChars += tabSize;
      } else {
        break;
      }
      i++;
    }
    return Math.floor(nChars / tabSize);
  }
  function isEOL(text, offset) {
    return "\r\n".indexOf(text.charAt(offset)) !== -1;
  }
  function isWhitespace(text, offset) {
    return " 	".indexOf(text.charAt(offset)) !== -1;
  }

  // node_modules/vscode-css-languageservice/lib/esm/data/webCustomData.js
  var cssData = {
    "version": 1.1,
    "properties": [
      {
        "name": "additive-symbols",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "[ <integer> && <symbol> ]#",
        "relevance": 50,
        "description": "@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor. Needs to be specified if the counter system is 'additive'.",
        "restrictions": [
          "integer",
          "string",
          "image",
          "identifier"
        ]
      },
      {
        "name": "align-content",
        "browsers": [
          "E12",
          "FF28",
          "S9",
          "C29",
          "IE11",
          "O16"
        ],
        "values": [
          {
            "name": "center",
            "description": "Lines are packed toward the center of the flex container."
          },
          {
            "name": "flex-end",
            "description": "Lines are packed toward the end of the flex container."
          },
          {
            "name": "flex-start",
            "description": "Lines are packed toward the start of the flex container."
          },
          {
            "name": "space-around",
            "description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
          },
          {
            "name": "space-between",
            "description": "Lines are evenly distributed in the flex container."
          },
          {
            "name": "stretch",
            "description": "Lines stretch to take up the remaining space."
          },
          {
            "name": "start"
          },
          {
            "name": "end"
          },
          {
            "name": "normal"
          },
          {
            "name": "baseline"
          },
          {
            "name": "first baseline"
          },
          {
            "name": "last baseline"
          },
          {
            "name": "space-around"
          },
          {
            "name": "space-between"
          },
          {
            "name": "space-evenly"
          },
          {
            "name": "stretch"
          },
          {
            "name": "safe"
          },
          {
            "name": "unsafe"
          }
        ],
        "syntax": "normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",
        "relevance": 66,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/align-content"
          }
        ],
        "description": "Aligns a flex container's lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "align-items",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE11",
          "O16"
        ],
        "values": [
          {
            "name": "baseline",
            "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
          },
          {
            "name": "center",
            "description": "The flex item's margin box is centered in the cross axis within the line."
          },
          {
            "name": "flex-end",
            "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
          },
          {
            "name": "flex-start",
            "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
          },
          {
            "name": "stretch",
            "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
          },
          {
            "name": "normal"
          },
          {
            "name": "start"
          },
          {
            "name": "end"
          },
          {
            "name": "self-start"
          },
          {
            "name": "self-end"
          },
          {
            "name": "first baseline"
          },
          {
            "name": "last baseline"
          },
          {
            "name": "stretch"
          },
          {
            "name": "safe"
          },
          {
            "name": "unsafe"
          }
        ],
        "syntax": "normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ]",
        "relevance": 87,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/align-items"
          }
        ],
        "description": "Aligns flex items along the cross axis of the current line of the flex container.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "justify-items",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C52",
          "IE11",
          "O12.1"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "normal"
          },
          {
            "name": "end"
          },
          {
            "name": "start"
          },
          {
            "name": "flex-end",
            "description": '"Flex items are packed toward the end of the line."'
          },
          {
            "name": "flex-start",
            "description": '"Flex items are packed toward the start of the line."'
          },
          {
            "name": "self-end",
            "description": "The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."
          },
          {
            "name": "self-start",
            "description": "The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."
          },
          {
            "name": "center",
            "description": "The items are packed flush to each other toward the center of the of the alignment container."
          },
          {
            "name": "left"
          },
          {
            "name": "right"
          },
          {
            "name": "baseline"
          },
          {
            "name": "first baseline"
          },
          {
            "name": "last baseline"
          },
          {
            "name": "stretch",
            "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
          },
          {
            "name": "safe"
          },
          {
            "name": "unsafe"
          },
          {
            "name": "legacy"
          }
        ],
        "syntax": "normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ]",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/justify-items"
          }
        ],
        "description": "Defines the default justify-self for all items of the box, giving them the default way of justifying each box along the appropriate axis",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "justify-self",
        "browsers": [
          "E16",
          "FF45",
          "S10.1",
          "C57",
          "IE10",
          "O44"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "normal"
          },
          {
            "name": "end"
          },
          {
            "name": "start"
          },
          {
            "name": "flex-end",
            "description": '"Flex items are packed toward the end of the line."'
          },
          {
            "name": "flex-start",
            "description": '"Flex items are packed toward the start of the line."'
          },
          {
            "name": "self-end",
            "description": "The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."
          },
          {
            "name": "self-start",
            "description": "The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."
          },
          {
            "name": "center",
            "description": "The items are packed flush to each other toward the center of the of the alignment container."
          },
          {
            "name": "left"
          },
          {
            "name": "right"
          },
          {
            "name": "baseline"
          },
          {
            "name": "first baseline"
          },
          {
            "name": "last baseline"
          },
          {
            "name": "stretch",
            "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
          },
          {
            "name": "save"
          },
          {
            "name": "unsave"
          }
        ],
        "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ]",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/justify-self"
          }
        ],
        "description": "Defines the way of justifying a box inside its container along the appropriate axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "align-self",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE10",
          "O12.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Computes to the value of 'align-items' on the element's parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
          },
          {
            "name": "normal"
          },
          {
            "name": "self-end"
          },
          {
            "name": "self-start"
          },
          {
            "name": "baseline",
            "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
          },
          {
            "name": "center",
            "description": "The flex item's margin box is centered in the cross axis within the line."
          },
          {
            "name": "flex-end",
            "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
          },
          {
            "name": "flex-start",
            "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
          },
          {
            "name": "stretch",
            "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
          },
          {
            "name": "baseline"
          },
          {
            "name": "first baseline"
          },
          {
            "name": "last baseline"
          },
          {
            "name": "safe"
          },
          {
            "name": "unsafe"
          }
        ],
        "syntax": "auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position>",
        "relevance": 73,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/align-self"
          }
        ],
        "description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "all",
        "browsers": [
          "E79",
          "FF27",
          "S9.1",
          "C37",
          "O24"
        ],
        "values": [],
        "syntax": "initial | inherit | unset | revert | revert-layer",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/all"
          }
        ],
        "description": "Shorthand that resets all properties except 'direction' and 'unicode-bidi'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "alt",
        "browsers": [
          "S9"
        ],
        "values": [],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/alt"
          }
        ],
        "description": "Provides alternative text for assistive technology to replace the generated content of a ::before or ::after element.",
        "restrictions": [
          "string",
          "enum"
        ]
      },
      {
        "name": "animation",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "values": [
          {
            "name": "alternate",
            "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
          },
          {
            "name": "alternate-reverse",
            "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
          },
          {
            "name": "backwards",
            "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
          },
          {
            "name": "both",
            "description": "Both forwards and backwards fill modes are applied."
          },
          {
            "name": "forwards",
            "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
          },
          {
            "name": "infinite",
            "description": "Causes the animation to repeat forever."
          },
          {
            "name": "none",
            "description": "No animation is performed"
          },
          {
            "name": "normal",
            "description": "Normal playback."
          },
          {
            "name": "reverse",
            "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
          }
        ],
        "syntax": "<single-animation>#",
        "relevance": 82,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation"
          }
        ],
        "description": "Shorthand property combines six of the animation properties into a single property.",
        "restrictions": [
          "time",
          "timing-function",
          "enum",
          "identifier",
          "number"
        ]
      },
      {
        "name": "animation-delay",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "syntax": "<time>#",
        "relevance": 66,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-delay"
          }
        ],
        "description": "Defines when the animation will start.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "animation-direction",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "values": [
          {
            "name": "alternate",
            "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
          },
          {
            "name": "alternate-reverse",
            "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
          },
          {
            "name": "normal",
            "description": "Normal playback."
          },
          {
            "name": "reverse",
            "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
          }
        ],
        "syntax": "<single-animation-direction>#",
        "relevance": 58,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-direction"
          }
        ],
        "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "animation-duration",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "syntax": "<time>#",
        "relevance": 72,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-duration"
          }
        ],
        "description": "Defines the length of time that an animation takes to complete one cycle.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "animation-fill-mode",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "values": [
          {
            "name": "backwards",
            "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
          },
          {
            "name": "both",
            "description": "Both forwards and backwards fill modes are applied."
          },
          {
            "name": "forwards",
            "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
          },
          {
            "name": "none",
            "description": "There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."
          }
        ],
        "syntax": "<single-animation-fill-mode>#",
        "relevance": 65,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode"
          }
        ],
        "description": "Defines what values are applied by the animation outside the time it is executing.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "animation-iteration-count",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "values": [
          {
            "name": "infinite",
            "description": "Causes the animation to repeat forever."
          }
        ],
        "syntax": "<single-animation-iteration-count>#",
        "relevance": 64,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count"
          }
        ],
        "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
        "restrictions": [
          "number",
          "enum"
        ]
      },
      {
        "name": "animation-name",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "values": [
          {
            "name": "none",
            "description": "No animation is performed"
          }
        ],
        "syntax": "[ none | <keyframes-name> ]#",
        "relevance": 72,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-name"
          }
        ],
        "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
        "restrictions": [
          "identifier",
          "enum"
        ]
      },
      {
        "name": "animation-play-state",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "values": [
          {
            "name": "paused",
            "description": "A running animation will be paused."
          },
          {
            "name": "running",
            "description": "Resume playback of a paused animation."
          }
        ],
        "syntax": "<single-animation-play-state>#",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-play-state"
          }
        ],
        "description": "Defines whether the animation is running or paused.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "animation-timing-function",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C43",
          "IE10",
          "O30"
        ],
        "syntax": "<easing-function>#",
        "relevance": 71,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/animation-timing-function"
          }
        ],
        "description": "Describes how the animation will progress over one cycle of its duration.",
        "restrictions": [
          "timing-function"
        ]
      },
      {
        "name": "backface-visibility",
        "browsers": [
          "E12",
          "FF16",
          "S15.4",
          "C36",
          "IE10",
          "O23"
        ],
        "values": [
          {
            "name": "hidden",
            "description": "Back side is hidden."
          },
          {
            "name": "visible",
            "description": "Back side is visible."
          }
        ],
        "syntax": "visible | hidden",
        "relevance": 60,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/backface-visibility"
          }
        ],
        "description": "Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "background",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "fixed",
            "description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
          },
          {
            "name": "local",
            "description": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."
          },
          {
            "name": "none",
            "description": "A value of 'none' counts as an image layer but draws nothing."
          },
          {
            "name": "scroll",
            "description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
          }
        ],
        "syntax": "[ <bg-layer> , ]* <final-bg-layer>",
        "relevance": 93,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background"
          }
        ],
        "description": "Shorthand property for setting most background properties at the same place in the style sheet.",
        "restrictions": [
          "enum",
          "image",
          "color",
          "position",
          "length",
          "repeat",
          "percentage",
          "box"
        ]
      },
      {
        "name": "background-attachment",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "fixed",
            "description": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."
          },
          {
            "name": "local",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O3.5"
            ],
            "description": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."
          },
          {
            "name": "scroll",
            "description": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
          }
        ],
        "syntax": "<attachment>#",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-attachment"
          }
        ],
        "description": "Specifies whether the background images are fixed with regard to the viewport ('fixed') or scroll along with the element ('scroll') or its contents ('local').",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "background-blend-mode",
        "browsers": [
          "E79",
          "FF30",
          "S8",
          "C35",
          "O22"
        ],
        "values": [
          {
            "name": "normal",
            "description": "Default attribute which specifies no blending"
          },
          {
            "name": "multiply",
            "description": "The source color is multiplied by the destination color and replaces the destination."
          },
          {
            "name": "screen",
            "description": "Multiplies the complements of the backdrop and source color values, then complements the result."
          },
          {
            "name": "overlay",
            "description": "Multiplies or screens the colors, depending on the backdrop color value."
          },
          {
            "name": "darken",
            "description": "Selects the darker of the backdrop and source colors."
          },
          {
            "name": "lighten",
            "description": "Selects the lighter of the backdrop and source colors."
          },
          {
            "name": "color-dodge",
            "description": "Brightens the backdrop color to reflect the source color."
          },
          {
            "name": "color-burn",
            "description": "Darkens the backdrop color to reflect the source color."
          },
          {
            "name": "hard-light",
            "description": "Multiplies or screens the colors, depending on the source color value."
          },
          {
            "name": "soft-light",
            "description": "Darkens or lightens the colors, depending on the source color value."
          },
          {
            "name": "difference",
            "description": "Subtracts the darker of the two constituent colors from the lighter color.."
          },
          {
            "name": "exclusion",
            "description": "Produces an effect similar to that of the Difference mode but lower in contrast."
          },
          {
            "name": "hue",
            "browsers": [
              "E79",
              "FF30",
              "S8",
              "C35",
              "O22"
            ],
            "description": "Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."
          },
          {
            "name": "saturation",
            "browsers": [
              "E79",
              "FF30",
              "S8",
              "C35",
              "O22"
            ],
            "description": "Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."
          },
          {
            "name": "color",
            "browsers": [
              "E79",
              "FF30",
              "S8",
              "C35",
              "O22"
            ],
            "description": "Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."
          },
          {
            "name": "luminosity",
            "browsers": [
              "E79",
              "FF30",
              "S8",
              "C35",
              "O22"
            ],
            "description": "Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."
          }
        ],
        "syntax": "<blend-mode>#",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-blend-mode"
          }
        ],
        "description": "Defines the blending mode of each background layer.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "background-clip",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C1",
          "IE9",
          "O10.5"
        ],
        "syntax": "<box>#",
        "relevance": 69,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-clip"
          }
        ],
        "description": "Determines the background painting area.",
        "restrictions": [
          "box"
        ]
      },
      {
        "name": "background-color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<color>",
        "relevance": 94,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-color"
          }
        ],
        "description": "Sets the background color of an element.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "background-image",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "none",
            "description": "Counts as an image layer but draws nothing."
          }
        ],
        "syntax": "<bg-image>#",
        "relevance": 88,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-image"
          }
        ],
        "description": "Sets the background image(s) of an element.",
        "restrictions": [
          "image",
          "enum"
        ]
      },
      {
        "name": "background-origin",
        "browsers": [
          "E12",
          "FF4",
          "S3",
          "C1",
          "IE9",
          "O10.5"
        ],
        "syntax": "<box>#",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-origin"
          }
        ],
        "description": "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
        "restrictions": [
          "box"
        ]
      },
      {
        "name": "background-position",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<bg-position>#",
        "relevance": 87,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-position"
          }
        ],
        "description": "Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "background-position-x",
        "browsers": [
          "E12",
          "FF49",
          "S1",
          "C1",
          "IE6",
          "O15"
        ],
        "values": [
          {
            "name": "center",
            "description": "Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."
          },
          {
            "name": "left",
            "description": "Equivalent to '0%' for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset."
          },
          {
            "name": "right",
            "description": "Equivalent to '100%' for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset."
          }
        ],
        "syntax": "[ center | [ [ left | right | x-start | x-end ]? <length-percentage>? ]! ]#",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-position-x"
          }
        ],
        "description": "If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "background-position-y",
        "browsers": [
          "E12",
          "FF49",
          "S1",
          "C1",
          "IE6",
          "O15"
        ],
        "values": [
          {
            "name": "bottom",
            "description": "Equivalent to '100%' for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset."
          },
          {
            "name": "center",
            "description": "Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."
          },
          {
            "name": "top",
            "description": "Equivalent to '0%' for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."
          }
        ],
        "syntax": "[ center | [ [ top | bottom | y-start | y-end ]? <length-percentage>? ]! ]#",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-position-y"
          }
        ],
        "description": "If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "background-repeat",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [],
        "syntax": "<repeat-style>#",
        "relevance": 85,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-repeat"
          }
        ],
        "description": "Specifies how background images are tiled after they have been sized and positioned.",
        "restrictions": [
          "repeat"
        ]
      },
      {
        "name": "background-size",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C3",
          "IE9",
          "O10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."
          },
          {
            "name": "contain",
            "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
          },
          {
            "name": "cover",
            "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
          }
        ],
        "syntax": "<bg-size>#",
        "relevance": 85,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/background-size"
          }
        ],
        "description": "Specifies the size of the background images.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "behavior",
        "browsers": [
          "IE6"
        ],
        "relevance": 50,
        "description": "IE only. Used to extend behaviors of the browser.",
        "restrictions": [
          "url"
        ]
      },
      {
        "name": "block-size",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Depends on the values of other properties."
          }
        ],
        "syntax": "<'width'>",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/block-size"
          }
        ],
        "description": "Size of an element in the direction opposite that of the direction specified by 'writing-mode'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "border",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width> || <line-style> || <color>",
        "relevance": 95,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border"
          }
        ],
        "description": "Shorthand property for setting border width, style, and color.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-block-end",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end"
          }
        ],
        "description": "Logical 'border-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-block-start",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start"
          }
        ],
        "description": "Logical 'border-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-block-end-color",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-color'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end-color"
          }
        ],
        "description": "Logical 'border-bottom-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-block-start-color",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-color'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start-color"
          }
        ],
        "description": "Logical 'border-top-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-block-end-style",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-style'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end-style"
          }
        ],
        "description": "Logical 'border-bottom-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-block-start-style",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-style'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start-style"
          }
        ],
        "description": "Logical 'border-top-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-block-end-width",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-end-width"
          }
        ],
        "description": "Logical 'border-bottom-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-block-start-width",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-block-start-width"
          }
        ],
        "description": "Logical 'border-top-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-bottom",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width> || <line-style> || <color>",
        "relevance": 87,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom"
          }
        ],
        "description": "Shorthand property for setting border width, style and color.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-bottom-color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<'border-top-color'>",
        "relevance": 70,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-color"
          }
        ],
        "description": "Sets the color of the bottom border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-bottom-left-radius",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C4",
          "IE9",
          "O10.5"
        ],
        "syntax": "<length-percentage>{1,2}",
        "relevance": 74,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius"
          }
        ],
        "description": "Defines the radii of the bottom left outer border edge.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "border-bottom-right-radius",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C4",
          "IE9",
          "O10.5"
        ],
        "syntax": "<length-percentage>{1,2}",
        "relevance": 74,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius"
          }
        ],
        "description": "Defines the radii of the bottom right outer border edge.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "border-bottom-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O9.2"
        ],
        "syntax": "<line-style>",
        "relevance": 60,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-style"
          }
        ],
        "description": "Sets the style of the bottom border.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-bottom-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width>",
        "relevance": 65,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-bottom-width"
          }
        ],
        "description": "Sets the thickness of the bottom border.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-collapse",
        "browsers": [
          "E12",
          "FF1",
          "S1.2",
          "C1",
          "IE5",
          "O4"
        ],
        "values": [
          {
            "name": "collapse",
            "description": "Selects the collapsing borders model."
          },
          {
            "name": "separate",
            "description": "Selects the separated borders border model."
          }
        ],
        "syntax": "collapse | separate",
        "relevance": 71,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-collapse"
          }
        ],
        "description": "Selects a table's border model.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "border-color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [],
        "syntax": "<color>{1,4}",
        "relevance": 86,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-color"
          }
        ],
        "description": "The color of the border around all four edges of an element.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-image",
        "browsers": [
          "E12",
          "FF15",
          "S6",
          "C16",
          "IE11",
          "O11"
        ],
        "values": [
          {
            "name": "auto",
            "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
          },
          {
            "name": "fill",
            "description": "Causes the middle part of the border-image to be preserved."
          },
          {
            "name": "none",
            "description": "Use the border styles."
          },
          {
            "name": "repeat",
            "description": "The image is tiled (repeated) to fill the area."
          },
          {
            "name": "round",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
          },
          {
            "name": "space",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
          },
          {
            "name": "stretch",
            "description": "The image is stretched to fill the area."
          },
          {
            "name": "url()"
          }
        ],
        "syntax": "<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-image"
          }
        ],
        "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
        "restrictions": [
          "length",
          "percentage",
          "number",
          "url",
          "enum"
        ]
      },
      {
        "name": "border-image-outset",
        "browsers": [
          "E12",
          "FF15",
          "S6",
          "C15",
          "IE11",
          "O15"
        ],
        "syntax": "[ <length> | <number> ]{1,4}",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-outset"
          }
        ],
        "description": "The values specify the amount by which the border image area extends beyond the border box on the top, right, bottom, and left sides respectively. If the fourth value is absent, it is the same as the second. If the third one is also absent, it is the same as the first. If the second one is also absent, it is the same as the first. Numbers represent multiples of the corresponding border-width.",
        "restrictions": [
          "length",
          "number"
        ]
      },
      {
        "name": "border-image-repeat",
        "browsers": [
          "E12",
          "FF15",
          "S6",
          "C15",
          "IE11",
          "O15"
        ],
        "values": [
          {
            "name": "repeat",
            "description": "The image is tiled (repeated) to fill the area."
          },
          {
            "name": "round",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
          },
          {
            "name": "space",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
          },
          {
            "name": "stretch",
            "description": "The image is stretched to fill the area."
          }
        ],
        "syntax": "[ stretch | repeat | round | space ]{1,2}",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-repeat"
          }
        ],
        "description": "Specifies how the images for the sides and the middle part of the border image are scaled and tiled. If the second keyword is absent, it is assumed to be the same as the first.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "border-image-slice",
        "browsers": [
          "E12",
          "FF15",
          "S6",
          "C15",
          "IE11",
          "O15"
        ],
        "values": [
          {
            "name": "fill",
            "description": "Causes the middle part of the border-image to be preserved."
          }
        ],
        "syntax": "<number-percentage>{1,4} && fill?",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-slice"
          }
        ],
        "description": "Specifies inward offsets from the top, right, bottom, and left edges of the image, dividing it into nine regions: four corners, four edges and a middle.",
        "restrictions": [
          "number",
          "percentage"
        ]
      },
      {
        "name": "border-image-source",
        "browsers": [
          "E12",
          "FF15",
          "S6",
          "C15",
          "IE11",
          "O15"
        ],
        "values": [
          {
            "name": "none",
            "description": "Use the border styles."
          }
        ],
        "syntax": "none | <image>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-source"
          }
        ],
        "description": "Specifies an image to use instead of the border styles given by the 'border-style' properties and as an additional background layer for the element. If the value is 'none' or if the image cannot be displayed, the border styles will be used.",
        "restrictions": [
          "image"
        ]
      },
      {
        "name": "border-image-width",
        "browsers": [
          "E12",
          "FF13",
          "S6",
          "C15",
          "IE11",
          "O15"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
          }
        ],
        "syntax": "[ <length-percentage> | <number> | auto ]{1,4}",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-image-width"
          }
        ],
        "description": "The four values of 'border-image-width' specify offsets that are used to divide the border image area into nine parts. They represent inward distances from the top, right, bottom, and left sides of the area, respectively.",
        "restrictions": [
          "length",
          "percentage",
          "number"
        ]
      },
      {
        "name": "border-inline-end",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end"
          }
        ],
        "description": "Logical 'border-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-inline-start",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'> || <'border-top-style'> || <color>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start"
          }
        ],
        "description": "Logical 'border-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-inline-end-color",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-color'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color"
          }
        ],
        "description": "Logical 'border-right-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-inline-start-color",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-color'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color"
          }
        ],
        "description": "Logical 'border-left-color'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-inline-end-style",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-style'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style"
          }
        ],
        "description": "Logical 'border-right-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-inline-start-style",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-style'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style"
          }
        ],
        "description": "Logical 'border-left-style'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-inline-end-width",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width"
          }
        ],
        "description": "Logical 'border-right-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-inline-start-width",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'border-top-width'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width"
          }
        ],
        "description": "Logical 'border-left-width'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-left",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width> || <line-style> || <color>",
        "relevance": 81,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-left"
          }
        ],
        "description": "Shorthand property for setting border width, style and color",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-left-color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<color>",
        "relevance": 67,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-left-color"
          }
        ],
        "description": "Sets the color of the left border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-left-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O9.2"
        ],
        "syntax": "<line-style>",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-left-style"
          }
        ],
        "description": "Sets the style of the left border.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-left-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width>",
        "relevance": 63,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-left-width"
          }
        ],
        "description": "Sets the thickness of the left border.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-radius",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C4",
          "IE9",
          "O10.5"
        ],
        "syntax": "<length-percentage>{1,4} [ / <length-percentage>{1,4} ]?",
        "relevance": 92,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-radius"
          }
        ],
        "description": "Defines the radii of the outer border edge.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "border-right",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O9.2"
        ],
        "syntax": "<line-width> || <line-style> || <color>",
        "relevance": 80,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-right"
          }
        ],
        "description": "Shorthand property for setting border width, style and color",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-right-color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<color>",
        "relevance": 66,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-right-color"
          }
        ],
        "description": "Sets the color of the right border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-right-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O9.2"
        ],
        "syntax": "<line-style>",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-right-style"
          }
        ],
        "description": "Sets the style of the right border.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-right-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width>",
        "relevance": 63,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-right-width"
          }
        ],
        "description": "Sets the thickness of the right border.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-spacing",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE8",
          "O4"
        ],
        "syntax": "<length> <length>?",
        "relevance": 67,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-spacing"
          }
        ],
        "description": "The lengths specify the distance that separates adjoining cell borders. If one length is specified, it gives both the horizontal and vertical spacing. If two are specified, the first gives the horizontal spacing and the second the vertical spacing. Lengths may not be negative.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "border-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [],
        "syntax": "<line-style>{1,4}",
        "relevance": 79,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-style"
          }
        ],
        "description": "The style of the border around edges of an element.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-top",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width> || <line-style> || <color>",
        "relevance": 86,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-top"
          }
        ],
        "description": "Shorthand property for setting border width, style and color",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "border-top-color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<color>",
        "relevance": 71,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-color"
          }
        ],
        "description": "Sets the color of the top border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "border-top-left-radius",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C4",
          "IE9",
          "O10.5"
        ],
        "syntax": "<length-percentage>{1,2}",
        "relevance": 75,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius"
          }
        ],
        "description": "Defines the radii of the top left outer border edge.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "border-top-right-radius",
        "browsers": [
          "E12",
          "FF4",
          "S5",
          "C4",
          "IE9",
          "O10.5"
        ],
        "syntax": "<length-percentage>{1,2}",
        "relevance": 75,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius"
          }
        ],
        "description": "Defines the radii of the top right outer border edge.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "border-top-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O9.2"
        ],
        "syntax": "<line-style>",
        "relevance": 58,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-style"
          }
        ],
        "description": "Sets the style of the top border.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "border-top-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<line-width>",
        "relevance": 61,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-top-width"
          }
        ],
        "description": "Sets the thickness of the top border.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "border-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [],
        "syntax": "<line-width>{1,4}",
        "relevance": 82,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/border-width"
          }
        ],
        "description": "Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "bottom",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5",
          "O6"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 90,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/bottom"
          }
        ],
        "description": "Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "box-decoration-break",
        "browsers": [
          "E79",
          "FF32",
          "S7",
          "C22",
          "O15"
        ],
        "values": [
          {
            "name": "clone",
            "description": "Each box is independently wrapped with the border and padding."
          },
          {
            "name": "slice",
            "description": "The effect is as though the element were rendered with no breaks present, and then sliced by the breaks afterward."
          }
        ],
        "syntax": "slice | clone",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/box-decoration-break"
          }
        ],
        "description": "Specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "box-shadow",
        "browsers": [
          "E12",
          "FF4",
          "S5.1",
          "C10",
          "IE9",
          "O10.5"
        ],
        "values": [
          {
            "name": "inset",
            "description": "Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."
          },
          {
            "name": "none",
            "description": "No shadow."
          }
        ],
        "syntax": "none | <shadow>#",
        "relevance": 90,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/box-shadow"
          }
        ],
        "description": "Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",
        "restrictions": [
          "length",
          "color",
          "enum"
        ]
      },
      {
        "name": "box-sizing",
        "browsers": [
          "E12",
          "FF29",
          "S5.1",
          "C10",
          "IE8",
          "O7"
        ],
        "values": [
          {
            "name": "border-box",
            "description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
          },
          {
            "name": "content-box",
            "description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
          }
        ],
        "syntax": "content-box | border-box",
        "relevance": 92,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/box-sizing"
          }
        ],
        "description": "Specifies the behavior of the 'width' and 'height' properties.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "break-after",
        "browsers": [
          "E12",
          "FF65",
          "S10",
          "C50",
          "IE10",
          "O37"
        ],
        "values": [
          {
            "name": "always",
            "description": "Always force a page break before/after the generated box."
          },
          {
            "name": "auto",
            "description": "Neither force nor forbid a page/column break before/after the principal box."
          },
          {
            "name": "avoid",
            "description": "Avoid a break before/after the principal box."
          },
          {
            "name": "avoid-column",
            "description": "Avoid a column break before/after the principal box."
          },
          {
            "name": "avoid-page",
            "description": "Avoid a page break before/after the principal box."
          },
          {
            "name": "column",
            "description": "Always force a column break before/after the principal box."
          },
          {
            "name": "left",
            "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."
          },
          {
            "name": "page",
            "description": "Always force a page break before/after the principal box."
          },
          {
            "name": "right",
            "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."
          }
        ],
        "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/break-after"
          }
        ],
        "description": "Describes the page/column/region break behavior after the generated box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "break-before",
        "browsers": [
          "E12",
          "FF65",
          "S10",
          "C50",
          "IE10",
          "O37"
        ],
        "values": [
          {
            "name": "always",
            "description": "Always force a page break before/after the generated box."
          },
          {
            "name": "auto",
            "description": "Neither force nor forbid a page/column break before/after the principal box."
          },
          {
            "name": "avoid",
            "description": "Avoid a break before/after the principal box."
          },
          {
            "name": "avoid-column",
            "description": "Avoid a column break before/after the principal box."
          },
          {
            "name": "avoid-page",
            "description": "Avoid a page break before/after the principal box."
          },
          {
            "name": "column",
            "description": "Always force a column break before/after the principal box."
          },
          {
            "name": "left",
            "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."
          },
          {
            "name": "page",
            "description": "Always force a page break before/after the principal box."
          },
          {
            "name": "right",
            "description": "Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."
          }
        ],
        "syntax": "auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/break-before"
          }
        ],
        "description": "Describes the page/column/region break behavior before the generated box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "break-inside",
        "browsers": [
          "E12",
          "FF65",
          "S10",
          "C50",
          "IE10",
          "O37"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Impose no additional breaking constraints within the box."
          },
          {
            "name": "avoid",
            "description": "Avoid breaks within the box."
          },
          {
            "name": "avoid-column",
            "description": "Avoid a column break within the box."
          },
          {
            "name": "avoid-page",
            "description": "Avoid a page break within the box."
          }
        ],
        "syntax": "auto | avoid | avoid-page | avoid-column | avoid-region",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/break-inside"
          }
        ],
        "description": "Describes the page/column/region break behavior inside the principal box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "caption-side",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE8",
          "O4"
        ],
        "values": [
          {
            "name": "bottom",
            "description": "Positions the caption box below the table box."
          },
          {
            "name": "top",
            "description": "Positions the caption box above the table box."
          }
        ],
        "syntax": "top | bottom | block-start | block-end | inline-start | inline-end",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/caption-side"
          }
        ],
        "description": "Specifies the position of the caption box with respect to the table box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "caret-color",
        "browsers": [
          "E79",
          "FF53",
          "S11.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent selects an appropriate color for the caret. This is generally currentcolor, but the user agent may choose a different color to ensure good visibility and contrast with the surrounding content, taking into account the value of currentcolor, the background, shadows, and other factors."
          }
        ],
        "syntax": "auto | <color>",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/caret-color"
          }
        ],
        "description": "Controls the color of the text insertion indicator.",
        "restrictions": [
          "color",
          "enum"
        ]
      },
      {
        "name": "clear",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "both",
            "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."
          },
          {
            "name": "left",
            "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document."
          },
          {
            "name": "none",
            "description": "No constraint on the box's position with respect to floats."
          },
          {
            "name": "right",
            "description": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document."
          }
        ],
        "syntax": "none | left | right | both | inline-start | inline-end",
        "relevance": 83,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/clear"
          }
        ],
        "description": "Indicates which sides of an element's box(es) may not be adjacent to an earlier floating box. The 'clear' property does not consider floats inside the element itself or in other block formatting contexts.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "clip",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The element does not clip."
          },
          {
            "name": "rect()",
            "description": "Specifies offsets from the edges of the border box."
          }
        ],
        "syntax": "<shape> | auto",
        "relevance": 74,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/clip"
          }
        ],
        "description": "Deprecated. Use the 'clip-path' property when support allows. Defines the visible portion of an element's box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "clip-path",
        "browsers": [
          "E79",
          "FF3.5",
          "S9.1",
          "C55",
          "IE10",
          "O42"
        ],
        "values": [
          {
            "name": "none",
            "description": "No clipping path gets created."
          },
          {
            "name": "url()",
            "description": "References a <clipPath> element to create a clipping path."
          }
        ],
        "syntax": "<clip-source> | [ <basic-shape> || <geometry-box> ] | none",
        "relevance": 64,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/clip-path"
          }
        ],
        "description": "Specifies a clipping path where everything inside the path is visible and everything outside is clipped out.",
        "restrictions": [
          "url",
          "shape",
          "geometry-box",
          "enum"
        ]
      },
      {
        "name": "clip-rule",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "evenodd",
            "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."
          },
          {
            "name": "nonzero",
            "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."
          }
        ],
        "relevance": 50,
        "description": "Indicates the algorithm which is to be used to determine what parts of the canvas are included inside the shape.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "color",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "syntax": "<color>",
        "relevance": 94,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/color"
          }
        ],
        "description": "Sets the color of an element's text",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "color-interpolation-filters",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Color operations are not required to occur in a particular color space."
          },
          {
            "name": "linearRGB",
            "description": "Color operations should occur in the linearized RGB color space."
          },
          {
            "name": "sRGB",
            "description": "Color operations should occur in the sRGB color space."
          }
        ],
        "relevance": 50,
        "description": "Specifies the color space for imaging operations performed via filter effects.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "column-count",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Determines the number of columns by the 'column-width' property and the element width."
          }
        ],
        "syntax": "<integer> | auto",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-count"
          }
        ],
        "description": "Describes the optimal number of columns into which the content of the element will be flowed.",
        "restrictions": [
          "integer",
          "enum"
        ]
      },
      {
        "name": "column-fill",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O37"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Fills columns sequentially."
          },
          {
            "name": "balance",
            "description": "Balance content equally between columns, if possible."
          }
        ],
        "syntax": "auto | balance | balance-all",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-fill"
          }
        ],
        "description": "In continuous media, this property will only be consulted if the length of columns has been constrained. Otherwise, columns will automatically be balanced.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "column-gap",
        "browsers": [
          "E12",
          "FF1.5",
          "S3",
          "C1",
          "IE10",
          "O11.1"
        ],
        "values": [
          {
            "name": "normal",
            "description": "User agent specific and typically equivalent to 1em."
          }
        ],
        "syntax": "normal | <length-percentage>",
        "relevance": 60,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-gap"
          }
        ],
        "description": "Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",
        "restrictions": [
          "length",
          "enum"
        ]
      },
      {
        "name": "column-rule",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "syntax": "<'column-rule-width'> || <'column-rule-style'> || <'column-rule-color'>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule"
          }
        ],
        "description": "Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "column-rule-color",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "syntax": "<color>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule-color"
          }
        ],
        "description": "Sets the color of the column rule",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "column-rule-style",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "syntax": "<'border-style'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule-style"
          }
        ],
        "description": "Sets the style of the rule between columns of an element.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "column-rule-width",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "syntax": "<'border-width'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-rule-width"
          }
        ],
        "description": "Sets the width of the rule between columns. Negative values are not allowed.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "columns",
        "browsers": [
          "E12",
          "FF52",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The width depends on the values of other properties."
          }
        ],
        "syntax": "<'column-width'> || <'column-count'>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/columns"
          }
        ],
        "description": "A shorthand property which sets both 'column-width' and 'column-count'.",
        "restrictions": [
          "length",
          "integer",
          "enum"
        ]
      },
      {
        "name": "column-span",
        "browsers": [
          "E12",
          "FF71",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "values": [
          {
            "name": "all",
            "description": "The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."
          },
          {
            "name": "none",
            "description": "The element does not span multiple columns."
          }
        ],
        "syntax": "none | all",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-span"
          }
        ],
        "description": "Describes the page/column break behavior after the generated box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "column-width",
        "browsers": [
          "E12",
          "FF50",
          "S9",
          "C50",
          "IE10",
          "O11.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The width depends on the values of other properties."
          }
        ],
        "syntax": "<length> | auto",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/column-width"
          }
        ],
        "description": "Describes the width of columns in multicol elements.",
        "restrictions": [
          "length",
          "enum"
        ]
      },
      {
        "name": "contain",
        "browsers": [
          "E79",
          "FF69",
          "S15.4",
          "C52",
          "O39"
        ],
        "values": [
          {
            "name": "none",
            "description": "Indicates that the property has no effect."
          },
          {
            "name": "strict",
            "description": "Turns on all forms of containment for the element."
          },
          {
            "name": "content",
            "description": "All containment rules except size are applied to the element."
          },
          {
            "name": "size",
            "description": "For properties that can have effects on more than just an element and its descendants, those effects don't escape the containing element."
          },
          {
            "name": "layout",
            "description": "Turns on layout containment for the element."
          },
          {
            "name": "style",
            "description": "Turns on style containment for the element."
          },
          {
            "name": "paint",
            "description": "Turns on paint containment for the element."
          }
        ],
        "syntax": "none | strict | content | [ [ size || inline-size ] || layout || style || paint ]",
        "relevance": 58,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/contain"
          }
        ],
        "description": "Indicates that an element and its contents are, as much as possible, independent of the rest of the document tree.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "content",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE8",
          "O4"
        ],
        "values": [
          {
            "name": "attr()",
            "description": "The attr(n) function returns as a string the value of attribute n for the subject of the selector."
          },
          {
            "name": "counter(name)",
            "description": "Counters are denoted by identifiers (see the 'counter-increment' and 'counter-reset' properties)."
          },
          {
            "name": "icon",
            "description": "The (pseudo-)element is replaced in its entirety by the resource referenced by its 'icon' property, and treated as a replaced element."
          },
          {
            "name": "none",
            "description": "On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. On pseudo-elements it causes the pseudo-element to have no content."
          },
          {
            "name": "normal",
            "description": "See http://www.w3.org/TR/css3-content/#content for computation rules."
          },
          {
            "name": "url()"
          }
        ],
        "syntax": "normal | none | [ <content-replacement> | <content-list> ] [/ [ <string> | <counter> ]+ ]?",
        "relevance": 89,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/content"
          }
        ],
        "description": "Determines which page-based occurrence of a given element is applied to a counter or string value.",
        "restrictions": [
          "string",
          "url"
        ]
      },
      {
        "name": "counter-increment",
        "browsers": [
          "E12",
          "FF1",
          "S3",
          "C2",
          "IE8",
          "O9.2"
        ],
        "values": [
          {
            "name": "none",
            "description": "This element does not alter the value of any counters."
          }
        ],
        "syntax": "[ <counter-name> <integer>? ]+ | none",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/counter-increment"
          }
        ],
        "description": "Manipulate the value of existing counters.",
        "restrictions": [
          "identifier",
          "integer"
        ]
      },
      {
        "name": "counter-reset",
        "browsers": [
          "E12",
          "FF1",
          "S3",
          "C2",
          "IE8",
          "O9.2"
        ],
        "values": [
          {
            "name": "none",
            "description": "The counter is not modified."
          }
        ],
        "syntax": "[ <counter-name> <integer>? | <reversed-counter-name> <integer>? ]+ | none",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/counter-reset"
          }
        ],
        "description": "Property accepts one or more names of counters (identifiers), each one optionally followed by an integer. The integer gives the value that the counter is set to on each occurrence of the element.",
        "restrictions": [
          "identifier",
          "integer"
        ]
      },
      {
        "name": "cursor",
        "browsers": [
          "E12",
          "FF1",
          "S1.2",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "alias",
            "description": "Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it."
          },
          {
            "name": "all-scroll",
            "description": "Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle."
          },
          {
            "name": "auto",
            "description": "The UA determines the cursor to display based on the current context."
          },
          {
            "name": "cell",
            "description": "Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle."
          },
          {
            "name": "col-resize",
            "description": "Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them."
          },
          {
            "name": "context-menu",
            "description": "A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it."
          },
          {
            "name": "copy",
            "description": "Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it."
          },
          {
            "name": "crosshair",
            "description": "A simple crosshair (e.g., short line segments resembling a '+' sign). Often used to indicate a two dimensional bitmap selection mode."
          },
          {
            "name": "default",
            "description": "The platform-dependent default cursor. Often rendered as an arrow."
          },
          {
            "name": "e-resize",
            "description": "Indicates that east edge is to be moved."
          },
          {
            "name": "ew-resize",
            "description": "Indicates a bidirectional east-west resize cursor."
          },
          {
            "name": "grab",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be grabbed."
          },
          {
            "name": "grabbing",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something is being grabbed."
          },
          {
            "name": "help",
            "description": "Help is available for the object under the cursor. Often rendered as a question mark or a balloon."
          },
          {
            "name": "move",
            "description": "Indicates something is to be moved."
          },
          {
            "name": "-moz-grab",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be grabbed."
          },
          {
            "name": "-moz-grabbing",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something is being grabbed."
          },
          {
            "name": "-moz-zoom-in",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be zoomed (magnified) in."
          },
          {
            "name": "-moz-zoom-out",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be zoomed (magnified) out."
          },
          {
            "name": "ne-resize",
            "description": "Indicates that movement starts from north-east corner."
          },
          {
            "name": "nesw-resize",
            "description": "Indicates a bidirectional north-east/south-west cursor."
          },
          {
            "name": "no-drop",
            "description": "Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it."
          },
          {
            "name": "none",
            "description": "No cursor is rendered for the element."
          },
          {
            "name": "not-allowed",
            "description": "Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it."
          },
          {
            "name": "n-resize",
            "description": "Indicates that north edge is to be moved."
          },
          {
            "name": "ns-resize",
            "description": "Indicates a bidirectional north-south cursor."
          },
          {
            "name": "nw-resize",
            "description": "Indicates that movement starts from north-west corner."
          },
          {
            "name": "nwse-resize",
            "description": "Indicates a bidirectional north-west/south-east cursor."
          },
          {
            "name": "pointer",
            "description": "The cursor is a pointer that indicates a link."
          },
          {
            "name": "progress",
            "description": "A progress indicator. The program is performing some processing, but is different from 'wait' in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass."
          },
          {
            "name": "row-resize",
            "description": "Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them."
          },
          {
            "name": "se-resize",
            "description": "Indicates that movement starts from south-east corner."
          },
          {
            "name": "s-resize",
            "description": "Indicates that south edge is to be moved."
          },
          {
            "name": "sw-resize",
            "description": "Indicates that movement starts from south-west corner."
          },
          {
            "name": "text",
            "description": "Indicates text that may be selected. Often rendered as a vertical I-beam."
          },
          {
            "name": "vertical-text",
            "description": "Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam."
          },
          {
            "name": "wait",
            "description": "Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass."
          },
          {
            "name": "-webkit-grab",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be grabbed."
          },
          {
            "name": "-webkit-grabbing",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something is being grabbed."
          },
          {
            "name": "-webkit-zoom-in",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be zoomed (magnified) in."
          },
          {
            "name": "-webkit-zoom-out",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be zoomed (magnified) out."
          },
          {
            "name": "w-resize",
            "description": "Indicates that west edge is to be moved."
          },
          {
            "name": "zoom-in",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be zoomed (magnified) in."
          },
          {
            "name": "zoom-out",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Indicates that something can be zoomed (magnified) out."
          }
        ],
        "syntax": "[ [ <url> [ <x> <y> ]? , ]* [ auto | default | none | context-menu | help | pointer | progress | wait | cell | crosshair | text | vertical-text | alias | copy | move | no-drop | not-allowed | e-resize | n-resize | ne-resize | nw-resize | s-resize | se-resize | sw-resize | w-resize | ew-resize | ns-resize | nesw-resize | nwse-resize | col-resize | row-resize | all-scroll | zoom-in | zoom-out | grab | grabbing ] ]",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/cursor"
          }
        ],
        "description": "Allows control over cursor appearance in an element",
        "restrictions": [
          "url",
          "number",
          "enum"
        ]
      },
      {
        "name": "direction",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C2",
          "IE5.5",
          "O9.2"
        ],
        "values": [
          {
            "name": "ltr",
            "description": "Left-to-right direction."
          },
          {
            "name": "rtl",
            "description": "Right-to-left direction."
          }
        ],
        "syntax": "ltr | rtl",
        "relevance": 71,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/direction"
          }
        ],
        "description": "Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "display",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "block",
            "description": "The element generates a block-level box"
          },
          {
            "name": "contents",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element itself does not generate any boxes, but its children and pseudo-elements still generate boxes as normal."
          },
          {
            "name": "flex",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element generates a principal flex container box and establishes a flex formatting context."
          },
          {
            "name": "flexbox",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
          },
          {
            "name": "flow-root",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element generates a block container box, and lays out its contents using flow layout."
          },
          {
            "name": "grid",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element generates a principal grid container box, and establishes a grid formatting context."
          },
          {
            "name": "inline",
            "description": "The element generates an inline-level box."
          },
          {
            "name": "inline-block",
            "description": "A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box."
          },
          {
            "name": "inline-flex",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level flex container."
          },
          {
            "name": "inline-flexbox",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level flex container. Standardized as 'inline-flex'"
          },
          {
            "name": "inline-table",
            "description": "Inline-level table wrapper box containing table box."
          },
          {
            "name": "list-item",
            "description": "One or more block boxes and one marker box."
          },
          {
            "name": "-moz-box",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
          },
          {
            "name": "-moz-deck",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-grid",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-grid-group",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-grid-line",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-groupbox",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-inline-box",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level flex container. Standardized as 'inline-flex'"
          },
          {
            "name": "-moz-inline-grid",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-inline-stack",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-marker",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-popup",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-moz-stack",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ]
          },
          {
            "name": "-ms-flexbox",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
          },
          {
            "name": "-ms-grid",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element generates a principal grid container box, and establishes a grid formatting context."
          },
          {
            "name": "-ms-inline-flexbox",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level flex container. Standardized as 'inline-flex'"
          },
          {
            "name": "-ms-inline-grid",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level grid container."
          },
          {
            "name": "none",
            "description": "The element and its descendants generates no boxes."
          },
          {
            "name": "ruby",
            "description": "The element generates a principal ruby container box, and establishes a ruby formatting context."
          },
          {
            "name": "ruby-base"
          },
          {
            "name": "ruby-base-container"
          },
          {
            "name": "ruby-text"
          },
          {
            "name": "ruby-text-container"
          },
          {
            "name": "run-in",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element generates a run-in box. Run-in elements act like inlines or blocks, depending on the surrounding elements."
          },
          {
            "name": "table",
            "description": "The element generates a principal table wrapper box containing an additionally-generated table box, and establishes a table formatting context."
          },
          {
            "name": "table-caption"
          },
          {
            "name": "table-cell"
          },
          {
            "name": "table-column"
          },
          {
            "name": "table-column-group"
          },
          {
            "name": "table-footer-group"
          },
          {
            "name": "table-header-group"
          },
          {
            "name": "table-row"
          },
          {
            "name": "table-row-group"
          },
          {
            "name": "-webkit-box",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."
          },
          {
            "name": "-webkit-flex",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "The element lays out its contents using flow layout (block-and-inline layout)."
          },
          {
            "name": "-webkit-inline-box",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level flex container. Standardized as 'inline-flex'"
          },
          {
            "name": "-webkit-inline-flex",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Inline-level flex container."
          }
        ],
        "syntax": "[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",
        "relevance": 96,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/display"
          }
        ],
        "description": "In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "empty-cells",
        "browsers": [
          "E12",
          "FF1",
          "S1.2",
          "C1",
          "IE8",
          "O4"
        ],
        "values": [
          {
            "name": "hide",
            "description": "No borders or backgrounds are drawn around/behind empty cells."
          },
          {
            "name": "-moz-show-background",
            "browsers": [
              "E12",
              "FF1",
              "S1.2",
              "C1",
              "IE8",
              "O4"
            ]
          },
          {
            "name": "show",
            "description": "Borders and backgrounds are drawn around/behind empty cells (like normal cells)."
          }
        ],
        "syntax": "show | hide",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/empty-cells"
          }
        ],
        "description": "In the separated borders model, this property controls the rendering of borders and backgrounds around cells that have no visible content.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "enable-background",
        "values": [
          {
            "name": "accumulate",
            "description": "If the ancestor container element has a property of new, then all graphics elements within the current container are rendered both on the parent's background image and onto the target."
          },
          {
            "name": "new",
            "description": "Create a new background image canvas. All children of the current container element can access the background, and they will be rendered onto both the parent's background image canvas in addition to the target device."
          }
        ],
        "relevance": 50,
        "description": "Deprecated. Use 'isolation' property instead when support allows. Specifies how the accumulation of the background image is managed.",
        "restrictions": [
          "integer",
          "length",
          "percentage",
          "enum"
        ]
      },
      {
        "name": "fallback",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "<counter-style-name>",
        "relevance": 50,
        "description": "@counter-style descriptor. Specifies a fallback counter style to be used when the current counter style can't create a representation for a given counter value.",
        "restrictions": [
          "identifier"
        ]
      },
      {
        "name": "fill",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "url()",
            "description": "A URL reference to a paint server element, which is an element that defines a paint server: 'hatch', 'linearGradient', 'mesh', 'pattern', 'radialGradient' and 'solidcolor'."
          },
          {
            "name": "none",
            "description": "No paint is applied in this layer."
          }
        ],
        "relevance": 77,
        "description": "Paints the interior of the given graphical element.",
        "restrictions": [
          "color",
          "enum",
          "url"
        ]
      },
      {
        "name": "fill-opacity",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 52,
        "description": "Specifies the opacity of the painting operation used to paint the interior the current object.",
        "restrictions": [
          "number(0-1)"
        ]
      },
      {
        "name": "fill-rule",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "evenodd",
            "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."
          },
          {
            "name": "nonzero",
            "description": "Determines the 'insideness' of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."
          }
        ],
        "relevance": 51,
        "description": "Indicates the algorithm (or winding rule) which is to be used to determine what parts of the canvas are included inside the shape.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "filter",
        "browsers": [
          "E12",
          "FF35",
          "S9.1",
          "C53",
          "O40"
        ],
        "values": [
          {
            "name": "none",
            "description": "No filter effects are applied."
          },
          {
            "name": "blur()",
            "description": "Applies a Gaussian blur to the input image."
          },
          {
            "name": "brightness()",
            "description": "Applies a linear multiplier to input image, making it appear more or less bright."
          },
          {
            "name": "contrast()",
            "description": "Adjusts the contrast of the input."
          },
          {
            "name": "drop-shadow()",
            "description": "Applies a drop shadow effect to the input image."
          },
          {
            "name": "grayscale()",
            "description": "Converts the input image to grayscale."
          },
          {
            "name": "hue-rotate()",
            "description": "Applies a hue rotation on the input image. "
          },
          {
            "name": "invert()",
            "description": "Inverts the samples in the input image."
          },
          {
            "name": "opacity()",
            "description": "Applies transparency to the samples in the input image."
          },
          {
            "name": "saturate()",
            "description": "Saturates the input image."
          },
          {
            "name": "sepia()",
            "description": "Converts the input image to sepia."
          },
          {
            "name": "url()",
            "browsers": [
              "E12",
              "FF35",
              "S9.1",
              "C53",
              "O40"
            ],
            "description": "A filter reference to a <filter> element."
          }
        ],
        "syntax": "none | <filter-function-list>",
        "relevance": 70,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/filter"
          }
        ],
        "description": "Processes an element's rendering before it is displayed in the document, by applying one or more filter effects.",
        "restrictions": [
          "enum",
          "url"
        ]
      },
      {
        "name": "flex",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Retrieves the value of the main size property as the used 'flex-basis'."
          },
          {
            "name": "content",
            "browsers": [
              "E12",
              "FF20",
              "S9",
              "C29",
              "IE11",
              "O12.1"
            ],
            "description": "Indicates automatic sizing, based on the flex item's content."
          },
          {
            "name": "none",
            "description": "Expands to '0 0 auto'."
          }
        ],
        "syntax": "none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",
        "relevance": 81,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex"
          }
        ],
        "description": "Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",
        "restrictions": [
          "length",
          "number",
          "percentage"
        ]
      },
      {
        "name": "flex-basis",
        "browsers": [
          "E12",
          "FF22",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Retrieves the value of the main size property as the used 'flex-basis'."
          },
          {
            "name": "content",
            "browsers": [
              "E12",
              "FF22",
              "S9",
              "C29",
              "IE11",
              "O12.1"
            ],
            "description": "Indicates automatic sizing, based on the flex item's content."
          }
        ],
        "syntax": "content | <'width'>",
        "relevance": 70,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex-basis"
          }
        ],
        "description": "Sets the flex basis.",
        "restrictions": [
          "length",
          "number",
          "percentage"
        ]
      },
      {
        "name": "flex-direction",
        "browsers": [
          "E12",
          "FF81",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "values": [
          {
            "name": "column",
            "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
          },
          {
            "name": "column-reverse",
            "description": "Same as 'column', except the main-start and main-end directions are swapped."
          },
          {
            "name": "row",
            "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
          },
          {
            "name": "row-reverse",
            "description": "Same as 'row', except the main-start and main-end directions are swapped."
          }
        ],
        "syntax": "row | row-reverse | column | column-reverse",
        "relevance": 84,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex-direction"
          }
        ],
        "description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container's main axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "flex-flow",
        "browsers": [
          "E12",
          "FF28",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "values": [
          {
            "name": "column",
            "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
          },
          {
            "name": "column-reverse",
            "description": "Same as 'column', except the main-start and main-end directions are swapped."
          },
          {
            "name": "nowrap",
            "description": "The flex container is single-line."
          },
          {
            "name": "row",
            "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
          },
          {
            "name": "row-reverse",
            "description": "Same as 'row', except the main-start and main-end directions are swapped."
          },
          {
            "name": "wrap",
            "description": "The flexbox is multi-line."
          },
          {
            "name": "wrap-reverse",
            "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
          }
        ],
        "syntax": "<'flex-direction'> || <'flex-wrap'>",
        "relevance": 64,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex-flow"
          }
        ],
        "description": "Specifies how flexbox items are placed in the flexbox.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "flex-grow",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "syntax": "<number>",
        "relevance": 77,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex-grow"
          }
        ],
        "description": "Sets the flex grow factor. Negative numbers are invalid.",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "flex-shrink",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE10",
          "O12.1"
        ],
        "syntax": "<number>",
        "relevance": 76,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex-shrink"
          }
        ],
        "description": "Sets the flex shrink factor. Negative numbers are invalid.",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "flex-wrap",
        "browsers": [
          "E12",
          "FF28",
          "S9",
          "C29",
          "IE11",
          "O17"
        ],
        "values": [
          {
            "name": "nowrap",
            "description": "The flex container is single-line."
          },
          {
            "name": "wrap",
            "description": "The flexbox is multi-line."
          },
          {
            "name": "wrap-reverse",
            "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
          }
        ],
        "syntax": "nowrap | wrap | wrap-reverse",
        "relevance": 82,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/flex-wrap"
          }
        ],
        "description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "float",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "inline-end",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "A keyword indicating that the element must float on the end side of its containing block. That is the right side with ltr scripts, and the left side with rtl scripts."
          },
          {
            "name": "inline-start",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "A keyword indicating that the element must float on the start side of its containing block. That is the left side with ltr scripts, and the right side with rtl scripts."
          },
          {
            "name": "left",
            "description": "The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the 'clear' property)."
          },
          {
            "name": "none",
            "description": "The box is not floated."
          },
          {
            "name": "right",
            "description": "Similar to 'left', except the box is floated to the right, and content flows on the left side of the box, starting at the top."
          }
        ],
        "syntax": "left | right | none | inline-start | inline-end",
        "relevance": 89,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/float"
          }
        ],
        "description": "Specifies how a box should be floated. It may be set for any element, but only applies to elements that generate boxes that are not absolutely positioned.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "flood-color",
        "browsers": [
          "E12",
          "FF3",
          "S6",
          "C5",
          "IE",
          "O15"
        ],
        "relevance": 50,
        "description": "Indicates what color to use to flood the current filter primitive subregion.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "flood-opacity",
        "browsers": [
          "E12",
          "FF3",
          "S6",
          "C5",
          "IE",
          "O15"
        ],
        "relevance": 50,
        "description": "Indicates what opacity to use to flood the current filter primitive subregion.",
        "restrictions": [
          "number(0-1)",
          "percentage"
        ]
      },
      {
        "name": "font",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "100",
            "description": "Thin"
          },
          {
            "name": "200",
            "description": "Extra Light (Ultra Light)"
          },
          {
            "name": "300",
            "description": "Light"
          },
          {
            "name": "400",
            "description": "Normal"
          },
          {
            "name": "500",
            "description": "Medium"
          },
          {
            "name": "600",
            "description": "Semi Bold (Demi Bold)"
          },
          {
            "name": "700",
            "description": "Bold"
          },
          {
            "name": "800",
            "description": "Extra Bold (Ultra Bold)"
          },
          {
            "name": "900",
            "description": "Black (Heavy)"
          },
          {
            "name": "bold",
            "description": "Same as 700"
          },
          {
            "name": "bolder",
            "description": "Specifies the weight of the face bolder than the inherited value."
          },
          {
            "name": "caption",
            "description": "The font used for captioned controls (e.g., buttons, drop-downs, etc.)."
          },
          {
            "name": "icon",
            "description": "The font used to label icons."
          },
          {
            "name": "italic",
            "description": "Selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'."
          },
          {
            "name": "large"
          },
          {
            "name": "larger"
          },
          {
            "name": "lighter",
            "description": "Specifies the weight of the face lighter than the inherited value."
          },
          {
            "name": "medium"
          },
          {
            "name": "menu",
            "description": "The font used in menus (e.g., dropdown menus and menu lists)."
          },
          {
            "name": "message-box",
            "description": "The font used in dialog boxes."
          },
          {
            "name": "normal",
            "description": "Specifies a face that is not labeled as a small-caps font."
          },
          {
            "name": "oblique",
            "description": "Selects a font that is labeled 'oblique'."
          },
          {
            "name": "small"
          },
          {
            "name": "small-caps",
            "description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
          },
          {
            "name": "small-caption",
            "description": "The font used for labeling small controls."
          },
          {
            "name": "smaller"
          },
          {
            "name": "status-bar",
            "description": "The font used in window status bars."
          },
          {
            "name": "x-large"
          },
          {
            "name": "x-small"
          },
          {
            "name": "xx-large"
          },
          {
            "name": "xx-small"
          }
        ],
        "syntax": "[ [ <'font-style'> || <font-variant-css21> || <'font-weight'> || <'font-stretch'> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'> ] | caption | icon | menu | message-box | small-caption | status-bar",
        "relevance": 83,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font"
          }
        ],
        "description": "Shorthand property for setting 'font-style', 'font-variant', 'font-weight', 'font-size', 'line-height', and 'font-family', at the same place in the style sheet. The syntax of this property is based on a traditional typographical shorthand notation to set multiple properties related to fonts.",
        "restrictions": [
          "font"
        ]
      },
      {
        "name": "font-family",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"
          },
          {
            "name": "Arial, Helvetica, sans-serif"
          },
          {
            "name": "Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"
          },
          {
            "name": "'Courier New', Courier, monospace"
          },
          {
            "name": "cursive"
          },
          {
            "name": "fantasy"
          },
          {
            "name": "'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"
          },
          {
            "name": "Georgia, 'Times New Roman', Times, serif"
          },
          {
            "name": "'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"
          },
          {
            "name": "Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"
          },
          {
            "name": "'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"
          },
          {
            "name": "monospace"
          },
          {
            "name": "sans-serif"
          },
          {
            "name": "'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"
          },
          {
            "name": "serif"
          },
          {
            "name": "'Times New Roman', Times, serif"
          },
          {
            "name": "'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"
          },
          {
            "name": "Verdana, Geneva, Tahoma, sans-serif"
          }
        ],
        "atRule": "@font-face",
        "syntax": "<family-name>",
        "relevance": 93,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-family"
          }
        ],
        "description": "Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",
        "restrictions": [
          "font"
        ]
      },
      {
        "name": "font-feature-settings",
        "browsers": [
          "E15",
          "FF34",
          "S9.1",
          "C48",
          "IE10",
          "O35"
        ],
        "values": [
          {
            "name": '"aalt"',
            "description": "Access All Alternates."
          },
          {
            "name": '"abvf"',
            "description": "Above-base Forms. Required in Khmer script."
          },
          {
            "name": '"abvm"',
            "description": "Above-base Mark Positioning. Required in Indic scripts."
          },
          {
            "name": '"abvs"',
            "description": "Above-base Substitutions. Required in Indic scripts."
          },
          {
            "name": '"afrc"',
            "description": "Alternative Fractions."
          },
          {
            "name": '"akhn"',
            "description": "Akhand. Required in most Indic scripts."
          },
          {
            "name": '"blwf"',
            "description": "Below-base Form. Required in a number of Indic scripts."
          },
          {
            "name": '"blwm"',
            "description": "Below-base Mark Positioning. Required in Indic scripts."
          },
          {
            "name": '"blws"',
            "description": "Below-base Substitutions. Required in Indic scripts."
          },
          {
            "name": '"calt"',
            "description": "Contextual Alternates."
          },
          {
            "name": '"case"',
            "description": "Case-Sensitive Forms. Applies only to European scripts; particularly prominent in Spanish-language setting."
          },
          {
            "name": '"ccmp"',
            "description": "Glyph Composition/Decomposition."
          },
          {
            "name": '"cfar"',
            "description": "Conjunct Form After Ro. Required in Khmer scripts."
          },
          {
            "name": '"cjct"',
            "description": "Conjunct Forms. Required in Indic scripts that show similarity to Devanagari."
          },
          {
            "name": '"clig"',
            "description": "Contextual Ligatures."
          },
          {
            "name": '"cpct"',
            "description": "Centered CJK Punctuation. Used primarily in Chinese fonts."
          },
          {
            "name": '"cpsp"',
            "description": "Capital Spacing. Should not be used in connecting scripts (e.g. most Arabic)."
          },
          {
            "name": '"cswh"',
            "description": "Contextual Swash."
          },
          {
            "name": '"curs"',
            "description": "Cursive Positioning. Can be used in any cursive script."
          },
          {
            "name": '"c2pc"',
            "description": "Petite Capitals From Capitals. Applies only to bicameral scripts."
          },
          {
            "name": '"c2sc"',
            "description": "Small Capitals From Capitals. Applies only to bicameral scripts."
          },
          {
            "name": '"dist"',
            "description": "Distances. Required in Indic scripts."
          },
          {
            "name": '"dlig"',
            "description": "Discretionary ligatures."
          },
          {
            "name": '"dnom"',
            "description": "Denominators."
          },
          {
            "name": '"dtls"',
            "description": "Dotless Forms. Applied to math formula layout."
          },
          {
            "name": '"expt"',
            "description": "Expert Forms. Applies only to Japanese."
          },
          {
            "name": '"falt"',
            "description": "Final Glyph on Line Alternates. Can be used in any cursive script."
          },
          {
            "name": '"fin2"',
            "description": "Terminal Form #2. Used only with the Syriac script."
          },
          {
            "name": '"fin3"',
            "description": "Terminal Form #3. Used only with the Syriac script."
          },
          {
            "name": '"fina"',
            "description": "Terminal Forms. Can be used in any alphabetic script."
          },
          {
            "name": '"flac"',
            "description": "Flattened ascent forms. Applied to math formula layout."
          },
          {
            "name": '"frac"',
            "description": "Fractions."
          },
          {
            "name": '"fwid"',
            "description": "Full Widths. Applies to any script which can use monospaced forms."
          },
          {
            "name": '"half"',
            "description": "Half Forms. Required in Indic scripts that show similarity to Devanagari."
          },
          {
            "name": '"haln"',
            "description": "Halant Forms. Required in Indic scripts."
          },
          {
            "name": '"halt"',
            "description": "Alternate Half Widths. Used only in CJKV fonts."
          },
          {
            "name": '"hist"',
            "description": "Historical Forms."
          },
          {
            "name": '"hkna"',
            "description": "Horizontal Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."
          },
          {
            "name": '"hlig"',
            "description": "Historical Ligatures."
          },
          {
            "name": '"hngl"',
            "description": "Hangul. Korean only."
          },
          {
            "name": '"hojo"',
            "description": "Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms). Used only with Kanji script."
          },
          {
            "name": '"hwid"',
            "description": "Half Widths. Generally used only in CJKV fonts."
          },
          {
            "name": '"init"',
            "description": "Initial Forms. Can be used in any alphabetic script."
          },
          {
            "name": '"isol"',
            "description": "Isolated Forms. Can be used in any cursive script."
          },
          {
            "name": '"ital"',
            "description": "Italics. Applies mostly to Latin; note that many non-Latin fonts contain Latin as well."
          },
          {
            "name": '"jalt"',
            "description": "Justification Alternates. Can be used in any cursive script."
          },
          {
            "name": '"jp78"',
            "description": "JIS78 Forms. Applies only to Japanese."
          },
          {
            "name": '"jp83"',
            "description": "JIS83 Forms. Applies only to Japanese."
          },
          {
            "name": '"jp90"',
            "description": "JIS90 Forms. Applies only to Japanese."
          },
          {
            "name": '"jp04"',
            "description": "JIS2004 Forms. Applies only to Japanese."
          },
          {
            "name": '"kern"',
            "description": "Kerning."
          },
          {
            "name": '"lfbd"',
            "description": "Left Bounds."
          },
          {
            "name": '"liga"',
            "description": "Standard Ligatures."
          },
          {
            "name": '"ljmo"',
            "description": "Leading Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
          },
          {
            "name": '"lnum"',
            "description": "Lining Figures."
          },
          {
            "name": '"locl"',
            "description": "Localized Forms."
          },
          {
            "name": '"ltra"',
            "description": "Left-to-right glyph alternates."
          },
          {
            "name": '"ltrm"',
            "description": "Left-to-right mirrored forms."
          },
          {
            "name": '"mark"',
            "description": "Mark Positioning."
          },
          {
            "name": '"med2"',
            "description": "Medial Form #2. Used only with the Syriac script."
          },
          {
            "name": '"medi"',
            "description": "Medial Forms."
          },
          {
            "name": '"mgrk"',
            "description": "Mathematical Greek."
          },
          {
            "name": '"mkmk"',
            "description": "Mark to Mark Positioning."
          },
          {
            "name": '"nalt"',
            "description": "Alternate Annotation Forms."
          },
          {
            "name": '"nlck"',
            "description": "NLC Kanji Forms. Used only with Kanji script."
          },
          {
            "name": '"nukt"',
            "description": "Nukta Forms. Required in Indic scripts.."
          },
          {
            "name": '"numr"',
            "description": "Numerators."
          },
          {
            "name": '"onum"',
            "description": "Oldstyle Figures."
          },
          {
            "name": '"opbd"',
            "description": "Optical Bounds."
          },
          {
            "name": '"ordn"',
            "description": "Ordinals. Applies mostly to Latin script."
          },
          {
            "name": '"ornm"',
            "description": "Ornaments."
          },
          {
            "name": '"palt"',
            "description": "Proportional Alternate Widths. Used mostly in CJKV fonts."
          },
          {
            "name": '"pcap"',
            "description": "Petite Capitals."
          },
          {
            "name": '"pkna"',
            "description": "Proportional Kana. Generally used only in Japanese fonts."
          },
          {
            "name": '"pnum"',
            "description": "Proportional Figures."
          },
          {
            "name": '"pref"',
            "description": "Pre-base Forms. Required in Khmer and Myanmar (Burmese) scripts and southern Indic scripts that may display a pre-base form of Ra."
          },
          {
            "name": '"pres"',
            "description": "Pre-base Substitutions. Required in Indic scripts."
          },
          {
            "name": '"pstf"',
            "description": "Post-base Forms. Required in scripts of south and southeast Asia that have post-base forms for consonants eg: Gurmukhi, Malayalam, Khmer."
          },
          {
            "name": '"psts"',
            "description": "Post-base Substitutions."
          },
          {
            "name": '"pwid"',
            "description": "Proportional Widths."
          },
          {
            "name": '"qwid"',
            "description": "Quarter Widths. Generally used only in CJKV fonts."
          },
          {
            "name": '"rand"',
            "description": "Randomize."
          },
          {
            "name": '"rclt"',
            "description": "Required Contextual Alternates. May apply to any script, but is especially important for many styles of Arabic."
          },
          {
            "name": '"rlig"',
            "description": "Required Ligatures. Applies to Arabic and Syriac. May apply to some other scripts."
          },
          {
            "name": '"rkrf"',
            "description": "Rakar Forms. Required in Devanagari and Gujarati scripts."
          },
          {
            "name": '"rphf"',
            "description": "Reph Form. Required in Indic scripts. E.g. Devanagari, Kannada."
          },
          {
            "name": '"rtbd"',
            "description": "Right Bounds."
          },
          {
            "name": '"rtla"',
            "description": "Right-to-left alternates."
          },
          {
            "name": '"rtlm"',
            "description": "Right-to-left mirrored forms."
          },
          {
            "name": '"ruby"',
            "description": "Ruby Notation Forms. Applies only to Japanese."
          },
          {
            "name": '"salt"',
            "description": "Stylistic Alternates."
          },
          {
            "name": '"sinf"',
            "description": "Scientific Inferiors."
          },
          {
            "name": '"size"',
            "description": "Optical size."
          },
          {
            "name": '"smcp"',
            "description": "Small Capitals. Applies only to bicameral scripts."
          },
          {
            "name": '"smpl"',
            "description": "Simplified Forms. Applies only to Chinese and Japanese."
          },
          {
            "name": '"ssty"',
            "description": "Math script style alternates."
          },
          {
            "name": '"stch"',
            "description": "Stretching Glyph Decomposition."
          },
          {
            "name": '"subs"',
            "description": "Subscript."
          },
          {
            "name": '"sups"',
            "description": "Superscript."
          },
          {
            "name": '"swsh"',
            "description": "Swash. Does not apply to ideographic scripts."
          },
          {
            "name": '"titl"',
            "description": "Titling."
          },
          {
            "name": '"tjmo"',
            "description": "Trailing Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
          },
          {
            "name": '"tnam"',
            "description": "Traditional Name Forms. Applies only to Japanese."
          },
          {
            "name": '"tnum"',
            "description": "Tabular Figures."
          },
          {
            "name": '"trad"',
            "description": "Traditional Forms. Applies only to Chinese and Japanese."
          },
          {
            "name": '"twid"',
            "description": "Third Widths. Generally used only in CJKV fonts."
          },
          {
            "name": '"unic"',
            "description": "Unicase."
          },
          {
            "name": '"valt"',
            "description": "Alternate Vertical Metrics. Applies only to scripts with vertical writing modes."
          },
          {
            "name": '"vatu"',
            "description": "Vattu Variants. Used for Indic scripts. E.g. Devanagari."
          },
          {
            "name": '"vert"',
            "description": "Vertical Alternates. Applies only to scripts with vertical writing modes."
          },
          {
            "name": '"vhal"',
            "description": "Alternate Vertical Half Metrics. Used only in CJKV fonts."
          },
          {
            "name": '"vjmo"',
            "description": "Vowel Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."
          },
          {
            "name": '"vkna"',
            "description": "Vertical Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."
          },
          {
            "name": '"vkrn"',
            "description": "Vertical Kerning."
          },
          {
            "name": '"vpal"',
            "description": "Proportional Alternate Vertical Metrics. Used mostly in CJKV fonts."
          },
          {
            "name": '"vrt2"',
            "description": "Vertical Alternates and Rotation. Applies only to scripts with vertical writing modes."
          },
          {
            "name": '"zero"',
            "description": "Slashed Zero."
          },
          {
            "name": "normal",
            "description": "No change in glyph substitution or positioning occurs."
          },
          {
            "name": "off",
            "description": "Disable feature."
          },
          {
            "name": "on",
            "description": "Enable feature."
          }
        ],
        "atRule": "@font-face",
        "syntax": "normal | <feature-tag-value>#",
        "relevance": 57,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-feature-settings"
          }
        ],
        "description": "Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",
        "restrictions": [
          "string",
          "integer"
        ]
      },
      {
        "name": "font-kerning",
        "browsers": [
          "E79",
          "FF32",
          "S9",
          "C33",
          "O20"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Specifies that kerning is applied at the discretion of the user agent."
          },
          {
            "name": "none",
            "description": "Specifies that kerning is not applied."
          },
          {
            "name": "normal",
            "description": "Specifies that kerning is applied."
          }
        ],
        "syntax": "auto | normal | none",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-kerning"
          }
        ],
        "description": "Kerning is the contextual adjustment of inter-glyph spacing. This property controls metric kerning, kerning that utilizes adjustment data contained in the font.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-language-override",
        "browsers": [
          "FF34"
        ],
        "values": [
          {
            "name": "normal",
            "description": "Implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering."
          }
        ],
        "syntax": "normal | <string>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-language-override"
          }
        ],
        "description": "The value of 'normal' implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering.",
        "restrictions": [
          "string"
        ]
      },
      {
        "name": "font-size",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O7"
        ],
        "values": [
          {
            "name": "large"
          },
          {
            "name": "larger"
          },
          {
            "name": "medium"
          },
          {
            "name": "small"
          },
          {
            "name": "smaller"
          },
          {
            "name": "x-large"
          },
          {
            "name": "x-small"
          },
          {
            "name": "xx-large"
          },
          {
            "name": "xx-small"
          }
        ],
        "syntax": "<absolute-size> | <relative-size> | <length-percentage>",
        "relevance": 94,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-size"
          }
        ],
        "description": "Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "font-size-adjust",
        "browsers": [
          "FF3",
          "S16.4"
        ],
        "values": [
          {
            "name": "none",
            "description": "Do not preserve the font's x-height."
          }
        ],
        "syntax": "none | [ ex-height | cap-height | ch-width | ic-width | ic-height ]? [ from-font | <number> ]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-size-adjust"
          }
        ],
        "description": "Preserves the readability of text when font fallback occurs by adjusting the font-size so that the x-height is the same regardless of the font used.",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "font-stretch",
        "browsers": [
          "E12",
          "FF9",
          "S11",
          "C60",
          "IE9",
          "O47"
        ],
        "values": [
          {
            "name": "condensed"
          },
          {
            "name": "expanded"
          },
          {
            "name": "extra-condensed"
          },
          {
            "name": "extra-expanded"
          },
          {
            "name": "narrower",
            "browsers": [
              "E12",
              "FF9",
              "S11",
              "C60",
              "IE9",
              "O47"
            ],
            "description": "Indicates a narrower value relative to the width of the parent element."
          },
          {
            "name": "normal"
          },
          {
            "name": "semi-condensed"
          },
          {
            "name": "semi-expanded"
          },
          {
            "name": "ultra-condensed"
          },
          {
            "name": "ultra-expanded"
          },
          {
            "name": "wider",
            "browsers": [
              "E12",
              "FF9",
              "S11",
              "C60",
              "IE9",
              "O47"
            ],
            "description": "Indicates a wider value relative to the width of the parent element."
          }
        ],
        "atRule": "@font-face",
        "syntax": "<font-stretch-absolute>{1,2}",
        "relevance": 56,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-stretch"
          }
        ],
        "description": "Selects a normal, condensed, or expanded face from a font family.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "italic",
            "description": "Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"
          },
          {
            "name": "normal",
            "description": "Selects a face that is classified as 'normal'."
          },
          {
            "name": "oblique",
            "description": "Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."
          }
        ],
        "atRule": "@font-face",
        "syntax": "normal | italic | oblique <angle>{0,2}",
        "relevance": 89,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-style"
          }
        ],
        "description": "Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-synthesis",
        "browsers": [
          "E97",
          "FF34",
          "S9",
          "C97",
          "O83"
        ],
        "values": [
          {
            "name": "none",
            "description": "Disallow all synthetic faces."
          },
          {
            "name": "style",
            "description": "Allow synthetic italic faces."
          },
          {
            "name": "weight",
            "description": "Allow synthetic bold faces."
          }
        ],
        "syntax": "none | [ weight || style || small-caps || position]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-synthesis"
          }
        ],
        "description": "Controls whether user agents are allowed to synthesize bold or oblique font faces when a font family lacks bold or italic faces.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "normal",
            "description": "Specifies a face that is not labeled as a small-caps font."
          },
          {
            "name": "small-caps",
            "description": "Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."
          }
        ],
        "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
        "relevance": 64,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant"
          }
        ],
        "description": "Specifies variant representations of the font",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant-alternates",
        "browsers": [
          "E111",
          "FF34",
          "S9.1",
          "C111",
          "O97"
        ],
        "values": [
          {
            "name": "annotation()",
            "description": "Enables display of alternate annotation forms."
          },
          {
            "name": "character-variant()",
            "description": "Enables display of specific character variants."
          },
          {
            "name": "historical-forms",
            "description": "Enables display of historical forms."
          },
          {
            "name": "normal",
            "description": "None of the features are enabled."
          },
          {
            "name": "ornaments()",
            "description": "Enables replacement of default glyphs with ornaments, if provided in the font."
          },
          {
            "name": "styleset()",
            "description": "Enables display with stylistic sets."
          },
          {
            "name": "stylistic()",
            "description": "Enables display of stylistic alternates."
          },
          {
            "name": "swash()",
            "description": "Enables display of swash glyphs."
          }
        ],
        "syntax": "normal | [ stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) ]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates"
          }
        ],
        "description": "For any given character, fonts can provide a variety of alternate glyphs in addition to the default glyph for that character. This property provides control over the selection of these alternate glyphs.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant-caps",
        "browsers": [
          "E79",
          "FF34",
          "S9.1",
          "C52",
          "O39"
        ],
        "values": [
          {
            "name": "all-petite-caps",
            "description": "Enables display of petite capitals for both upper and lowercase letters."
          },
          {
            "name": "all-small-caps",
            "description": "Enables display of small capitals for both upper and lowercase letters."
          },
          {
            "name": "normal",
            "description": "None of the features are enabled."
          },
          {
            "name": "petite-caps",
            "description": "Enables display of petite capitals."
          },
          {
            "name": "small-caps",
            "description": "Enables display of small capitals. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."
          },
          {
            "name": "titling-caps",
            "description": "Enables display of titling capitals."
          },
          {
            "name": "unicase",
            "description": "Enables display of mixture of small capitals for uppercase letters with normal lowercase letters."
          }
        ],
        "syntax": "normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-caps"
          }
        ],
        "description": "Specifies control over capitalized forms.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant-east-asian",
        "browsers": [
          "E79",
          "FF34",
          "S9.1",
          "C63",
          "O50"
        ],
        "values": [
          {
            "name": "full-width",
            "description": "Enables rendering of full-width variants."
          },
          {
            "name": "jis04",
            "description": "Enables rendering of JIS04 forms."
          },
          {
            "name": "jis78",
            "description": "Enables rendering of JIS78 forms."
          },
          {
            "name": "jis83",
            "description": "Enables rendering of JIS83 forms."
          },
          {
            "name": "jis90",
            "description": "Enables rendering of JIS90 forms."
          },
          {
            "name": "normal",
            "description": "None of the features are enabled."
          },
          {
            "name": "proportional-width",
            "description": "Enables rendering of proportionally-spaced variants."
          },
          {
            "name": "ruby",
            "description": "Enables display of ruby variant glyphs."
          },
          {
            "name": "simplified",
            "description": "Enables rendering of simplified forms."
          },
          {
            "name": "traditional",
            "description": "Enables rendering of traditional forms."
          }
        ],
        "syntax": "normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian"
          }
        ],
        "description": "Allows control of glyph substitute and positioning in East Asian text.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant-ligatures",
        "browsers": [
          "E79",
          "FF34",
          "S9.1",
          "C34",
          "O21"
        ],
        "values": [
          {
            "name": "additional-ligatures",
            "description": "Enables display of additional ligatures."
          },
          {
            "name": "common-ligatures",
            "description": "Enables display of common ligatures."
          },
          {
            "name": "contextual",
            "browsers": [
              "E79",
              "FF34",
              "S9.1",
              "C34",
              "O21"
            ],
            "description": "Enables display of contextual alternates."
          },
          {
            "name": "discretionary-ligatures",
            "description": "Enables display of discretionary ligatures."
          },
          {
            "name": "historical-ligatures",
            "description": "Enables display of historical ligatures."
          },
          {
            "name": "no-additional-ligatures",
            "description": "Disables display of additional ligatures."
          },
          {
            "name": "no-common-ligatures",
            "description": "Disables display of common ligatures."
          },
          {
            "name": "no-contextual",
            "browsers": [
              "E79",
              "FF34",
              "S9.1",
              "C34",
              "O21"
            ],
            "description": "Disables display of contextual alternates."
          },
          {
            "name": "no-discretionary-ligatures",
            "description": "Disables display of discretionary ligatures."
          },
          {
            "name": "no-historical-ligatures",
            "description": "Disables display of historical ligatures."
          },
          {
            "name": "none",
            "browsers": [
              "E79",
              "FF34",
              "S9.1",
              "C34",
              "O21"
            ],
            "description": "Disables all ligatures."
          },
          {
            "name": "normal",
            "description": "Implies that the defaults set by the font are used."
          }
        ],
        "syntax": "normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures"
          }
        ],
        "description": "Specifies control over which ligatures are enabled or disabled. A value of 'normal' implies that the defaults set by the font are used.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant-numeric",
        "browsers": [
          "E79",
          "FF34",
          "S9.1",
          "C52",
          "O39"
        ],
        "values": [
          {
            "name": "diagonal-fractions",
            "description": "Enables display of lining diagonal fractions."
          },
          {
            "name": "lining-nums",
            "description": "Enables display of lining numerals."
          },
          {
            "name": "normal",
            "description": "None of the features are enabled."
          },
          {
            "name": "oldstyle-nums",
            "description": "Enables display of old-style numerals."
          },
          {
            "name": "ordinal",
            "description": "Enables display of letter forms used with ordinal numbers."
          },
          {
            "name": "proportional-nums",
            "description": "Enables display of proportional numerals."
          },
          {
            "name": "slashed-zero",
            "description": "Enables display of slashed zeros."
          },
          {
            "name": "stacked-fractions",
            "description": "Enables display of lining stacked fractions."
          },
          {
            "name": "tabular-nums",
            "description": "Enables display of tabular numerals."
          }
        ],
        "syntax": "normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric"
          }
        ],
        "description": "Specifies control over numerical forms.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-variant-position",
        "browsers": [
          "E117",
          "FF34",
          "S9.1",
          "C117",
          "O103"
        ],
        "values": [
          {
            "name": "normal",
            "description": "None of the features are enabled."
          },
          {
            "name": "sub",
            "description": "Enables display of subscript variants (OpenType feature: subs)."
          },
          {
            "name": "super",
            "description": "Enables display of superscript variants (OpenType feature: sups)."
          }
        ],
        "syntax": "normal | sub | super",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-variant-position"
          }
        ],
        "description": "Specifies the vertical position",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "font-weight",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C2",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "100",
            "description": "Thin"
          },
          {
            "name": "200",
            "description": "Extra Light (Ultra Light)"
          },
          {
            "name": "300",
            "description": "Light"
          },
          {
            "name": "400",
            "description": "Normal"
          },
          {
            "name": "500",
            "description": "Medium"
          },
          {
            "name": "600",
            "description": "Semi Bold (Demi Bold)"
          },
          {
            "name": "700",
            "description": "Bold"
          },
          {
            "name": "800",
            "description": "Extra Bold (Ultra Bold)"
          },
          {
            "name": "900",
            "description": "Black (Heavy)"
          },
          {
            "name": "bold",
            "description": "Same as 700"
          },
          {
            "name": "bolder",
            "description": "Specifies the weight of the face bolder than the inherited value."
          },
          {
            "name": "lighter",
            "description": "Specifies the weight of the face lighter than the inherited value."
          },
          {
            "name": "normal",
            "description": "Same as 400"
          }
        ],
        "atRule": "@font-face",
        "syntax": "<font-weight-absolute>{1,2}",
        "relevance": 93,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/font-weight"
          }
        ],
        "description": "Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "glyph-orientation-horizontal",
        "relevance": 50,
        "description": "Controls glyph orientation when the inline-progression-direction is horizontal.",
        "restrictions": [
          "angle",
          "number"
        ]
      },
      {
        "name": "glyph-orientation-vertical",
        "browsers": [
          "S13.1"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Sets the orientation based on the fullwidth or non-fullwidth characters and the most common orientation."
          }
        ],
        "relevance": 50,
        "description": "Controls glyph orientation when the inline-progression-direction is vertical.",
        "restrictions": [
          "angle",
          "number",
          "enum"
        ]
      },
      {
        "name": "grid-area",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line> [ / <grid-line> ]{0,3}",
        "relevance": 57,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-area"
          }
        ],
        "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement. Shorthand for 'grid-row-start', 'grid-column-start', 'grid-row-end', and 'grid-column-end'.",
        "restrictions": [
          "identifier",
          "integer"
        ]
      },
      {
        "name": "grid",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "syntax": "<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid"
          }
        ],
        "description": "The grid CSS property is a shorthand property that sets all of the explicit grid properties ('grid-template-rows', 'grid-template-columns', and 'grid-template-areas'), and all the implicit grid properties ('grid-auto-rows', 'grid-auto-columns', and 'grid-auto-flow'), in a single declaration.",
        "restrictions": [
          "identifier",
          "length",
          "percentage",
          "string",
          "enum"
        ]
      },
      {
        "name": "grid-auto-columns",
        "browsers": [
          "E16",
          "FF70",
          "S10.1",
          "C57",
          "IE10",
          "O44"
        ],
        "values": [
          {
            "name": "min-content",
            "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "max-content",
            "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "auto",
            "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
          },
          {
            "name": "minmax()",
            "description": "Defines a size range greater than or equal to min and less than or equal to max."
          }
        ],
        "syntax": "<track-size>+",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns"
          }
        ],
        "description": "Specifies the size of implicitly created columns.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "grid-auto-flow",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "row",
            "description": "The auto-placement algorithm places items by filling each row in turn, adding new rows as necessary."
          },
          {
            "name": "column",
            "description": "The auto-placement algorithm places items by filling each column in turn, adding new columns as necessary."
          },
          {
            "name": "dense",
            "description": 'If specified, the auto-placement algorithm uses a "dense" packing algorithm, which attempts to fill in holes earlier in the grid if smaller items come up later.'
          }
        ],
        "syntax": "[ row | column ] || dense",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow"
          }
        ],
        "description": "Controls how the auto-placement algorithm works, specifying exactly how auto-placed items get flowed into the grid.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "grid-auto-rows",
        "browsers": [
          "E16",
          "FF70",
          "S10.1",
          "C57",
          "IE10",
          "O44"
        ],
        "values": [
          {
            "name": "min-content",
            "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "max-content",
            "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "auto",
            "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
          },
          {
            "name": "minmax()",
            "description": "Defines a size range greater than or equal to min and less than or equal to max."
          }
        ],
        "syntax": "<track-size>+",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows"
          }
        ],
        "description": "Specifies the size of implicitly created rows.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "grid-column",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line> [ / <grid-line> ]?",
        "relevance": 56,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-column"
          }
        ],
        "description": "Shorthand for 'grid-column-start' and 'grid-column-end'.",
        "restrictions": [
          "identifier",
          "integer",
          "enum"
        ]
      },
      {
        "name": "grid-column-end",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-column-end"
          }
        ],
        "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
        "restrictions": [
          "identifier",
          "integer",
          "enum"
        ]
      },
      {
        "name": "grid-column-gap",
        "browsers": [
          "FF52",
          "C57",
          "S10.1",
          "O44"
        ],
        "status": "obsolete",
        "syntax": "<length-percentage>",
        "relevance": 4,
        "description": "Specifies the gutters between grid columns. Replaced by 'column-gap' property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "grid-column-start",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-column-start"
          }
        ],
        "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
        "restrictions": [
          "identifier",
          "integer",
          "enum"
        ]
      },
      {
        "name": "grid-gap",
        "browsers": [
          "FF52",
          "C57",
          "S10.1",
          "O44"
        ],
        "status": "obsolete",
        "syntax": "<'grid-row-gap'> <'grid-column-gap'>?",
        "relevance": 5,
        "description": "Shorthand that specifies the gutters between grid columns and grid rows in one declaration. Replaced by 'gap' property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "grid-row",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line> [ / <grid-line> ]?",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-row"
          }
        ],
        "description": "Shorthand for 'grid-row-start' and 'grid-row-end'.",
        "restrictions": [
          "identifier",
          "integer",
          "enum"
        ]
      },
      {
        "name": "grid-row-end",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-row-end"
          }
        ],
        "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
        "restrictions": [
          "identifier",
          "integer",
          "enum"
        ]
      },
      {
        "name": "grid-row-gap",
        "browsers": [
          "FF52",
          "C57",
          "S10.1",
          "O44"
        ],
        "status": "obsolete",
        "syntax": "<length-percentage>",
        "relevance": 2,
        "description": "Specifies the gutters between grid rows. Replaced by 'row-gap' property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "grid-row-start",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The property contributes nothing to the grid item's placement, indicating auto-placement, an automatic span, or a default span of one."
          },
          {
            "name": "span",
            "description": "Contributes a grid span to the grid item's placement such that the corresponding edge of the grid item's grid area is N lines from its opposite edge."
          }
        ],
        "syntax": "<grid-line>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-row-start"
          }
        ],
        "description": "Determine a grid item's size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",
        "restrictions": [
          "identifier",
          "integer",
          "enum"
        ]
      },
      {
        "name": "grid-template",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "none",
            "description": "Sets all three properties to their initial values."
          },
          {
            "name": "min-content",
            "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "max-content",
            "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "auto",
            "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
          },
          {
            "name": "subgrid",
            "description": "Sets 'grid-template-rows' and 'grid-template-columns' to 'subgrid', and 'grid-template-areas' to its initial value."
          },
          {
            "name": "minmax()",
            "description": "Defines a size range greater than or equal to min and less than or equal to max."
          },
          {
            "name": "repeat()",
            "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
          }
        ],
        "syntax": "none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template"
          }
        ],
        "description": "Shorthand for setting grid-template-columns, grid-template-rows, and grid-template-areas in a single declaration.",
        "restrictions": [
          "identifier",
          "length",
          "percentage",
          "string",
          "enum"
        ]
      },
      {
        "name": "grid-template-areas",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "none",
            "description": "The grid container doesn't define any named grid areas."
          }
        ],
        "syntax": "none | <string>+",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template-areas"
          }
        ],
        "description": "Specifies named grid areas, which are not associated with any particular grid item, but can be referenced from the grid-placement properties.",
        "restrictions": [
          "string"
        ]
      },
      {
        "name": "grid-template-columns",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "IE10",
          "O44"
        ],
        "values": [
          {
            "name": "none",
            "description": "There is no explicit grid; any rows/columns will be implicitly generated."
          },
          {
            "name": "min-content",
            "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "max-content",
            "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "auto",
            "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
          },
          {
            "name": "subgrid",
            "description": "Indicates that the grid will align to its parent grid in that axis."
          },
          {
            "name": "minmax()",
            "description": "Defines a size range greater than or equal to min and less than or equal to max."
          },
          {
            "name": "repeat()",
            "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
          }
        ],
        "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
        "relevance": 64,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template-columns"
          }
        ],
        "description": "specifies, as a space-separated track list, the line names and track sizing functions of the grid.",
        "restrictions": [
          "identifier",
          "length",
          "percentage",
          "enum"
        ]
      },
      {
        "name": "grid-template-rows",
        "browsers": [
          "E16",
          "FF52",
          "S10.1",
          "C57",
          "IE10",
          "O44"
        ],
        "values": [
          {
            "name": "none",
            "description": "There is no explicit grid; any rows/columns will be implicitly generated."
          },
          {
            "name": "min-content",
            "description": "Represents the largest min-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "max-content",
            "description": "Represents the largest max-content contribution of the grid items occupying the grid track."
          },
          {
            "name": "auto",
            "description": "As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."
          },
          {
            "name": "subgrid",
            "description": "Indicates that the grid will align to its parent grid in that axis."
          },
          {
            "name": "minmax()",
            "description": "Defines a size range greater than or equal to min and less than or equal to max."
          },
          {
            "name": "repeat()",
            "description": "Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."
          }
        ],
        "syntax": "none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",
        "relevance": 57,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/grid-template-rows"
          }
        ],
        "description": "specifies, as a space-separated track list, the line names and track sizing functions of the grid.",
        "restrictions": [
          "identifier",
          "length",
          "percentage",
          "string",
          "enum"
        ]
      },
      {
        "name": "height",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The height depends on the values of other properties."
          },
          {
            "name": "fit-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
          },
          {
            "name": "max-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
          },
          {
            "name": "min-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
          }
        ],
        "syntax": "auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",
        "relevance": 96,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/height"
          }
        ],
        "description": "Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "hyphens",
        "browsers": [
          "E79",
          "FF43",
          "S17",
          "C55",
          "IE10",
          "O42"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
          },
          {
            "name": "manual",
            "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
          },
          {
            "name": "none",
            "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
          }
        ],
        "syntax": "none | manual | auto",
        "relevance": 56,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/hyphens"
          }
        ],
        "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "image-orientation",
        "browsers": [
          "E81",
          "FF26",
          "S13.1",
          "C81",
          "O67"
        ],
        "values": [
          {
            "name": "flip",
            "description": "After rotating by the precededing angle, the image is flipped horizontally. Defaults to 0deg if the angle is ommitted."
          },
          {
            "name": "from-image",
            "description": "If the image has an orientation specified in its metadata, such as EXIF, this value computes to the angle that the metadata specifies is necessary to correctly orient the image."
          }
        ],
        "syntax": "from-image | <angle> | [ <angle>? flip ]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/image-orientation"
          }
        ],
        "description": "Specifies an orthogonal rotation to be applied to an image before it is laid out.",
        "restrictions": [
          "angle"
        ]
      },
      {
        "name": "image-rendering",
        "browsers": [
          "E79",
          "FF3.6",
          "S6",
          "C13",
          "O15"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The image should be scaled with an algorithm that maximizes the appearance of the image."
          },
          {
            "name": "crisp-edges",
            "description": "The image must be scaled with an algorithm that preserves contrast and edges in the image, and which does not smooth colors or introduce blur to the image in the process."
          },
          {
            "name": "-moz-crisp-edges",
            "browsers": [
              "E79",
              "FF3.6",
              "S6",
              "C13",
              "O15"
            ]
          },
          {
            "name": "optimizeQuality",
            "description": "Deprecated."
          },
          {
            "name": "optimizeSpeed",
            "description": "Deprecated."
          },
          {
            "name": "pixelated",
            "description": "When scaling the image up, the 'nearest neighbor' or similar algorithm must be used, so that the image appears to be simply composed of very large pixels."
          }
        ],
        "syntax": "auto | crisp-edges | pixelated",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/image-rendering"
          }
        ],
        "description": "Provides a hint to the user-agent about what aspects of an image are most important to preserve when the image is scaled, to aid the user-agent in the choice of an appropriate scaling algorithm.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "ime-mode",
        "browsers": [
          "E12",
          "FF3",
          "IE5"
        ],
        "values": [
          {
            "name": "active",
            "description": "The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."
          },
          {
            "name": "auto",
            "description": "No change is made to the current input method editor state. This is the default."
          },
          {
            "name": "disabled",
            "description": "The input method editor is disabled and may not be activated by the user."
          },
          {
            "name": "inactive",
            "description": "The input method editor is initially inactive, but the user may activate it if they wish."
          },
          {
            "name": "normal",
            "description": "The IME state should be normal; this value can be used in a user style sheet to override the page setting."
          }
        ],
        "status": "obsolete",
        "syntax": "auto | normal | active | inactive | disabled",
        "relevance": 0,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/ime-mode"
          }
        ],
        "description": "Controls the state of the input method editor for text fields.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "inline-size",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Depends on the values of other properties."
          }
        ],
        "syntax": "<'width'>",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/inline-size"
          }
        ],
        "description": "Size of an element in the direction specified by 'writing-mode'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "isolation",
        "browsers": [
          "E79",
          "FF36",
          "S8",
          "C41",
          "O30"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Elements are not isolated unless an operation is applied that causes the creation of a stacking context."
          },
          {
            "name": "isolate",
            "description": "In CSS will turn the element into a stacking context."
          }
        ],
        "syntax": "auto | isolate",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/isolation"
          }
        ],
        "description": "In CSS setting to 'isolate' will turn the element into a stacking context. In SVG, it defines whether an element is isolated or not.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "justify-content",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "values": [
          {
            "name": "center",
            "description": "Flex items are packed toward the center of the line."
          },
          {
            "name": "start",
            "description": "The items are packed flush to each other toward the start edge of the alignment container in the main axis."
          },
          {
            "name": "end",
            "description": "The items are packed flush to each other toward the end edge of the alignment container in the main axis."
          },
          {
            "name": "left",
            "description": "The items are packed flush to each other toward the left edge of the alignment container in the main axis."
          },
          {
            "name": "right",
            "description": "The items are packed flush to each other toward the right edge of the alignment container in the main axis."
          },
          {
            "name": "safe",
            "description": "If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."
          },
          {
            "name": "unsafe",
            "description": "Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."
          },
          {
            "name": "stretch",
            "description": "If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."
          },
          {
            "name": "space-evenly",
            "description": "The items are evenly distributed within the alignment container along the main axis."
          },
          {
            "name": "flex-end",
            "description": "Flex items are packed toward the end of the line."
          },
          {
            "name": "flex-start",
            "description": "Flex items are packed toward the start of the line."
          },
          {
            "name": "space-around",
            "description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
          },
          {
            "name": "space-between",
            "description": "Flex items are evenly distributed in the line."
          },
          {
            "name": "baseline",
            "description": "Specifies participation in first-baseline alignment."
          },
          {
            "name": "first baseline",
            "description": "Specifies participation in first-baseline alignment."
          },
          {
            "name": "last baseline",
            "description": "Specifies participation in last-baseline alignment."
          }
        ],
        "syntax": "normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",
        "relevance": 87,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/justify-content"
          }
        ],
        "description": "Aligns flex items along the main axis of the current line of the flex container.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "kerning",
        "values": [
          {
            "name": "auto",
            "description": "Indicates that the user agent should adjust inter-glyph spacing based on kerning tables that are included in the font that will be used."
          }
        ],
        "relevance": 50,
        "description": "Indicates whether the user agent should adjust inter-glyph spacing based on kerning tables that are included in the relevant font or instead disable auto-kerning and set inter-character spacing to a specific length.",
        "restrictions": [
          "length",
          "enum"
        ]
      },
      {
        "name": "left",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 94,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/left"
          }
        ],
        "description": "Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "letter-spacing",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "normal",
            "description": "The spacing is the normal spacing for the current font. It is typically zero-length."
          }
        ],
        "syntax": "normal | <length>",
        "relevance": 81,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/letter-spacing"
          }
        ],
        "description": "Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "lighting-color",
        "browsers": [
          "E12",
          "FF3",
          "S6",
          "C5",
          "IE",
          "O15"
        ],
        "relevance": 50,
        "description": "Defines the color of the light source for filter primitives 'feDiffuseLighting' and 'feSpecularLighting'.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "line-break",
        "browsers": [
          "E14",
          "FF69",
          "S11",
          "C58",
          "IE5.5",
          "O45"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."
          },
          {
            "name": "loose",
            "description": "Breaks text using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."
          },
          {
            "name": "normal",
            "description": "Breaks text using the most common set of line-breaking rules."
          },
          {
            "name": "strict",
            "description": "Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."
          },
          {
            "name": "anywhere",
            "description": "There is a soft wrap opportunity around every typographic character unit, including around any punctuation character or preserved white spaces, or in the middle of words, disregarding any prohibition against line breaks, even those introduced by characters with the GL, WJ, or ZWJ line breaking classes or mandated by the word-break property."
          }
        ],
        "syntax": "auto | loose | normal | strict | anywhere",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/line-break"
          }
        ],
        "description": "Specifies what set of line breaking restrictions are in effect within the element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "line-height",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "normal",
            "description": "Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."
          }
        ],
        "syntax": "normal | <number> | <length> | <percentage>",
        "relevance": 92,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/line-height"
          }
        ],
        "description": "Determines the block-progression dimension of the text content area of an inline box.",
        "restrictions": [
          "number",
          "length",
          "percentage"
        ]
      },
      {
        "name": "list-style",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "armenian"
          },
          {
            "name": "circle",
            "description": "A hollow circle."
          },
          {
            "name": "decimal"
          },
          {
            "name": "decimal-leading-zero"
          },
          {
            "name": "disc",
            "description": "A filled circle."
          },
          {
            "name": "georgian"
          },
          {
            "name": "inside",
            "description": "The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."
          },
          {
            "name": "lower-alpha"
          },
          {
            "name": "lower-greek"
          },
          {
            "name": "lower-latin"
          },
          {
            "name": "lower-roman"
          },
          {
            "name": "none"
          },
          {
            "name": "outside",
            "description": "The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."
          },
          {
            "name": "square",
            "description": "A filled square."
          },
          {
            "name": "symbols()",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Allows a counter style to be defined inline."
          },
          {
            "name": "upper-alpha"
          },
          {
            "name": "upper-latin"
          },
          {
            "name": "upper-roman"
          },
          {
            "name": "url()"
          }
        ],
        "syntax": "<'list-style-type'> || <'list-style-position'> || <'list-style-image'>",
        "relevance": 83,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/list-style"
          }
        ],
        "description": "Shorthand for setting 'list-style-type', 'list-style-position' and 'list-style-image'",
        "restrictions": [
          "image",
          "enum",
          "url"
        ]
      },
      {
        "name": "list-style-image",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "none",
            "description": "The default contents of the of the list item's marker are given by 'list-style-type' instead."
          }
        ],
        "syntax": "<image> | none",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/list-style-image"
          }
        ],
        "description": "Sets the image that will be used as the list item marker. When the image is available, it will replace the marker set with the 'list-style-type' marker.",
        "restrictions": [
          "image"
        ]
      },
      {
        "name": "list-style-position",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "inside",
            "description": "The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."
          },
          {
            "name": "outside",
            "description": "The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."
          }
        ],
        "syntax": "inside | outside",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/list-style-position"
          }
        ],
        "description": "Specifies the position of the '::marker' pseudo-element's box in the list item.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "list-style-type",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [
          {
            "name": "armenian",
            "description": "Traditional uppercase Armenian numbering."
          },
          {
            "name": "circle",
            "description": "A hollow circle."
          },
          {
            "name": "decimal",
            "description": "Western decimal numbers."
          },
          {
            "name": "decimal-leading-zero",
            "description": "Decimal numbers padded by initial zeros."
          },
          {
            "name": "disc",
            "description": "A filled circle."
          },
          {
            "name": "georgian",
            "description": "Traditional Georgian numbering."
          },
          {
            "name": "lower-alpha",
            "description": "Lowercase ASCII letters."
          },
          {
            "name": "lower-greek",
            "description": "Lowercase classical Greek."
          },
          {
            "name": "lower-latin",
            "description": "Lowercase ASCII letters."
          },
          {
            "name": "lower-roman",
            "description": "Lowercase ASCII Roman numerals."
          },
          {
            "name": "none",
            "description": "No marker"
          },
          {
            "name": "square",
            "description": "A filled square."
          },
          {
            "name": "symbols()",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O3.5"
            ],
            "description": "Allows a counter style to be defined inline."
          },
          {
            "name": "upper-alpha",
            "description": "Uppercase ASCII letters."
          },
          {
            "name": "upper-latin",
            "description": "Uppercase ASCII letters."
          },
          {
            "name": "upper-roman",
            "description": "Uppercase ASCII Roman numerals."
          }
        ],
        "syntax": "<counter-style> | <string> | none",
        "relevance": 73,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/list-style-type"
          }
        ],
        "description": "Used to construct the default contents of a list item's marker",
        "restrictions": [
          "enum",
          "string"
        ]
      },
      {
        "name": "margin",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "[ <length> | <percentage> | auto ]{1,4}",
        "relevance": 95,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-block-end",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<'margin-left'>",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-block-end"
          }
        ],
        "description": "Logical 'margin-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-block-start",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<'margin-left'>",
        "relevance": 56,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-block-start"
          }
        ],
        "description": "Logical 'margin-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-bottom",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-bottom"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-inline-end",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<'margin-left'>",
        "relevance": 58,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-inline-end"
          }
        ],
        "description": "Logical 'margin-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-inline-start",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<'margin-left'>",
        "relevance": 59,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-inline-start"
          }
        ],
        "description": "Logical 'margin-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-left",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-left"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-right",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-right"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "margin-top",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 94,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/margin-top"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "marker",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "none",
            "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
          },
          {
            "name": "url()",
            "description": "Indicates that the <marker> element referenced will be used."
          }
        ],
        "relevance": 50,
        "description": "Specifies the marker symbol that shall be used for all points on the sets the value for all vertices on the given 'path' element or basic shape.",
        "restrictions": [
          "url"
        ]
      },
      {
        "name": "marker-end",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "none",
            "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
          },
          {
            "name": "url()",
            "description": "Indicates that the <marker> element referenced will be used."
          }
        ],
        "relevance": 50,
        "description": "Specifies the marker that will be drawn at the last vertices of the given markable element.",
        "restrictions": [
          "url"
        ]
      },
      {
        "name": "marker-mid",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "none",
            "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
          },
          {
            "name": "url()",
            "description": "Indicates that the <marker> element referenced will be used."
          }
        ],
        "relevance": 50,
        "description": "Specifies the marker that will be drawn at all vertices except the first and last.",
        "restrictions": [
          "url"
        ]
      },
      {
        "name": "marker-start",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "none",
            "description": "Indicates that no marker symbol will be drawn at the given vertex or vertices."
          },
          {
            "name": "url()",
            "description": "Indicates that the <marker> element referenced will be used."
          }
        ],
        "relevance": 50,
        "description": "Specifies the marker that will be drawn at the first vertices of the given markable element.",
        "restrictions": [
          "url"
        ]
      },
      {
        "name": "mask-image",
        "browsers": [
          "E79",
          "FF53",
          "S15.4",
          "C120",
          "O15"
        ],
        "values": [
          {
            "name": "none",
            "description": "Counts as a transparent black image layer."
          },
          {
            "name": "url()",
            "description": "Reference to a <mask element or to a CSS image."
          }
        ],
        "syntax": "<mask-reference>#",
        "relevance": 57,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-image"
          }
        ],
        "description": "Sets the mask layer image of an element.",
        "restrictions": [
          "url",
          "image",
          "enum"
        ]
      },
      {
        "name": "mask-mode",
        "browsers": [
          "E120",
          "FF53",
          "S15.4",
          "C120",
          "O106"
        ],
        "values": [
          {
            "name": "alpha",
            "description": "Alpha values of the mask layer image should be used as the mask values."
          },
          {
            "name": "auto",
            "description": "Use alpha values if 'mask-image' is an image, luminance if a <mask> element or a CSS image."
          },
          {
            "name": "luminance",
            "description": "Luminance values of the mask layer image should be used as the mask values."
          }
        ],
        "syntax": "<masking-mode>#",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-mode"
          }
        ],
        "description": "Indicates whether the mask layer image is treated as luminance mask or alpha mask.",
        "restrictions": [
          "url",
          "image",
          "enum"
        ]
      },
      {
        "name": "mask-origin",
        "browsers": [
          "E120",
          "FF53",
          "S15.4",
          "C120",
          "O106"
        ],
        "syntax": "<geometry-box>#",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-origin"
          }
        ],
        "description": "Specifies the mask positioning area.",
        "restrictions": [
          "geometry-box",
          "enum"
        ]
      },
      {
        "name": "mask-position",
        "browsers": [
          "E79",
          "FF53",
          "S15.4",
          "C120",
          "O106"
        ],
        "syntax": "<position>#",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-position"
          }
        ],
        "description": "Specifies how mask layer images are positioned.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "mask-repeat",
        "browsers": [
          "E79",
          "FF53",
          "S15.4",
          "C120",
          "O106"
        ],
        "syntax": "<repeat-style>#",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-repeat"
          }
        ],
        "description": "Specifies how mask layer images are tiled after they have been sized and positioned.",
        "restrictions": [
          "repeat"
        ]
      },
      {
        "name": "mask-size",
        "browsers": [
          "E79",
          "FF53",
          "S15.4",
          "C120",
          "O106"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%."
          },
          {
            "name": "contain",
            "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
          },
          {
            "name": "cover",
            "description": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."
          }
        ],
        "syntax": "<bg-size>#",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-size"
          }
        ],
        "description": "Specifies the size of the mask layer images.",
        "restrictions": [
          "length",
          "percentage",
          "enum"
        ]
      },
      {
        "name": "mask-type",
        "browsers": [
          "E79",
          "FF35",
          "S7",
          "C24",
          "O15"
        ],
        "values": [
          {
            "name": "alpha",
            "description": "Indicates that the alpha values of the mask should be used."
          },
          {
            "name": "luminance",
            "description": "Indicates that the luminance values of the mask should be used."
          }
        ],
        "syntax": "luminance | alpha",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mask-type"
          }
        ],
        "description": "Defines whether the content of the <mask> element is treated as as luminance mask or alpha mask.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "max-block-size",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "none",
            "description": "No limit on the width of the box."
          }
        ],
        "syntax": "<'max-width'>",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/max-block-size"
          }
        ],
        "description": "Maximum size of an element in the direction opposite that of the direction specified by 'writing-mode'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "max-height",
        "browsers": [
          "E12",
          "FF1",
          "S1.3",
          "C18",
          "IE7",
          "O7"
        ],
        "values": [
          {
            "name": "none",
            "description": "No limit on the height of the box."
          },
          {
            "name": "fit-content",
            "browsers": [
              "E12",
              "FF1",
              "S1.3",
              "C18",
              "IE7",
              "O7"
            ],
            "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
          },
          {
            "name": "max-content",
            "browsers": [
              "E12",
              "FF1",
              "S1.3",
              "C18",
              "IE7",
              "O7"
            ],
            "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
          },
          {
            "name": "min-content",
            "browsers": [
              "E12",
              "FF1",
              "S1.3",
              "C18",
              "IE7",
              "O7"
            ],
            "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
          }
        ],
        "syntax": "none | <length-percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",
        "relevance": 85,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/max-height"
          }
        ],
        "description": "Allows authors to constrain content height to a certain range.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "max-inline-size",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "none",
            "description": "No limit on the height of the box."
          }
        ],
        "syntax": "<'max-width'>",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/max-inline-size"
          }
        ],
        "description": "Maximum size of an element in the direction specified by 'writing-mode'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "max-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE7",
          "O4"
        ],
        "values": [
          {
            "name": "none",
            "description": "No limit on the width of the box."
          },
          {
            "name": "fit-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
          },
          {
            "name": "max-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
          },
          {
            "name": "min-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
          }
        ],
        "syntax": "none | <length-percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/max-width"
          }
        ],
        "description": "Allows authors to constrain content width to a certain range.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "min-block-size",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C57",
          "O44"
        ],
        "syntax": "<'min-width'>",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/min-block-size"
          }
        ],
        "description": "Minimal size of an element in the direction opposite that of the direction specified by 'writing-mode'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "min-height",
        "browsers": [
          "E12",
          "FF3",
          "S1.3",
          "C1",
          "IE7",
          "O4"
        ],
        "values": [
          {
            "name": "auto",
            "browsers": [
              "E12",
              "FF3",
              "S1.3",
              "C1",
              "IE7",
              "O4"
            ]
          },
          {
            "name": "fit-content",
            "browsers": [
              "E12",
              "FF3",
              "S1.3",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
          },
          {
            "name": "max-content",
            "browsers": [
              "E12",
              "FF3",
              "S1.3",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
          },
          {
            "name": "min-content",
            "browsers": [
              "E12",
              "FF3",
              "S1.3",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
          }
        ],
        "syntax": "auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",
        "relevance": 89,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/min-height"
          }
        ],
        "description": "Allows authors to constrain content height to a certain range.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "min-inline-size",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C57",
          "O44"
        ],
        "syntax": "<'min-width'>",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/min-inline-size"
          }
        ],
        "description": "Minimal size of an element in the direction specified by 'writing-mode'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "min-width",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE7",
          "O4"
        ],
        "values": [
          {
            "name": "auto",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ]
          },
          {
            "name": "fit-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."
          },
          {
            "name": "max-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the max-content inline size or max-content block size, as appropriate to the writing mode."
          },
          {
            "name": "min-content",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE7",
              "O4"
            ],
            "description": "Use the min-content inline size or min-content block size, as appropriate to the writing mode."
          }
        ],
        "syntax": "auto | <length> | <percentage> | min-content | max-content | fit-content | fit-content(<length-percentage>)",
        "relevance": 88,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/min-width"
          }
        ],
        "description": "Allows authors to constrain content width to a certain range.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "mix-blend-mode",
        "browsers": [
          "E79",
          "FF32",
          "S8",
          "C41",
          "O28"
        ],
        "values": [
          {
            "name": "normal",
            "description": "Default attribute which specifies no blending"
          },
          {
            "name": "multiply",
            "description": "The source color is multiplied by the destination color and replaces the destination."
          },
          {
            "name": "screen",
            "description": "Multiplies the complements of the backdrop and source color values, then complements the result."
          },
          {
            "name": "overlay",
            "description": "Multiplies or screens the colors, depending on the backdrop color value."
          },
          {
            "name": "darken",
            "description": "Selects the darker of the backdrop and source colors."
          },
          {
            "name": "lighten",
            "description": "Selects the lighter of the backdrop and source colors."
          },
          {
            "name": "color-dodge",
            "description": "Brightens the backdrop color to reflect the source color."
          },
          {
            "name": "color-burn",
            "description": "Darkens the backdrop color to reflect the source color."
          },
          {
            "name": "hard-light",
            "description": "Multiplies or screens the colors, depending on the source color value."
          },
          {
            "name": "soft-light",
            "description": "Darkens or lightens the colors, depending on the source color value."
          },
          {
            "name": "difference",
            "description": "Subtracts the darker of the two constituent colors from the lighter color.."
          },
          {
            "name": "exclusion",
            "description": "Produces an effect similar to that of the Difference mode but lower in contrast."
          },
          {
            "name": "hue",
            "browsers": [
              "E79",
              "FF32",
              "S8",
              "C41",
              "O28"
            ],
            "description": "Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."
          },
          {
            "name": "saturation",
            "browsers": [
              "E79",
              "FF32",
              "S8",
              "C41",
              "O28"
            ],
            "description": "Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."
          },
          {
            "name": "color",
            "browsers": [
              "E79",
              "FF32",
              "S8",
              "C41",
              "O28"
            ],
            "description": "Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."
          },
          {
            "name": "luminosity",
            "browsers": [
              "E79",
              "FF32",
              "S8",
              "C41",
              "O28"
            ],
            "description": "Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."
          }
        ],
        "syntax": "<blend-mode> | plus-lighter",
        "relevance": 54,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode"
          }
        ],
        "description": "Defines the formula that must be used to mix the colors with the backdrop.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "motion",
        "browsers": [
          "C46",
          "O33"
        ],
        "values": [
          {
            "name": "none",
            "description": "No motion path gets created."
          },
          {
            "name": "path()",
            "description": "Defines an SVG path as a string, with optional 'fill-rule' as the first argument."
          },
          {
            "name": "auto",
            "description": "Indicates that the object is rotated by the angle of the direction of the motion path."
          },
          {
            "name": "reverse",
            "description": "Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."
          }
        ],
        "relevance": 50,
        "description": "Shorthand property for setting 'motion-path', 'motion-offset' and 'motion-rotation'.",
        "restrictions": [
          "url",
          "length",
          "percentage",
          "angle",
          "shape",
          "geometry-box",
          "enum"
        ]
      },
      {
        "name": "motion-offset",
        "browsers": [
          "C46",
          "O33"
        ],
        "relevance": 50,
        "description": "A distance that describes the position along the specified motion path.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "motion-path",
        "browsers": [
          "C46",
          "O33"
        ],
        "values": [
          {
            "name": "none",
            "description": "No motion path gets created."
          },
          {
            "name": "path()",
            "description": "Defines an SVG path as a string, with optional 'fill-rule' as the first argument."
          }
        ],
        "relevance": 50,
        "description": "Specifies the motion path the element gets positioned at.",
        "restrictions": [
          "url",
          "shape",
          "geometry-box",
          "enum"
        ]
      },
      {
        "name": "motion-rotation",
        "browsers": [
          "C46",
          "O33"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Indicates that the object is rotated by the angle of the direction of the motion path."
          },
          {
            "name": "reverse",
            "description": "Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."
          }
        ],
        "relevance": 50,
        "description": "Defines the direction of the element while positioning along the motion path.",
        "restrictions": [
          "angle"
        ]
      },
      {
        "name": "-moz-animation",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "alternate",
            "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
          },
          {
            "name": "alternate-reverse",
            "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
          },
          {
            "name": "backwards",
            "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
          },
          {
            "name": "both",
            "description": "Both forwards and backwards fill modes are applied."
          },
          {
            "name": "forwards",
            "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
          },
          {
            "name": "infinite",
            "description": "Causes the animation to repeat forever."
          },
          {
            "name": "none",
            "description": "No animation is performed"
          },
          {
            "name": "normal",
            "description": "Normal playback."
          },
          {
            "name": "reverse",
            "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
          }
        ],
        "relevance": 50,
        "description": "Shorthand property combines six of the animation properties into a single property.",
        "restrictions": [
          "time",
          "enum",
          "timing-function",
          "identifier",
          "number"
        ]
      },
      {
        "name": "-moz-animation-delay",
        "browsers": [
          "FF9"
        ],
        "relevance": 50,
        "description": "Defines when the animation will start.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-moz-animation-direction",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "alternate",
            "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
          },
          {
            "name": "alternate-reverse",
            "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
          },
          {
            "name": "normal",
            "description": "Normal playback."
          },
          {
            "name": "reverse",
            "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
          }
        ],
        "relevance": 50,
        "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-animation-duration",
        "browsers": [
          "FF9"
        ],
        "relevance": 50,
        "description": "Defines the length of time that an animation takes to complete one cycle.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-moz-animation-iteration-count",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "infinite",
            "description": "Causes the animation to repeat forever."
          }
        ],
        "relevance": 50,
        "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
        "restrictions": [
          "number",
          "enum"
        ]
      },
      {
        "name": "-moz-animation-name",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "none",
            "description": "No animation is performed"
          }
        ],
        "relevance": 50,
        "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
        "restrictions": [
          "identifier",
          "enum"
        ]
      },
      {
        "name": "-moz-animation-play-state",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "paused",
            "description": "A running animation will be paused."
          },
          {
            "name": "running",
            "description": "Resume playback of a paused animation."
          }
        ],
        "relevance": 50,
        "description": "Defines whether the animation is running or paused.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-animation-timing-function",
        "browsers": [
          "FF9"
        ],
        "relevance": 50,
        "description": "Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",
        "restrictions": [
          "timing-function"
        ]
      },
      {
        "name": "-moz-appearance",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "button"
          },
          {
            "name": "button-arrow-down"
          },
          {
            "name": "button-arrow-next"
          },
          {
            "name": "button-arrow-previous"
          },
          {
            "name": "button-arrow-up"
          },
          {
            "name": "button-bevel"
          },
          {
            "name": "checkbox"
          },
          {
            "name": "checkbox-container"
          },
          {
            "name": "checkbox-label"
          },
          {
            "name": "dialog"
          },
          {
            "name": "groupbox"
          },
          {
            "name": "listbox"
          },
          {
            "name": "menuarrow"
          },
          {
            "name": "menuimage"
          },
          {
            "name": "menuitem"
          },
          {
            "name": "menuitemtext"
          },
          {
            "name": "menulist"
          },
          {
            "name": "menulist-button"
          },
          {
            "name": "menulist-text"
          },
          {
            "name": "menulist-textfield"
          },
          {
            "name": "menupopup"
          },
          {
            "name": "menuradio"
          },
          {
            "name": "menuseparator"
          },
          {
            "name": "-moz-mac-unified-toolbar"
          },
          {
            "name": "-moz-win-borderless-glass"
          },
          {
            "name": "-moz-win-browsertabbar-toolbox"
          },
          {
            "name": "-moz-win-communications-toolbox"
          },
          {
            "name": "-moz-win-glass"
          },
          {
            "name": "-moz-win-media-toolbox"
          },
          {
            "name": "none"
          },
          {
            "name": "progressbar"
          },
          {
            "name": "progresschunk"
          },
          {
            "name": "radio"
          },
          {
            "name": "radio-container"
          },
          {
            "name": "radio-label"
          },
          {
            "name": "radiomenuitem"
          },
          {
            "name": "resizer"
          },
          {
            "name": "resizerpanel"
          },
          {
            "name": "scrollbarbutton-down"
          },
          {
            "name": "scrollbarbutton-left"
          },
          {
            "name": "scrollbarbutton-right"
          },
          {
            "name": "scrollbarbutton-up"
          },
          {
            "name": "scrollbar-small"
          },
          {
            "name": "scrollbartrack-horizontal"
          },
          {
            "name": "scrollbartrack-vertical"
          },
          {
            "name": "separator"
          },
          {
            "name": "spinner"
          },
          {
            "name": "spinner-downbutton"
          },
          {
            "name": "spinner-textfield"
          },
          {
            "name": "spinner-upbutton"
          },
          {
            "name": "statusbar"
          },
          {
            "name": "statusbarpanel"
          },
          {
            "name": "tab"
          },
          {
            "name": "tabpanels"
          },
          {
            "name": "tab-scroll-arrow-back"
          },
          {
            "name": "tab-scroll-arrow-forward"
          },
          {
            "name": "textfield"
          },
          {
            "name": "textfield-multiline"
          },
          {
            "name": "toolbar"
          },
          {
            "name": "toolbox"
          },
          {
            "name": "tooltip"
          },
          {
            "name": "treeheadercell"
          },
          {
            "name": "treeheadersortarrow"
          },
          {
            "name": "treeitem"
          },
          {
            "name": "treetwistyopen"
          },
          {
            "name": "treeview"
          },
          {
            "name": "treewisty"
          },
          {
            "name": "window"
          }
        ],
        "status": "nonstandard",
        "syntax": "none | button | button-arrow-down | button-arrow-next | button-arrow-previous | button-arrow-up | button-bevel | button-focus | caret | checkbox | checkbox-container | checkbox-label | checkmenuitem | dualbutton | groupbox | listbox | listitem | menuarrow | menubar | menucheckbox | menuimage | menuitem | menuitemtext | menulist | menulist-button | menulist-text | menulist-textfield | menupopup | menuradio | menuseparator | meterbar | meterchunk | progressbar | progressbar-vertical | progresschunk | progresschunk-vertical | radio | radio-container | radio-label | radiomenuitem | range | range-thumb | resizer | resizerpanel | scale-horizontal | scalethumbend | scalethumb-horizontal | scalethumbstart | scalethumbtick | scalethumb-vertical | scale-vertical | scrollbarbutton-down | scrollbarbutton-left | scrollbarbutton-right | scrollbarbutton-up | scrollbarthumb-horizontal | scrollbarthumb-vertical | scrollbartrack-horizontal | scrollbartrack-vertical | searchfield | separator | sheet | spinner | spinner-downbutton | spinner-textfield | spinner-upbutton | splitter | statusbar | statusbarpanel | tab | tabpanel | tabpanels | tab-scroll-arrow-back | tab-scroll-arrow-forward | textfield | textfield-multiline | toolbar | toolbarbutton | toolbarbutton-dropdown | toolbargripper | toolbox | tooltip | treeheader | treeheadercell | treeheadersortarrow | treeitem | treeline | treetwisty | treetwistyopen | treeview | -moz-mac-unified-toolbar | -moz-win-borderless-glass | -moz-win-browsertabbar-toolbox | -moz-win-communicationstext | -moz-win-communications-toolbox | -moz-win-exclude-glass | -moz-win-glass | -moz-win-mediatext | -moz-win-media-toolbox | -moz-window-button-box | -moz-window-button-box-maximized | -moz-window-button-close | -moz-window-button-maximize | -moz-window-button-minimize | -moz-window-button-restore | -moz-window-frame-bottom | -moz-window-frame-left | -moz-window-frame-right | -moz-window-titlebar | -moz-window-titlebar-maximized",
        "relevance": 0,
        "description": "Used in Gecko (Firefox) to display an element using a platform-native styling based on the operating system's theme.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-backface-visibility",
        "browsers": [
          "FF10"
        ],
        "values": [
          {
            "name": "hidden"
          },
          {
            "name": "visible"
          }
        ],
        "relevance": 50,
        "description": "Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-background-clip",
        "browsers": [
          "FF1-3.6"
        ],
        "values": [
          {
            "name": "padding"
          }
        ],
        "relevance": 50,
        "description": "Determines the background painting area.",
        "restrictions": [
          "box",
          "enum"
        ]
      },
      {
        "name": "-moz-background-inline-policy",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "bounding-box"
          },
          {
            "name": "continuous"
          },
          {
            "name": "each-box"
          }
        ],
        "relevance": 50,
        "description": "In Gecko-based applications like Firefox, the -moz-background-inline-policy CSS property specifies how the background image of an inline element is determined when the content of the inline element wraps onto multiple lines. The choice of position has significant effects on repetition.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-background-origin",
        "browsers": [
          "FF1"
        ],
        "relevance": 50,
        "description": "For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",
        "restrictions": [
          "box"
        ]
      },
      {
        "name": "-moz-border-bottom-colors",
        "browsers": [
          "FF1"
        ],
        "status": "nonstandard",
        "syntax": "<color>+ | none",
        "relevance": 0,
        "description": "Sets a list of colors for the bottom border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-moz-border-image",
        "browsers": [
          "FF3.6"
        ],
        "values": [
          {
            "name": "auto",
            "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
          },
          {
            "name": "fill",
            "description": "Causes the middle part of the border-image to be preserved."
          },
          {
            "name": "none"
          },
          {
            "name": "repeat",
            "description": "The image is tiled (repeated) to fill the area."
          },
          {
            "name": "round",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
          },
          {
            "name": "space",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
          },
          {
            "name": "stretch",
            "description": "The image is stretched to fill the area."
          },
          {
            "name": "url()"
          }
        ],
        "relevance": 50,
        "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
        "restrictions": [
          "length",
          "percentage",
          "number",
          "url",
          "enum"
        ]
      },
      {
        "name": "-moz-border-left-colors",
        "browsers": [
          "FF1"
        ],
        "status": "nonstandard",
        "syntax": "<color>+ | none",
        "relevance": 0,
        "description": "Sets a list of colors for the bottom border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-moz-border-right-colors",
        "browsers": [
          "FF1"
        ],
        "status": "nonstandard",
        "syntax": "<color>+ | none",
        "relevance": 0,
        "description": "Sets a list of colors for the bottom border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-moz-border-top-colors",
        "browsers": [
          "FF1"
        ],
        "status": "nonstandard",
        "syntax": "<color>+ | none",
        "relevance": 0,
        "description": "Ske Firefox, -moz-border-bottom-colors sets a list of colors for the bottom border.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-moz-box-align",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "baseline",
            "description": "If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."
          },
          {
            "name": "center",
            "description": "Any extra space is divided evenly, with half placed above the child and the other half placed after the child."
          },
          {
            "name": "end",
            "description": "For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."
          },
          {
            "name": "start",
            "description": "For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."
          },
          {
            "name": "stretch",
            "description": "The height of each child is adjusted to that of the containing block."
          }
        ],
        "relevance": 50,
        "description": "Specifies how a XUL box aligns its contents across (perpendicular to) the direction of its layout. The effect of this is only visible if there is extra space in the box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-box-direction",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "normal",
            "description": "A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."
          },
          {
            "name": "reverse",
            "description": "A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."
          }
        ],
        "relevance": 50,
        "description": "Specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-box-flex",
        "browsers": [
          "FF1"
        ],
        "relevance": 50,
        "description": "Specifies how a box grows to fill the box that contains it, in the direction of the containing box's layout.",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "-moz-box-flexgroup",
        "browsers": [
          "FF1"
        ],
        "relevance": 50,
        "description": "Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-moz-box-ordinal-group",
        "browsers": [
          "FF1"
        ],
        "relevance": 50,
        "description": "Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-moz-box-orient",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "block-axis",
            "description": "Elements are oriented along the box's axis."
          },
          {
            "name": "horizontal",
            "description": "The box displays its children from left to right in a horizontal line."
          },
          {
            "name": "inline-axis",
            "description": "Elements are oriented vertically."
          },
          {
            "name": "vertical",
            "description": "The box displays its children from stacked from top to bottom vertically."
          }
        ],
        "relevance": 50,
        "description": "In Mozilla applications, -moz-box-orient specifies whether a box lays out its contents horizontally or vertically.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-box-pack",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "center",
            "description": "The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."
          },
          {
            "name": "end",
            "description": "For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."
          },
          {
            "name": "justify",
            "description": "The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."
          },
          {
            "name": "start",
            "description": "For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."
          }
        ],
        "relevance": 50,
        "description": "Specifies how a box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-box-sizing",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "border-box",
            "description": "The specified width and height (and respective min/max properties) on this element determine the border box of the element."
          },
          {
            "name": "content-box",
            "description": "Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."
          },
          {
            "name": "padding-box",
            "description": "The specified width and height (and respective min/max properties) on this element determine the padding box of the element."
          }
        ],
        "relevance": 50,
        "description": "Box Model addition in CSS3.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-column-count",
        "browsers": [
          "FF3.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Determines the number of columns by the 'column-width' property and the element width."
          }
        ],
        "relevance": 50,
        "description": "Describes the optimal number of columns into which the content of the element will be flowed.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-moz-column-gap",
        "browsers": [
          "FF3.5"
        ],
        "values": [
          {
            "name": "normal",
            "description": "User agent specific and typically equivalent to 1em."
          }
        ],
        "relevance": 50,
        "description": "Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-moz-column-rule",
        "browsers": [
          "FF3.5"
        ],
        "relevance": 50,
        "description": "Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color"
        ]
      },
      {
        "name": "-moz-column-rule-color",
        "browsers": [
          "FF3.5"
        ],
        "relevance": 50,
        "description": "Sets the color of the column rule",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-moz-column-rule-style",
        "browsers": [
          "FF3.5"
        ],
        "relevance": 50,
        "description": "Sets the style of the rule between columns of an element.",
        "restrictions": [
          "line-style"
        ]
      },
      {
        "name": "-moz-column-rule-width",
        "browsers": [
          "FF3.5"
        ],
        "relevance": 50,
        "description": "Sets the width of the rule between columns. Negative values are not allowed.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "-moz-columns",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The width depends on the values of other properties."
          }
        ],
        "relevance": 50,
        "description": "A shorthand property which sets both 'column-width' and 'column-count'.",
        "restrictions": [
          "length",
          "integer"
        ]
      },
      {
        "name": "-moz-column-width",
        "browsers": [
          "FF3.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The width depends on the values of other properties."
          }
        ],
        "relevance": 50,
        "description": "This property describes the width of columns in multicol elements.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-moz-font-feature-settings",
        "browsers": [
          "FF4"
        ],
        "values": [
          {
            "name": '"c2cs"'
          },
          {
            "name": '"dlig"'
          },
          {
            "name": '"kern"'
          },
          {
            "name": '"liga"'
          },
          {
            "name": '"lnum"'
          },
          {
            "name": '"onum"'
          },
          {
            "name": '"smcp"'
          },
          {
            "name": '"swsh"'
          },
          {
            "name": '"tnum"'
          },
          {
            "name": "normal",
            "description": "No change in glyph substitution or positioning occurs."
          },
          {
            "name": "off",
            "browsers": [
              "FF4"
            ]
          },
          {
            "name": "on",
            "browsers": [
              "FF4"
            ]
          }
        ],
        "relevance": 50,
        "description": "Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",
        "restrictions": [
          "string",
          "integer"
        ]
      },
      {
        "name": "-moz-hyphens",
        "browsers": [
          "FF9"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
          },
          {
            "name": "manual",
            "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
          },
          {
            "name": "none",
            "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
          }
        ],
        "relevance": 50,
        "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-perspective",
        "browsers": [
          "FF10"
        ],
        "values": [
          {
            "name": "none",
            "description": "No perspective transform is applied."
          }
        ],
        "relevance": 50,
        "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-moz-perspective-origin",
        "browsers": [
          "FF10"
        ],
        "relevance": 50,
        "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
        "restrictions": [
          "position",
          "percentage",
          "length"
        ]
      },
      {
        "name": "-moz-text-align-last",
        "browsers": [
          "FF12"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "center",
            "description": "The inline contents are centered within the line box."
          },
          {
            "name": "justify",
            "description": "The text is justified according to the method specified by the 'text-justify' property."
          },
          {
            "name": "left",
            "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
          },
          {
            "name": "right",
            "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
          }
        ],
        "relevance": 50,
        "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-text-decoration-color",
        "browsers": [
          "FF6"
        ],
        "relevance": 50,
        "description": "Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-moz-text-decoration-line",
        "browsers": [
          "FF6"
        ],
        "values": [
          {
            "name": "line-through",
            "description": "Each line of text has a line through the middle."
          },
          {
            "name": "none",
            "description": "Neither produces nor inhibits text decoration."
          },
          {
            "name": "overline",
            "description": "Each line of text has a line above it."
          },
          {
            "name": "underline",
            "description": "Each line of text is underlined."
          }
        ],
        "relevance": 50,
        "description": "Specifies what line decorations, if any, are added to the element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-text-decoration-style",
        "browsers": [
          "FF6"
        ],
        "values": [
          {
            "name": "dashed",
            "description": "Produces a dashed line style."
          },
          {
            "name": "dotted",
            "description": "Produces a dotted line."
          },
          {
            "name": "double",
            "description": "Produces a double line."
          },
          {
            "name": "none",
            "description": "Produces no line."
          },
          {
            "name": "solid",
            "description": "Produces a solid line."
          },
          {
            "name": "wavy",
            "description": "Produces a wavy line."
          }
        ],
        "relevance": 50,
        "description": "Specifies the line style for underline, line-through and overline text decoration.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-text-size-adjust",
        "browsers": [
          "FF"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Renderers must use the default size adjustment when displaying on a small device."
          },
          {
            "name": "none",
            "description": "Renderers must not do size adjustment when displaying on a small device."
          }
        ],
        "relevance": 50,
        "description": "Specifies a size adjustment for displaying text content in mobile browsers.",
        "restrictions": [
          "enum",
          "percentage"
        ]
      },
      {
        "name": "-moz-transform",
        "browsers": [
          "FF3.5"
        ],
        "values": [
          {
            "name": "matrix()",
            "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
          },
          {
            "name": "matrix3d()",
            "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
          },
          {
            "name": "none"
          },
          {
            "name": "perspective",
            "description": "Specifies a perspective projection matrix."
          },
          {
            "name": "rotate()",
            "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
          },
          {
            "name": "rotate3d()",
            "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
          },
          {
            "name": "rotateX('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the X axis."
          },
          {
            "name": "rotateY('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the Y axis."
          },
          {
            "name": "rotateZ('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the Z axis."
          },
          {
            "name": "scale()",
            "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
          },
          {
            "name": "scale3d()",
            "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
          },
          {
            "name": "scaleX()",
            "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
          },
          {
            "name": "scaleY()",
            "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
          },
          {
            "name": "scaleZ()",
            "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
          },
          {
            "name": "skew()",
            "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
          },
          {
            "name": "skewX()",
            "description": "Specifies a skew transformation along the X axis by the given angle."
          },
          {
            "name": "skewY()",
            "description": "Specifies a skew transformation along the Y axis by the given angle."
          },
          {
            "name": "translate()",
            "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
          },
          {
            "name": "translate3d()",
            "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
          },
          {
            "name": "translateX()",
            "description": "Specifies a translation by the given amount in the X direction."
          },
          {
            "name": "translateY()",
            "description": "Specifies a translation by the given amount in the Y direction."
          },
          {
            "name": "translateZ()",
            "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
          }
        ],
        "relevance": 50,
        "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-moz-transform-origin",
        "browsers": [
          "FF3.5"
        ],
        "relevance": 50,
        "description": "Establishes the origin of transformation for an element.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "-moz-transition",
        "browsers": [
          "FF4"
        ],
        "values": [
          {
            "name": "all",
            "description": "Every property that is able to undergo a transition will do so."
          },
          {
            "name": "none",
            "description": "No property will transition."
          }
        ],
        "relevance": 50,
        "description": "Shorthand property combines four of the transition properties into a single property.",
        "restrictions": [
          "time",
          "property",
          "timing-function",
          "enum"
        ]
      },
      {
        "name": "-moz-transition-delay",
        "browsers": [
          "FF4"
        ],
        "relevance": 50,
        "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-moz-transition-duration",
        "browsers": [
          "FF4"
        ],
        "relevance": 50,
        "description": "Specifies how long the transition from the old value to the new value should take.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-moz-transition-property",
        "browsers": [
          "FF4"
        ],
        "values": [
          {
            "name": "all",
            "description": "Every property that is able to undergo a transition will do so."
          },
          {
            "name": "none",
            "description": "No property will transition."
          }
        ],
        "relevance": 50,
        "description": "Specifies the name of the CSS property to which the transition is applied.",
        "restrictions": [
          "property"
        ]
      },
      {
        "name": "-moz-transition-timing-function",
        "browsers": [
          "FF4"
        ],
        "relevance": 50,
        "description": "Describes how the intermediate values used during a transition will be calculated.",
        "restrictions": [
          "timing-function"
        ]
      },
      {
        "name": "-moz-user-focus",
        "browsers": [
          "FF1"
        ],
        "values": [
          {
            "name": "ignore"
          },
          {
            "name": "normal"
          }
        ],
        "status": "nonstandard",
        "syntax": "ignore | normal | select-after | select-before | select-menu | select-same | select-all | none",
        "relevance": 0,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/-moz-user-focus"
          }
        ],
        "description": "Used to indicate whether the element can have focus."
      },
      {
        "name": "-moz-user-select",
        "browsers": [
          "FF1.5"
        ],
        "values": [
          {
            "name": "all"
          },
          {
            "name": "element"
          },
          {
            "name": "elements"
          },
          {
            "name": "-moz-all"
          },
          {
            "name": "-moz-none"
          },
          {
            "name": "none"
          },
          {
            "name": "text"
          },
          {
            "name": "toggle"
          }
        ],
        "relevance": 50,
        "description": "Controls the appearance of selection.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-accelerator",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "false",
            "description": "The element does not contain an accelerator key sequence."
          },
          {
            "name": "true",
            "description": "The element contains an accelerator key sequence."
          }
        ],
        "status": "nonstandard",
        "syntax": "false | true",
        "relevance": 0,
        "description": "IE only. Has the ability to turn off its system underlines for accelerator keys until the ALT key is pressed",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-behavior",
        "browsers": [
          "IE8"
        ],
        "relevance": 50,
        "description": "IE only. Used to extend behaviors of the browser",
        "restrictions": [
          "url"
        ]
      },
      {
        "name": "-ms-block-progression",
        "browsers": [
          "IE8"
        ],
        "values": [
          {
            "name": "bt",
            "description": "Bottom-to-top block flow. Layout is horizontal."
          },
          {
            "name": "lr",
            "description": "Left-to-right direction. The flow orientation is vertical."
          },
          {
            "name": "rl",
            "description": "Right-to-left direction. The flow orientation is vertical."
          },
          {
            "name": "tb",
            "description": "Top-to-bottom direction. The flow orientation is horizontal."
          }
        ],
        "status": "nonstandard",
        "syntax": "tb | rl | bt | lr",
        "relevance": 0,
        "description": "Sets the block-progression value and the flow orientation",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-content-zoom-chaining",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "chained",
            "description": "The nearest zoomable parent element begins zooming when the user hits a zoom limit during a manipulation. No bounce effect is shown."
          },
          {
            "name": "none",
            "description": "A bounce effect is shown when the user hits a zoom limit during a manipulation."
          }
        ],
        "status": "nonstandard",
        "syntax": "none | chained",
        "relevance": 0,
        "description": "Specifies the zoom behavior that occurs when a user hits the zoom limit during a manipulation."
      },
      {
        "name": "-ms-content-zooming",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none",
            "description": "The element is not zoomable."
          },
          {
            "name": "zoom",
            "description": "The element is zoomable."
          }
        ],
        "status": "nonstandard",
        "syntax": "none | zoom",
        "relevance": 0,
        "description": "Specifies whether zooming is enabled.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-content-zoom-limit",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>",
        "relevance": 0,
        "description": "Shorthand property for the -ms-content-zoom-limit-min and -ms-content-zoom-limit-max properties.",
        "restrictions": [
          "percentage"
        ]
      },
      {
        "name": "-ms-content-zoom-limit-max",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<percentage>",
        "relevance": 0,
        "description": "Specifies the maximum zoom factor.",
        "restrictions": [
          "percentage"
        ]
      },
      {
        "name": "-ms-content-zoom-limit-min",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<percentage>",
        "relevance": 0,
        "description": "Specifies the minimum zoom factor.",
        "restrictions": [
          "percentage"
        ]
      },
      {
        "name": "-ms-content-zoom-snap",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "mandatory",
            "description": "Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."
          },
          {
            "name": "none",
            "description": "Indicates that zooming is unaffected by any defined snap-points."
          },
          {
            "name": "proximity",
            "description": 'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'
          },
          {
            "name": "snapInterval(100%, 100%)",
            "description": "Specifies where the snap-points will be placed."
          },
          {
            "name": "snapList()",
            "description": "Specifies the position of individual snap-points as a comma-separated list of zoom factors."
          }
        ],
        "status": "nonstandard",
        "syntax": "<'-ms-content-zoom-snap-type'> || <'-ms-content-zoom-snap-points'>",
        "relevance": 0,
        "description": "Shorthand property for the -ms-content-zoom-snap-type and -ms-content-zoom-snap-points properties."
      },
      {
        "name": "-ms-content-zoom-snap-points",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "snapInterval(100%, 100%)",
            "description": "Specifies where the snap-points will be placed."
          },
          {
            "name": "snapList()",
            "description": "Specifies the position of individual snap-points as a comma-separated list of zoom factors."
          }
        ],
        "status": "nonstandard",
        "syntax": "snapInterval( <percentage>, <percentage> ) | snapList( <percentage># )",
        "relevance": 0,
        "description": "Defines where zoom snap-points are located."
      },
      {
        "name": "-ms-content-zoom-snap-type",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "mandatory",
            "description": "Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."
          },
          {
            "name": "none",
            "description": "Indicates that zooming is unaffected by any defined snap-points."
          },
          {
            "name": "proximity",
            "description": 'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'
          }
        ],
        "status": "nonstandard",
        "syntax": "none | proximity | mandatory",
        "relevance": 0,
        "description": "Specifies how zooming is affected by defined snap-points.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-filter",
        "browsers": [
          "IE8-9"
        ],
        "status": "nonstandard",
        "syntax": "<string>",
        "relevance": 0,
        "description": "IE only. Used to produce visual effects.",
        "restrictions": [
          "string"
        ]
      },
      {
        "name": "-ms-flex",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Retrieves the value of the main size property as the used 'flex-basis'."
          },
          {
            "name": "none",
            "description": "Expands to '0 0 auto'."
          }
        ],
        "relevance": 50,
        "description": "specifies the parameters of a flexible length: the positive and negative flexibility, and the preferred size.",
        "restrictions": [
          "length",
          "number",
          "percentage"
        ]
      },
      {
        "name": "-ms-flex-align",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "baseline",
            "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
          },
          {
            "name": "center",
            "description": "The flex item's margin box is centered in the cross axis within the line."
          },
          {
            "name": "end",
            "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
          },
          {
            "name": "start",
            "description": "The cross-start margin edge of the flexbox item is placed flush with the cross-start edge of the line."
          },
          {
            "name": "stretch",
            "description": "If the cross size property of the flexbox item is anything other than 'auto', this value is identical to 'start'."
          }
        ],
        "relevance": 50,
        "description": "Aligns flex items along the cross axis of the current line of the flex container.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flex-direction",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "column",
            "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
          },
          {
            "name": "column-reverse",
            "description": "Same as 'column', except the main-start and main-end directions are swapped."
          },
          {
            "name": "row",
            "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
          },
          {
            "name": "row-reverse",
            "description": "Same as 'row', except the main-start and main-end directions are swapped."
          }
        ],
        "relevance": 50,
        "description": "Specifies how flex items are placed in the flex container, by setting the direction of the flex container's main axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flex-flow",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "column",
            "description": "The flex container's main axis has the same orientation as the block axis of the current writing mode."
          },
          {
            "name": "column-reverse",
            "description": "Same as 'column', except the main-start and main-end directions are swapped."
          },
          {
            "name": "nowrap",
            "description": "The flex container is single-line."
          },
          {
            "name": "row",
            "description": "The flex container's main axis has the same orientation as the inline axis of the current writing mode."
          },
          {
            "name": "wrap",
            "description": "The flexbox is multi-line."
          },
          {
            "name": "wrap-reverse",
            "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
          }
        ],
        "relevance": 50,
        "description": "Specifies how flexbox items are placed in the flexbox.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flex-item-align",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Computes to the value of 'align-items' on the element's parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."
          },
          {
            "name": "baseline",
            "description": "If the flex item's inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."
          },
          {
            "name": "center",
            "description": "The flex item's margin box is centered in the cross axis within the line."
          },
          {
            "name": "end",
            "description": "The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."
          },
          {
            "name": "start",
            "description": "The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."
          },
          {
            "name": "stretch",
            "description": "If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."
          }
        ],
        "relevance": 50,
        "description": "Allows the default alignment along the cross axis to be overridden for individual flex items.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flex-line-pack",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "center",
            "description": "Lines are packed toward the center of the flex container."
          },
          {
            "name": "distribute",
            "description": "Lines are evenly distributed in the flex container, with half-size spaces on either end."
          },
          {
            "name": "end",
            "description": "Lines are packed toward the end of the flex container."
          },
          {
            "name": "justify",
            "description": "Lines are evenly distributed in the flex container."
          },
          {
            "name": "start",
            "description": "Lines are packed toward the start of the flex container."
          },
          {
            "name": "stretch",
            "description": "Lines stretch to take up the remaining space."
          }
        ],
        "relevance": 50,
        "description": "Aligns a flex container's lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flex-order",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-ms-flex-pack",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "center",
            "description": "Flex items are packed toward the center of the line."
          },
          {
            "name": "distribute",
            "description": "Flex items are evenly distributed in the line, with half-size spaces on either end."
          },
          {
            "name": "end",
            "description": "Flex items are packed toward the end of the line."
          },
          {
            "name": "justify",
            "description": "Flex items are evenly distributed in the line."
          },
          {
            "name": "start",
            "description": "Flex items are packed toward the start of the line."
          }
        ],
        "relevance": 50,
        "description": "Aligns flex items along the main axis of the current line of the flex container.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flex-wrap",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "nowrap",
            "description": "The flex container is single-line."
          },
          {
            "name": "wrap",
            "description": "The flexbox is multi-line."
          },
          {
            "name": "wrap-reverse",
            "description": "Same as 'wrap', except the cross-start and cross-end directions are swapped."
          }
        ],
        "relevance": 50,
        "description": "Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-flow-from",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none",
            "description": "The block container is not a CSS Region."
          }
        ],
        "status": "nonstandard",
        "syntax": "[ none | <custom-ident> ]#",
        "relevance": 0,
        "description": "Makes a block container a region and associates it with a named flow.",
        "restrictions": [
          "identifier"
        ]
      },
      {
        "name": "-ms-flow-into",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none",
            "description": "The element is not moved to a named flow and normal CSS processing takes place."
          }
        ],
        "status": "nonstandard",
        "syntax": "[ none | <custom-ident> ]#",
        "relevance": 0,
        "description": "Places an element or its contents into a named flow.",
        "restrictions": [
          "identifier"
        ]
      },
      {
        "name": "-ms-grid-column",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "end"
          },
          {
            "name": "start"
          }
        ],
        "relevance": 50,
        "description": "Used to place grid items and explicitly defined grid cells in the Grid.",
        "restrictions": [
          "integer",
          "string",
          "enum"
        ]
      },
      {
        "name": "-ms-grid-column-align",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "center",
            "description": "Places the center of the Grid Item's margin box at the center of the Grid Item's column."
          },
          {
            "name": "end",
            "description": "Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's column."
          },
          {
            "name": "start",
            "description": "Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's column."
          },
          {
            "name": "stretch",
            "description": "Ensures that the Grid Item's margin box is equal to the size of the Grid Item's column."
          }
        ],
        "relevance": 50,
        "description": "Aligns the columns in a grid.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-grid-columns",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "none | <track-list> | <auto-track-list>",
        "relevance": 0,
        "description": "Lays out the columns of the grid."
      },
      {
        "name": "-ms-grid-column-span",
        "browsers": [
          "E",
          "IE10"
        ],
        "relevance": 50,
        "description": "Specifies the number of columns to span.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-ms-grid-layer",
        "browsers": [
          "E",
          "IE10"
        ],
        "relevance": 50,
        "description": "Grid-layer is similar in concept to z-index, but avoids overloading the meaning of the z-index property, which is applicable only to positioned elements.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-ms-grid-row",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "end"
          },
          {
            "name": "start"
          }
        ],
        "relevance": 50,
        "description": "grid-row is used to place grid items and explicitly defined grid cells in the Grid.",
        "restrictions": [
          "integer",
          "string",
          "enum"
        ]
      },
      {
        "name": "-ms-grid-row-align",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "center",
            "description": "Places the center of the Grid Item's margin box at the center of the Grid Item's row."
          },
          {
            "name": "end",
            "description": "Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's row."
          },
          {
            "name": "start",
            "description": "Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's row."
          },
          {
            "name": "stretch",
            "description": "Ensures that the Grid Item's margin box is equal to the size of the Grid Item's row."
          }
        ],
        "relevance": 50,
        "description": "Aligns the rows in a grid.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-grid-rows",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "none | <track-list> | <auto-track-list>",
        "relevance": 0,
        "description": "Lays out the columns of the grid."
      },
      {
        "name": "-ms-grid-row-span",
        "browsers": [
          "E",
          "IE10"
        ],
        "relevance": 50,
        "description": "Specifies the number of rows to span.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-ms-high-contrast-adjust",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Properties will be adjusted as applicable."
          },
          {
            "name": "none",
            "description": "No adjustments will be applied."
          }
        ],
        "status": "nonstandard",
        "syntax": "auto | none",
        "relevance": 0,
        "description": "Specifies if properties should be adjusted in high contrast mode.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-hyphenate-limit-chars",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent chooses a value that adapts to the current layout."
          }
        ],
        "status": "nonstandard",
        "syntax": "auto | <integer>{1,3}",
        "relevance": 0,
        "description": "Specifies the minimum number of characters in a hyphenated word.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-ms-hyphenate-limit-lines",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "no-limit",
            "description": "There is no limit."
          }
        ],
        "status": "nonstandard",
        "syntax": "no-limit | <integer>",
        "relevance": 0,
        "description": "Indicates the maximum number of successive hyphenated lines in an element.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-ms-hyphenate-limit-zone",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<percentage> | <length>",
        "relevance": 0,
        "description": "Specifies the maximum amount of unfilled space (before justification) that may be left in the line box before hyphenation is triggered to pull part of a word from the next line back up into the current line.",
        "restrictions": [
          "percentage",
          "length"
        ]
      },
      {
        "name": "-ms-hyphens",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."
          },
          {
            "name": "manual",
            "description": "Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"
          },
          {
            "name": "none",
            "description": "Words are not broken at line breaks, even if characters inside the word suggest line break points."
          }
        ],
        "relevance": 50,
        "description": "Controls whether hyphenation is allowed to create more break opportunities within a line of text.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-ime-mode",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "active",
            "description": "The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."
          },
          {
            "name": "auto",
            "description": "No change is made to the current input method editor state. This is the default."
          },
          {
            "name": "disabled",
            "description": "The input method editor is disabled and may not be activated by the user."
          },
          {
            "name": "inactive",
            "description": "The input method editor is initially inactive, but the user may activate it if they wish."
          },
          {
            "name": "normal",
            "description": "The IME state should be normal; this value can be used in a user style sheet to override the page setting."
          }
        ],
        "relevance": 50,
        "description": "Controls the state of the input method editor for text fields.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-interpolation-mode",
        "browsers": [
          "IE7"
        ],
        "values": [
          {
            "name": "bicubic"
          },
          {
            "name": "nearest-neighbor"
          }
        ],
        "relevance": 50,
        "description": "Gets or sets the interpolation (resampling) method used to stretch images.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-layout-grid",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "char",
            "description": "Any of the range of character values available to the -ms-layout-grid-char property."
          },
          {
            "name": "line",
            "description": "Any of the range of line values available to the -ms-layout-grid-line property."
          },
          {
            "name": "mode",
            "description": "Any of the range of mode values available to the -ms-layout-grid-mode property."
          },
          {
            "name": "type",
            "description": "Any of the range of type values available to the -ms-layout-grid-type property."
          }
        ],
        "relevance": 50,
        "description": "Sets or retrieves the composite document grid properties that specify the layout of text characters."
      },
      {
        "name": "-ms-layout-grid-char",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Largest character in the font of the element is used to set the character grid."
          },
          {
            "name": "none",
            "description": "Default. No character grid is set."
          }
        ],
        "relevance": 50,
        "description": "Sets or retrieves the size of the character grid used for rendering the text content of an element.",
        "restrictions": [
          "enum",
          "length",
          "percentage"
        ]
      },
      {
        "name": "-ms-layout-grid-line",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Largest character in the font of the element is used to set the character grid."
          },
          {
            "name": "none",
            "description": "Default. No grid line is set."
          }
        ],
        "relevance": 50,
        "description": "Sets or retrieves the gridline value used for rendering the text content of an element.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-layout-grid-mode",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "both",
            "description": "Default. Both the char and line grid modes are enabled. This setting is necessary to fully enable the layout grid on an element."
          },
          {
            "name": "char",
            "description": "Only a character grid is used. This is recommended for use with block-level elements, such as a blockquote, where the line grid is intended to be disabled."
          },
          {
            "name": "line",
            "description": "Only a line grid is used. This is recommended for use with inline elements, such as a span, to disable the horizontal grid on runs of text that act as a single entity in the grid layout."
          },
          {
            "name": "none",
            "description": "No grid is used."
          }
        ],
        "relevance": 50,
        "description": "Gets or sets whether the text layout grid uses two dimensions.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-layout-grid-type",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "fixed",
            "description": "Grid used for monospaced layout. All noncursive characters are treated as equal; every character is centered within a single grid space by default."
          },
          {
            "name": "loose",
            "description": "Default. Grid used for Japanese and Korean characters."
          },
          {
            "name": "strict",
            "description": "Grid used for Chinese, as well as Japanese (Genko) and Korean characters. Only the ideographs, kanas, and wide characters are snapped to the grid."
          }
        ],
        "relevance": 50,
        "description": "Sets or retrieves the type of grid used for rendering the text content of an element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-line-break",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."
          },
          {
            "name": "keep-all",
            "description": "Sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of word separator characters still creates line-breaking opportunities, as in Korean."
          },
          {
            "name": "newspaper",
            "description": "Breaks CJK scripts using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."
          },
          {
            "name": "normal",
            "description": "Breaks CJK scripts using a normal set of line-breaking rules."
          },
          {
            "name": "strict",
            "description": "Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."
          }
        ],
        "relevance": 50,
        "description": "Specifies what set of line breaking restrictions are in effect within the element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-overflow-style",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "No preference, UA should use the first scrolling method in the list that it supports."
          },
          {
            "name": "-ms-autohiding-scrollbar",
            "description": "Indicates the element displays auto-hiding scrollbars during mouse interactions and panning indicators during touch and keyboard interactions."
          },
          {
            "name": "none",
            "description": "Indicates the element does not display scrollbars or panning indicators, even when its content overflows."
          },
          {
            "name": "scrollbar",
            "description": 'Scrollbars are typically narrow strips inserted on one or two edges of an element and which often have arrows to click on and a "thumb" to drag up and down (or left and right) to move the contents of the element.'
          }
        ],
        "status": "nonstandard",
        "syntax": "auto | none | scrollbar | -ms-autohiding-scrollbar",
        "relevance": 0,
        "description": "Specify whether content is clipped when it overflows the element's content area.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-perspective",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "none",
            "description": "No perspective transform is applied."
          }
        ],
        "relevance": 50,
        "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-perspective-origin",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
        "restrictions": [
          "position",
          "percentage",
          "length"
        ]
      },
      {
        "name": "-ms-perspective-origin-x",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "Establishes the origin for the perspective property. It effectively sets the X  position at which the viewer appears to be looking at the children of the element.",
        "restrictions": [
          "position",
          "percentage",
          "length"
        ]
      },
      {
        "name": "-ms-perspective-origin-y",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "Establishes the origin for the perspective property. It effectively sets the Y position at which the viewer appears to be looking at the children of the element.",
        "restrictions": [
          "position",
          "percentage",
          "length"
        ]
      },
      {
        "name": "-ms-progress-appearance",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "bar"
          },
          {
            "name": "ring"
          }
        ],
        "relevance": 50,
        "description": "Gets or sets a value that specifies whether a progress control displays as a bar or a ring.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-scrollbar-3dlight-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-arrow-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the arrow elements of a scroll arrow.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-base-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-darkshadow-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the gutter of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-face-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-highlight-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-shadow-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scrollbar-track-color",
        "browsers": [
          "IE8"
        ],
        "status": "nonstandard",
        "syntax": "<color>",
        "relevance": 0,
        "description": "Determines the color of the track element of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "-ms-scroll-chaining",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "chained"
          },
          {
            "name": "none"
          }
        ],
        "status": "nonstandard",
        "syntax": "chained | none",
        "relevance": 0,
        "description": "Gets or sets a value that indicates the scrolling behavior that occurs when a user hits the content boundary during a manipulation.",
        "restrictions": [
          "enum",
          "length"
        ]
      },
      {
        "name": "-ms-scroll-limit",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "status": "nonstandard",
        "syntax": "<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>",
        "relevance": 0,
        "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-limit-x-min, -ms-scroll-limit-y-min, -ms-scroll-limit-x-max, and -ms-scroll-limit-y-max properties.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-scroll-limit-x-max",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "status": "nonstandard",
        "syntax": "auto | <length>",
        "relevance": 0,
        "description": "Gets or sets a value that specifies the maximum value for the scrollLeft property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-scroll-limit-x-min",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<length>",
        "relevance": 0,
        "description": "Gets or sets a value that specifies the minimum value for the scrollLeft property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-scroll-limit-y-max",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto"
          }
        ],
        "status": "nonstandard",
        "syntax": "auto | <length>",
        "relevance": 0,
        "description": "Gets or sets a value that specifies the maximum value for the scrollTop property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-scroll-limit-y-min",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<length>",
        "relevance": 0,
        "description": "Gets or sets a value that specifies the minimum value for the scrollTop property.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "-ms-scroll-rails",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none"
          },
          {
            "name": "railed"
          }
        ],
        "status": "nonstandard",
        "syntax": "none | railed",
        "relevance": 0,
        "description": "Gets or sets a value that indicates whether or not small motions perpendicular to the primary axis of motion will result in either changes to both the scrollTop and scrollLeft properties or a change to the primary axis (for instance, either the scrollTop or scrollLeft properties will change, but not both).",
        "restrictions": [
          "enum",
          "length"
        ]
      },
      {
        "name": "-ms-scroll-snap-points-x",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "snapInterval(100%, 100%)"
          },
          {
            "name": "snapList()"
          }
        ],
        "status": "nonstandard",
        "syntax": "snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",
        "relevance": 0,
        "description": "Gets or sets a value that defines where snap-points will be located along the x-axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-scroll-snap-points-y",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "snapInterval(100%, 100%)"
          },
          {
            "name": "snapList()"
          }
        ],
        "status": "nonstandard",
        "syntax": "snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",
        "relevance": 0,
        "description": "Gets or sets a value that defines where snap-points will be located along the y-axis.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-scroll-snap-type",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none",
            "description": "The visual viewport of this scroll container must ignore snap points, if any, when scrolled."
          },
          {
            "name": "mandatory",
            "description": "The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."
          },
          {
            "name": "proximity",
            "description": "The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."
          }
        ],
        "status": "nonstandard",
        "syntax": "none | proximity | mandatory",
        "relevance": 0,
        "description": "Gets or sets a value that defines what type of snap-point should be used for the current element. There are two type of snap-points, with the primary difference being whether or not the user is guaranteed to always stop on a snap-point.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-scroll-snap-x",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "mandatory"
          },
          {
            "name": "none"
          },
          {
            "name": "proximity"
          },
          {
            "name": "snapInterval(100%, 100%)"
          },
          {
            "name": "snapList()"
          }
        ],
        "status": "nonstandard",
        "syntax": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>",
        "relevance": 0,
        "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-x properties.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-scroll-snap-y",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "mandatory"
          },
          {
            "name": "none"
          },
          {
            "name": "proximity"
          },
          {
            "name": "snapInterval(100%, 100%)"
          },
          {
            "name": "snapList()"
          }
        ],
        "status": "nonstandard",
        "syntax": "<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>",
        "relevance": 0,
        "description": "Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-y properties.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-scroll-translation",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none"
          },
          {
            "name": "vertical-to-horizontal"
          }
        ],
        "status": "nonstandard",
        "syntax": "none | vertical-to-horizontal",
        "relevance": 0,
        "description": "Gets or sets a value that specifies whether vertical-to-horizontal scroll wheel translation occurs on the specified element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-text-align-last",
        "browsers": [
          "E",
          "IE8"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "center",
            "description": "The inline contents are centered within the line box."
          },
          {
            "name": "justify",
            "description": "The text is justified according to the method specified by the 'text-justify' property."
          },
          {
            "name": "left",
            "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
          },
          {
            "name": "right",
            "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
          }
        ],
        "relevance": 50,
        "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-text-autospace",
        "browsers": [
          "E",
          "IE8"
        ],
        "values": [
          {
            "name": "ideograph-alpha",
            "description": "Creates 1/4em extra spacing between runs of ideographic letters and non-ideographic letters, such as Latin-based, Cyrillic, Greek, Arabic or Hebrew."
          },
          {
            "name": "ideograph-numeric",
            "description": "Creates 1/4em extra spacing between runs of ideographic letters and numeric glyphs."
          },
          {
            "name": "ideograph-parenthesis",
            "description": "Creates extra spacing between normal (non wide) parenthesis and ideographs."
          },
          {
            "name": "ideograph-space",
            "description": "Extends the width of the space character while surrounded by ideographs."
          },
          {
            "name": "none",
            "description": "No extra space is created."
          },
          {
            "name": "punctuation",
            "description": "Creates extra non-breaking spacing around punctuation as required by language-specific typographic conventions."
          }
        ],
        "status": "nonstandard",
        "syntax": "none | ideograph-alpha | ideograph-numeric | ideograph-parenthesis | ideograph-space",
        "relevance": 0,
        "description": "Determines whether or not a full-width punctuation mark character should be trimmed if it appears at the beginning of a line, so that its 'ink' lines up with the first glyph in the line above and below.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-text-combine-horizontal",
        "browsers": [
          "E",
          "IE11"
        ],
        "values": [
          {
            "name": "all",
            "description": "Attempt to typeset horizontally all consecutive characters within the box such that they take up the space of a single character within the vertical line box."
          },
          {
            "name": "digits",
            "description": "Attempt to typeset horizontally each maximal sequence of consecutive ASCII digits (U+0030-U+0039) that has as many or fewer characters than the specified integer such that it takes up the space of a single character within the vertical line box."
          },
          {
            "name": "none",
            "description": "No special processing."
          }
        ],
        "relevance": 50,
        "description": "This property specifies the combination of multiple characters into the space of a single character.",
        "restrictions": [
          "enum",
          "integer"
        ]
      },
      {
        "name": "-ms-text-justify",
        "browsers": [
          "E",
          "IE8"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."
          },
          {
            "name": "distribute",
            "description": "Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."
          },
          {
            "name": "inter-cluster",
            "description": "Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."
          },
          {
            "name": "inter-ideograph",
            "description": "Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."
          },
          {
            "name": "inter-word",
            "description": "Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."
          },
          {
            "name": "kashida",
            "description": "Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."
          }
        ],
        "relevance": 50,
        "description": "Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-text-kashida-space",
        "browsers": [
          "E",
          "IE10"
        ],
        "relevance": 50,
        "description": "Sets or retrieves the ratio of kashida expansion to white space expansion when justifying lines of text in the object.",
        "restrictions": [
          "percentage"
        ]
      },
      {
        "name": "-ms-text-overflow",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "clip",
            "description": "Clip inline content that overflows. Characters may be only partially rendered."
          },
          {
            "name": "ellipsis",
            "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
          }
        ],
        "relevance": 50,
        "description": "Text can overflow for example when it is prevented from wrapping",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-text-size-adjust",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Renderers must use the default size adjustment when displaying on a small device."
          },
          {
            "name": "none",
            "description": "Renderers must not do size adjustment when displaying on a small device."
          }
        ],
        "relevance": 50,
        "description": "Specifies a size adjustment for displaying text content in mobile browsers.",
        "restrictions": [
          "enum",
          "percentage"
        ]
      },
      {
        "name": "-ms-text-underline-position",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "alphabetic",
            "description": "The underline is aligned with the alphabetic baseline. In this case the underline is likely to cross some descenders."
          },
          {
            "name": "auto",
            "description": "The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."
          },
          {
            "name": "over",
            "description": "The underline is aligned with the 'top' (right in vertical writing) edge of the element's em-box. In this mode, an overline also switches sides."
          },
          {
            "name": "under",
            "description": "The underline is aligned with the 'bottom' (left in vertical writing) edge of the element's em-box. In this case the underline usually does not cross the descenders. This is sometimes called 'accounting' underline."
          }
        ],
        "relevance": 50,
        "description": "Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements.This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-touch-action",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The element is a passive element, with several exceptions."
          },
          {
            "name": "double-tap-zoom",
            "description": "The element will zoom on double-tap."
          },
          {
            "name": "manipulation",
            "description": "The element is a manipulation-causing element."
          },
          {
            "name": "none",
            "description": "The element is a manipulation-blocking element."
          },
          {
            "name": "pan-x",
            "description": "The element permits touch-driven panning on the horizontal axis. The touch pan is performed on the nearest ancestor with horizontally scrollable content."
          },
          {
            "name": "pan-y",
            "description": "The element permits touch-driven panning on the vertical axis. The touch pan is performed on the nearest ancestor with vertically scrollable content."
          },
          {
            "name": "pinch-zoom",
            "description": "The element permits pinch-zooming. The pinch-zoom is performed on the nearest ancestor with zoomable content."
          }
        ],
        "relevance": 50,
        "description": "Gets or sets a value that indicates whether and how a given region can be manipulated by the user.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-touch-select",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "grippers",
            "description": "Grippers are always on."
          },
          {
            "name": "none",
            "description": "Grippers are always off."
          }
        ],
        "status": "nonstandard",
        "syntax": "grippers | none",
        "relevance": 0,
        "description": "Gets or sets a value that toggles the 'gripper' visual elements that enable touch text selection.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-transform",
        "browsers": [
          "IE9-9"
        ],
        "values": [
          {
            "name": "matrix()",
            "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
          },
          {
            "name": "matrix3d()",
            "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
          },
          {
            "name": "none"
          },
          {
            "name": "rotate()",
            "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
          },
          {
            "name": "rotate3d()",
            "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
          },
          {
            "name": "rotateX('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the X axis."
          },
          {
            "name": "rotateY('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the Y axis."
          },
          {
            "name": "rotateZ('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the Z axis."
          },
          {
            "name": "scale()",
            "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
          },
          {
            "name": "scale3d()",
            "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
          },
          {
            "name": "scaleX()",
            "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
          },
          {
            "name": "scaleY()",
            "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
          },
          {
            "name": "scaleZ()",
            "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
          },
          {
            "name": "skew()",
            "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
          },
          {
            "name": "skewX()",
            "description": "Specifies a skew transformation along the X axis by the given angle."
          },
          {
            "name": "skewY()",
            "description": "Specifies a skew transformation along the Y axis by the given angle."
          },
          {
            "name": "translate()",
            "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
          },
          {
            "name": "translate3d()",
            "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
          },
          {
            "name": "translateX()",
            "description": "Specifies a translation by the given amount in the X direction."
          },
          {
            "name": "translateY()",
            "description": "Specifies a translation by the given amount in the Y direction."
          },
          {
            "name": "translateZ()",
            "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
          }
        ],
        "relevance": 50,
        "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-transform-origin",
        "browsers": [
          "IE9-9"
        ],
        "relevance": 50,
        "description": "Establishes the origin of transformation for an element.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "-ms-transform-origin-x",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "-ms-transform-origin-y",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "-ms-transform-origin-z",
        "browsers": [
          "IE10"
        ],
        "relevance": 50,
        "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "-ms-user-select",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "element"
          },
          {
            "name": "none"
          },
          {
            "name": "text"
          }
        ],
        "status": "nonstandard",
        "syntax": "none | element | text",
        "relevance": 0,
        "description": "Controls the appearance of selection.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-word-break",
        "browsers": [
          "IE8"
        ],
        "values": [
          {
            "name": "break-all",
            "description": "Lines may break between any two grapheme clusters for non-CJK scripts."
          },
          {
            "name": "keep-all",
            "description": "Block characters can no longer create implied break points."
          },
          {
            "name": "normal",
            "description": "Breaks non-CJK scripts according to their own rules."
          }
        ],
        "relevance": 50,
        "description": "Specifies line break opportunities for non-CJK scripts.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-word-wrap",
        "browsers": [
          "IE8"
        ],
        "values": [
          {
            "name": "break-word",
            "description": "An unbreakable 'word' may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
          },
          {
            "name": "normal",
            "description": "Lines may break only at allowed break points."
          }
        ],
        "relevance": 50,
        "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-wrap-flow",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For floats an exclusion is created, for all other elements an exclusion is not created."
          },
          {
            "name": "both",
            "description": "Inline flow content can flow on all sides of the exclusion."
          },
          {
            "name": "clear",
            "description": "Inline flow content can only wrap on top and bottom of the exclusion and must leave the areas to the start and end edges of the exclusion box empty."
          },
          {
            "name": "end",
            "description": "Inline flow content can wrap on the end side of the exclusion area but must leave the area to the start edge of the exclusion area empty."
          },
          {
            "name": "maximum",
            "description": "Inline flow content can wrap on the side of the exclusion with the largest available space for the given line, and must leave the other side of the exclusion empty."
          },
          {
            "name": "minimum",
            "description": "Inline flow content can flow around the edge of the exclusion with the smallest available space within the flow content's containing block, and must leave the other edge of the exclusion empty."
          },
          {
            "name": "start",
            "description": "Inline flow content can wrap on the start edge of the exclusion area but must leave the area to end edge of the exclusion area empty."
          }
        ],
        "status": "nonstandard",
        "syntax": "auto | both | start | end | maximum | clear",
        "relevance": 0,
        "description": "An element becomes an exclusion when its 'wrap-flow' property has a computed value other than 'auto'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-wrap-margin",
        "browsers": [
          "E",
          "IE10"
        ],
        "status": "nonstandard",
        "syntax": "<length>",
        "relevance": 0,
        "description": "Gets or sets a value that is used to offset the inner wrap shape from other shapes.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "-ms-wrap-through",
        "browsers": [
          "E",
          "IE10"
        ],
        "values": [
          {
            "name": "none",
            "description": "The exclusion element does not inherit its parent node's wrapping context. Its descendants are only subject to exclusion shapes defined inside the element."
          },
          {
            "name": "wrap",
            "description": "The exclusion element inherits its parent node's wrapping context. Its descendant inline content wraps around exclusions defined outside the element."
          }
        ],
        "status": "nonstandard",
        "syntax": "wrap | none",
        "relevance": 0,
        "description": "Specifies if an element inherits its parent wrapping context. In other words if it is subject to the exclusions defined outside the element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-writing-mode",
        "browsers": [
          "IE8"
        ],
        "values": [
          {
            "name": "bt-lr"
          },
          {
            "name": "bt-rl"
          },
          {
            "name": "lr-bt"
          },
          {
            "name": "lr-tb"
          },
          {
            "name": "rl-bt"
          },
          {
            "name": "rl-tb"
          },
          {
            "name": "tb-lr"
          },
          {
            "name": "tb-rl"
          }
        ],
        "relevance": 50,
        "description": "Shorthand property for both 'direction' and 'block-progression'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-ms-zoom",
        "browsers": [
          "IE8"
        ],
        "values": [
          {
            "name": "normal"
          }
        ],
        "relevance": 50,
        "description": "Sets or retrieves the magnification scale of the object.",
        "restrictions": [
          "enum",
          "integer",
          "number",
          "percentage"
        ]
      },
      {
        "name": "-ms-zoom-animation",
        "browsers": [
          "IE10"
        ],
        "values": [
          {
            "name": "default"
          },
          {
            "name": "none"
          }
        ],
        "relevance": 50,
        "description": "Gets or sets a value that indicates whether an animation is used when zooming.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "nav-down",
        "browsers": [
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
          },
          {
            "name": "current",
            "description": "Indicates that the user agent should target the frame that the element is in."
          },
          {
            "name": "root",
            "description": "Indicates that the user agent should target the full window."
          }
        ],
        "relevance": 50,
        "description": "Provides an way to control directional focus navigation.",
        "restrictions": [
          "enum",
          "identifier",
          "string"
        ]
      },
      {
        "name": "nav-index",
        "browsers": [
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The element's sequential navigation order is assigned automatically by the user agent."
          }
        ],
        "relevance": 50,
        "description": "Provides an input-method-neutral way of specifying the sequential navigation order (also known as 'tabbing order').",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "nav-left",
        "browsers": [
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
          },
          {
            "name": "current",
            "description": "Indicates that the user agent should target the frame that the element is in."
          },
          {
            "name": "root",
            "description": "Indicates that the user agent should target the full window."
          }
        ],
        "relevance": 50,
        "description": "Provides an way to control directional focus navigation.",
        "restrictions": [
          "enum",
          "identifier",
          "string"
        ]
      },
      {
        "name": "nav-right",
        "browsers": [
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
          },
          {
            "name": "current",
            "description": "Indicates that the user agent should target the frame that the element is in."
          },
          {
            "name": "root",
            "description": "Indicates that the user agent should target the full window."
          }
        ],
        "relevance": 50,
        "description": "Provides an way to control directional focus navigation.",
        "restrictions": [
          "enum",
          "identifier",
          "string"
        ]
      },
      {
        "name": "nav-up",
        "browsers": [
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent automatically determines which element to navigate the focus to in response to directional navigational input."
          },
          {
            "name": "current",
            "description": "Indicates that the user agent should target the frame that the element is in."
          },
          {
            "name": "root",
            "description": "Indicates that the user agent should target the full window."
          }
        ],
        "relevance": 50,
        "description": "Provides an way to control directional focus navigation.",
        "restrictions": [
          "enum",
          "identifier",
          "string"
        ]
      },
      {
        "name": "negative",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "<symbol> <symbol>?",
        "relevance": 50,
        "description": "@counter-style descriptor. Defines how to alter the representation when the counter value is negative.",
        "restrictions": [
          "image",
          "identifier",
          "string"
        ]
      },
      {
        "name": "-o-animation",
        "browsers": [
          "O12"
        ],
        "values": [
          {
            "name": "alternate",
            "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
          },
          {
            "name": "alternate-reverse",
            "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
          },
          {
            "name": "backwards",
            "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
          },
          {
            "name": "both",
            "description": "Both forwards and backwards fill modes are applied."
          },
          {
            "name": "forwards",
            "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
          },
          {
            "name": "infinite",
            "description": "Causes the animation to repeat forever."
          },
          {
            "name": "none",
            "description": "No animation is performed"
          },
          {
            "name": "normal",
            "description": "Normal playback."
          },
          {
            "name": "reverse",
            "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
          }
        ],
        "relevance": 50,
        "description": "Shorthand property combines six of the animation properties into a single property.",
        "restrictions": [
          "time",
          "enum",
          "timing-function",
          "identifier",
          "number"
        ]
      },
      {
        "name": "-o-animation-delay",
        "browsers": [
          "O12"
        ],
        "relevance": 50,
        "description": "Defines when the animation will start.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-o-animation-direction",
        "browsers": [
          "O12"
        ],
        "values": [
          {
            "name": "alternate",
            "description": "The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."
          },
          {
            "name": "alternate-reverse",
            "description": "The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."
          },
          {
            "name": "normal",
            "description": "Normal playback."
          },
          {
            "name": "reverse",
            "description": "All iterations of the animation are played in the reverse direction from the way they were specified."
          }
        ],
        "relevance": 50,
        "description": "Defines whether or not the animation should play in reverse on alternate cycles.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-o-animation-duration",
        "browsers": [
          "O12"
        ],
        "relevance": 50,
        "description": "Defines the length of time that an animation takes to complete one cycle.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-o-animation-fill-mode",
        "browsers": [
          "O12"
        ],
        "values": [
          {
            "name": "backwards",
            "description": "The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."
          },
          {
            "name": "both",
            "description": "Both forwards and backwards fill modes are applied."
          },
          {
            "name": "forwards",
            "description": "The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."
          },
          {
            "name": "none",
            "description": "There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."
          }
        ],
        "relevance": 50,
        "description": "Defines what values are applied by the animation outside the time it is executing.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-o-animation-iteration-count",
        "browsers": [
          "O12"
        ],
        "values": [
          {
            "name": "infinite",
            "description": "Causes the animation to repeat forever."
          }
        ],
        "relevance": 50,
        "description": "Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",
        "restrictions": [
          "number",
          "enum"
        ]
      },
      {
        "name": "-o-animation-name",
        "browsers": [
          "O12"
        ],
        "values": [
          {
            "name": "none",
            "description": "No animation is performed"
          }
        ],
        "relevance": 50,
        "description": "Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",
        "restrictions": [
          "identifier",
          "enum"
        ]
      },
      {
        "name": "-o-animation-play-state",
        "browsers": [
          "O12"
        ],
        "values": [
          {
            "name": "paused",
            "description": "A running animation will be paused."
          },
          {
            "name": "running",
            "description": "Resume playback of a paused animation."
          }
        ],
        "relevance": 50,
        "description": "Defines whether the animation is running or paused.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-o-animation-timing-function",
        "browsers": [
          "O12"
        ],
        "relevance": 50,
        "description": "Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",
        "restrictions": [
          "timing-function"
        ]
      },
      {
        "name": "object-fit",
        "browsers": [
          "E79",
          "FF36",
          "S10",
          "C32",
          "O19"
        ],
        "values": [
          {
            "name": "contain",
            "description": "The replaced content is sized to maintain its aspect ratio while fitting within the element's content box: its concrete object size is resolved as a contain constraint against the element's used width and height."
          },
          {
            "name": "cover",
            "description": "The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element's used width and height."
          },
          {
            "name": "fill",
            "description": "The replaced content is sized to fill the element's content box: the object's concrete object size is the element's used width and height."
          },
          {
            "name": "none",
            "description": "The replaced content is not resized to fit inside the element's content box"
          },
          {
            "name": "scale-down",
            "description": "Size the content as if 'none' or 'contain' were specified, whichever would result in a smaller concrete object size."
          }
        ],
        "syntax": "fill | contain | cover | none | scale-down",
        "relevance": 72,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/object-fit"
          }
        ],
        "description": "Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "object-position",
        "browsers": [
          "E79",
          "FF36",
          "S10",
          "C32",
          "O19"
        ],
        "syntax": "<position>",
        "relevance": 57,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/object-position"
          }
        ],
        "description": "Determines the alignment of the replaced element inside its box.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "-o-border-image",
        "browsers": [
          "O11.6"
        ],
        "values": [
          {
            "name": "auto",
            "description": "If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."
          },
          {
            "name": "fill",
            "description": "Causes the middle part of the border-image to be preserved."
          },
          {
            "name": "none"
          },
          {
            "name": "repeat",
            "description": "The image is tiled (repeated) to fill the area."
          },
          {
            "name": "round",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."
          },
          {
            "name": "space",
            "description": "The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."
          },
          {
            "name": "stretch",
            "description": "The image is stretched to fill the area."
          }
        ],
        "relevance": 50,
        "description": "Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",
        "restrictions": [
          "length",
          "percentage",
          "number",
          "image",
          "enum"
        ]
      },
      {
        "name": "-o-object-fit",
        "browsers": [
          "O10.6"
        ],
        "values": [
          {
            "name": "contain",
            "description": "The replaced content is sized to maintain its aspect ratio while fitting within the element's content box: its concrete object size is resolved as a contain constraint against the element's used width and height."
          },
          {
            "name": "cover",
            "description": "The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element's used width and height."
          },
          {
            "name": "fill",
            "description": "The replaced content is sized to fill the element's content box: the object's concrete object size is the element's used width and height."
          },
          {
            "name": "none",
            "description": "The replaced content is not resized to fit inside the element's content box"
          },
          {
            "name": "scale-down",
            "description": "Size the content as if 'none' or 'contain' were specified, whichever would result in a smaller concrete object size."
          }
        ],
        "relevance": 50,
        "description": "Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-o-object-position",
        "browsers": [
          "O10.6"
        ],
        "relevance": 50,
        "description": "Determines the alignment of the replaced element inside its box.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "opacity",
        "browsers": [
          "E12",
          "FF1",
          "S2",
          "C1",
          "IE9",
          "O9"
        ],
        "syntax": "<alpha-value>",
        "relevance": 92,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/opacity"
          }
        ],
        "description": "Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",
        "restrictions": [
          "number(0-1)"
        ]
      },
      {
        "name": "order",
        "browsers": [
          "E12",
          "FF20",
          "S9",
          "C29",
          "IE11",
          "O12.1"
        ],
        "syntax": "<integer>",
        "relevance": 67,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/order"
          }
        ],
        "description": "Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "orphans",
        "browsers": [
          "E12",
          "S1.3",
          "C25",
          "IE8",
          "O9.2"
        ],
        "syntax": "<integer>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/orphans"
          }
        ],
        "description": "Specifies the minimum number of line boxes in a block container that must be left in a fragment before a fragmentation break.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-o-table-baseline",
        "browsers": [
          "O9.6"
        ],
        "relevance": 50,
        "description": "Determines which row of a inline-table should be used as baseline of inline-table.",
        "restrictions": [
          "integer"
        ]
      },
      {
        "name": "-o-tab-size",
        "browsers": [
          "O10.6"
        ],
        "relevance": 50,
        "description": "This property determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",
        "restrictions": [
          "integer",
          "length"
        ]
      },
      {
        "name": "-o-text-overflow",
        "browsers": [
          "O10"
        ],
        "values": [
          {
            "name": "clip",
            "description": "Clip inline content that overflows. Characters may be only partially rendered."
          },
          {
            "name": "ellipsis",
            "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
          }
        ],
        "relevance": 50,
        "description": "Text can overflow for example when it is prevented from wrapping",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-o-transform",
        "browsers": [
          "O10.5"
        ],
        "values": [
          {
            "name": "matrix()",
            "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
          },
          {
            "name": "matrix3d()",
            "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
          },
          {
            "name": "none"
          },
          {
            "name": "rotate()",
            "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
          },
          {
            "name": "rotate3d()",
            "description": "Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."
          },
          {
            "name": "rotateX('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the X axis."
          },
          {
            "name": "rotateY('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the Y axis."
          },
          {
            "name": "rotateZ('angle')",
            "description": "Specifies a clockwise rotation by the given angle about the Z axis."
          },
          {
            "name": "scale()",
            "description": "Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."
          },
          {
            "name": "scale3d()",
            "description": "Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."
          },
          {
            "name": "scaleX()",
            "description": "Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."
          },
          {
            "name": "scaleY()",
            "description": "Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."
          },
          {
            "name": "scaleZ()",
            "description": "Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."
          },
          {
            "name": "skew()",
            "description": "Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."
          },
          {
            "name": "skewX()",
            "description": "Specifies a skew transformation along the X axis by the given angle."
          },
          {
            "name": "skewY()",
            "description": "Specifies a skew transformation along the Y axis by the given angle."
          },
          {
            "name": "translate()",
            "description": "Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."
          },
          {
            "name": "translate3d()",
            "description": "Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."
          },
          {
            "name": "translateX()",
            "description": "Specifies a translation by the given amount in the X direction."
          },
          {
            "name": "translateY()",
            "description": "Specifies a translation by the given amount in the Y direction."
          },
          {
            "name": "translateZ()",
            "description": "Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."
          }
        ],
        "relevance": 50,
        "description": "A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "-o-transform-origin",
        "browsers": [
          "O10.5"
        ],
        "relevance": 50,
        "description": "Establishes the origin of transformation for an element.",
        "restrictions": [
          "positon",
          "length",
          "percentage"
        ]
      },
      {
        "name": "-o-transition",
        "browsers": [
          "O11.5"
        ],
        "values": [
          {
            "name": "all",
            "description": "Every property that is able to undergo a transition will do so."
          },
          {
            "name": "none",
            "description": "No property will transition."
          }
        ],
        "relevance": 50,
        "description": "Shorthand property combines four of the transition properties into a single property.",
        "restrictions": [
          "time",
          "property",
          "timing-function",
          "enum"
        ]
      },
      {
        "name": "-o-transition-delay",
        "browsers": [
          "O11.5"
        ],
        "relevance": 50,
        "description": "Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-o-transition-duration",
        "browsers": [
          "O11.5"
        ],
        "relevance": 50,
        "description": "Specifies how long the transition from the old value to the new value should take.",
        "restrictions": [
          "time"
        ]
      },
      {
        "name": "-o-transition-property",
        "browsers": [
          "O11.5"
        ],
        "values": [
          {
            "name": "all",
            "description": "Every property that is able to undergo a transition will do so."
          },
          {
            "name": "none",
            "description": "No property will transition."
          }
        ],
        "relevance": 50,
        "description": "Specifies the name of the CSS property to which the transition is applied.",
        "restrictions": [
          "property"
        ]
      },
      {
        "name": "-o-transition-timing-function",
        "browsers": [
          "O11.5"
        ],
        "relevance": 50,
        "description": "Describes how the intermediate values used during a transition will be calculated.",
        "restrictions": [
          "timing-function"
        ]
      },
      {
        "name": "offset-block-end",
        "browsers": [
          "FF41"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
          }
        ],
        "relevance": 50,
        "description": "Logical 'bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "offset-block-start",
        "browsers": [
          "FF41"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
          }
        ],
        "relevance": 50,
        "description": "Logical 'top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "offset-inline-end",
        "browsers": [
          "FF41"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
          }
        ],
        "relevance": 50,
        "description": "Logical 'right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "offset-inline-start",
        "browsers": [
          "FF41"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."
          }
        ],
        "relevance": 50,
        "description": "Logical 'left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "outline",
        "browsers": [
          "E94",
          "FF88",
          "S16.4",
          "C94",
          "IE8",
          "O80"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Permits the user agent to render a custom outline style, typically the default platform style."
          },
          {
            "name": "invert",
            "browsers": [
              "E94",
              "FF88",
              "S16.4",
              "C94",
              "IE8",
              "O80"
            ],
            "description": "Performs a color inversion on the pixels on the screen."
          }
        ],
        "syntax": "[ <'outline-color'> || <'outline-style'> || <'outline-width'> ]",
        "relevance": 88,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/outline"
          }
        ],
        "description": "Shorthand property for 'outline-style', 'outline-width', and 'outline-color'.",
        "restrictions": [
          "length",
          "line-width",
          "line-style",
          "color",
          "enum"
        ]
      },
      {
        "name": "outline-color",
        "browsers": [
          "E12",
          "FF1.5",
          "S1.2",
          "C1",
          "IE8",
          "O7"
        ],
        "values": [
          {
            "name": "invert",
            "browsers": [
              "E12",
              "FF1.5",
              "S1.2",
              "C1",
              "IE8",
              "O7"
            ],
            "description": "Performs a color inversion on the pixels on the screen."
          }
        ],
        "syntax": "auto | <color>",
        "relevance": 61,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/outline-color"
          }
        ],
        "description": "The color of the outline.",
        "restrictions": [
          "enum",
          "color"
        ]
      },
      {
        "name": "outline-offset",
        "browsers": [
          "E15",
          "FF1.5",
          "S1.2",
          "C1",
          "O9.5"
        ],
        "syntax": "<length>",
        "relevance": 69,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/outline-offset"
          }
        ],
        "description": "Offset the outline and draw it beyond the border edge.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "outline-style",
        "browsers": [
          "E12",
          "FF1.5",
          "S1.2",
          "C1",
          "IE8",
          "O7"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Permits the user agent to render a custom outline style, typically the default platform style."
          }
        ],
        "syntax": "auto | <'border-style'>",
        "relevance": 61,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/outline-style"
          }
        ],
        "description": "Style of the outline.",
        "restrictions": [
          "line-style",
          "enum"
        ]
      },
      {
        "name": "outline-width",
        "browsers": [
          "E12",
          "FF1.5",
          "S1.2",
          "C1",
          "IE8",
          "O7"
        ],
        "syntax": "<line-width>",
        "relevance": 62,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/outline-width"
          }
        ],
        "description": "Width of the outline.",
        "restrictions": [
          "length",
          "line-width"
        ]
      },
      {
        "name": "overflow",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
          },
          {
            "name": "hidden",
            "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
          },
          {
            "name": "-moz-hidden-unscrollable",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O7"
            ],
            "description": "Same as the standardized 'clip', except doesn't establish a block formatting context."
          },
          {
            "name": "scroll",
            "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
          },
          {
            "name": "visible",
            "description": "Content is not clipped, i.e., it may be rendered outside the content box."
          }
        ],
        "syntax": "[ visible | hidden | clip | scroll | auto ]{1,2}",
        "relevance": 93,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/overflow"
          }
        ],
        "description": "Shorthand for setting 'overflow-x' and 'overflow-y'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "overflow-wrap",
        "browsers": [
          "E18",
          "FF49",
          "S7",
          "C23",
          "IE5.5",
          "O12.1"
        ],
        "values": [
          {
            "name": "break-word",
            "description": "An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."
          },
          {
            "name": "normal",
            "description": "Lines may break only at allowed break points."
          }
        ],
        "syntax": "normal | break-word | anywhere",
        "relevance": 65,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-wrap"
          }
        ],
        "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "overflow-x",
        "browsers": [
          "E12",
          "FF3.5",
          "S3",
          "C1",
          "IE5",
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
          },
          {
            "name": "hidden",
            "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
          },
          {
            "name": "scroll",
            "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
          },
          {
            "name": "visible",
            "description": "Content is not clipped, i.e., it may be rendered outside the content box."
          }
        ],
        "syntax": "visible | hidden | clip | scroll | auto",
        "relevance": 81,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-x"
          }
        ],
        "description": "Specifies the handling of overflow in the horizontal direction.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "overflow-y",
        "browsers": [
          "E12",
          "FF3.5",
          "S3",
          "C1",
          "IE5",
          "O9.5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."
          },
          {
            "name": "hidden",
            "description": "Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."
          },
          {
            "name": "scroll",
            "description": "Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."
          },
          {
            "name": "visible",
            "description": "Content is not clipped, i.e., it may be rendered outside the content box."
          }
        ],
        "syntax": "visible | hidden | clip | scroll | auto",
        "relevance": 82,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/overflow-y"
          }
        ],
        "description": "Specifies the handling of overflow in the vertical direction.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "pad",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "<integer> && <symbol>",
        "relevance": 50,
        "description": '@counter-style descriptor. Specifies a "fixed-width" counter style, where representations shorter than the pad value are padded with a particular <symbol>',
        "restrictions": [
          "integer",
          "image",
          "string",
          "identifier"
        ]
      },
      {
        "name": "padding",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "values": [],
        "syntax": "[ <length> | <percentage> ]{1,4}",
        "relevance": 95,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-bottom",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<length> | <percentage>",
        "relevance": 88,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-bottom"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-block-end",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'padding-left'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-block-end"
          }
        ],
        "description": "Logical 'padding-bottom'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-block-start",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'padding-left'>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-block-start"
          }
        ],
        "description": "Logical 'padding-top'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-inline-end",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'padding-left'>",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-inline-end"
          }
        ],
        "description": "Logical 'padding-right'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-inline-start",
        "browsers": [
          "E79",
          "FF41",
          "S12.1",
          "C69",
          "O56"
        ],
        "syntax": "<'padding-left'>",
        "relevance": 56,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-inline-start"
          }
        ],
        "description": "Logical 'padding-left'. Mapping depends on the parent element's 'writing-mode', 'direction', and 'text-orientation'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-left",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<length> | <percentage>",
        "relevance": 89,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-left"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-right",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<length> | <percentage>",
        "relevance": 88,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-right"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "padding-top",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O3.5"
        ],
        "syntax": "<length> | <percentage>",
        "relevance": 89,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/padding-top"
          }
        ],
        "description": "Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "page-break-after",
        "browsers": [
          "E12",
          "FF1",
          "S1.2",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "always",
            "description": "Always force a page break after the generated box."
          },
          {
            "name": "auto",
            "description": "Neither force nor forbid a page break after generated box."
          },
          {
            "name": "avoid",
            "description": "Avoid a page break after the generated box."
          },
          {
            "name": "left",
            "description": "Force one or two page breaks after the generated box so that the next page is formatted as a left page."
          },
          {
            "name": "right",
            "description": "Force one or two page breaks after the generated box so that the next page is formatted as a right page."
          }
        ],
        "syntax": "auto | always | avoid | left | right | recto | verso",
        "relevance": 52,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/page-break-after"
          }
        ],
        "description": "Defines rules for page breaks after an element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "page-break-before",
        "browsers": [
          "E12",
          "FF1",
          "S1.2",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "always",
            "description": "Always force a page break before the generated box."
          },
          {
            "name": "auto",
            "description": "Neither force nor forbid a page break before the generated box."
          },
          {
            "name": "avoid",
            "description": "Avoid a page break before the generated box."
          },
          {
            "name": "left",
            "description": "Force one or two page breaks before the generated box so that the next page is formatted as a left page."
          },
          {
            "name": "right",
            "description": "Force one or two page breaks before the generated box so that the next page is formatted as a right page."
          }
        ],
        "syntax": "auto | always | avoid | left | right | recto | verso",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/page-break-before"
          }
        ],
        "description": "Defines rules for page breaks before an element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "page-break-inside",
        "browsers": [
          "E12",
          "FF19",
          "S1.3",
          "C1",
          "IE8",
          "O7"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Neither force nor forbid a page break inside the generated box."
          },
          {
            "name": "avoid",
            "description": "Avoid a page break inside the generated box."
          }
        ],
        "syntax": "auto | avoid",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/page-break-inside"
          }
        ],
        "description": "Defines rules for page breaks inside an element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "paint-order",
        "browsers": [
          "E79",
          "FF60",
          "S11",
          "C35",
          "O22"
        ],
        "values": [
          {
            "name": "fill"
          },
          {
            "name": "markers"
          },
          {
            "name": "normal",
            "description": "The element is painted with the standard order of painting operations: the 'fill' is painted first, then its 'stroke' and finally its markers."
          },
          {
            "name": "stroke"
          }
        ],
        "syntax": "normal | [ fill || stroke || markers ]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/paint-order"
          }
        ],
        "description": "Controls the order that the three paint operations that shapes and text are rendered with: their fill, their stroke and any markers they might have.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "perspective",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C36",
          "IE10",
          "O23"
        ],
        "values": [
          {
            "name": "none",
            "description": "No perspective transform is applied."
          }
        ],
        "syntax": "none | <length>",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/perspective"
          }
        ],
        "description": "Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",
        "restrictions": [
          "length",
          "enum"
        ]
      },
      {
        "name": "perspective-origin",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C36",
          "IE10",
          "O23"
        ],
        "syntax": "<position>",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/perspective-origin"
          }
        ],
        "description": "Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",
        "restrictions": [
          "position",
          "percentage",
          "length"
        ]
      },
      {
        "name": "pointer-events",
        "browsers": [
          "E12",
          "FF1.5",
          "S4",
          "C1",
          "IE11",
          "O9"
        ],
        "values": [
          {
            "name": "all",
            "description": "The given element can be the target element for pointer events whenever the pointer is over either the interior or the perimeter of the element."
          },
          {
            "name": "fill",
            "description": "The given element can be the target element for pointer events whenever the pointer is over the interior of the element."
          },
          {
            "name": "none",
            "description": "The given element does not receive pointer events."
          },
          {
            "name": "painted",
            "description": 'The given element can be the target element for pointer events when the pointer is over a "painted" area. '
          },
          {
            "name": "stroke",
            "description": "The given element can be the target element for pointer events whenever the pointer is over the perimeter of the element."
          },
          {
            "name": "visible",
            "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and the pointer is over either the interior or the perimeter of the element."
          },
          {
            "name": "visibleFill",
            "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over the interior of the element."
          },
          {
            "name": "visiblePainted",
            "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over a 'painted' area."
          },
          {
            "name": "visibleStroke",
            "description": "The given element can be the target element for pointer events when the 'visibility' property is set to visible and when the pointer is over the perimeter of the element."
          }
        ],
        "syntax": "auto | none | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | inherit",
        "relevance": 82,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/pointer-events"
          }
        ],
        "description": "Specifies under what circumstances a given element can be the target element for a pointer event.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "position",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O4"
        ],
        "values": [
          {
            "name": "absolute",
            "description": "The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."
          },
          {
            "name": "fixed",
            "description": "The box's position is calculated according to the 'absolute' model, but in addition, the box is fixed with respect to some reference. As with the 'absolute' model, the box's margins do not collapse with any other margins."
          },
          {
            "name": "-ms-page",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O4"
            ],
            "description": "The box's position is calculated according to the 'absolute' model."
          },
          {
            "name": "relative",
            "description": "The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."
          },
          {
            "name": "static",
            "description": "The box is a normal box, laid out according to the normal flow. The 'top', 'right', 'bottom', and 'left' properties do not apply."
          },
          {
            "name": "sticky",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O4"
            ],
            "description": "The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."
          },
          {
            "name": "-webkit-sticky",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE4",
              "O4"
            ],
            "description": "The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."
          }
        ],
        "syntax": "static | relative | absolute | sticky | fixed",
        "relevance": 95,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/position"
          }
        ],
        "description": "The position CSS property sets how an element is positioned in a document. The top, right, bottom, and left properties determine the final location of positioned elements.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "prefix",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "<symbol>",
        "relevance": 50,
        "description": "@counter-style descriptor. Specifies a <symbol> that is prepended to the marker representation.",
        "restrictions": [
          "image",
          "string",
          "identifier"
        ]
      },
      {
        "name": "quotes",
        "browsers": [
          "E12",
          "FF1.5",
          "S9",
          "C11",
          "IE8",
          "O4"
        ],
        "values": [
          {
            "name": "none",
            "description": "The 'open-quote' and 'close-quote' values of the 'content' property produce no quotations marks, as if they were 'no-open-quote' and 'no-close-quote' respectively."
          }
        ],
        "syntax": "none | auto | [ <string> <string> ]+",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/quotes"
          }
        ],
        "description": "Specifies quotation marks for any number of embedded quotations.",
        "restrictions": [
          "string"
        ]
      },
      {
        "name": "range",
        "browsers": [
          "FF33"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The range depends on the counter system."
          },
          {
            "name": "infinite",
            "description": "If used as the first value in a range, it represents negative infinity; if used as the second value, it represents positive infinity."
          }
        ],
        "atRule": "@counter-style",
        "syntax": "[ [ <integer> | infinite ]{2} ]# | auto",
        "relevance": 50,
        "description": "@counter-style descriptor. Defines the ranges over which the counter style is defined.",
        "restrictions": [
          "integer",
          "enum"
        ]
      },
      {
        "name": "resize",
        "browsers": [
          "E79",
          "FF4",
          "S3",
          "C1",
          "O12.1"
        ],
        "values": [
          {
            "name": "both",
            "description": "The UA presents a bidirectional resizing mechanism to allow the user to adjust both the height and the width of the element."
          },
          {
            "name": "horizontal",
            "description": "The UA presents a unidirectional horizontal resizing mechanism to allow the user to adjust only the width of the element."
          },
          {
            "name": "none",
            "description": "The UA does not present a resizing mechanism on the element, and the user is given no direct manipulation mechanism to resize the element."
          },
          {
            "name": "vertical",
            "description": "The UA presents a unidirectional vertical resizing mechanism to allow the user to adjust only the height of the element."
          }
        ],
        "syntax": "none | both | horizontal | vertical | block | inline",
        "relevance": 66,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/resize"
          }
        ],
        "description": "Specifies whether or not an element is resizable by the user, and if so, along which axis/axes.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "right",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5.5",
          "O5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/right"
          }
        ],
        "description": "Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "ruby-align",
        "browsers": [
          "FF38",
          "Spreview"
        ],
        "values": [
          {
            "name": "auto",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "The user agent determines how the ruby contents are aligned. This is the initial value."
          },
          {
            "name": "center",
            "description": "The ruby content is centered within its box."
          },
          {
            "name": "distribute-letter",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with the first and last ruby text glyphs lining up with the corresponding first and last base glyphs. If the width of the ruby text is at least the width of the base, then the letters of the base are evenly distributed across the width of the ruby text."
          },
          {
            "name": "distribute-space",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with a certain amount of white space preceding the first and following the last character in the ruby text. That amount of white space is normally equal to half the amount of inter-character space of the ruby text."
          },
          {
            "name": "left",
            "description": "The ruby text content is aligned with the start edge of the base."
          },
          {
            "name": "line-edge",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "If the ruby text is not adjacent to a line edge, it is aligned as in 'auto'. If it is adjacent to a line edge, then it is still aligned as in auto, but the side of the ruby text that touches the end of the line is lined up with the corresponding edge of the base."
          },
          {
            "name": "right",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "The ruby text content is aligned with the end edge of the base."
          },
          {
            "name": "start",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "The ruby text content is aligned with the start edge of the base."
          },
          {
            "name": "space-between",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "The ruby content expands as defined for normal text justification (as defined by 'text-justify'),"
          },
          {
            "name": "space-around",
            "browsers": [
              "FF38",
              "Spreview"
            ],
            "description": "As for 'space-between' except that there exists an extra justification opportunities whose space is distributed half before and half after the ruby content."
          }
        ],
        "status": "experimental",
        "syntax": "start | center | space-between | space-around",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/ruby-align"
          }
        ],
        "description": "Specifies how text is distributed within the various ruby boxes when their contents do not exactly fill their respective boxes.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "ruby-overhang",
        "browsers": [
          "FF10",
          "IE5"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The ruby text can overhang text adjacent to the base on either side. This is the initial value."
          },
          {
            "name": "end",
            "description": "The ruby text can overhang the text that follows it."
          },
          {
            "name": "none",
            "description": "The ruby text cannot overhang any text adjacent to its base, only its own base."
          },
          {
            "name": "start",
            "description": "The ruby text can overhang the text that precedes it."
          }
        ],
        "relevance": 50,
        "description": "Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "ruby-position",
        "browsers": [
          "E84",
          "FF38",
          "S7",
          "C84",
          "O70"
        ],
        "values": [
          {
            "name": "after",
            "description": "The ruby text appears after the base. This is a relatively rare setting used in ideographic East Asian writing systems, most easily found in educational text."
          },
          {
            "name": "before",
            "description": "The ruby text appears before the base. This is the most common setting used in ideographic East Asian writing systems."
          },
          {
            "name": "inline"
          },
          {
            "name": "right",
            "description": "The ruby text appears on the right of the base. Unlike 'before' and 'after', this value is not relative to the text flow direction."
          }
        ],
        "syntax": "[ alternate || [ over | under ] ] | inter-character",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/ruby-position"
          }
        ],
        "description": "Used by the parent of elements with display: ruby-text to control the position of the ruby text with respect to its base.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "ruby-span",
        "browsers": [
          "FF10"
        ],
        "values": [
          {
            "name": "attr(x)",
            "description": "The value of attribute 'x' is a string value. The string value is evaluated as a <number> to determine the number of ruby base elements to be spanned by the annotation element."
          },
          {
            "name": "none",
            "description": "No spanning. The computed value is '1'."
          }
        ],
        "relevance": 50,
        "description": "Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "scrollbar-3dlight-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-3dlight-color"
          }
        ],
        "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-arrow-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-arrow-color"
          }
        ],
        "description": "Determines the color of the arrow elements of a scroll arrow.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-base-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-base-color"
          }
        ],
        "description": "Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-darkshadow-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-darkshadow-color"
          }
        ],
        "description": "Determines the color of the gutter of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-face-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-face-color"
          }
        ],
        "description": "Determines the color of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-highlight-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-highlight-color"
          }
        ],
        "description": "Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-shadow-color",
        "browsers": [
          "IE5"
        ],
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scrollbar-shadow-color"
          }
        ],
        "description": "Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scrollbar-track-color",
        "browsers": [
          "IE6"
        ],
        "relevance": 50,
        "description": "Determines the color of the track element of a scroll bar.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "scroll-behavior",
        "browsers": [
          "E79",
          "FF36",
          "S15.4",
          "C61",
          "O48"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Scrolls in an instant fashion."
          },
          {
            "name": "smooth",
            "description": "Scrolls in a smooth fashion using a user-agent-defined timing function and time period."
          }
        ],
        "syntax": "auto | smooth",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-behavior"
          }
        ],
        "description": "Specifies the scrolling behavior for a scrolling box, when scrolling happens due to navigation or CSSOM scrolling APIs.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "scroll-snap-coordinate",
        "browsers": [
          "FF39"
        ],
        "values": [
          {
            "name": "none",
            "description": "Specifies that this element does not contribute a snap point."
          }
        ],
        "status": "obsolete",
        "syntax": "none | <position>#",
        "relevance": 0,
        "description": "Defines the x and y coordinate within the element which will align with the nearest ancestor scroll container's snap-destination for the respective axis.",
        "restrictions": [
          "position",
          "length",
          "percentage",
          "enum"
        ]
      },
      {
        "name": "scroll-snap-destination",
        "browsers": [
          "FF39"
        ],
        "status": "obsolete",
        "syntax": "<position>",
        "relevance": 0,
        "description": "Define the x and y coordinate within the scroll container's visual viewport which element snap points will align with.",
        "restrictions": [
          "position",
          "length",
          "percentage"
        ]
      },
      {
        "name": "scroll-snap-points-x",
        "browsers": [
          "FF39"
        ],
        "values": [
          {
            "name": "none",
            "description": "No snap points are defined by this scroll container."
          },
          {
            "name": "repeat()",
            "description": "Defines an interval at which snap points are defined, starting from the container's relevant start edge."
          }
        ],
        "status": "obsolete",
        "syntax": "none | repeat( <length-percentage> )",
        "relevance": 0,
        "description": "Defines the positioning of snap points along the x axis of the scroll container it is applied to.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "scroll-snap-points-y",
        "browsers": [
          "FF39"
        ],
        "values": [
          {
            "name": "none",
            "description": "No snap points are defined by this scroll container."
          },
          {
            "name": "repeat()",
            "description": "Defines an interval at which snap points are defined, starting from the container's relevant start edge."
          }
        ],
        "status": "obsolete",
        "syntax": "none | repeat( <length-percentage> )",
        "relevance": 0,
        "description": "Defines the positioning of snap points along the y axis of the scroll container it is applied to.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "scroll-snap-type",
        "browsers": [
          "E79",
          "FF99",
          "S11",
          "C69",
          "IE10",
          "O56"
        ],
        "values": [
          {
            "name": "none",
            "description": "The visual viewport of this scroll container must ignore snap points, if any, when scrolled."
          },
          {
            "name": "mandatory",
            "description": "The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."
          },
          {
            "name": "proximity",
            "description": "The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."
          }
        ],
        "syntax": "none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type"
          }
        ],
        "description": "Defines how strictly snap points are enforced on the scroll container.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "shape-image-threshold",
        "browsers": [
          "E79",
          "FF62",
          "S10.1",
          "C37",
          "O24"
        ],
        "syntax": "<alpha-value>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold"
          }
        ],
        "description": "Defines the alpha channel threshold used to extract the shape using an image. A value of 0.5 means that the shape will enclose all the pixels that are more than 50% opaque.",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "shape-margin",
        "browsers": [
          "E79",
          "FF62",
          "S10.1",
          "C37",
          "O24"
        ],
        "syntax": "<length-percentage>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/shape-margin"
          }
        ],
        "description": "Adds a margin to a 'shape-outside'. This defines a new shape that is the smallest contour that includes all the points that are the 'shape-margin' distance outward in the perpendicular direction from a point on the underlying shape.",
        "restrictions": [
          "url",
          "length",
          "percentage"
        ]
      },
      {
        "name": "shape-outside",
        "browsers": [
          "E79",
          "FF62",
          "S10.1",
          "C37",
          "O24"
        ],
        "values": [
          {
            "name": "margin-box",
            "description": "The background is painted within (clipped to) the margin box."
          },
          {
            "name": "none",
            "description": "The float area is unaffected."
          }
        ],
        "syntax": "none | [ <shape-box> || <basic-shape> ] | <image>",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/shape-outside"
          }
        ],
        "description": "Specifies an orthogonal rotation to be applied to an image before it is laid out.",
        "restrictions": [
          "image",
          "box",
          "shape",
          "enum"
        ]
      },
      {
        "name": "shape-rendering",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Suppresses aural rendering."
          },
          {
            "name": "crispEdges",
            "description": "Emphasize the contrast between clean edges of artwork over rendering speed and geometric precision."
          },
          {
            "name": "geometricPrecision",
            "description": "Emphasize geometric precision over speed and crisp edges."
          },
          {
            "name": "optimizeSpeed",
            "description": "Emphasize rendering speed over geometric precision and crisp edges."
          }
        ],
        "relevance": 50,
        "description": "Provides hints about what tradeoffs to make as it renders vector graphics elements such as <path> elements and basic shapes such as circles and rectangles.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "size",
        "browsers": [
          "C",
          "O8"
        ],
        "atRule": "@page",
        "syntax": "<length>{1,2} | auto | [ <page-size> || [ portrait | landscape ] ]",
        "relevance": 53,
        "description": "The size CSS at-rule descriptor, used with the @page at-rule, defines the size and orientation of the box which is used to represent a page. Most of the time, this size corresponds to the target size of the printed page if applicable.",
        "restrictions": [
          "length"
        ]
      },
      {
        "name": "src",
        "values": [
          {
            "name": "url()",
            "description": "Reference font by URL"
          },
          {
            "name": "format()",
            "description": "Optional hint describing the format of the font resource."
          },
          {
            "name": "local()",
            "description": "Format-specific string that identifies a locally available copy of a given font."
          }
        ],
        "atRule": "@font-face",
        "syntax": "[ <url> [ format( <string># ) ]? | local( <family-name> ) ]#",
        "relevance": 86,
        "description": "@font-face descriptor. Specifies the resource containing font data. It is required, whether the font is downloadable or locally installed.",
        "restrictions": [
          "enum",
          "url",
          "identifier"
        ]
      },
      {
        "name": "stop-color",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 50,
        "description": "Indicates what color to use at that gradient stop.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "stop-opacity",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 50,
        "description": "Defines the opacity of a given gradient stop.",
        "restrictions": [
          "number(0-1)"
        ]
      },
      {
        "name": "stroke",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "url()",
            "description": "A URL reference to a paint server element, which is an element that defines a paint server: 'hatch', 'linearGradient', 'mesh', 'pattern', 'radialGradient' and 'solidcolor'."
          },
          {
            "name": "none",
            "description": "No paint is applied in this layer."
          }
        ],
        "relevance": 67,
        "description": "Paints along the outline of the given graphical element.",
        "restrictions": [
          "color",
          "enum",
          "url"
        ]
      },
      {
        "name": "stroke-dasharray",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "none",
            "description": "Indicates that no dashing is used."
          }
        ],
        "relevance": 61,
        "description": "Controls the pattern of dashes and gaps used to stroke paths.",
        "restrictions": [
          "length",
          "percentage",
          "number",
          "enum"
        ]
      },
      {
        "name": "stroke-dashoffset",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 62,
        "description": "Specifies the distance into the dash pattern to start the dash.",
        "restrictions": [
          "percentage",
          "length"
        ]
      },
      {
        "name": "stroke-linecap",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "butt",
            "description": "Indicates that the stroke for each subpath does not extend beyond its two endpoints."
          },
          {
            "name": "round",
            "description": "Indicates that at each end of each subpath, the shape representing the stroke will be extended by a half circle with a radius equal to the stroke width."
          },
          {
            "name": "square",
            "description": "Indicates that at the end of each subpath, the shape representing the stroke will be extended by a rectangle with the same width as the stroke width and whose length is half of the stroke width."
          }
        ],
        "relevance": 53,
        "description": "Specifies the shape to be used at the end of open subpaths when they are stroked.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "stroke-linejoin",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "bevel",
            "description": "Indicates that a bevelled corner is to be used to join path segments."
          },
          {
            "name": "miter",
            "description": "Indicates that a sharp corner is to be used to join path segments."
          },
          {
            "name": "round",
            "description": "Indicates that a round corner is to be used to join path segments."
          }
        ],
        "relevance": 51,
        "description": "Specifies the shape to be used at the corners of paths or basic shapes when they are stroked.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "stroke-miterlimit",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 51,
        "description": "When two line segments meet at a sharp angle and miter joins have been specified for 'stroke-linejoin', it is possible for the miter to extend far beyond the thickness of the line stroking the path.",
        "restrictions": [
          "number"
        ]
      },
      {
        "name": "stroke-opacity",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 52,
        "description": "Specifies the opacity of the painting operation used to stroke the current object.",
        "restrictions": [
          "number(0-1)"
        ]
      },
      {
        "name": "stroke-width",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "relevance": 64,
        "description": "Specifies the width of the stroke on the current object.",
        "restrictions": [
          "percentage",
          "length"
        ]
      },
      {
        "name": "suffix",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "<symbol>",
        "relevance": 50,
        "description": "@counter-style descriptor. Specifies a <symbol> that is appended to the marker representation.",
        "restrictions": [
          "image",
          "string",
          "identifier"
        ]
      },
      {
        "name": "system",
        "browsers": [
          "FF33"
        ],
        "values": [
          {
            "name": "additive",
            "description": 'Represents "sign-value" numbering systems, which, rather than using reusing digits in different positions to change their value, define additional digits with much larger values, so that the value of the number can be obtained by adding all the digits together.'
          },
          {
            "name": "alphabetic",
            "description": 'Interprets the list of counter symbols as digits to an alphabetic numbering system, similar to the default lower-alpha counter style, which wraps from "a", "b", "c", to "aa", "ab", "ac".'
          },
          {
            "name": "cyclic",
            "description": "Cycles repeatedly through its provided symbols, looping back to the beginning when it reaches the end of the list."
          },
          {
            "name": "extends",
            "description": "Use the algorithm of another counter style, but alter other aspects."
          },
          {
            "name": "fixed",
            "description": "Runs through its list of counter symbols once, then falls back."
          },
          {
            "name": "numeric",
            "description": `interprets the list of counter symbols as digits to a "place-value" numbering system, similar to the default 'decimal' counter style.`
          },
          {
            "name": "symbolic",
            "description": "Cycles repeatedly through its provided symbols, doubling, tripling, etc. the symbols on each successive pass through the list."
          }
        ],
        "atRule": "@counter-style",
        "syntax": "cyclic | numeric | alphabetic | symbolic | additive | [ fixed <integer>? ] | [ extends <counter-style-name> ]",
        "relevance": 50,
        "description": "@counter-style descriptor. Specifies which algorithm will be used to construct the counter's representation based on the counter value.",
        "restrictions": [
          "enum",
          "integer"
        ]
      },
      {
        "name": "symbols",
        "browsers": [
          "FF33"
        ],
        "atRule": "@counter-style",
        "syntax": "<symbol>+",
        "relevance": 50,
        "description": "@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor.",
        "restrictions": [
          "image",
          "string",
          "identifier"
        ]
      },
      {
        "name": "table-layout",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C14",
          "IE5",
          "O7"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Use any automatic table layout algorithm."
          },
          {
            "name": "fixed",
            "description": "Use the fixed table layout algorithm."
          }
        ],
        "syntax": "auto | fixed",
        "relevance": 58,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/table-layout"
          }
        ],
        "description": "Controls the algorithm used to lay out the table cells, rows, and columns.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "tab-size",
        "browsers": [
          "E79",
          "FF91",
          "S7",
          "C21",
          "O15"
        ],
        "syntax": "<integer> | <length>",
        "relevance": 53,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/tab-size"
          }
        ],
        "description": "Determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",
        "restrictions": [
          "integer",
          "length"
        ]
      },
      {
        "name": "text-align",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "center",
            "description": "The inline contents are centered within the line box."
          },
          {
            "name": "end",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE3",
              "O3.5"
            ],
            "description": "The inline contents are aligned to the end edge of the line box."
          },
          {
            "name": "justify",
            "description": "The text is justified according to the method specified by the 'text-justify' property."
          },
          {
            "name": "left",
            "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
          },
          {
            "name": "right",
            "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
          },
          {
            "name": "start",
            "browsers": [
              "E12",
              "FF1",
              "S1",
              "C1",
              "IE3",
              "O3.5"
            ],
            "description": "The inline contents are aligned to the start edge of the line box."
          }
        ],
        "syntax": "start | end | left | right | center | justify | match-parent",
        "relevance": 93,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-align"
          }
        ],
        "description": "Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",
        "restrictions": [
          "string"
        ]
      },
      {
        "name": "text-align-last",
        "browsers": [
          "E12",
          "FF49",
          "S16",
          "C47",
          "IE5.5",
          "O34"
        ],
        "values": [
          {
            "name": "auto",
            "description": "Content on the affected line is aligned per 'text-align' unless 'text-align' is set to 'justify', in which case it is 'start-aligned'."
          },
          {
            "name": "center",
            "description": "The inline contents are centered within the line box."
          },
          {
            "name": "justify",
            "description": "The text is justified according to the method specified by the 'text-justify' property."
          },
          {
            "name": "left",
            "description": "The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."
          },
          {
            "name": "right",
            "description": "The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."
          }
        ],
        "syntax": "auto | start | end | left | right | center | justify",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-align-last"
          }
        ],
        "description": "Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-anchor",
        "browsers": [
          "E80",
          "FF72",
          "S13.1",
          "C80",
          "O67"
        ],
        "values": [
          {
            "name": "end",
            "description": "The rendered characters are aligned such that the end of the resulting rendered text is at the initial current text position."
          },
          {
            "name": "middle",
            "description": "The rendered characters are aligned such that the geometric middle of the resulting rendered text is at the initial current text position."
          },
          {
            "name": "start",
            "description": "The rendered characters are aligned such that the start of the resulting rendered text is at the initial current text position."
          }
        ],
        "relevance": 50,
        "description": "Used to align (start-, middle- or end-alignment) a string of text relative to a given point.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-decoration",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [
          {
            "name": "dashed",
            "description": "Produces a dashed line style."
          },
          {
            "name": "dotted",
            "description": "Produces a dotted line."
          },
          {
            "name": "double",
            "description": "Produces a double line."
          },
          {
            "name": "line-through",
            "description": "Each line of text has a line through the middle."
          },
          {
            "name": "none",
            "description": "Produces no line."
          },
          {
            "name": "overline",
            "description": "Each line of text has a line above it."
          },
          {
            "name": "solid",
            "description": "Produces a solid line."
          },
          {
            "name": "underline",
            "description": "Each line of text is underlined."
          },
          {
            "name": "wavy",
            "description": "Produces a wavy line."
          }
        ],
        "syntax": "<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",
        "relevance": 91,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration"
          }
        ],
        "description": "Decorations applied to font used for an element's text.",
        "restrictions": [
          "enum",
          "color"
        ]
      },
      {
        "name": "text-decoration-color",
        "browsers": [
          "E79",
          "FF36",
          "S12.1",
          "C57",
          "O44"
        ],
        "syntax": "<color>",
        "relevance": 55,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-color"
          }
        ],
        "description": "Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",
        "restrictions": [
          "color"
        ]
      },
      {
        "name": "text-decoration-line",
        "browsers": [
          "E79",
          "FF36",
          "S12.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "line-through",
            "description": "Each line of text has a line through the middle."
          },
          {
            "name": "none",
            "description": "Neither produces nor inhibits text decoration."
          },
          {
            "name": "overline",
            "description": "Each line of text has a line above it."
          },
          {
            "name": "underline",
            "description": "Each line of text is underlined."
          }
        ],
        "syntax": "none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",
        "relevance": 57,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-line"
          }
        ],
        "description": "Specifies what line decorations, if any, are added to the element.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-decoration-style",
        "browsers": [
          "E79",
          "FF36",
          "S12.1",
          "C57",
          "O44"
        ],
        "values": [
          {
            "name": "dashed",
            "description": "Produces a dashed line style."
          },
          {
            "name": "dotted",
            "description": "Produces a dotted line."
          },
          {
            "name": "double",
            "description": "Produces a double line."
          },
          {
            "name": "none",
            "description": "Produces no line."
          },
          {
            "name": "solid",
            "description": "Produces a solid line."
          },
          {
            "name": "wavy",
            "description": "Produces a wavy line."
          }
        ],
        "syntax": "solid | double | dotted | dashed | wavy",
        "relevance": 51,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-decoration-style"
          }
        ],
        "description": "Specifies the line style for underline, line-through and overline text decoration.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-indent",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE3",
          "O3.5"
        ],
        "values": [],
        "syntax": "<length-percentage> && hanging? && each-line?",
        "relevance": 67,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-indent"
          }
        ],
        "description": "Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",
        "restrictions": [
          "percentage",
          "length"
        ]
      },
      {
        "name": "text-justify",
        "browsers": [
          "E79",
          "FF55",
          "C32",
          "IE11",
          "O19"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."
          },
          {
            "name": "distribute",
            "description": "Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."
          },
          {
            "name": "distribute-all-lines"
          },
          {
            "name": "inter-cluster",
            "description": "Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."
          },
          {
            "name": "inter-ideograph",
            "description": "Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."
          },
          {
            "name": "inter-word",
            "description": "Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."
          },
          {
            "name": "kashida",
            "description": "Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."
          },
          {
            "name": "newspaper"
          }
        ],
        "syntax": "auto | inter-character | inter-word | none",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-justify"
          }
        ],
        "description": "Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-orientation",
        "browsers": [
          "E79",
          "FF41",
          "S14",
          "C48",
          "O35"
        ],
        "values": [
          {
            "name": "sideways",
            "browsers": [
              "E79",
              "FF41",
              "S14",
              "C48",
              "O35"
            ],
            "description": "This value is equivalent to 'sideways-right' in 'vertical-rl' writing mode and equivalent to 'sideways-left' in 'vertical-lr' writing mode."
          },
          {
            "name": "sideways-right",
            "browsers": [
              "E79",
              "FF41",
              "S14",
              "C48",
              "O35"
            ],
            "description": "In vertical writing modes, this causes text to be set as if in a horizontal layout, but rotated 90\xB0 clockwise."
          },
          {
            "name": "upright",
            "description": "In vertical writing modes, characters from horizontal-only scripts are rendered upright, i.e. in their standard horizontal orientation."
          }
        ],
        "syntax": "mixed | upright | sideways",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-orientation"
          }
        ],
        "description": "Specifies the orientation of text within a line.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-overflow",
        "browsers": [
          "E12",
          "FF7",
          "S1.3",
          "C1",
          "IE6",
          "O11"
        ],
        "values": [
          {
            "name": "clip",
            "description": "Clip inline content that overflows. Characters may be only partially rendered."
          },
          {
            "name": "ellipsis",
            "description": "Render an ellipsis character (U+2026) to represent clipped inline content."
          }
        ],
        "syntax": "[ clip | ellipsis | <string> ]{1,2}",
        "relevance": 82,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-overflow"
          }
        ],
        "description": "Text can overflow for example when it is prevented from wrapping.",
        "restrictions": [
          "enum",
          "string"
        ]
      },
      {
        "name": "text-rendering",
        "browsers": [
          "E79",
          "FF1",
          "S5",
          "C4",
          "O15"
        ],
        "values": [
          {
            "name": "auto"
          },
          {
            "name": "geometricPrecision",
            "description": "Indicates that the user agent shall emphasize geometric precision over legibility and rendering speed."
          },
          {
            "name": "optimizeLegibility",
            "description": "Indicates that the user agent shall emphasize legibility over rendering speed and geometric precision."
          },
          {
            "name": "optimizeSpeed",
            "description": "Indicates that the user agent shall emphasize rendering speed over legibility and geometric precision."
          }
        ],
        "syntax": "auto | optimizeSpeed | optimizeLegibility | geometricPrecision",
        "relevance": 68,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-rendering"
          }
        ],
        "description": "The creator of SVG content might want to provide a hint to the implementation about what tradeoffs to make as it renders text. The 'text-rendering' property provides these hints.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-shadow",
        "browsers": [
          "E12",
          "FF3.5",
          "S1.1",
          "C2",
          "IE10",
          "O9.5"
        ],
        "values": [
          {
            "name": "none",
            "description": "No shadow."
          }
        ],
        "syntax": "none | <shadow-t>#",
        "relevance": 73,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-shadow"
          }
        ],
        "description": "Enables shadow effects to be applied to the text of the element.",
        "restrictions": [
          "length",
          "color"
        ]
      },
      {
        "name": "text-transform",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE4",
          "O7"
        ],
        "values": [
          {
            "name": "capitalize",
            "description": "Puts the first typographic letter unit of each word in titlecase."
          },
          {
            "name": "lowercase",
            "description": "Puts all letters in lowercase."
          },
          {
            "name": "none",
            "description": "No effects."
          },
          {
            "name": "uppercase",
            "description": "Puts all letters in uppercase."
          }
        ],
        "syntax": "none | capitalize | uppercase | lowercase | full-width | full-size-kana",
        "relevance": 86,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-transform"
          }
        ],
        "description": "Controls capitalization effects of an element's text.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "text-underline-position",
        "browsers": [
          "E12",
          "FF74",
          "S12.1",
          "C33",
          "IE6",
          "O20"
        ],
        "values": [
          {
            "name": "above"
          },
          {
            "name": "auto",
            "description": "The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."
          },
          {
            "name": "below",
            "description": "The underline is aligned with the under edge of the element's content box."
          }
        ],
        "syntax": "auto | from-font | [ under || [ left | right ] ]",
        "relevance": 50,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/text-underline-position"
          }
        ],
        "description": "Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements. This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "top",
        "browsers": [
          "E12",
          "FF1",
          "S1",
          "C1",
          "IE5",
          "O6"
        ],
        "values": [
          {
            "name": "auto",
            "description": "For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"
          }
        ],
        "syntax": "<length> | <percentage> | auto",
        "relevance": 95,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/top"
          }
        ],
        "description": "Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",
        "restrictions": [
          "length",
          "percentage"
        ]
      },
      {
        "name": "touch-action",
        "browsers": [
          "E12",
          "FF52",
          "S13",
          "C36",
          "IE11",
          "O23"
        ],
        "values": [
          {
            "name": "auto",
            "description": "The user agent may determine any permitted touch behaviors for touches that begin on the element."
          },
          {
            "name": "cross-slide-x",
            "browsers": [
              "E12",
              "FF52",
              "S13",
              "C36",
              "IE11",
              "O23"
            ]
          },
          {
            "name": "cross-slide-y",
            "browsers": [
              "E12",
              "FF52",
              "S13",
              "C36",
              "IE11",
              "O23"
            ]
          },
          {
            "name": "double-tap-zoom",
            "browsers": [
              "E12",
              "FF52",
              "S13",
              "C36",
              "IE11",
              "O23"
            ]
          },
          {
            "name": "manipulation",
            "description": "The user agent may consider touches that begin on the element only for the purposes of scrolling and continuous zooming."
          },
          {
            "name": "none",
            "description": "Touches that begin on the element must not trigger default touch behaviors."
          },
          {
            "name": "pan-x",
            "description": "The user agent may consider touches that begin on the element only for the purposes of horizontally scrolling the element's nearest ancestor with horizontally scrollable content."
          },
          {
            "name": "pan-y",
            "description": "The user agent may consider touches that begin on the element only for the purposes of vertically scrolling the element's nearest ancestor with vertically scrollable content."
          },
          {
            "name": "pinch-zoom",
            "browsers": [
              "E12",
              "FF52",
              "S13",
              "C36",
              "IE11",
              "O23"
            ]
          }
        ],
        "syntax": "auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation",
        "relevance": 69,
        "references": [
          {
            "name": "MDN Reference",
            "url": "https://developer.mozilla.org/docs/Web/CSS/touch-action"
          }
        ],
        "description": "Determines whether touch input may trigger default behavior supplied by user agent.",
        "restrictions": [
          "enum"
        ]
      },
      {
        "name": "transform",
        "browsers": [
          "E12",
          "FF16",
          "S9",
          "C36",
          "IE10",
          "O23"
        ],
        "values": [
          {
            "name": "matrix()",
            "description": "Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"
          },
          {
            "name": "matrix3d()",
            "description": "Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."
          },
          {
            "name": "none"
          },
          {
            "name": "perspective()",
            "description": "Specifies a perspective projection matrix."
          },
          {
            "name": "rotate()",
            "description": "Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."
          },